/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.FileUtil;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.QRCodeHelper;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.marketing.dto.IdsReq;
import com.kuaike.scrm.marketing.dto.MarketingPlanExportDto;
import com.kuaike.scrm.marketing.service.MarketingPlanService;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="marketingPlanExport")
public class ExportMarketingPlanServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportMarketingPlanServiceImpl.class);
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Resource
    private MarketingPlanService marketingPlanService;

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        Long bizId = task.getBizId();
        Long userId = LoginUtils.getCurrentUserId();
        this.createCorpDir(corpId);
        File dirFile = null;
        IdsReq idsReq = (IdsReq)JSON.parseObject((String)json, IdsReq.class);
        String filePath = this.createFilePath(corpId, ExportTaskType.MARKETING_PLAN, "\u6e20\u9053\u6d3b\u7801\u5bfc\u51fa");
        String sheetName = "\u6e20\u9053\u6d3b\u7801\u5bfc\u51fa";
        ExcelWriter excelWriter = null;
        String url = null;
        try {
            excelWriter = EasyExcel.write((String)filePath, MarketingPlanExportDto.class).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0, (String)sheetName).build();
            List<MarketingPlanExportDto> list = this.marketingPlanService.exportList(idsReq);
            String path = System.getProperty("java.io.tmpdir") + File.separator + "marketPlan" + File.separator + UUID.randomUUID().toString();
            dirFile = new File(path);
            if (!dirFile.mkdirs()) {
                log.info("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25:{}", (Object)dirFile);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                for (MarketingPlanExportDto item : list) {
                    if (!StringUtils.isNotBlank((CharSequence)item.getInviteUrl())) continue;
                    if (!item.getInviteUrl().contains("wework.qpic.cn")) {
                        String qrCodeImgPath = QRCodeHelper.createQrCode((String)item.getInviteUrl(), (String)path, (String)(item.getNum() + ".jpg"), (int)400, (int)400);
                        File qrCodeFile = new File(qrCodeImgPath);
                        item.setQrCode(qrCodeFile);
                        continue;
                    }
                    try {
                        File file = ExportMarketingPlanServiceImpl.download(item.getInviteUrl(), path, item.getNum());
                        if (!Objects.nonNull(file)) continue;
                        item.setQrCode(file);
                    }
                    catch (Exception e) {
                        log.error("\u4e0b\u8f7d\u56fe\u7247\u5931\u8d25", (Throwable)e);
                    }
                }
            }
            excelWriter.write(list, writeSheet);
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(corpId, file);
            }
        }
        catch (BusinessException e) {
            log.error("createExportFile BusinessException error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("createExportFile error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            File file;
            if (excelWriter != null) {
                excelWriter.finish();
            }
            if ((file = new File(filePath)).exists()) {
                file.delete();
            }
            if (Objects.nonNull(dirFile) && dirFile.exists() && dirFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)dirFile);
                    log.info("delete dir:{}", (Object)dirFile.getAbsolutePath());
                }
                catch (IOException e) {
                    log.error("delete dir:{} fail", (Object)dirFile.getAbsolutePath(), (Object)e);
                }
            }
        }
        return url;
    }

    public static CloseableHttpClient getHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(35000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static File download(String url, String path, String fileName) throws Exception {
        try {
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpClient httpClient = ExportMarketingPlanServiceImpl.getHttpClient();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpGet.abort();
                throw new IllegalStateException("download - error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String type = entity.getContentType().getValue();
            Object[] arr = type.split("/");
            if (StringUtils.isBlank((CharSequence)type) || ArrayUtils.isEmpty((Object[])arr) || ArrayUtils.getLength((Object)arr) != 2) {
                log.warn("download - error content type :{}", (Object)type);
                return null;
            }
            String suffix = type.split("/")[1];
            byte[] result = FileUtil.readBytes((InputStream)entity.getContent());
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            File file = new File(path, fileName + "." + suffix);
            FileUtils.writeByteArrayToFile((File)file, (byte[])result);
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (task == null) {
                log.info("build task is null");
                return;
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }
}

