/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.lockcustomer.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.IdName;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.SettingCustomerDetailService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.req.SettingCustomerConfigDto;
import com.kuaike.scrm.common.service.dto.req.SettingCustomerDetailDto;
import com.kuaike.scrm.common.service.dto.req.SettingReqDto;
import com.kuaike.scrm.common.service.dto.req.ShareCustomerConfigDto;
import com.kuaike.scrm.common.service.dto.resp.SettingRespDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.lockcustomer.dto.ShareCustomerReq;
import com.kuaike.scrm.lockcustomer.dto.ShareCustomerResp;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShareCustomerSupport {
    private static final Logger log = LoggerFactory.getLogger(ShareCustomerSupport.class);
    @Autowired
    private SettingCustomerDetailService settingCustomerDetailService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private DepartmentService departmentService;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;

    @Transactional(rollbackFor={Exception.class})
    public void addShareCustomer(ShareCustomerReq req) {
        req.validateForAdd();
        SettingReqDto settingReq = new SettingReqDto();
        settingReq.setParamName(SettingEnum.SHARE_CUSTOMER.getName());
        settingReq.setStatus(req.getStatus());
        settingReq.setParamValue(JSON.toJSONString((Object)req.getCustomerConfigDto()));
        SettingRespDto settingRespDto = this.settingService.modSetting(settingReq);
        if (Objects.isNull(settingRespDto)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65b0\u589e\u5ba2\u8d44\u5171\u4eab\u5f02\u5e38");
        }
        List<SettingCustomerDetailDto> addDetailParams = this.buildAddSettingDetailsParam(settingRespDto, req);
        SettingCustomerConfigDto detailReq = new SettingCustomerConfigDto();
        detailReq.setDtos(addDetailParams);
        detailReq.setSettingId(settingRespDto.getSettingId());
        detailReq.setBizId(settingRespDto.getBizId());
        this.settingCustomerDetailService.butchModCustomerDetail(detailReq);
    }

    public ShareCustomerResp hasShareCustomerPermission(ShareCustomerReq req) {
        WeworkUser weworkUser;
        req.setType(SettingEnum.SHARE_CUSTOMER);
        req.setFillUserOrDepName(YnEnum.NO.getValue());
        req.validateForPermission();
        ShareCustomerResp shareCustomerDetails = this.queryShareCustomer(req);
        ShareCustomerResp resp = new ShareCustomerResp();
        resp.setHasPermission(YnEnum.NO.getValue());
        if (!YnEnum.YES.getValue().equals(shareCustomerDetails.getStatus())) {
            return resp;
        }
        List<IdName<String>> weworkUserNums = shareCustomerDetails.getWeworkUserNums();
        if (CollectionUtils.isNotEmpty(weworkUserNums)) {
            for (IdName<String> weworkUserNum : weworkUserNums) {
                if (!StringUtils.equals((CharSequence)((CharSequence)weworkUserNum.getId()), (CharSequence)req.getWeworkUserNum())) continue;
                resp.setHasPermission(YnEnum.YES.getValue());
                return resp;
            }
        }
        if (Objects.isNull(weworkUser = this.weworkUserMapper.queryWeworkUserByNum(req.getWeworkUserNum()))) {
            return resp;
        }
        List weworkDepartmentUsers = this.weworkDepartmentUserMapper.selectExistDepartmentUser(weworkUser.getCorpId(), weworkUser.getWeworkUserId());
        Set currentUserDeptIds = weworkDepartmentUsers.stream().map(WeworkDepartmentUser::getDepartmentId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(currentUserDeptIds)) {
            return resp;
        }
        List<IdName<Long>> weworkDepIds = shareCustomerDetails.getWeworkDepIds();
        if (CollectionUtils.isNotEmpty(weworkDepIds)) {
            Set depIds = weworkDepIds.stream().map(item -> ((Long)item.getId()).intValue()).collect(Collectors.toSet());
            Set allChildDepIds = this.departmentService.getAllFlatDepartment(weworkUser.getCorpId(), depIds, true);
            HashSet wrapperAllDepIds = Sets.newHashSet((Iterable)allChildDepIds);
            wrapperAllDepIds.retainAll(currentUserDeptIds);
            if (CollectionUtils.isNotEmpty((Collection)wrapperAllDepIds)) {
                resp.setHasPermission(YnEnum.YES.getValue());
                return resp;
            }
        }
        return resp;
    }

    public ShareCustomerResp queryShareCustomer(ShareCustomerReq req) {
        SettingRespDto settingRespDto;
        req.validateForQuery();
        List respDtos = this.settingService.settingDetails(req.getType());
        if (CollectionUtils.isEmpty((Collection)respDtos)) {
            settingRespDto = this.initDefaultShareCustomerConfig();
            if (settingRespDto == null) {
                log.info("queryShareCustomer, settingRespDto is null");
                return new ShareCustomerResp();
            }
            respDtos = com.google.common.collect.Lists.newArrayList((Object[])new SettingRespDto[]{settingRespDto});
        }
        if (CollectionUtils.isEmpty((Collection)respDtos)) {
            log.info("queryShareCustomer, respDtos is null");
            return new ShareCustomerResp();
        }
        if (respDtos.size() > 1) {
            log.error("\u5f53\u524d\u914d\u7f6e\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5 type:{} req:{}", (Object)req.getType(), (Object)JSON.toJSONString((Object)req));
        }
        settingRespDto = (SettingRespDto)respDtos.get(0);
        SettingCustomerDetailDto detailDto = new SettingCustomerDetailDto();
        detailDto.setSettingId(settingRespDto.getSettingId());
        detailDto.setSettingEnum(req.getType());
        detailDto.setBizId(LoginUtils.getCurrentUserBizId());
        List customerDetail = null;
        if (!YnEnum.YES.getValue().equals(req.getOnlyShowConfigDetail())) {
            customerDetail = this.settingCustomerDetailService.getCustomerDetail(detailDto, req.getFillUserOrDepName());
        }
        ShareCustomerResp resp = this.buildResp(settingRespDto, customerDetail);
        log.info("queryShareCustomer param:{}; result:{}", (Object)JSON.toJSONString((Object)req), (Object)JSON.toJSONString((Object)resp));
        return resp;
    }

    private ShareCustomerResp buildResp(SettingRespDto settingRespDto, List<SettingCustomerDetailDto> customerDetail) {
        ShareCustomerResp resp = new ShareCustomerResp();
        resp.setStatus(settingRespDto.getStatus());
        resp.setCustomerConfigDto((ShareCustomerConfigDto)JSON.parseObject((String)settingRespDto.getParamValue(), ShareCustomerConfigDto.class));
        if (CollectionUtils.isEmpty(customerDetail)) {
            return resp;
        }
        List<IdName<Long>> depList = customerDetail.stream().filter(item -> Objects.nonNull(item.getWeworkDepartmentId())).map(item -> {
            IdName idName = new IdName();
            idName.setId((Object)item.getWeworkDepartmentId());
            idName.setName(item.getWeworkDepartmentName());
            return idName;
        }).collect(Collectors.toList());
        List<IdName<String>> weworkNumList = customerDetail.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getWeworkUserNum())).map(item -> {
            IdName idName = new IdName();
            idName.setId((Object)item.getWeworkUserNum());
            idName.setName(item.getWeworkUserName());
            return idName;
        }).collect(Collectors.toList());
        resp.setWeworkDepIds(depList);
        resp.setWeworkUserNums(weworkNumList);
        return resp;
    }

    private List<SettingCustomerDetailDto> buildAddSettingDetailsParam(SettingRespDto settingRespDto, ShareCustomerReq req) {
        if (Objects.isNull(req)) {
            return Lists.newArrayList();
        }
        ArrayList param = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(req.getWeworkDepIds())) {
            List depParam = req.getWeworkDepIds().stream().map(item -> {
                SettingCustomerDetailDto detailDto = new SettingCustomerDetailDto();
                detailDto.setSettingEnum(SettingEnum.getEnum((String)settingRespDto.getParamName()));
                detailDto.setSettingId(settingRespDto.getSettingId());
                detailDto.setBizId(settingRespDto.getBizId());
                detailDto.setWeworkDepartmentId(item);
                return detailDto;
            }).collect(Collectors.toList());
            param.addAll(depParam);
        }
        if (CollectionUtils.isNotEmpty(req.getWeworkUserNums())) {
            List userNumParam = req.getWeworkUserNums().stream().map(item -> {
                SettingCustomerDetailDto detailDto = new SettingCustomerDetailDto();
                detailDto.setSettingEnum(SettingEnum.getEnum((String)settingRespDto.getParamName()));
                detailDto.setSettingId(settingRespDto.getSettingId());
                detailDto.setBizId(settingRespDto.getBizId());
                detailDto.setWeworkUserNum(item);
                return detailDto;
            }).collect(Collectors.toList());
            param.addAll(userNumParam);
        }
        return param;
    }

    private SettingRespDto initDefaultShareCustomerConfig() {
        SettingReqDto settingReq = new SettingReqDto();
        settingReq.setParamName(SettingEnum.SHARE_CUSTOMER.getName());
        settingReq.setStatus(YnEnum.YES.getValue());
        ShareCustomerConfigDto customerConfigDto = new ShareCustomerConfigDto();
        customerConfigDto.setShareCusRemark(Integer.valueOf(1));
        customerConfigDto.setShareCusDesc(Integer.valueOf(1));
        customerConfigDto.setShareCusMobile(Integer.valueOf(1));
        customerConfigDto.setShareCusStage(Integer.valueOf(0));
        customerConfigDto.setShareCusTag(Integer.valueOf(0));
        settingReq.setParamValue(JSON.toJSONString((Object)customerConfigDto));
        SettingRespDto settingRespDto = this.settingService.modSetting(settingReq);
        if (settingRespDto == null) {
            log.warn("initDefaultShareCustomerConfig fail, settingReq:{}", (Object)settingReq);
        }
        return settingRespDto;
    }
}

