/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.friendfission.service.impl;

import cn.kinyun.scrm.page.auth.service.WeworkOauthService;
import cn.kinyun.wework.sdk.api.external.ContactWayClient;
import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.common.utils.qr.google.MatrixToImageWriter;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.jsmsg.JsNewsDto;
import com.kuaike.scrm.common.enums.MarketingConfigType;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.dto.FissionListDto;
import com.kuaike.scrm.dal.marketing.dto.FissionListRes;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingConfig;
import com.kuaike.scrm.dal.marketing.entity.MarketingJoin;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingReward;
import com.kuaike.scrm.dal.marketing.entity.MarketingRewardStage;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingConfigMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingJoinMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupUserMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardStageMapper;
import com.kuaike.scrm.dal.system.entity.LockCustomer;
import com.kuaike.scrm.dal.system.mapper.LockCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.friendfission.dto.BillboardAvatarDto;
import com.kuaike.scrm.friendfission.dto.BillboardNameDto;
import com.kuaike.scrm.friendfission.dto.BillboardQrcodeDto;
import com.kuaike.scrm.friendfission.dto.BillboardResultDto;
import com.kuaike.scrm.friendfission.dto.CreateBillboardReqDto;
import com.kuaike.scrm.friendfission.dto.EnableRes;
import com.kuaike.scrm.friendfission.dto.EnableSendFissionDto;
import com.kuaike.scrm.friendfission.dto.FissionBillboardDto;
import com.kuaike.scrm.friendfission.dto.FissionPlanDto;
import com.kuaike.scrm.friendfission.dto.FissionPlanStageDto;
import com.kuaike.scrm.friendfission.dto.FissionSwitchDto;
import com.kuaike.scrm.friendfission.dto.FriendFissionSidebarListReqDto;
import com.kuaike.scrm.friendfission.dto.SidebarBillboardReqDto;
import com.kuaike.scrm.friendfission.dto.SidebarMsgReqDto;
import com.kuaike.scrm.friendfission.dto.resp.FriendFissionSidebarListRespDto;
import com.kuaike.scrm.friendfission.dto.resp.SidebarBillboardRespDto;
import com.kuaike.scrm.friendfission.dto.resp.SidebarMsgRespDto;
import com.kuaike.scrm.friendfission.service.FissionChannelService;
import com.kuaike.scrm.friendfission.service.FissionPlanService;
import com.kuaike.scrm.friendfission.service.FissionStageService;
import com.kuaike.scrm.friendfission.service.FissionTagRuleService;
import com.kuaike.scrm.friendfission.utils.Billboard;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import com.kuaike.scrm.marketing.service.MarketingConfigService;
import com.kuaike.scrm.marketing.service.MarketingQrcodeService;
import com.kuaike.scrm.marketing.service.MarketingUserService;
import com.kuaike.scrm.material.service.MaterialManagerService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FissionPlanServiceImpl
implements FissionPlanService {
    private static final Logger log = LoggerFactory.getLogger(FissionPlanServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private AliyunOss aliyunOss;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private MarketingRewardStageMapper marketingRewardStageMapper;
    @Resource
    private MarketingRewardMapper marketingRewardMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Resource
    private MarketingConfigMapper marketingConfigMapper;
    @Resource
    private MarketingPlanGroupUserMapper marketingPlanGroupUserMapper;
    @Resource
    private MarketingJoinMapper marketingJoinMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MarketingUserService marketingUserService;
    @Autowired
    private FissionStageService fissionStageService;
    @Autowired
    private FissionTagRuleService fissionTagRuleService;
    @Autowired
    private MarketingConfigService marketingConfigService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private MaterialManagerService materialManagerService;
    @Autowired
    private ContactWayClient contactWayClient;
    @Autowired
    private MarketingQrcodeService marketingQrcodeService;
    @Autowired
    private FissionChannelService fissionChannelService;
    @Resource
    private LockCustomerMapper lockCustomerMapper;
    @Autowired
    private WeworkOauthService weworkOauthService;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${fission-qrcode.url.format:/fissionQrcode?id={0}}")
    private String fissionQrcodeUrl;
    @Value(value="${friend-fission.h5.title}")
    private String h5Title;
    @Value(value="${friend-fission.h5.desc}")
    private String h5Desc;
    @Value(value="${friend-fission.h5.picUrl}")
    private String h5PicUrl;
    private final Random rd = new Random();

    @Override
    @Transactional
    public String add(FissionPlanDto params) {
        log.info("add fission plan params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        Long planId = this.insertMarketingPlan(params);
        this.marketingUserService.saveMarketingUser(bizId, corpId, userId, planId, -1L, params.getWeworkUserIds(), Lists.newArrayList(), Collections.emptyMap(), Collections.emptyMap());
        this.fissionStageService.save(planId, params.getStages(), true);
        this.fissionTagRuleService.save(planId, params.getAttachTagRules(), true);
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.SPREAD_REPLY.getValue(), params.getSpreadReply());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.SUCCESS_INVITE_REPLY.getValue(), params.getSuccessInviteReply());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.REPEAT_INVITE_REPLY.getValue(), params.getRepeatInviteReply());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FINISH_REPLY.getValue(), params.getFinishReply());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.LIMIT_NEW_CUSTOMER_REPLY.getValue(), params.getLimitNewCustomerReply());
        FissionSwitchDto fissionSwitchDto = (FissionSwitchDto)BeanUtil.convert((Object)params, FissionSwitchDto.class, (String[])new String[0]);
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FISSION_SWITCH.getValue(), fissionSwitchDto);
        ArrayList configs = Lists.newArrayList();
        for (FissionBillboardDto billboardDto : params.getBillboard()) {
            String billboardStr = JacksonUtil.obj2Str((Object)billboardDto);
            configs.add(billboardStr);
        }
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.AUTO_REMARK.getValue(), params.getAddFriendRemark());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FISSION_BILL_BOARD.getValue(), configs);
        this.fissionChannelService.addFissionChannels(bizId, corpId, userId, planId, Lists.newArrayList((Object[])new Long[]{-1L}));
        this.marketingQrcodeService.saveMarketingQrcode(bizId, corpId, userId, planId, false);
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(planId);
        return params.getId();
    }

    @Override
    @Transactional
    public void mod(FissionPlanDto params) {
        log.info("mod fission plan params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        Long planId = this.updateMarketingPlan(params);
        if (planId == null) {
            log.info("mod fission plan is not exist");
            return;
        }
        boolean update = this.marketingUserService.saveMarketingUser(bizId, corpId, userId, planId, -1L, params.getWeworkUserIds(), Lists.newArrayList(), Collections.emptyMap(), Collections.emptyMap());
        this.fissionStageService.save(planId, params.getStages(), false);
        this.fissionTagRuleService.save(planId, params.getAttachTagRules(), false);
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.SPREAD_REPLY.getValue(), params.getSpreadReply());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.SUCCESS_INVITE_REPLY.getValue(), params.getSuccessInviteReply());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.REPEAT_INVITE_REPLY.getValue(), params.getRepeatInviteReply());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FINISH_REPLY.getValue(), params.getFinishReply());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.LIMIT_NEW_CUSTOMER_REPLY.getValue(), params.getLimitNewCustomerReply());
        FissionSwitchDto fissionSwitchDto = (FissionSwitchDto)BeanUtil.convert((Object)params, FissionSwitchDto.class, (String[])new String[0]);
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FISSION_SWITCH.getValue(), fissionSwitchDto);
        ArrayList configs = Lists.newArrayList();
        for (FissionBillboardDto billboardDto : params.getBillboard()) {
            String billboardStr = JacksonUtil.obj2Str((Object)billboardDto);
            configs.add(billboardStr);
        }
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FISSION_BILL_BOARD.getValue(), configs);
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.AUTO_REMARK.getValue(), params.getAddFriendRemark());
        this.marketingQrcodeService.saveMarketingQrcode(bizId, corpId, userId, planId, update);
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(planId);
    }

    @Override
    public FissionPlanDto detail(BaseDto params) {
        log.info("detail fission plan params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            log.info("detail fission plan is not exist");
            return null;
        }
        Long planId = marketingPlan.getId();
        FissionPlanDto planDto = new FissionPlanDto();
        planDto.setId(marketingPlan.getNum());
        planDto.setName(marketingPlan.getName());
        planDto.setEndTime(marketingPlan.getEndTime());
        planDto.setWeworkUsers(this.marketingUserService.getPlanGroupUserInfo(planId, -1L));
        planDto.setStages(this.fissionStageService.getList(corpId, planId));
        planDto.setAttachTagRules(this.fissionTagRuleService.getTagRules(corpId, planId));
        planDto.setCustomizeReply(marketingPlan.getCustomizeReply());
        planDto.setSpreadReply(this.marketingConfigService.getSpreadReply(corpId, planId));
        planDto.setSuccessInviteReply(this.marketingConfigService.getSuccessInviteReply(corpId, planId));
        planDto.setRepeatInviteReply(this.marketingConfigService.getRepeatInviteReply(corpId, planId));
        planDto.setFinishReply(this.marketingConfigService.getFinishReply(corpId, planId));
        planDto.setLimitNewCustomerReply(this.marketingConfigService.getLimitNewCustomerReply(corpId, planId));
        planDto.setBillboard(this.marketingConfigService.getBillboardConfig(corpId, planId));
        planDto.setAddFriendRemark(this.marketingConfigService.getRemarkConfig(corpId, planId));
        FissionSwitchDto fissionSwitchDto = this.marketingConfigService.getSwitchConfig(corpId, planId);
        BeanUtils.copyProperties((Object)fissionSwitchDto, (Object)planDto);
        return planDto;
    }

    @Override
    public List<FissionListDto> list(FissionListRes params) {
        log.info("list fission plan params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        params.setCorpId(corpId);
        params.setUserIds(userIds);
        if (params.getPageDto() != null) {
            int count = this.marketingPlanMapper.queryFissionPlanCount(params);
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        return this.marketingPlanMapper.queryFissionPlanList(params);
    }

    @Override
    @Transactional
    public void enable(EnableRes params) {
        log.info("enable params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        params.checkParams();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1 || Objects.equals(marketingPlan.getIsEnabled(), params.getIsEnabled())) {
            return;
        }
        this.marketingPlanMapper.marketingIsEnableControl(bizId, corpId, userId, params.getId(), params.getIsEnabled());
    }

    @Override
    public List<EnableSendFissionDto> enableSendList(BaseDto params) {
        log.info("enable params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        String weworkUserNum = userInfo.getWeworkUserNum();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            int total = this.marketingPlanMapper.queryEnableSendFissionPlanCount(corpId, params.getName(), (Collection)userIds, weworkUserNum);
            pageDto.setCount(Integer.valueOf(total));
        }
        List list = this.marketingPlanMapper.queryEnableSendFissionPlanList(corpId, params.getName(), (Collection)userIds, weworkUserNum, pageDto);
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (MarketingPlan marketingPlan : list) {
            Long planId = marketingPlan.getId();
            EnableSendFissionDto fissionDto = new EnableSendFissionDto();
            fissionDto.setPlanId(planId);
            fissionDto.setId(marketingPlan.getNum());
            fissionDto.setName(marketingPlan.getName());
            fissionDto.setEndTime(marketingPlan.getEndTime());
            fissionDto.setType(marketingPlan.getType());
            FriendWelcomeDto spreadReply = this.marketingConfigService.getSpreadReply(corpId, planId);
            MarketingChannel defaultChannel = this.marketingChannelMapper.queryPlanChannelInfo(corpId, planId, Long.valueOf(-1L));
            fissionDto.setPlanPageUrl(defaultChannel.getUrl());
            fissionDto.setReply(spreadReply.getText());
            result.add(fissionDto);
        }
        return result;
    }

    @Override
    public void checkUpdatePlanStatus(Long planId) {
        if (planId == null) {
            return;
        }
        MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (marketingPlan == null) {
            return;
        }
        String corpId = marketingPlan.getCorpId();
        List<FissionPlanStageDto> list = this.fissionStageService.getList(corpId, planId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        boolean isUseAll = true;
        for (FissionPlanStageDto stageDto : list) {
            if (stageDto.getRemainRewardCount() <= 0) continue;
            isUseAll = false;
            break;
        }
        if (isUseAll) {
            marketingPlan.setStatus(Integer.valueOf(2));
            marketingPlan.setUpdateTime(new Date());
            this.marketingPlanMapper.updateByPrimaryKeySelective((Object)marketingPlan);
        }
    }

    @Override
    public List<FriendFissionSidebarListRespDto> sidebarList(FriendFissionSidebarListReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long userId = currentUserInfo.getId();
        String corpId = currentUserInfo.getCorpId();
        String weworkUserNum = currentUserInfo.getWeworkUserNum();
        log.info("sidebarList, params:{}, operatorId:{}, corpId:{}, weworkUserNum:{}", new Object[]{params, userId, corpId, weworkUserNum});
        params.validateParams();
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.warn("\u8be5\u7528\u6237\u4e0d\u662f\u4f01\u5fae\u6210\u5458");
            return Collections.emptyList();
        }
        int offset = (params.getPageDto().getPageNum() - 1) * params.getPageDto().getPageSize();
        List marketingPlans = this.marketingPlanMapper.selectSidebarFriendFissionPlans(corpId, weworkUserNum, params.getName(), Integer.valueOf(offset), params.getPageDto().getPageSize());
        if (CollectionUtils.isEmpty((Collection)marketingPlans)) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)corpId, (Object)weworkUserNum);
            return Collections.emptyList();
        }
        int count = this.marketingPlanMapper.getSidebarFriendFissionPlanCount(corpId, weworkUserNum, params.getName());
        params.getPageDto().setCount(Integer.valueOf(count));
        Set<Long> planIds = marketingPlans.stream().map(MarketingPlan::getId).collect(Collectors.toSet());
        Map<Long, List<MarketingConfig>> planId2ConfigsMap = this.marketingConfigService.getBillboardConfigByCorpIdAndPlanIds(corpId, planIds);
        ArrayList respDtos = Lists.newArrayList();
        for (MarketingPlan marketingPlan : marketingPlans) {
            Long planId = marketingPlan.getId();
            List<MarketingConfig> marketingConfigs = planId2ConfigsMap.get(planId);
            FriendFissionSidebarListRespDto friendFissionSidebarListRespDto = new FriendFissionSidebarListRespDto();
            respDtos.add(friendFissionSidebarListRespDto);
            friendFissionSidebarListRespDto.setId(marketingPlan.getNum());
            friendFissionSidebarListRespDto.setName(marketingPlan.getName());
            MarketingConfig marketingconfig = marketingConfigs.get(this.rd.nextInt(marketingConfigs.size()));
            friendFissionSidebarListRespDto.setBgPicId(marketingconfig.getId());
            try {
                FissionBillboardDto fissionBillboardDto = (FissionBillboardDto)JacksonUtil.str2Obj((String)marketingconfig.getConfigJson(), FissionBillboardDto.class);
                friendFissionSidebarListRespDto.setBgUrl(fissionBillboardDto.getBgUrl());
            }
            catch (IOException e) {
                log.error("\u5c06configJson:{}\u8f6c\u6362\u6210FissionBillboardDto\u5931\u8d25:", (Object)marketingconfig.getConfigJson(), (Object)e);
            }
        }
        return respDtos;
    }

    @Override
    public SidebarMsgRespDto sidebarMsgs(SidebarMsgReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long userId = currentUserInfo.getId();
        String corpId = currentUserInfo.getCorpId();
        String weworkUserNum = currentUserInfo.getWeworkUserNum();
        log.info("sidebarMsgs, params:{}, operatorId:{}, weworkUserNum:{}", new Object[]{params, userId, weworkUserNum});
        params.validateParams();
        MarketingPlan marketingPlan = this.marketingPlanMapper.selectByNum(params.getId());
        Preconditions.checkArgument((boolean)Objects.nonNull(marketingPlan), (Object)"\u6d3b\u52a8id\u4e0d\u5408\u6cd5");
        if (NumberUtils.INTEGER_ZERO.equals(marketingPlan.getIsEnabled())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8\u3010" + marketingPlan.getName() + "\u3011\u5df2\u7981\u7528");
        }
        if (NumberUtils.INTEGER_TWO.equals(marketingPlan.getStatus())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8\u3010" + marketingPlan.getName() + "\u3011\u5df2\u7ed3\u675f");
        }
        String content = "";
        FriendWelcomeDto friendWelcomeDto = this.marketingConfigService.getSpreadReply(corpId, marketingPlan.getId());
        if (Objects.isNull(friendWelcomeDto)) {
            log.warn("\u6d3b\u52a8id:{}\u672a\u914d\u7f6e\u88c2\u53d8\u63a8\u5e7f\u8bdd\u672f", (Object)marketingPlan.getId());
        } else {
            boolean flag;
            content = friendWelcomeDto.getText();
            if (content.contains("${nickname}")) {
                WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(currentUserInfo.getBizId(), corpId, params.getContactId());
                if (Objects.nonNull(weworkContact)) {
                    while (content.contains("${nickname}")) {
                        content = content.replace("${nickname}", weworkContact.getName());
                    }
                } else {
                    while (content.contains("${nickname}")) {
                        content = content.replace("${nickname}", "");
                    }
                }
            }
            boolean bl = flag = content.contains("${remainReward-1}") || content.contains("${remainReward-2}") || content.contains("${remainReward-3}");
            if (flag) {
                int count;
                Map stageRewardCountMap = this.marketingRewardStageMapper.getStageRewardCountByPlanId(marketingPlan.getId());
                Map receiveStageRewardCountMap = this.marketingRewardMapper.getReceiveStageRewardCountByPlanId(marketingPlan.getId());
                if (content.contains("${remainReward-1}")) {
                    int firstStageRewardCount = stageRewardCountMap.getOrDefault(1, 0);
                    int firstStageReceiveCount = receiveStageRewardCountMap == null ? 0 : receiveStageRewardCountMap.getOrDefault(1, 0);
                    count = Math.max(firstStageRewardCount - firstStageReceiveCount, 0);
                    while (content.contains("${remainReward-1}")) {
                        content = content.replace("${remainReward-1}", Integer.toString(count));
                    }
                }
                if (content.contains("${remainReward-2}")) {
                    int secondStageRewardCount = stageRewardCountMap.getOrDefault(2, 0);
                    int secondStageReceiveCount = receiveStageRewardCountMap == null ? 0 : receiveStageRewardCountMap.getOrDefault(2, 0);
                    count = Math.max(secondStageRewardCount - secondStageReceiveCount, 0);
                    while (content.contains("${remainReward-2}")) {
                        content = content.replace("${remainReward-2}", Integer.toString(count));
                    }
                }
                if (content.contains("${remainReward-3}")) {
                    int thirdStageRewardCount = stageRewardCountMap.getOrDefault(3, 0);
                    int thirdStageReceiveCount = receiveStageRewardCountMap == null ? 0 : receiveStageRewardCountMap.getOrDefault(3, 0);
                    count = Math.max(thirdStageRewardCount - thirdStageReceiveCount, 0);
                    while (content.contains("${remainReward-3}")) {
                        content = content.replace("${remainReward-3}", Integer.toString(count));
                    }
                }
            }
        }
        MarketingChannel marketingChannel = this.marketingChannelMapper.selectByPlanIdAndChannelId(marketingPlan.getId(), NumberUtils.LONG_MINUS_ONE);
        JsNewsDto jsNewsDto = new JsNewsDto();
        jsNewsDto.setTitle(this.h5Title);
        jsNewsDto.setDesc(this.h5Desc);
        jsNewsDto.setImgUrl(this.h5PicUrl);
        jsNewsDto.setLink(marketingChannel.getUrl());
        SidebarMsgRespDto sidebarMsgRespDto = new SidebarMsgRespDto();
        sidebarMsgRespDto.setContent(content);
        sidebarMsgRespDto.setNews(jsNewsDto);
        return sidebarMsgRespDto;
    }

    @Override
    public SidebarBillboardRespDto sidebarBillboard(SidebarBillboardReqDto params) {
        FissionBillboardDto fissionBillboardDto;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long userId = currentUserInfo.getId();
        String corpId = currentUserInfo.getCorpId();
        String weworkUserNum = currentUserInfo.getWeworkUserNum();
        log.info("sidebarBillboard, params:{}, operatorId:{}, weworkUserNum:{}", new Object[]{params, userId, weworkUserNum});
        params.validateParams();
        MarketingPlan marketingPlan = this.marketingPlanMapper.selectByNum(params.getId());
        Preconditions.checkArgument((boolean)Objects.nonNull(marketingPlan), (Object)"\u6d3b\u52a8id\u4e0d\u5408\u6cd5");
        if (NumberUtils.INTEGER_ZERO.equals(marketingPlan.getIsEnabled())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8\u3010" + marketingPlan.getName() + "\u3011\u5df2\u7981\u7528");
        }
        if (NumberUtils.INTEGER_TWO.equals(marketingPlan.getStatus())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8\u3010" + marketingPlan.getName() + "\u3011\u5df2\u7ed3\u675f");
        }
        String billboardUrl = this.marketingJoinMapper.selectBgResultUrlByCorpIdPlanIdAndContactId(corpId, marketingPlan.getId(), params.getContactId());
        SidebarBillboardRespDto sidebarBillboardRespDto = new SidebarBillboardRespDto();
        if (StringUtils.isNotBlank((CharSequence)billboardUrl)) {
            String mediaId = this.materialManagerService.getMediaId(currentUserInfo.getBizId(), corpId, billboardUrl, "image");
            sidebarBillboardRespDto.setMediaId(mediaId);
            sidebarBillboardRespDto.setBillboardUrl(billboardUrl);
            return sidebarBillboardRespDto;
        }
        String configJson = this.marketingConfigMapper.getConfigJsonById(params.getBgPicId());
        if (StringUtils.isNotBlank((CharSequence)configJson)) {
            try {
                fissionBillboardDto = (FissionBillboardDto)JacksonUtil.str2Obj((String)configJson, FissionBillboardDto.class);
            }
            catch (IOException e) {
                log.error("configJson:{}\u8f6c\u6362\u6210FissionBillboardDto\u5931\u8d25", (Object)configJson, (Object)e);
                return sidebarBillboardRespDto;
            }
        } else {
            List<FissionBillboardDto> billboardDtos = this.marketingConfigService.getBillboardConfig(corpId, marketingPlan.getId());
            fissionBillboardDto = billboardDtos.get(0);
        }
        CreateBillboardReqDto createBillboardReqDto = new CreateBillboardReqDto();
        createBillboardReqDto.setModel(1);
        createBillboardReqDto.setFissionBillboardDto(fissionBillboardDto);
        createBillboardReqDto.setChannelId(NumberUtils.LONG_MINUS_ONE);
        createBillboardReqDto.setWeworkUserNum(weworkUserNum);
        createBillboardReqDto.setContactId(params.getContactId());
        createBillboardReqDto.setMarketingPlan(marketingPlan);
        BillboardResultDto billboardResultDto = this.createBillboard(createBillboardReqDto);
        if (Objects.nonNull(billboardResultDto)) {
            sidebarBillboardRespDto.setMediaId(billboardResultDto.getMediaId());
            sidebarBillboardRespDto.setBillboardUrl(billboardResultDto.getPicUrl());
        }
        return sidebarBillboardRespDto;
    }

    @Override
    public BillboardResultDto createBillboard(CreateBillboardReqDto params) {
        log.info("createBillboard, params:{}", (Object)params);
        BillboardResultDto billboardResultDto = new BillboardResultDto();
        MarketingPlan marketingPlan = params.getMarketingPlan();
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(marketingPlan.getBizId(), marketingPlan.getCorpId(), params.getContactId());
        String contactAvatar = null;
        String contactName = null;
        if (Objects.isNull(weworkContact)) {
            ReplyContext ctx = ReplyContextUtil.get();
            contactAvatar = ctx.getContactAvatar();
            contactName = ctx.getNickname();
        } else {
            contactAvatar = weworkContact.getAvatar();
            contactName = weworkContact.getName();
        }
        if (StringUtils.isBlank((CharSequence)contactAvatar) && StringUtils.isBlank((CharSequence)contactName)) {
            log.warn("\u6839\u636ecorpId:{}, contactId:{}\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u8bb0\u5f55", (Object)marketingPlan.getCorpId(), (Object)params.getContactId());
            return billboardResultDto;
        }
        FissionBillboardDto fissionBillboardDto = params.getFissionBillboardDto();
        BillboardAvatarDto avatar = fissionBillboardDto.getAvatar();
        BillboardNameDto nameDto = fissionBillboardDto.getName();
        BillboardQrcodeDto qrcodeDto = fissionBillboardDto.getQrcode();
        MarketingJoin marketingJoin = this.buildMarketingJoin(params);
        Billboard billboard = new Billboard();
        CountDownLatch countDownLatch = new CountDownLatch(3);
        new Thread(() -> {
            try {
                billboard.setBackground(fissionBillboardDto.getBgUrl());
            }
            catch (Exception ex) {
                log.error("\u7ed9\u6d77\u62a5\u8bbe\u7f6e\u80cc\u666f\u56fe\u5931\u8d25", (Throwable)ex);
            }
            countDownLatch.countDown();
        }).start();
        String tAvatar = contactAvatar;
        new Thread(() -> {
            if (Objects.nonNull(avatar) && NumberUtils.INTEGER_ONE.equals(avatar.getEnable())) {
                boolean round = NumberUtils.INTEGER_ONE.equals(avatar.getIsRound());
                try {
                    billboard.addImage(tAvatar, (int)avatar.getX(), (int)avatar.getY(), (int)avatar.getW(), (int)avatar.getH(), round);
                }
                catch (Exception ex) {
                    log.error("\u7ed9\u6d77\u62a5\u8bbe\u7f6e\u7528\u6237\u56fe\u50cf\u5931\u8d25", (Throwable)ex);
                }
            }
            countDownLatch.countDown();
        }).start();
        if (Objects.nonNull(nameDto) && NumberUtils.INTEGER_ONE.equals(nameDto.getEnable())) {
            billboard.setTextProp(nameDto.getX(), nameDto.getY() + nameDto.getFontSize() - 3, nameDto.getFontSize(), nameDto.getRed(), nameDto.getGreen(), nameDto.getBlue(), contactName);
        }
        new Thread(() -> {
            try {
                ConfigIdResp configIdResp = this.createFriendFissionQrcode(params, marketingJoin.getNum());
                marketingJoin.setQrcodeUrl(configIdResp.getQrCode());
                marketingJoin.setQrConfigId(configIdResp.getConfigId());
                String originUrl = MessageFormat.format(this.fissionQrcodeUrl, marketingJoin.getNum());
                LockCustomer lockCustomer = this.lockCustomerMapper.queryLockCustomer(marketingJoin.getCorpId());
                if (lockCustomer != null && lockCustomer.getState() == 1) {
                    String shortUrl = this.weworkOauthService.wrapUrl(marketingJoin.getBizId(), marketingJoin.getCorpId(), originUrl, marketingJoin.getNum(), Integer.valueOf(OauthShortUrlTypeEnum.MERCHANT_WRAP_URL.getValue()));
                    BufferedImage qrcodeImage = this.getQRCodeImage(shortUrl, qrcodeDto.getW(), qrcodeDto.getH());
                    billboard.addImage(qrcodeImage, (int)qrcodeDto.getX(), (int)qrcodeDto.getY(), (int)qrcodeDto.getW(), (int)qrcodeDto.getH(), false);
                } else {
                    billboard.addImage(configIdResp.getQrCode(), (int)qrcodeDto.getX(), (int)qrcodeDto.getY(), (int)qrcodeDto.getW(), (int)qrcodeDto.getH(), false);
                }
            }
            catch (Exception ex) {
                log.info("\u4e3aplanId:{},contactId:{}\u751f\u6210\u4e13\u5c5e\u6d77\u62a5\u5f02\u5e38", new Object[]{marketingPlan.getId(), params.getContactId(), ex});
            }
            countDownLatch.countDown();
        }).start();
        String fileName = "friendFission_" + marketingPlan.getId() + params.getContactId() + ".jpg";
        File file = new File(fileName);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("\u7b49\u5f85\u751f\u6210\u6d77\u62a5\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            Thread.currentThread().interrupt();
            return billboardResultDto;
        }
        billboard.saveTo(file);
        String fileUrl = this.aliyunOss.uploadFile(marketingPlan.getCorpId(), file, file.getName());
        marketingJoin.setBgResultUrl(fileUrl);
        String mediaId = this.materialManagerService.getBillboardMediaId(marketingPlan.getBizId(), marketingPlan.getCorpId(), fileUrl, "image", file);
        if (file.exists()) {
            file.delete();
        }
        if (params.getModel() == 1 || params.getModel() == 2) {
            marketingJoin.setLevel(NumberUtils.INTEGER_ONE);
            marketingJoin.setIsNewCustomer(Boolean.valueOf(false));
        } else if (params.getModel() == 3) {
            if (params.isAssistantSuccess()) {
                Integer pLevel = this.marketingJoinMapper.getPlevelByCorpIdPlanIdAndContactId(marketingPlan.getCorpId(), marketingPlan.getId(), params.getPContactId());
                log.info("planId:{}, corpId:{}, pContactId:{}\u5bf9\u5e94\u7684\u7ea7\u522b\u4e3a:{}", new Object[]{marketingPlan.getId(), marketingPlan.getCorpId(), params.getPContactId(), pLevel});
                if (Objects.isNull(pLevel)) {
                    pLevel = 0;
                }
                marketingJoin.setLevel(Integer.valueOf(pLevel + 1));
            } else {
                marketingJoin.setLevel(NumberUtils.INTEGER_ONE);
            }
            marketingJoin.setIsNewCustomer(Boolean.valueOf(params.getIsNewCustomer() == 1));
            marketingJoin.setAddFriendTime(params.getAddFriendTime());
            marketingJoin.setPContactId(params.getPContactId());
        }
        marketingJoin.setWeworkUserNum(params.getWeworkUserNum());
        this.marketingJoinMapper.insertSelective((Object)marketingJoin);
        this.addSaveMarketingReward(marketingPlan, params.getContactId(), params.getChannelId());
        billboardResultDto.setMediaId(mediaId);
        billboardResultDto.setPicUrl(fileUrl);
        return billboardResultDto;
    }

    private BufferedImage getQRCodeImage(String url, int width, int height) throws WriterException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(url, BarcodeFormat.QR_CODE, width, height);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    private Long insertMarketingPlan(FissionPlanDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(this.idGen.getNum());
        marketingPlan.setBizId(userInfo.getBizId());
        marketingPlan.setCorpId(userInfo.getCorpId());
        marketingPlan.setName(params.getName());
        marketingPlan.setEndTime(params.getEndTime());
        marketingPlan.setStatus(Integer.valueOf(1));
        marketingPlan.setType(Integer.valueOf(PlanType.FRIEND_FISSION_PLAN.getValue()));
        marketingPlan.setTemplateType(Integer.valueOf(0));
        marketingPlan.setIsDeleted(Integer.valueOf(0));
        marketingPlan.setIsEnabled(Integer.valueOf(1));
        marketingPlan.setCreateBy(userInfo.getId());
        marketingPlan.setCreateTime(new Date());
        marketingPlan.setUpdateBy(userInfo.getId());
        marketingPlan.setUpdateTime(new Date());
        marketingPlan.setCustomizeReply(params.getCustomizeReply());
        this.marketingPlanMapper.insertSelective((Object)marketingPlan);
        params.setId(marketingPlan.getNum());
        return marketingPlan.getId();
    }

    private Long updateMarketingPlan(FissionPlanDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            return null;
        }
        marketingPlan.setName(params.getName());
        marketingPlan.setEndTime(params.getEndTime());
        marketingPlan.setStatus(Integer.valueOf(1));
        marketingPlan.setUpdateBy(userInfo.getId());
        marketingPlan.setUpdateTime(new Date());
        marketingPlan.setCustomizeReply(params.getCustomizeReply());
        List<FissionPlanStageDto> stages = params.getStages();
        boolean isUseAll = true;
        for (FissionPlanStageDto stageDto : stages) {
            Integer rewardCount = this.marketingRewardMapper.getRewardCount(userInfo.getCorpId(), marketingPlan.getId(), stageDto.getStage());
            if (stageDto.getRewardCount() <= rewardCount) continue;
            isUseAll = false;
            break;
        }
        if (isUseAll) {
            marketingPlan.setStatus(Integer.valueOf(2));
        } else {
            marketingPlan.setStatus(Integer.valueOf(1));
        }
        this.marketingPlanMapper.updateByPrimaryKeySelective((Object)marketingPlan);
        return marketingPlan.getId();
    }

    private ConfigIdResp createFriendFissionQrcode(CreateBillboardReqDto params, String state) {
        MarketingPlan marketingPlan = params.getMarketingPlan();
        FissionSwitchDto fissionSwitchDto = this.marketingConfigService.getSwitchConfig(marketingPlan.getCorpId(), marketingPlan.getId());
        log.info("createFriendFissionQrcode,fissionSwitchDto:{}", (Object)fissionSwitchDto);
        List weworkUserIds = this.marketingPlanGroupUserMapper.queryGroupUserIds(marketingPlan.getId(), NumberUtils.LONG_MINUS_ONE);
        ContactWay contactWayConfig = new ContactWay();
        if (NumberUtils.INTEGER_ONE.equals(fissionSwitchDto.getInviteQrcodeType())) {
            contactWayConfig.setType(NumberUtils.INTEGER_TWO);
            contactWayConfig.setUserIds(weworkUserIds);
        } else {
            String weworkUserId;
            contactWayConfig.setType(NumberUtils.INTEGER_ONE);
            if (NumberUtils.INTEGER_ONE.equals(params.getModel()) || params.getModel() == 3) {
                weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(params.getWeworkUserNum());
            } else {
                weworkUserId = (String)weworkUserIds.get(this.rd.nextInt(weworkUserIds.size()));
                String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(marketingPlan.getCorpId(), weworkUserId);
                params.setWeworkUserNum(weworkUserNum);
            }
            log.info("createFriendFissionQrcode,\u9009\u62e9\u7684\u6210\u5458\u4e3a:{}", (Object)weworkUserId);
            contactWayConfig.setUserIds((List)Lists.newArrayList((Object[])new String[]{weworkUserId}));
        }
        contactWayConfig.setScene(Integer.valueOf(2));
        contactWayConfig.setState(state);
        contactWayConfig.setIsTemp(Boolean.valueOf(false));
        return this.contactWayClient.create(marketingPlan.getCorpId(), contactWayConfig);
    }

    private MarketingJoin buildMarketingJoin(CreateBillboardReqDto params) {
        MarketingJoin marketingJoin = new MarketingJoin();
        String num = this.idGen.getNum();
        marketingJoin.setNum(num);
        marketingJoin.setBizId(params.getMarketingPlan().getBizId());
        marketingJoin.setCorpId(params.getMarketingPlan().getCorpId());
        marketingJoin.setContactId(params.getContactId());
        marketingJoin.setPlanId(params.getMarketingPlan().getId());
        marketingJoin.setPlanNum(params.getMarketingPlan().getNum());
        FissionBillboardDto fissionBillboardDto = params.getFissionBillboardDto();
        marketingJoin.setBgUrl(fissionBillboardDto.getBgUrl());
        marketingJoin.setBgParam(JacksonUtil.obj2Str((Object)fissionBillboardDto));
        marketingJoin.setQrcodeState(num);
        marketingJoin.setChannelId(params.getChannelId());
        marketingJoin.setCreateTime(new Date());
        marketingJoin.setUpdateTime(new Date());
        return marketingJoin;
    }

    private void addSaveMarketingReward(MarketingPlan marketingPlan, String contactId, Long channelId) {
        List stages = this.marketingRewardStageMapper.selectByPlanId(marketingPlan.getId());
        for (MarketingRewardStage stage : stages) {
            MarketingReward marketingReward = new MarketingReward();
            marketingReward.setBizId(marketingPlan.getBizId());
            marketingReward.setCorpId(marketingPlan.getCorpId());
            marketingReward.setContactId(contactId);
            marketingReward.setPlanId(marketingPlan.getId());
            marketingReward.setPlanNum(marketingPlan.getNum());
            marketingReward.setChannelId(channelId);
            marketingReward.setStage(stage.getStage());
            marketingReward.setInviteCount(stage.getInviteCount());
            marketingReward.setRewardCount(stage.getRewardCount());
            marketingReward.setRewardType(stage.getType());
            marketingReward.setContent(stage.getContent());
            marketingReward.setIsReach(NumberUtils.INTEGER_ZERO);
            marketingReward.setIsReceive(NumberUtils.INTEGER_ZERO);
            marketingReward.setCreateTime(new Date());
            marketingReward.setUpdateTime(new Date());
            marketingReward.setIsDeleted(NumberUtils.INTEGER_ZERO);
            if (NumberUtils.INTEGER_TWO.equals(stage.getType())) {
                marketingReward.setCodeId(stage.getExchangeCodeId());
            }
            this.marketingRewardMapper.insert((Object)marketingReward);
        }
    }
}

