/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.service.runner;

import cn.kinyun.crm.common.service.CrmProductLineService;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsConfigResp;
import cn.kinyun.crm.common.service.dto.resp.CrmProductLineResp;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.FileUtils;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.customerupdate.dto.CustomerUpdateDetailDto;
import com.kuaike.scrm.customerupdate.dto.CustomerUpdateTaskDto;
import com.kuaike.scrm.customerupdate.dto.ImportContext;
import com.kuaike.scrm.customerupdate.dto.ImportError;
import com.kuaike.scrm.customerupdate.dto.ImportProgress;
import com.kuaike.scrm.customerupdate.dto.ImportRow;
import com.kuaike.scrm.customerupdate.enums.CuHandlerStatusEnum;
import com.kuaike.scrm.customerupdate.enums.ProcessState;
import com.kuaike.scrm.customerupdate.enums.TaskTypeEnum;
import com.kuaike.scrm.customerupdate.enums.ValidateStatusEnum;
import com.kuaike.scrm.customerupdate.service.CustomerUpdateService;
import com.kuaike.scrm.customerupdate.service.impl.CustomerUpdateSupport;
import com.kuaike.scrm.customerupdate.utils.CustomerUpdateImportUtil;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTask;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTaskDetail;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTaskDetailTag;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskDetailMapper;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskDetailTagMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagGroupMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTaskRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskRunner.class);
    private IdGen idGen;
    private ChannelMapper channelMapper;
    private UserMapper userMapper;
    private CustomerUpdateService customerUpdateService;
    private AliyunOss aliyunOss;
    private WeworkTagGroupMapper tagGroupMapper;
    private WeworkTagMapper weworkTagMapper;
    private CurrentUserInfo userInfo;
    private CustomerStageMapper customerStageMapper;
    private CustomerUpdateTaskDetailMapper taskDetailMapper;
    private CustomerUpdateTaskDetailTagMapper detailTagMapper;
    private CustomerUpdateTask task;
    private CustomerUpdateSupport customerUpdateSupport;
    private CrmProductLineService productLineService;
    private final ImportContext context;
    private final ImportProgress progress;
    private final List<ImportError> errors = Lists.newArrayList();
    private final List<CrmLeadsConfigResp> leadsConfigResps;
    private final long startTime;
    private static final String ERROR_FILE_NAME = "\u5ba2\u6237\u66f4\u65b0\u5bfc\u5165\u5931\u8d25\u8bb0\u5f55";
    private static final String SUFFIX = ".xlsx";
    private final Set<String> mobileCache = Sets.newHashSet();
    private final Set<String> unionIdCache = Sets.newHashSet();
    private final Map<CrmLeadsConfigResp, Set<String>> optionCache = new HashMap<CrmLeadsConfigResp, Set<String>>();
    private final Map<CrmLeadsConfigResp, String> errorCache = new HashMap<CrmLeadsConfigResp, String>();
    private final Map<String, SimpleDateFormat> formatter = new HashMap<String, SimpleDateFormat>();
    private final Map<String, Long> userIdCache = new HashMap<String, Long>();
    private final Map<String, Long> channelIdCache = new HashMap<String, Long>();
    private final Map<String, String> tagGroupIdCache = new HashMap<String, String>();
    private final Map<String, Long> stageIdCache = new HashMap<String, Long>();
    private final int taskType;
    private final List<String> headers;
    private final List<CustomerUpdateTaskDetail> taskDetails;
    private final List<CustomerUpdateTaskDetailTag> detailTags;
    private final List<Long> taskDetailIds;

    public ImportTaskRunner(Integer taskType, ImportContext context) {
        this.taskType = taskType;
        this.context = context;
        this.progress = context.getProgress();
        this.headers = context.getHeaders();
        this.leadsConfigResps = context.getBusinessFields();
        this.taskDetails = Lists.newArrayList();
        this.detailTags = Lists.newArrayList();
        this.taskDetailIds = Lists.newArrayList();
        this.startTime = System.currentTimeMillis();
        log.info("\u521b\u5efa\u5bfc\u5165\u4efb\u52a1, timestamp:{}, \u5bfc\u5165\u4efb\u52a1\u53c2\u6570:{}, \u8868\u5934\u5b57\u6bb5:{}", new Object[]{this.startTime, taskType, this.headers});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long sec = 1000000000L;
            long timer = 0L;
            long timestamp = System.nanoTime();
            for (ImportRow row : this.context.getData()) {
                this.doProcess(row, this.taskType);
                timestamp = System.nanoTime();
                if ((timer += System.nanoTime() - timestamp) < sec) continue;
                timer -= sec;
                this.customerUpdateService.updateImportProgress(this.progress);
            }
            this.doAfter();
        }
        catch (Exception e) {
            log.error("Excel\u89e3\u6790\u5931\u8d25", (Throwable)e);
            this.progress.setState(ProcessState.FINISHED.getValue());
            this.customerUpdateService.updateImportProgress(this.progress);
        }
        finally {
            this.release();
        }
    }

    private void doProcess(ImportRow row, Integer taskType) {
        ImportError error;
        log.debug("\u6b63\u5728\u5904\u7406\u7b2c {} \u884c\u6570\u636e", (Object)row.getIndex());
        this.progress.setDealCount(this.progress.getDealCount() + 1);
        try {
            error = TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == taskType.intValue() ? this.processWeworkCustomerUpdate(row) : this.processMobileCustomerUpdate(row);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6570\u636e\u5931\u8d25, row:{}", (Object)row, (Object)e);
            error = new ImportError(row.getIndex(), "\u8bfb\u53d6\u6570\u636e\u5931\u8d25");
        }
        if (error != null) {
            this.errors.add(error);
            this.progress.setFailedCount(this.progress.getFailedCount() + 1);
        } else {
            this.progress.setSuccess(this.progress.getSuccess() + 1);
        }
    }

    private Set<String> getOptions(CrmLeadsConfigResp def) {
        Set<String> options = this.optionCache.get(def);
        if (options == null) {
            if (CollectionUtils.isEmpty((Collection)def.getDetails())) {
                options = Collections.emptySet();
            } else {
                LinkedHashSet<String> tmp = new LinkedHashSet<String>();
                def.getDetails().forEach(it -> tmp.add(it.getName()));
                options = tmp;
            }
        }
        this.optionCache.put(def, options);
        return options;
    }

    private ImportError validateCellData(int rowNum, CrmLeadsConfigResp def, Object val, Map<String, Object> store) {
        String field = def.getFieldName();
        switch (def.getType()) {
            case 0: {
                store.put(field, this.getStringValue(val));
                break;
            }
            case 1: {
                try {
                    Double value = this.getDoubleValue(val);
                    if (value == null) break;
                    store.put(field, value.intValue());
                    break;
                }
                catch (NumberFormatException e) {
                    String error = this.errorCache.computeIfAbsent(def, k -> String.format("\u5b57\u6bb5\uff08%s\uff09\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6570\u503c\u3002", def.getName()));
                    return new ImportError(rowNum, error);
                }
            }
            case 2: {
                try {
                    Double value = this.getDoubleValue(val);
                    store.put(field, value);
                    break;
                }
                catch (NumberFormatException e) {
                    String error = this.errorCache.computeIfAbsent(def, k -> String.format("\u5b57\u6bb5\uff08%s\uff09\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6570\u503c\u3002", def.getName()));
                    return new ImportError(rowNum, error);
                }
            }
            case 3: {
                return this.validateDate(rowNum, def, val, "yyyy-MM-dd", store);
            }
            case 4: {
                return this.validateSingleSelection(rowNum, def, val, store);
            }
            case 5: {
                return this.validateMultiSelection(rowNum, def, val, store);
            }
            case 6: {
                return this.validateDate(rowNum, def, val, "yyyy-MM-dd HH:mm:ss", store);
            }
            default: {
                log.warn("!!!\u672a\u77e5\u7684\u5b57\u6bb5\u7c7b!!!, def={}", (Object)def);
            }
        }
        return null;
    }

    private ImportError validateDate(int rowNum, CrmLeadsConfigResp def, Object val, String format, Map<String, Object> store) {
        if (val == null) {
            return null;
        }
        try {
            SimpleDateFormat dateFormat = this.formatter.computeIfAbsent(format, f -> new SimpleDateFormat((String)f, Locale.ENGLISH));
            Date value = this.getDateValue(val, dateFormat);
            if (value != null) {
                store.put(def.getFieldName(), dateFormat.format(value));
            }
        }
        catch (ParseException e) {
            String error = this.errorCache.computeIfAbsent(def, k -> String.format("\u5b57\u6bb5\uff08%s\uff09\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a%s", def.getName(), format));
            return new ImportError(rowNum, error);
        }
        return null;
    }

    private ImportError validateSingleSelection(int rowNum, CrmLeadsConfigResp def, Object val, Map<String, Object> store) {
        String value = this.getStringValue(val);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Set<String> options = this.getOptions(def);
        if (!options.contains(value)) {
            String error = this.errorCache.computeIfAbsent(def, k -> String.format("\u5b57\u6bb5\uff08%s\uff09\u7684\u53d6\u503c\u5e94\u662f\u5176\u4e2d\u4e4b\u4e00:[%s]", def.getName(), StringUtils.join((Iterable)options, (String)",")));
            return new ImportError(rowNum, error);
        }
        store.put(def.getFieldName(), value);
        return null;
    }

    private ImportError validateMultiSelection(int rowNum, CrmLeadsConfigResp def, Object val, Map<String, Object> store) {
        String[] items;
        String value = this.getStringValue(val);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Set<String> options = this.getOptions(def);
        for (String item : items = value.split(",")) {
            if (options.contains(item)) continue;
            String error = this.errorCache.computeIfAbsent(def, k -> String.format("\u5b57\u6bb5\uff08%s\uff09\u7684\u53d6\u503c\u8303\u56f4:[%s]", def.getName(), StringUtils.join((Iterable)options, (String)",")));
            return new ImportError(rowNum, error);
        }
        store.put(def.getFieldName(), value);
        return null;
    }

    private ImportError processWeworkCustomerUpdate(ImportRow row) {
        int rowNum = row.getIndex();
        List<Object> rowData = row.getData();
        Date curTime = new Date();
        CustomerUpdateTaskDetail taskDetail = new CustomerUpdateTaskDetail();
        taskDetail.init();
        this.taskDetails.add(taskDetail);
        String taskDetailNum = this.idGen.getNum();
        taskDetail.setBizId(this.userInfo.getBizId());
        taskDetail.setNum(taskDetailNum);
        taskDetail.setTaskId(this.context.getTaskId());
        taskDetail.setImportRecordId(this.context.getImportRecordId());
        taskDetail.setCreateBy(this.userInfo.getId());
        taskDetail.setUpdateBy(this.userInfo.getId());
        taskDetail.setCreateTime(curTime);
        taskDetail.setUpdateTime(curTime);
        String unionId = this.getStringValue(rowData.get(0));
        taskDetail.setUnionid(unionId);
        String mobile = this.getStringValue(rowData.get(1));
        taskDetail.setMobile(mobile);
        String groupName = this.getStringValue(rowData.get(2));
        taskDetail.setGroupName(groupName);
        String tagName = this.getStringValue(rowData.get(3));
        String remarkName = this.getStringValue(rowData.get(4));
        taskDetail.setRemarkName(remarkName);
        String description = this.getStringValue(rowData.get(5));
        taskDetail.setDescription(description);
        String stageValue = this.getStringValue(rowData.get(6));
        taskDetail.setStageName(stageValue);
        String channelName = this.getStringValue(rowData.get(7));
        taskDetail.setChannelName(channelName);
        String communicationMobile = this.getStringValue(rowData.get(8));
        taskDetail.setCommunicationMobile(communicationMobile);
        int validateStatus = 0;
        StringBuilder sb = new StringBuilder();
        boolean isAllNull = this.checkUpdateFieldValueAllNull(rowData, TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue());
        if (isAllNull) {
            sb.append(";\u66f4\u65b0\u5b57\u6bb5\u503c\u90fd\u4e3a\u7a7a");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        if (StringUtils.isNotBlank((CharSequence)remarkName) && remarkName.length() > 40) {
            sb.append(";\u5907\u6ce8\u540d\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        if (StringUtils.isNotBlank((CharSequence)description) && description.length() > 512) {
            sb.append(";\u5ba2\u6237\u63cf\u8ff0\u4e0d\u80fd\u8d85\u8fc7512\u4e2a\u5b57\u7b26");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        if (StringUtils.isBlank((CharSequence)unionId) && StringUtils.isBlank((CharSequence)mobile)) {
            log.warn("#{}: unionID\u548c\u624b\u673a\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object)rowNum);
            sb.append(";unionID\u548c\u624b\u673a\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        if (StringUtils.isNotBlank((CharSequence)unionId) && this.unionIdCache.contains(unionId)) {
            sb.append(";unionID\u91cd\u590d");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        this.unionIdCache.add(unionId);
        if (StringUtils.isNotBlank((CharSequence)mobile) && this.mobileCache.contains(mobile)) {
            sb.append(";\u624b\u673a\u53f7\u91cd\u590d");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        this.mobileCache.add(mobile);
        List<String> tagNames = null;
        String tagGroupId = null;
        Map tagName2IdMap = null;
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            tagGroupId = this.tagGroupIdCache.get(groupName);
            if (StringUtils.isBlank((CharSequence)tagGroupId)) {
                tagGroupId = this.tagGroupMapper.queryGroupIdByBizIdAndGroupName(this.userInfo.getBizId(), groupName);
            }
            if (StringUtils.isBlank((CharSequence)tagGroupId)) {
                sb.append(";\u6807\u7b7e\u7ec4\u540d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            }
            this.tagGroupIdCache.put(groupName, tagGroupId);
            if (StringUtils.isNotBlank((CharSequence)tagName)) {
                tagNames = Arrays.asList(tagName.split(",|\uff0c"));
                tagName2IdMap = this.weworkTagMapper.queryTagIdNameByGroupIdAndNames(this.userInfo.getBizId(), tagGroupId, tagNames);
                if (MapUtils.isEmpty((Map)tagName2IdMap) || tagNames.size() != tagName2IdMap.size()) {
                    log.warn("excel\u4e2d\u7684\u6807\u7b7e:{},\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u6807\u7b7e:{}", tagNames, (Object)tagName2IdMap);
                    sb.append(";\u6709\u6807\u7b7e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    validateStatus = ValidateStatusEnum.FAIL.getValue();
                }
            } else {
                sb.append(";\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            }
        } else if (StringUtils.isNotBlank((CharSequence)tagName)) {
            sb.append(";\u6ca1\u6709\u8f93\u5165\u6807\u7b7e\u5bf9\u5e94\u7684\u6807\u7b7e\u7ec4");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        this.buildDetailTags(taskDetailNum, groupName, tagGroupId, tagNames, tagName2IdMap);
        if (StringUtils.isNotBlank((CharSequence)stageValue)) {
            Long stageId = this.stageIdCache.get(stageValue);
            if (Objects.isNull(stageId)) {
                stageId = this.customerStageMapper.queryIdByBizIdAndStageValue(this.userInfo.getBizId(), stageValue);
            }
            if (Objects.isNull(stageId)) {
                sb.append(";\u5ba2\u6237\u9636\u6bb5\u540d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            } else {
                this.stageIdCache.put(stageValue, stageId);
                taskDetail.setStageId(stageId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)channelName)) {
            Long channelId = this.channelIdCache.get(channelName);
            if (Objects.isNull(channelId)) {
                channelId = this.channelMapper.queryIdByBizIdAndChannelName(this.userInfo.getBizId(), channelName);
            }
            if (Objects.isNull(channelId)) {
                sb.append(";\u6570\u636e\u6e20\u9053\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            } else {
                this.channelIdCache.put(channelName, channelId);
                taskDetail.setChannelId(channelId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)communicationMobile) && !MobileUtils.isPhone((String)communicationMobile)) {
            sb.append(";\u4e92\u901a\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        ImportError importError = null;
        if (validateStatus == ValidateStatusEnum.FAIL.getValue()) {
            taskDetail.setValidateFailReason(sb.substring(1));
            taskDetail.setHandleStatus(Integer.valueOf(CuHandlerStatusEnum.FAIL.getValue()));
            importError = new ImportError(rowNum, sb.substring(1));
        } else {
            validateStatus = ValidateStatusEnum.SUCCESS.getValue();
        }
        taskDetail.setValidateStatus(Integer.valueOf(validateStatus));
        return importError;
    }

    private ImportError processMobileCustomerUpdate(ImportRow row) {
        int rowNum = row.getIndex();
        List<Object> rowData = row.getData();
        Date curTime = new Date();
        CustomerUpdateTaskDetail taskDetail = new CustomerUpdateTaskDetail();
        taskDetail.init();
        this.taskDetails.add(taskDetail);
        String taskDetailNum = this.idGen.getNum();
        taskDetail.setBizId(this.userInfo.getBizId());
        taskDetail.setNum(taskDetailNum);
        taskDetail.setTaskId(this.context.getTaskId());
        taskDetail.setImportRecordId(this.context.getImportRecordId());
        taskDetail.setCreateBy(this.userInfo.getId());
        taskDetail.setUpdateBy(this.userInfo.getId());
        taskDetail.setCreateTime(curTime);
        taskDetail.setUpdateTime(curTime);
        String mobile = this.getStringValue(rowData.get(0));
        taskDetail.setMobile(mobile);
        String customerName = this.getStringValue(rowData.get(1));
        taskDetail.setCustomerName(customerName);
        String groupName = this.getStringValue(rowData.get(2));
        String tagName = this.getStringValue(rowData.get(3));
        String bindingUserIdentifier = this.getStringValue(rowData.get(4));
        taskDetail.setBindingUserIdentifier(bindingUserIdentifier);
        String stageValue = this.getStringValue(rowData.get(5));
        taskDetail.setStageName(stageValue);
        String channelName = this.getStringValue(rowData.get(6));
        taskDetail.setChannelName(channelName);
        int validateStatus = 0;
        StringBuilder sb = new StringBuilder();
        boolean isAllNull = this.checkUpdateFieldValueAllNull(rowData, TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue());
        if (isAllNull) {
            sb.append(";\u66f4\u65b0\u5b57\u6bb5\u503c\u90fd\u4e3a\u7a7a");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        if (StringUtils.isNotBlank((CharSequence)customerName) && customerName.length() > 32) {
            sb.append(";\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        List<String> tagNames = null;
        String tagGroupId = null;
        Map tagName2IdMap = null;
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            tagGroupId = this.tagGroupIdCache.get(groupName);
            if (StringUtils.isBlank((CharSequence)tagGroupId)) {
                tagGroupId = this.tagGroupMapper.queryGroupIdByBizIdAndGroupName(this.userInfo.getBizId(), groupName);
            }
            if (StringUtils.isBlank((CharSequence)tagGroupId)) {
                sb.append(";\u6807\u7b7e\u7ec4\u540d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            }
            this.tagGroupIdCache.put(groupName, tagGroupId);
            if (StringUtils.isNotBlank((CharSequence)tagName)) {
                tagNames = Arrays.asList(tagName.split(",|\uff0c"));
                tagName2IdMap = this.weworkTagMapper.queryTagIdNameByGroupIdAndNames(this.userInfo.getBizId(), tagGroupId, tagNames);
                if (MapUtils.isEmpty((Map)tagName2IdMap) || tagNames.size() != tagName2IdMap.size()) {
                    log.warn("excel\u4e2d\u7684\u6807\u7b7e:{},\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u6807\u7b7e:{}", tagNames, (Object)tagName2IdMap);
                    sb.append(";\u6709\u6807\u7b7e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    validateStatus = ValidateStatusEnum.FAIL.getValue();
                }
            } else {
                sb.append(";\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            }
        } else if (StringUtils.isNotBlank((CharSequence)tagName)) {
            sb.append(";\u6ca1\u6709\u8f93\u5165\u6807\u7b7e\u5bf9\u5e94\u7684\u6807\u7b7e\u7ec4");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        this.buildDetailTags(taskDetailNum, groupName, tagGroupId, tagNames, tagName2IdMap);
        if (StringUtils.isNotBlank((CharSequence)stageValue)) {
            Long stageId = this.stageIdCache.get(stageValue);
            if (Objects.isNull(stageId)) {
                stageId = this.customerStageMapper.queryIdByBizIdAndStageValue(this.userInfo.getBizId(), stageValue);
            }
            if (Objects.isNull(stageId)) {
                sb.append(";\u5ba2\u6237\u9636\u6bb5\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            } else {
                this.stageIdCache.put(stageValue, stageId);
                taskDetail.setStageId(stageId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)channelName)) {
            Long channelId = this.channelIdCache.get(channelName);
            if (Objects.isNull(channelId)) {
                channelId = this.channelMapper.queryIdByBizIdAndChannelName(this.userInfo.getBizId(), channelName);
            }
            if (Objects.isNull(channelId)) {
                sb.append(";\u6570\u636e\u6e20\u9053\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            } else {
                this.channelIdCache.put(channelName, channelId);
                taskDetail.setChannelId(channelId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bindingUserIdentifier)) {
            Long bindingUserId = this.getUserIdByIdentifier(bindingUserIdentifier);
            if (-1L == bindingUserId) {
                sb.append(";\u7ed1\u5b9a\u4eba\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            } else {
                taskDetail.setBindingUserId(bindingUserId);
            }
        }
        if (StringUtils.isBlank((CharSequence)mobile)) {
            sb.append(";\u624b\u673a\u53f7\u5fc5\u586b");
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        } else {
            if (!MobileUtils.isPhone((String)mobile)) {
                sb.append(";\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            }
            if (this.mobileCache.contains(mobile)) {
                sb.append(";\u624b\u673a\u53f7\u91cd\u590d");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            }
        }
        this.mobileCache.add(mobile);
        ImportError importError = null;
        if (CollectionUtils.isEmpty(this.leadsConfigResps)) {
            if (validateStatus == ValidateStatusEnum.FAIL.getValue()) {
                taskDetail.setValidateFailReason(sb.substring(1));
                taskDetail.setHandleStatus(Integer.valueOf(CuHandlerStatusEnum.FAIL.getValue()));
                importError = new ImportError(rowNum, sb.substring(1));
            } else {
                validateStatus = ValidateStatusEnum.SUCCESS.getValue();
            }
            taskDetail.setValidateStatus(Integer.valueOf(validateStatus));
            return importError;
        }
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.leadsConfigResps.size(); ++i) {
            Object val = rowData.get(i + 7);
            if (val == null) continue;
            valueMap.put(this.leadsConfigResps.get(i).getFieldName(), this.getStringValue(val));
            ImportError error = this.validateCellData(rowNum, this.leadsConfigResps.get(i), val, valueMap);
            if (error == null) continue;
            log.warn("#{}: \u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d", (Object)row.getIndex());
            sb.append(";").append(error.getMessage());
            validateStatus = ValidateStatusEnum.FAIL.getValue();
        }
        taskDetail.setP1(valueMap.containsKey("p1") ? this.getStringValue(valueMap.get("p1")) : "");
        taskDetail.setP2(valueMap.containsKey("p2") ? this.getStringValue(valueMap.get("p2")) : "");
        taskDetail.setP3(valueMap.containsKey("p3") ? this.getStringValue(valueMap.get("p3")) : "");
        taskDetail.setP4(valueMap.containsKey("p4") ? this.getStringValue(valueMap.get("p4")) : "");
        taskDetail.setP5(valueMap.containsKey("p5") ? this.getStringValue(valueMap.get("p5")) : "");
        taskDetail.setP6(valueMap.containsKey("p6") ? this.getStringValue(valueMap.get("p6")) : "");
        taskDetail.setP7(valueMap.containsKey("p7") ? this.getStringValue(valueMap.get("p7")) : "");
        taskDetail.setP8(valueMap.containsKey("p8") ? this.getStringValue(valueMap.get("p8")) : "");
        taskDetail.setP9(valueMap.containsKey("p9") ? this.getStringValue(valueMap.get("p9")) : "");
        taskDetail.setP10(valueMap.containsKey("p10") ? this.getStringValue(valueMap.get("p10")) : "");
        taskDetail.setP11(valueMap.containsKey("p11") ? this.getStringValue(valueMap.get("p11")) : "");
        taskDetail.setP12(valueMap.containsKey("p12") ? this.getStringValue(valueMap.get("p12")) : "");
        taskDetail.setP13(valueMap.containsKey("p13") ? this.getStringValue(valueMap.get("p13")) : "");
        taskDetail.setP14(valueMap.containsKey("p14") ? this.getStringValue(valueMap.get("p14")) : "");
        taskDetail.setP15(valueMap.containsKey("p15") ? this.getStringValue(valueMap.get("p15")) : "");
        taskDetail.setP16(valueMap.containsKey("p16") ? this.getStringValue(valueMap.get("p16")) : "");
        taskDetail.setP17(valueMap.containsKey("p17") ? this.getStringValue(valueMap.get("p17")) : "");
        taskDetail.setP18(valueMap.containsKey("p18") ? this.getStringValue(valueMap.get("p18")) : "");
        taskDetail.setP19(valueMap.containsKey("p19") ? this.getStringValue(valueMap.get("p19")) : "");
        taskDetail.setP20(valueMap.containsKey("p20") ? this.getStringValue(valueMap.get("p20")) : "");
        if (valueMap.get("market_user_id") != null) {
            String marketUserIdentifier = (String)valueMap.get("market_user_id");
            taskDetail.setMarketUserName(marketUserIdentifier);
            Long marketUserId = this.getUserIdByIdentifier(marketUserIdentifier);
            if (-1L == marketUserId) {
                sb.append(";").append("\u63a8\u5e7f\u4eba\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                validateStatus = ValidateStatusEnum.FAIL.getValue();
            } else {
                taskDetail.setMarketUserId(marketUserId);
            }
        }
        if (validateStatus == ValidateStatusEnum.FAIL.getValue()) {
            taskDetail.setValidateFailReason(sb.substring(1));
            taskDetail.setHandleStatus(Integer.valueOf(CuHandlerStatusEnum.FAIL.getValue()));
            importError = new ImportError(rowNum, sb.substring(1));
        } else {
            validateStatus = ValidateStatusEnum.SUCCESS.getValue();
        }
        taskDetail.setValidateStatus(Integer.valueOf(validateStatus));
        return importError;
    }

    private Long getUserIdByIdentifier(String identifier) {
        Long userId = this.userIdCache.get(identifier);
        if (userId != null) {
            return userId;
        }
        userId = this.userMapper.getIdByIdentifier(this.context.getBizId(), identifier);
        if (userId == null) {
            userId = -1L;
        }
        this.userIdCache.put(identifier, userId);
        return userId;
    }

    private void doAfter() {
        if (CollectionUtils.isNotEmpty(this.errors)) {
            this.uploadErrorMessage();
        }
        this.progress.setState(ProcessState.FINISHED.getValue());
        this.progress.setCostTime((int)(System.currentTimeMillis() - this.startTime));
        this.customerUpdateService.updateImportProgress(this.progress);
        this.customerUpdateService.onFinished(this.progress);
        if (CollectionUtils.isNotEmpty(this.taskDetails)) {
            Lists.partition(this.taskDetails, (int)500).forEach(part -> this.taskDetailMapper.batchInsert((Collection)part));
            Map<String, Long> taskDetailNum2IdMap = this.taskDetails.stream().collect(Collectors.toMap(CustomerUpdateTaskDetail::getNum, CustomerUpdateTaskDetail::getId));
            for (CustomerUpdateTaskDetailTag detailTag : this.detailTags) {
                Long detailTaskId = taskDetailNum2IdMap.get(detailTag.getTaskDetailNum());
                detailTag.setTaskDetailId(detailTaskId);
            }
            Lists.partition(this.detailTags, (int)1000).forEach(part -> this.detailTagMapper.batchInsert((Collection)part));
            CustomerUpdateTaskDto taskDto = this.buildCustomerUpdateTaskDto();
            List<CustomerUpdateDetailDto> taskDetailDtos = this.buildUpdateDetailDtos();
            if (CollectionUtils.isEmpty(taskDetailDtos)) {
                log.info("\u6ca1\u6709\u6821\u9a8c\u901a\u8fc7\u7684\u8bb0\u5f55\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f");
            } else {
                this.customerUpdateSupport.syncUpdateCustomerInfo(taskDto, taskDetailDtos);
            }
            if (CollectionUtils.isNotEmpty(this.taskDetailIds)) {
                Lists.partition(this.taskDetailIds, (int)500).forEach(part -> this.taskDetailMapper.batchUpdateStatus((Collection)part, Integer.valueOf(CuHandlerStatusEnum.SUCCESS.getValue()), "", this.userInfo.getBizId(), this.userInfo.getId()));
            }
        }
    }

    private void release() {
        File file;
        log.info("release");
        LoginUtils.clear();
        Workbook workbook = this.context.getWorkbook();
        if (workbook != null) {
            try {
                workbook.close();
            }
            catch (IOException e) {
                log.info("\u5173\u95edworkbook\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            }
        }
        if ((file = this.context.getFile()) != null && file.exists() && !file.delete()) {
            log.warn("Delete file failed:{}", (Object)file.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadErrorMessage() {
        log.info("\u6b63\u5728\u4e0a\u4f20\u9519\u8bef\u4fe1\u606f:{}", this.errors);
        Workbook workbook = this.exportErrors();
        FileOutputStream os = null;
        File file = null;
        try {
            String prefix = "\u5ba2\u6237\u66f4\u65b0\u5bfc\u5165\u5931\u8d25\u8bb0\u5f55_" + this.progress.getTaskId();
            file = File.createTempFile(prefix, SUFFIX);
            os = new FileOutputStream(file);
            workbook.write((OutputStream)os);
            String url = this.aliyunOss.uploadFile(this.context.getCorpId(), file, file.getName());
            this.progress.setErrorUrl(url);
            this.progress.setErrorFileName(prefix + SUFFIX);
            this.progress.setErrorFileSize(FileUtils.format((long)file.length()));
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20excel\u9519\u8bef\u4fe1\u606f\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                }
            }
            if (file != null && file.exists() && !file.delete()) {
                log.warn("Delete file failed:{}", (Object)file.getName());
            }
        }
    }

    private Workbook exportErrors() {
        XSSFWorkbook workbook = CustomerUpdateImportUtil.createWorkbook(this.headers, this.taskType);
        XSSFSheet dstSheet = workbook.getSheetAt(0);
        XSSFFont font = workbook.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)12);
        font.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFont((Font)font);
        HashMap<Integer, CellStyle> styleMap = new HashMap<Integer, CellStyle>();
        int row = 3;
        Sheet sheet = this.context.getSheet();
        for (ImportError error : this.errors) {
            Row srcRow = sheet.getRow(error.getIndex());
            XSSFRow dstRow = dstSheet.createRow(row++);
            dstRow.setHeight(srcRow.getHeight());
            for (int col = 0; col < this.context.getColumnSize(); ++col) {
                Cell srcCell = srcRow.getCell(col);
                if (srcCell == null) continue;
                Cell dstCell = dstRow.createCell(col);
                ImportTaskRunner.copyCell(srcCell, dstCell, styleMap);
            }
            Cell cell = dstRow.createCell(this.context.getColumnSize(), CellType.STRING);
            cell.setCellValue(error.getMessage());
            cell.setCellStyle((CellStyle)style);
        }
        return workbook;
    }

    public static void copyCell(Cell srcCell, Cell dstCell, Map<Integer, CellStyle> styleMap) {
        if (styleMap != null) {
            int styleHashCode = srcCell.getCellStyle().hashCode();
            CellStyle newCellStyle = styleMap.get(styleHashCode);
            if (newCellStyle == null) {
                newCellStyle = dstCell.getSheet().getWorkbook().createCellStyle();
                newCellStyle.cloneStyleFrom(srcCell.getCellStyle());
                styleMap.put(styleHashCode, newCellStyle);
            }
            dstCell.setCellStyle(newCellStyle);
        }
        switch (srcCell.getCellType()) {
            case STRING: 
            case _NONE: {
                dstCell.setCellValue(srcCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                dstCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                dstCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                dstCell.setCellFormula(srcCell.getCellFormula());
                break;
            }
        }
    }

    protected String getStringValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            String s = (String)o;
            if (StringUtils.isEmpty((CharSequence)s)) {
                return "";
            }
            return s;
        }
        if (o instanceof Double) {
            return String.format("%.0f", (Double)o);
        }
        return String.valueOf(o);
    }

    protected Double getDoubleValue(Object o) throws NumberFormatException {
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        if (o instanceof Double) {
            return (double)((Double)o);
        }
        return null;
    }

    protected Date getDateValue(Object o, SimpleDateFormat formatter) throws ParseException {
        if (o instanceof String) {
            String str = (String)o;
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            return formatter.parse(str);
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Double) {
            return DateUtil.getJavaDate((double)((Double)o));
        }
        return null;
    }

    private void buildDetailTags(String taskDetailNum, String groupName, String tagGroupId, List<String> tagNames, Map<String, String> tagName2IdMap) {
        if (CollectionUtils.isEmpty(tagNames) && StringUtils.isBlank((CharSequence)groupName)) {
            return;
        }
        Date curTime = new Date();
        if (CollectionUtils.isNotEmpty(tagNames)) {
            for (String tagName : tagNames) {
                CustomerUpdateTaskDetailTag detailTag = new CustomerUpdateTaskDetailTag();
                this.detailTags.add(detailTag);
                detailTag.setBizId(this.userInfo.getBizId());
                detailTag.setNum(this.idGen.getNum());
                detailTag.setTaskDetailNum(taskDetailNum);
                detailTag.setGroupId(tagGroupId != null ? tagGroupId : "");
                detailTag.setGroupName(groupName);
                if (MapUtils.isNotEmpty(tagName2IdMap) && tagName2IdMap.containsKey(tagName)) {
                    detailTag.setTagId(tagName2IdMap.get(tagName));
                } else {
                    detailTag.setTagId("");
                }
                detailTag.setTagName(tagName);
                detailTag.setCreateBy(this.userInfo.getId());
                detailTag.setUpdateBy(this.userInfo.getId());
                detailTag.setCreateTime(curTime);
                detailTag.setUpdateTime(curTime);
                detailTag.setIsDeleted(NumberUtils.INTEGER_ZERO);
            }
        } else if (StringUtils.isNotBlank((CharSequence)groupName)) {
            CustomerUpdateTaskDetailTag detailTag = new CustomerUpdateTaskDetailTag();
            this.detailTags.add(detailTag);
            detailTag.setBizId(this.userInfo.getBizId());
            detailTag.setNum(this.idGen.getNum());
            detailTag.setTaskDetailNum(taskDetailNum);
            detailTag.setGroupId(tagGroupId != null ? tagGroupId : "");
            detailTag.setGroupName(groupName);
            detailTag.setTagId("");
            detailTag.setTagName("");
            detailTag.setCreateBy(this.userInfo.getId());
            detailTag.setUpdateBy(this.userInfo.getId());
            detailTag.setCreateTime(curTime);
            detailTag.setUpdateTime(curTime);
            detailTag.setIsDeleted(NumberUtils.INTEGER_ZERO);
        }
    }

    private CustomerUpdateTaskDto buildCustomerUpdateTaskDto() {
        CustomerUpdateTaskDto taskDto = new CustomerUpdateTaskDto();
        taskDto.setCorpId(this.userInfo.getCorpId());
        taskDto.setBizId(this.userInfo.getBizId());
        taskDto.setTaskId(this.task.getId());
        taskDto.setTaskType(this.task.getTaskType());
        if (Objects.nonNull(this.task.getProductLineId()) && this.task.getProductLineId() > 0L) {
            CrmProductLineResp crmProductLineResp = this.productLineService.getById(this.userInfo.getBizId(), this.task.getProductLineId());
            taskDto.setProductLineId(crmProductLineResp.getId());
            taskDto.setProductLineNum(crmProductLineResp.getNum());
        }
        taskDto.setTagHandleWay(this.task.getTagHandleWay());
        if (this.task.getRemarkNameHandleWay() != null && this.task.getRemarkNameHandleWay() > 0) {
            taskDto.setRemarkNameHandleWay(this.task.getRemarkNameHandleWay());
        }
        taskDto.setInputType(this.task.getInputType());
        if (StringUtils.isNotBlank((CharSequence)this.task.getTagIds())) {
            taskDto.setTagIds(Arrays.asList(this.task.getTagIds().split(",")));
        }
        taskDto.setOperatorUserId(this.userInfo.getId());
        return taskDto;
    }

    private List<CustomerUpdateDetailDto> buildUpdateDetailDtos() {
        ArrayList detailDtos = Lists.newArrayList();
        List channelIds = this.taskDetails.stream().map(CustomerUpdateTaskDetail::getChannelId).collect(Collectors.toList());
        Map<Object, Object> channelId2ChannelMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(channelIds)) {
            List channels = this.channelMapper.queryChannels(this.userInfo.getBizId(), channelIds);
            channelId2ChannelMap = channels.stream().collect(Collectors.toMap(Channel::getId, Functions.identity()));
        }
        Map<Object, Object> detailId2TagsMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(this.detailTags)) {
            detailId2TagsMap = this.detailTags.stream().collect(Collectors.groupingBy(CustomerUpdateTaskDetailTag::getTaskDetailId));
        }
        for (CustomerUpdateTaskDetail detail : this.taskDetails) {
            boolean isUpdateFieldsIsNull;
            List taskDetailTags;
            Channel channel;
            if (ValidateStatusEnum.SUCCESS.getValue() != detail.getValidateStatus().intValue()) continue;
            CustomerUpdateDetailDto detailDto = new CustomerUpdateDetailDto();
            detailDto.setTaskDetailId(detail.getId());
            if (StringUtils.isNotBlank((CharSequence)detail.getUnionid())) {
                detailDto.setUnionid(detail.getUnionid());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getMobile())) {
                detailDto.setMobile(detail.getMobile());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getRemarkName())) {
                detailDto.setRemarkName(detail.getRemarkName());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getCustomerName())) {
                detailDto.setCustomerName(detail.getCustomerName());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getDescription())) {
                detailDto.setDescription(detail.getDescription());
            }
            if (Objects.nonNull(detail.getStageId()) && detail.getStageId() > 0L) {
                detailDto.setStageId(detail.getStageId());
                detailDto.setStageName(detail.getStageName());
            }
            if (Objects.nonNull(detail.getChannelId()) && detail.getChannelId() > 0L && (channel = (Channel)channelId2ChannelMap.get(detail.getChannelId())) != null) {
                detailDto.setChannelId(channel.getId());
                detailDto.setChannelNum(channel.getNum());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getCommunicationMobile())) {
                detailDto.setCommunicationMobile(detail.getCommunicationMobile());
            }
            if (Objects.nonNull(detail.getMarketUserId())) {
                detailDto.setMarketUserId(detail.getMarketUserId());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP1())) {
                detailDto.setP1(detail.getP1());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP2())) {
                detailDto.setP2(detail.getP2());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP3())) {
                detailDto.setP3(detail.getP3());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP4())) {
                detailDto.setP4(detail.getP4());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP5())) {
                detailDto.setP5(detail.getP5());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP6())) {
                detailDto.setP6(detail.getP6());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP7())) {
                detailDto.setP7(detail.getP7());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP8())) {
                detailDto.setP8(detail.getP8());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP9())) {
                detailDto.setP9(detail.getP9());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP10())) {
                detailDto.setP10(detail.getP10());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP11())) {
                detailDto.setP11(detail.getP11());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP12())) {
                detailDto.setP12(detail.getP12());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP13())) {
                detailDto.setP13(detail.getP13());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP14())) {
                detailDto.setP14(detail.getP14());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP15())) {
                detailDto.setP15(detail.getP15());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP16())) {
                detailDto.setP16(detail.getP16());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP17())) {
                detailDto.setP17(detail.getP17());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP18())) {
                detailDto.setP18(detail.getP18());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP19())) {
                detailDto.setP19(detail.getP19());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP20())) {
                detailDto.setP20(detail.getP20());
            }
            if (CollectionUtils.isNotEmpty((Collection)(taskDetailTags = (List)detailId2TagsMap.get(detail.getId())))) {
                detailDto.setTagIds(taskDetailTags.stream().map(CustomerUpdateTaskDetailTag::getTagId).collect(Collectors.toList()));
            }
            if (Objects.nonNull(detail.getBindingUserId()) && detail.getBindingUserId() > 0L) {
                detailDto.setBindingUserId(detail.getBindingUserId());
            }
            if (isUpdateFieldsIsNull = detailDto.checkNeedUpdateFieldsIsNull()) {
                this.taskDetailIds.add(detail.getId());
                continue;
            }
            detailDtos.add(detailDto);
        }
        return detailDtos;
    }

    private boolean checkUpdateFieldValueAllNull(List<Object> rowData, int taskType) {
        int start = 1;
        if (taskType == TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue()) {
            start = 2;
        }
        for (int i = start; i < rowData.size(); ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getStringValue(rowData.get(i)))) continue;
            return false;
        }
        return true;
    }

    public void setIdGen(IdGen idGen) {
        this.idGen = idGen;
    }

    public void setChannelMapper(ChannelMapper channelMapper) {
        this.channelMapper = channelMapper;
    }

    public void setUserMapper(UserMapper userMapper) {
        this.userMapper = userMapper;
    }

    public void setCustomerUpdateService(CustomerUpdateService customerUpdateService) {
        this.customerUpdateService = customerUpdateService;
    }

    public void setAliyunOss(AliyunOss aliyunOss) {
        this.aliyunOss = aliyunOss;
    }

    public void setTagGroupMapper(WeworkTagGroupMapper tagGroupMapper) {
        this.tagGroupMapper = tagGroupMapper;
    }

    public void setWeworkTagMapper(WeworkTagMapper weworkTagMapper) {
        this.weworkTagMapper = weworkTagMapper;
    }

    public void setUserInfo(CurrentUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setCustomerStageMapper(CustomerStageMapper customerStageMapper) {
        this.customerStageMapper = customerStageMapper;
    }

    public void setTaskDetailMapper(CustomerUpdateTaskDetailMapper taskDetailMapper) {
        this.taskDetailMapper = taskDetailMapper;
    }

    public void setDetailTagMapper(CustomerUpdateTaskDetailTagMapper detailTagMapper) {
        this.detailTagMapper = detailTagMapper;
    }

    public void setTask(CustomerUpdateTask task) {
        this.task = task;
    }

    public void setCustomerUpdateSupport(CustomerUpdateSupport customerUpdateSupport) {
        this.customerUpdateSupport = customerUpdateSupport;
    }

    public void setProductLineService(CrmProductLineService productLineService) {
        this.productLineService = productLineService;
    }
}

