/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.service.impl;

import cn.kinyun.crm.common.service.CrmConfigService;
import cn.kinyun.crm.common.service.CrmProductLineService;
import cn.kinyun.crm.common.service.CrmTemplateService;
import cn.kinyun.crm.common.service.dto.req.CrmTemplateReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsConfigResp;
import cn.kinyun.crm.common.service.dto.resp.CrmProductLineResp;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.ExcelUtil;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdName;
import com.kuaike.scrm.common.dto.StrIdDto;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.FileUtils;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.customerupdate.dto.CustomerUpdateDetailDto;
import com.kuaike.scrm.customerupdate.dto.CustomerUpdateTaskDto;
import com.kuaike.scrm.customerupdate.dto.ImportContext;
import com.kuaike.scrm.customerupdate.dto.ImportProgress;
import com.kuaike.scrm.customerupdate.dto.ImportRow;
import com.kuaike.scrm.customerupdate.dto.req.CustomerListReq;
import com.kuaike.scrm.customerupdate.dto.req.CustomerUpdateAddReq;
import com.kuaike.scrm.customerupdate.dto.req.CustomerUpdateListReq;
import com.kuaike.scrm.customerupdate.dto.req.CustomerUpdateTemplateReq;
import com.kuaike.scrm.customerupdate.dto.resp.CustomerListResp;
import com.kuaike.scrm.customerupdate.dto.resp.CustomerUpdateResp;
import com.kuaike.scrm.customerupdate.dto.resp.CustomerUpdateTaskProgressResp;
import com.kuaike.scrm.customerupdate.enums.CuHandlerStatusEnum;
import com.kuaike.scrm.customerupdate.enums.InputTypeEnum;
import com.kuaike.scrm.customerupdate.enums.ProcessState;
import com.kuaike.scrm.customerupdate.enums.TaskTypeEnum;
import com.kuaike.scrm.customerupdate.enums.ValidateStatusEnum;
import com.kuaike.scrm.customerupdate.service.CustomerUpdateService;
import com.kuaike.scrm.customerupdate.service.impl.CustomerUpdateSupport;
import com.kuaike.scrm.customerupdate.service.runner.ImportTaskRunner;
import com.kuaike.scrm.customerupdate.utils.CustomerUpdateImportUtil;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.marketing.dto.CustomerUpdateListDto;
import com.kuaike.scrm.dal.marketing.dto.CustomerUpdateTaskDetailQuery;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateImportRecord;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTask;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTaskDetail;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTaskDetailTag;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateImportRecordMapper;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskDetailMapper;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskDetailTagMapper;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupPair;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupPairInfo;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagGroupMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.trace.utils.TraceExecutorWrapUtil;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CustomerUpdateServiceImpl
implements CustomerUpdateService {
    private static final Logger log = LoggerFactory.getLogger(CustomerUpdateServiceImpl.class);
    @Resource
    private UserRoleCommonService userRoleCommonService;
    @Resource
    private CrmTemplateService crmTemplateService;
    @Autowired
    private CrmProductLineService productLineService;
    @Resource
    private CrmConfigService crmConfigService;
    @Resource
    private IdGen idGen;
    @Resource
    private AliyunOss aliyunOss;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private CustomerUpdateSupport customerUpdateSupport;
    @Resource
    private CustomerUpdateTaskMapper taskMapper;
    @Resource
    private CustomerUpdateTaskDetailMapper taskDetailMapper;
    @Resource
    private CustomerUpdateTaskDetailTagMapper taskDetailTagMapper;
    @Resource
    private CustomerUpdateImportRecordMapper importRecordMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private WeworkTagGroupMapper tagGroupMapper;
    @Resource
    private CustomerStageMapper customerStageMapper;
    @Resource
    private CcCustomerNumService customerNumService;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Value(value="${spring.redis.key.prefix}")
    private String prefix;
    private final ExecutorService executeService = new ThreadPoolExecutor(4, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("customerUpdateImport"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executeService);
    }

    @Override
    public List<CustomerUpdateResp> list(CustomerUpdateListReq req) {
        CustomerUpdateListDto updateListDto;
        List tasks;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("list,params:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        if (Objects.nonNull(req.getCreatorId())) {
            if (manageUserIds.contains(req.getCreatorId())) {
                manageUserIds = Sets.newHashSet((Object[])new Long[]{req.getCreatorId()});
            } else {
                log.info("creatorId:{}\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u7ba1\u8f96\u8303\u56f4\u5185", (Object)req.getCreatorId());
                return Collections.emptyList();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(tasks = this.taskMapper.selectList(updateListDto = req.convert2UpdateListDto(userInfo.getBizId(), manageUserIds))))) {
            log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6updateListDto:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)updateListDto);
            return Collections.emptyList();
        }
        int count = this.taskMapper.getCount(updateListDto);
        req.getPageDto().setCount(Integer.valueOf(count));
        return this.buildTaskList(tasks, userInfo);
    }

    @Override
    public String template(CustomerUpdateTemplateReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("template,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        String templateUrl = "";
        if (TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue() == req.getTaskType().intValue()) {
            CrmTemplateReq crmTemplateReq = req.convert2CrmTemplateReq(userInfo);
            try {
                templateUrl = this.crmTemplateService.getCustomerUpdateTemplateUrl(crmTemplateReq);
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u624b\u673a\u5ba2\u6237\u66f4\u65b0\u6a21\u677f\u6587\u4ef6\u5931\u8d25,\u8bf7\u6c42\u53c2\u6570:{},\u5f02\u5e38\u4fe1\u606f:", (Object)crmTemplateReq, (Object)ex);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        return templateUrl;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String add(CustomerUpdateAddReq req, MultipartFile file) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("add,req:{},file:{},operatorId:{}", new Object[]{req, file, userInfo.getId()});
        req.validateParams(file);
        Long productLineId = NumberUtils.LONG_ZERO;
        if (TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue() == req.getTaskType().intValue()) {
            CrmProductLineResp crmProductLineResp = this.productLineService.getByNum(userInfo.getBizId(), req.getProductLineId());
            if (Objects.isNull(crmProductLineResp)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u9500\u552e\u7ebf\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            productLineId = crmProductLineResp.getId();
        }
        String importRecordNum = "";
        if (InputTypeEnum.MANUAL_INPUT.getValue() == req.getInputType().intValue()) {
            this.handleManualInputCustomers(req, userInfo, productLineId);
        } else {
            importRecordNum = this.handleExcelImportCustomers(req, userInfo, file, productLineId);
        }
        return importRecordNum;
    }

    @Override
    public void updateImportProgress(ImportProgress progress) {
        log.info("update import progress:{}, {}/{}", new Object[]{progress.getTaskId(), progress.getDealCount(), progress.getTotalCount()});
        try {
            String key = this.prefix + String.format("customer_update_import_record_num_%s", progress.getTaskId());
            String value = JSON.toJSONString((Object)progress);
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, Duration.ofSeconds(3600L));
            log.info("redisTemplate:{},\u5b58\u5165\u7f13\u5b58\u6570\u636e\uff1avalue:{}", this.redisTemplate, (Object)value);
        }
        catch (Exception e) {
            log.error("updateImportProgress\u5931\u8d25,progress:{},\u5f02\u5e38\u4fe1\u606f:", (Object)progress, (Object)e);
        }
    }

    @Override
    public void onFinished(ImportProgress progress) {
        log.info("update import progress:{}, {}/{}", new Object[]{progress.getTaskId(), progress.getDealCount(), progress.getTotalCount()});
        if (StringUtils.isBlank((CharSequence)progress.getErrorUrl())) {
            log.info("\u6b64\u6b21\u5bfc\u5165\u6ca1\u6709\u9519\u8bef\u6587\u4ef6\uff0cimportRecordNum:{}", (Object)progress.getTaskId());
            return;
        }
        CustomerUpdateImportRecord importRecord = this.importRecordMapper.getByNum(progress.getTaskId());
        importRecord.setResultFileUrl(progress.getErrorUrl());
        importRecord.setResultFileName(progress.getErrorFileName());
        importRecord.setResultFileSize(progress.getErrorFileSize());
        importRecord.setUpdateTime(new Date());
        this.importRecordMapper.updateByPrimaryKey((Object)importRecord);
    }

    @Override
    public CustomerUpdateTaskProgressResp progress(StrIdDto req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("get task progress, params={}, operatorId={}", (Object)req, (Object)userInfo.getId());
        ImportProgress progress = this.getImportProgress(userInfo.getBizId(), req.getId());
        CustomerUpdateTaskProgressResp result = new CustomerUpdateTaskProgressResp();
        result.setState(progress.getState());
        result.setTotalCount(progress.getTotalCount());
        result.setCurrent(progress.getDealCount());
        result.setSuccessCount(progress.getSuccess());
        result.setFailedCount(progress.getFailedCount());
        result.setErrorUrl(progress.getErrorUrl());
        return result;
    }

    @Override
    public List<CustomerListResp> customerList(CustomerListReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("customerList,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        CustomerUpdateTask task = this.taskMapper.selectByNum(req.getId());
        if (task == null) {
            log.warn("\u6839\u636etaskNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        CustomerUpdateTaskDetailQuery query = req.convert2TaskDetailQuery(userInfo.getBizId(), task.getId());
        List taskDetails = this.taskDetailMapper.selectListByParams(query);
        if (CollectionUtils.isEmpty((Collection)taskDetails)) {
            log.warn("\u6839\u636equery:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)query);
            return Collections.emptyList();
        }
        int count = this.taskDetailMapper.selectCountByParams(query);
        req.getPageDto().setCount(Integer.valueOf(count));
        return this.buildCustomerList(taskDetails, userInfo.getBizId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addAgain(CustomerUpdateAddReq req, MultipartFile file) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("addAgain,taskNum:{},customers:{},file:{},operatorId:{}", new Object[]{req.getId(), req.getCustomers(), file, userInfo.getId()});
        if (StringUtils.isBlank((CharSequence)req.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerUpdateTask task = this.taskMapper.selectByNum(req.getId());
        if (Objects.isNull(task)) {
            log.warn("\u6839\u636e\u4efb\u52a1num:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1id\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        String importRecordNum = "";
        if (InputTypeEnum.MANUAL_INPUT.getValue() == task.getInputType().intValue()) {
            String mobileOrUnionId;
            String string = mobileOrUnionId = TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == task.getTaskType().intValue() ? "\u5fae\u4fe1UnionID" : "\u624b\u673a\u53f7";
            if (CollectionUtils.isEmpty(req.getCustomers())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u5de5\u8f93\u5165\u5ba2\u6237" + mobileOrUnionId + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.handleAddAgainManualInputCustomers(task, userInfo, req.getCustomers());
        } else {
            if (Objects.isNull(file)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            importRecordNum = this.handleAddAgainExcelImportCustomers(task, userInfo, file);
        }
        return importRecordNum;
    }

    private List<CustomerUpdateResp> buildTaskList(List<CustomerUpdateTask> tasks, CurrentUserInfo userInfo) {
        List channels;
        ArrayList creatorIds = Lists.newArrayList();
        ArrayList taskIds = Lists.newArrayList();
        ArrayList channelIds = Lists.newArrayList();
        HashSet tagIds = Sets.newHashSet();
        for (CustomerUpdateTask task : tasks) {
            creatorIds.add(task.getCreateBy());
            taskIds.add(task.getId());
            if (Objects.nonNull(task.getChannelId()) && task.getChannelId() > 0L) {
                channelIds.add(task.getChannelId());
            }
            if (!StringUtils.isNotBlank((CharSequence)task.getTagIds())) continue;
            tagIds.addAll(Arrays.asList(task.getTagIds().split(",")));
        }
        Map creatorId2NameMap = this.userMapper.queryUserNameByIds((Collection)creatorIds);
        Map taskId2ImportCountMap = this.taskDetailMapper.queryTaskImportCount((Collection)taskIds);
        Map taskId2SuccessCountMap = this.taskDetailMapper.queryTaskSuccessCount((Collection)taskIds);
        Map channelId2ChannelMap = null;
        if (CollectionUtils.isNotEmpty((Collection)channelIds) && CollectionUtils.isNotEmpty((Collection)(channels = this.channelMapper.queryChannels(userInfo.getBizId(), (Collection)channelIds)))) {
            channelId2ChannelMap = channels.stream().collect(Collectors.toMap(Channel::getId, Functions.identity()));
        }
        List productLineResps = this.productLineService.getListByBizId(userInfo.getBizId());
        Map productLineId2RespMap = null;
        if (CollectionUtils.isNotEmpty((Collection)productLineResps)) {
            productLineId2RespMap = productLineResps.stream().collect(Collectors.toMap(CrmProductLineResp::getId, Functions.identity()));
        }
        Map tagId2NameMap = null;
        if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
            tagId2NameMap = this.weworkTagMapper.queryTagIdAndName(userInfo.getCorpId(), (Collection)tagIds);
        }
        ArrayList resps = Lists.newArrayList();
        for (CustomerUpdateTask task : tasks) {
            CustomerUpdateResp resp = new CustomerUpdateResp();
            resps.add(resp);
            resp.setId(task.getNum());
            resp.setName(task.getName());
            resp.setTagHandleWay(task.getTagHandleWay());
            resp.setRemarkNameHandleWay(task.getRemarkNameHandleWay());
            resp.setInputType(task.getInputType());
            resp.setImportCount(NumberUtils.INTEGER_ZERO);
            resp.setSuccessCount(NumberUtils.INTEGER_ZERO);
            if (MapUtils.isNotEmpty((Map)taskId2ImportCountMap) && taskId2ImportCountMap.containsKey(task.getId())) {
                resp.setImportCount((Integer)taskId2ImportCountMap.get(task.getId()));
            }
            if (MapUtils.isNotEmpty((Map)taskId2SuccessCountMap) && taskId2SuccessCountMap.containsKey(task.getId())) {
                resp.setSuccessCount((Integer)taskId2SuccessCountMap.get(task.getId()));
            }
            if (MapUtils.isNotEmpty((Map)creatorId2NameMap) && creatorId2NameMap.containsKey(task.getCreateBy())) {
                resp.setCreatorName((String)creatorId2NameMap.get(task.getCreateBy()));
            }
            resp.setCreateTime(task.getCreateTime());
            resp.setIsCanImportAgain(NumberUtils.INTEGER_ZERO);
            if (Objects.equals(task.getCreateBy(), userInfo.getId())) {
                resp.setIsCanImportAgain(NumberUtils.INTEGER_ONE);
            }
            resp.setIsCanDownload(NumberUtils.INTEGER_ONE);
            if (Objects.nonNull(task.getChannelId()) && task.getChannelId() > 0L && MapUtils.isNotEmpty(channelId2ChannelMap) && channelId2ChannelMap.containsKey(task.getChannelId())) {
                Channel channel = (Channel)channelId2ChannelMap.get(task.getChannelId());
                resp.setChannelId(channel.getNum());
                resp.setChannelName(channel.getName());
            }
            if (Objects.nonNull(task.getProductLineId()) && task.getProductLineId() > 0L && MapUtils.isNotEmpty(productLineId2RespMap) && productLineId2RespMap.containsKey(task.getProductLineId())) {
                CrmProductLineResp crmProductLineResp = (CrmProductLineResp)productLineId2RespMap.get(task.getProductLineId());
                resp.setProductLineId(crmProductLineResp.getNum());
                resp.setProductLineName(crmProductLineResp.getName());
            }
            if (!StringUtils.isNotBlank((CharSequence)task.getTagIds()) || !MapUtils.isNotEmpty((Map)tagId2NameMap)) continue;
            ArrayList tags = Lists.newArrayList();
            for (String tagId : task.getTagIds().split(",")) {
                if (!tagId2NameMap.containsKey(tagId)) continue;
                IdName idName = new IdName();
                tags.add(idName);
                idName.setName((String)tagId2NameMap.get(tagId));
                idName.setId((Object)tagId);
            }
            if (!CollectionUtils.isNotEmpty((Collection)tags)) continue;
            resp.setTags(tags);
        }
        return resps;
    }

    private void handleManualInputCustomers(CustomerUpdateAddReq req, CurrentUserInfo userInfo, Long productLineId) {
        Long channelId = NumberUtils.LONG_ZERO;
        Channel channel = null;
        if (StringUtils.isNotBlank((CharSequence)req.getChannelId())) {
            channel = this.channelMapper.selectByNum(req.getChannelId(), userInfo.getBizId(), userInfo.getCorpId());
            if (Objects.isNull(channel)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6570\u636e\u6e20\u9053\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            channelId = channel.getId();
        }
        List tagGroupPairs = null;
        if (CollectionUtils.isNotEmpty(req.getTagIds())) {
            tagGroupPairs = this.weworkTagMapper.queryTagGroupPairByCorpIdAndTagIds(userInfo.getCorpId(), req.getTagIds());
            if (CollectionUtils.isEmpty((Collection)tagGroupPairs)) {
                log.info("\u6839\u636ecorpId:{},tagIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)userInfo.getCorpId(), req.getTagIds());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6807\u7b7e\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            if (req.getTagIds().size() != tagGroupPairs.size()) {
                log.info("\u8bf7\u6c42\u53c2\u6570\u4e2dtagIds\u7684\u4e2a\u6570\u4e3a:{},\u6570\u636e\u5e93\u8fd4\u56de\u7684\u6807\u7b7e\u4e2a\u6570\u4e3a:{}", (Object)req.getTagIds().size(), (Object)tagGroupPairs.size());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6807\u7b7e\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            Set tagGroupIds = tagGroupPairs.stream().map(TagGroupPair::getGroupId).collect(Collectors.toSet());
            if (tagGroupIds.size() > 1) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u6807\u7b7e\u7ec4\u4e0b\u7684\u6807\u7b7e");
            }
        }
        CustomerUpdateTask task = this.buildCustomerUpdateTask(req, userInfo, productLineId, channelId);
        this.taskMapper.insertSelective((Object)task);
        List<CustomerUpdateTaskDetail> taskDetails = this.buildManualInputCustomerDetails(req.getCustomers(), channel, userInfo, task.getId(), req.getTaskType());
        Lists.partition(taskDetails, (int)1000).forEach(partTaskDetails -> this.taskDetailMapper.batchInsertManualInputCustomers((Collection)partTaskDetails));
        if (CollectionUtils.isNotEmpty((Collection)tagGroupPairs)) {
            List<Long> taskDetailIds = taskDetails.stream().map(CustomerUpdateTaskDetail::getId).collect(Collectors.toList());
            List<CustomerUpdateTaskDetailTag> detailTags = this.buildManualInputCustomerDetailTags(taskDetailIds, tagGroupPairs, userInfo);
            Lists.partition(detailTags, (int)1000).forEach(partDetailTags -> this.taskDetailTagMapper.batchInsert((Collection)partDetailTags));
        }
        CustomerUpdateTaskDto taskDto = this.buildCustomerUpdateTaskDto(task, userInfo, channel, productLineId);
        List<CustomerUpdateDetailDto> taskDetailDtos = this.buildUpdateDetailDtos(taskDetails, channel, req.getTagIds());
        if (CollectionUtils.isEmpty(taskDetailDtos)) {
            log.info("\u6ca1\u6709\u6821\u9a8c\u901a\u8fc7\u7684\u8bb0\u5f55\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f");
        }
        this.customerUpdateSupport.syncUpdateCustomerInfo(taskDto, taskDetailDtos);
    }

    private String handleExcelImportCustomers(CustomerUpdateAddReq req, CurrentUserInfo userInfo, MultipartFile multipartFile, Long productLineId) {
        Workbook workbook;
        File file = FileUtils.saveFile((MultipartFile)multipartFile);
        try {
            workbook = WorkbookFactory.create((File)file);
        }
        catch (Exception e) {
            log.error("Excel\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
            CustomerUpdateImportUtil.release(file, null);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "Excel\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Sheet sheet = ExcelUtil.getSheet((Workbook)workbook, (int)0);
        ArrayList headers = Lists.newArrayList();
        if (TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == req.getTaskType().intValue()) {
            headers.addAll(CustomerUpdateImportUtil.WEWORK_CUSTOMER_EXCEL_HEADER);
        } else {
            headers.addAll(CustomerUpdateImportUtil.MOBILE_CUSTOMER_EXCEL_FIXED_HEADER);
        }
        ArrayList leadsConfigResps = Lists.newArrayList();
        if (!this.validateHeader(sheet, headers, req.getTaskType(), userInfo.getBizId(), productLineId, leadsConfigResps)) {
            CustomerUpdateImportUtil.release(file, workbook);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6a21\u677f\u5934\u90e8\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u6a21\u677f\u540e\u4e0a\u4f20");
        }
        if (sheet.getPhysicalNumberOfRows() <= 3) {
            CustomerUpdateImportUtil.release(file, workbook);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u4efb\u4f55\u6709\u6548\u6570\u636e");
        }
        List<ImportRow> data = CustomerUpdateImportUtil.scan(file, workbook, sheet, headers.size());
        if (CollectionUtils.isEmpty(data)) {
            CustomerUpdateImportUtil.release(file, workbook);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u4efb\u4f55\u6709\u6548\u6570\u636e");
        }
        CustomerUpdateTask task = this.buildCustomerUpdateTask(req, userInfo, productLineId, NumberUtils.LONG_ZERO);
        this.taskMapper.insertSelective((Object)task);
        CustomerUpdateImportRecord importRecord = this.buildCustomerUpdateImportRecord(task.getId(), userInfo, multipartFile);
        this.saveOriginFile(importRecord, file, userInfo.getCorpId());
        this.importRecordMapper.insertSelective((Object)importRecord);
        ImportProgress progress = new ImportProgress();
        progress.setTaskId(importRecord.getNum());
        progress.setTotalCount(data.size());
        progress.setState(ProcessState.ONGOING.getValue());
        this.updateImportProgress(progress);
        ImportContext context = this.buildImportContext(task, userInfo, progress, workbook, sheet, file, headers, data, leadsConfigResps);
        context.setImportRecordId(importRecord.getId());
        ImportTaskRunner runner = new ImportTaskRunner(req.getTaskType(), context);
        runner.setIdGen(this.idGen);
        runner.setChannelMapper(this.channelMapper);
        runner.setUserMapper(this.userMapper);
        runner.setUserInfo(userInfo);
        runner.setAliyunOss(this.aliyunOss);
        runner.setWeworkTagMapper(this.weworkTagMapper);
        runner.setTagGroupMapper(this.tagGroupMapper);
        runner.setCustomerStageMapper(this.customerStageMapper);
        runner.setTaskDetailMapper(this.taskDetailMapper);
        runner.setDetailTagMapper(this.taskDetailTagMapper);
        runner.setTask(task);
        runner.setProductLineService(this.productLineService);
        runner.setCustomerUpdateService(this);
        runner.setCustomerUpdateSupport(this.customerUpdateSupport);
        TraceExecutorWrapUtil.wrapSubmit((ExecutorService)this.executeService, (Runnable)runner);
        return importRecord.getNum();
    }

    private CustomerUpdateTask buildCustomerUpdateTask(CustomerUpdateAddReq req, CurrentUserInfo userInfo, Long productLineId, Long channelId) {
        CustomerUpdateTask task = new CustomerUpdateTask();
        task.setBizId(userInfo.getBizId());
        task.setNum(this.idGen.getNum());
        task.setTaskType(req.getTaskType());
        task.setName(req.getName());
        task.setInputType(req.getInputType());
        task.setProductLineId(productLineId);
        task.setTagHandleWay(req.getTagHandleWay());
        if (Objects.isNull(req.getRemarkNameHandleWay())) {
            task.setRemarkNameHandleWay(NumberUtils.INTEGER_ZERO);
        } else {
            task.setRemarkNameHandleWay(req.getRemarkNameHandleWay());
        }
        if (CollectionUtils.isEmpty(req.getTagIds())) {
            task.setTagIds("");
        } else {
            task.setTagIds(String.join((CharSequence)",", req.getTagIds()));
        }
        task.setChannelId(channelId);
        task.setCreateBy(userInfo.getId());
        task.setCreateTime(new Date());
        task.setUpdateBy(userInfo.getId());
        task.setUpdateTime(new Date());
        task.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return task;
    }

    private List<CustomerUpdateTaskDetail> buildManualInputCustomerDetails(List<String> customers, Channel channel, CurrentUserInfo userInfo, Long taskId, Integer taskType) {
        ArrayList taskDetails = Lists.newArrayListWithCapacity((int)customers.size());
        Date curTime = new Date();
        for (String customer : customers) {
            CustomerUpdateTaskDetail taskDetail = new CustomerUpdateTaskDetail();
            taskDetail.init();
            taskDetails.add(taskDetail);
            taskDetail.setBizId(userInfo.getBizId());
            taskDetail.setNum(this.idGen.getNum());
            taskDetail.setTaskId(taskId);
            taskDetail.setValidateStatus(Integer.valueOf(ValidateStatusEnum.SUCCESS.getValue()));
            taskDetail.setValidateFailReason("");
            if (TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue() == taskType.intValue()) {
                taskDetail.setUnionid("");
                taskDetail.setMobile(customer);
                boolean isPone = MobileUtils.isPhone((String)customer);
                if (!isPone) {
                    taskDetail.setValidateStatus(Integer.valueOf(ValidateStatusEnum.FAIL.getValue()));
                    taskDetail.setValidateFailReason("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
                    taskDetail.setHandleStatus(Integer.valueOf(CuHandlerStatusEnum.FAIL.getValue()));
                }
            } else {
                taskDetail.setUnionid(customer);
                taskDetail.setMobile("");
            }
            if (Objects.nonNull(channel)) {
                taskDetail.setChannelName(channel.getName());
                taskDetail.setChannelId(channel.getId());
            } else {
                taskDetail.setChannelName("");
                taskDetail.setChannelId(NumberUtils.LONG_ZERO);
            }
            taskDetail.setCreateBy(userInfo.getId());
            taskDetail.setCreateTime(curTime);
            taskDetail.setUpdateBy(userInfo.getId());
            taskDetail.setUpdateTime(curTime);
        }
        return taskDetails;
    }

    private List<CustomerUpdateTaskDetailTag> buildManualInputCustomerDetailTags(List<Long> taskDetailIds, List<TagGroupPairInfo> tagGroupPairs, CurrentUserInfo userInfo) {
        Date curTime = new Date();
        ArrayList detailTags = Lists.newArrayList();
        for (Long taskDetailId : taskDetailIds) {
            for (TagGroupPairInfo tagGroupPairInfo : tagGroupPairs) {
                CustomerUpdateTaskDetailTag detailTag = new CustomerUpdateTaskDetailTag();
                detailTags.add(detailTag);
                detailTag.setBizId(userInfo.getBizId());
                detailTag.setNum(this.idGen.getNum());
                detailTag.setTaskDetailId(taskDetailId);
                detailTag.setGroupId(tagGroupPairInfo.getGroupId());
                detailTag.setGroupName(tagGroupPairInfo.getGroupName());
                detailTag.setTagId(tagGroupPairInfo.getTagId());
                detailTag.setTagName(tagGroupPairInfo.getTagName());
                detailTag.setCreateBy(userInfo.getId());
                detailTag.setCreateTime(curTime);
                detailTag.setUpdateBy(userInfo.getId());
                detailTag.setUpdateTime(curTime);
                detailTag.setIsDeleted(NumberUtils.INTEGER_ZERO);
            }
        }
        return detailTags;
    }

    private boolean validateHeader(Sheet sheet, List<String> headers, Integer taskType, Long bizId, Long productLineId, List<CrmLeadsConfigResp> leadsConfigResps) {
        List crmLeadsConfigResps;
        List nameRow = ExcelUtil.getRowDatas((Sheet)sheet, (int)2, null);
        if (CollectionUtils.isEmpty((Collection)nameRow)) {
            log.warn("name row is empty!");
            return false;
        }
        int columnSize = nameRow.size();
        if (TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue() == taskType.intValue() && CollectionUtils.isNotEmpty((Collection)(crmLeadsConfigResps = this.crmConfigService.getAllEnabledBusinessField(bizId, productLineId)))) {
            leadsConfigResps.addAll(crmLeadsConfigResps);
            headers.addAll(crmLeadsConfigResps.stream().map(CrmLeadsConfigResp::getName).collect(Collectors.toList()));
        }
        if (columnSize != headers.size()) {
            log.warn("\u4e0a\u4f20\u7684Excel\u548c\u6a21\u677f\u7684\u5217\u6570\u4e0d\u4e00\u81f4\uff0ctemplateSize={}, excel columnSize={}, template:{},columns:{}", new Object[]{headers.size(), columnSize, headers, nameRow});
            return false;
        }
        for (int i = 0; i < headers.size(); ++i) {
            String columnName;
            String templateName = headers.get(i);
            if (templateName.equals(columnName = String.valueOf(nameRow.get(i)))) continue;
            log.info("\u6a21\u677f\u548c\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u7b2c{}\u5217\u7684\u8868\u5934\u4e0d\u4e00\u81f4,\u6a21\u677f\u8868\u5934\u540d\u4e3a:{},\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u7684\u8868\u5934\u540d\u4e3a:{}", new Object[]{i, templateName, columnName});
            return false;
        }
        return true;
    }

    private CustomerUpdateImportRecord buildCustomerUpdateImportRecord(Long taskId, CurrentUserInfo userInfo, MultipartFile multipartFile) {
        CustomerUpdateImportRecord importRecord = new CustomerUpdateImportRecord();
        importRecord.setBizId(userInfo.getBizId());
        importRecord.setNum(this.idGen.getNum());
        importRecord.setTaskId(taskId);
        importRecord.setUploadFileUrl("");
        importRecord.setUploadFileName(multipartFile.getOriginalFilename());
        importRecord.setUploadFileSize(FileUtils.format((long)multipartFile.getSize()));
        importRecord.setCreateBy(userInfo.getId());
        importRecord.setCreateTime(new Date());
        importRecord.setUpdateBy(userInfo.getId());
        importRecord.setUpdateTime(new Date());
        importRecord.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return importRecord;
    }

    private void saveOriginFile(CustomerUpdateImportRecord importRecord, File file, String corpId) {
        try {
            log.info("save origin file, taskId:{}, fileName:{}, exist:{}, canRead:{}", new Object[]{importRecord.getTaskId(), importRecord.getUploadFileName(), file.exists(), file.canRead()});
            String url = this.aliyunOss.uploadFile(corpId, file, file.getName());
            log.info("file upload to oss, url:{}", (Object)url);
            importRecord.setUploadFileUrl(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4fdd\u5b58\u5ba2\u6237\u4e0a\u4f20\u7684\u539f\u59cb\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    private ImportContext buildImportContext(CustomerUpdateTask task, CurrentUserInfo userInfo, ImportProgress progress, Workbook workbook, Sheet sheet, File file, List<String> headers, List<ImportRow> data, List<CrmLeadsConfigResp> leadsConfigResps) {
        ImportContext context = new ImportContext();
        context.setTaskId(task.getId());
        context.setTaskName(task.getName());
        context.setUserId(userInfo.getId());
        context.setBizId(userInfo.getBizId());
        context.setProductLineId(task.getProductLineId());
        context.setCorpId(userInfo.getCorpId());
        context.setProgress(progress);
        context.setWorkbook(workbook);
        context.setSheet(sheet);
        context.setFile(file);
        context.setColumnSize(headers.size());
        context.setData(data);
        context.setHeaders(headers);
        context.setBusinessFields(leadsConfigResps);
        return context;
    }

    private ImportProgress getImportProgress(Long bizId, String importRecordNum) {
        String key = this.prefix + String.format("customer_update_import_record_num_%s", importRecordNum);
        String cache = (String)this.redisTemplate.opsForValue().get((Object)key);
        log.info("getImportProgress,key:{},cache:{}", (Object)key, (Object)cache);
        if (StringUtils.isBlank((CharSequence)cache)) {
            CustomerUpdateImportRecord importRecord = this.importRecordMapper.getByNum(importRecordNum);
            if (importRecord == null) {
                log.warn("\u6839\u636eimportRecordNum:{}\u672a\u67e5\u8be2\u5230\u5bfc\u5165\u8bb0\u5f55", (Object)importRecordNum);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            List taskDetails = this.taskDetailMapper.queryDetailIdAndValidateStatus(bizId, importRecord.getId());
            int totalCount = taskDetails != null ? taskDetails.size() : 0;
            int successCount = 0;
            int failCount = 0;
            if (taskDetails != null) {
                for (CustomerUpdateTaskDetail taskDetail : taskDetails) {
                    if (taskDetail.getValidateStatus().intValue() == ValidateStatusEnum.SUCCESS.getValue()) {
                        ++successCount;
                        continue;
                    }
                    ++failCount;
                }
            }
            ImportProgress importProgress = new ImportProgress();
            importProgress.setState(ProcessState.FINISHED.getValue());
            if (importRecord.getResultFileUrl() != null) {
                importProgress.setErrorUrl(importRecord.getResultFileUrl());
            }
            importProgress.setTotalCount(totalCount);
            importProgress.setDealCount(totalCount);
            importProgress.setSuccess(successCount);
            importProgress.setFailedCount(failCount);
            return importProgress;
        }
        try {
            ImportProgress progress = (ImportProgress)JSON.parseObject((String)cache, ImportProgress.class);
            if (progress.getState() == ProcessState.FINISHED.getValue()) {
                log.info("delete import progress:{}", (Object)importRecordNum);
                this.redisTemplate.delete((Object)key);
            }
            return progress;
        }
        catch (Exception e) {
            log.error("getImportProgress,importRecordNum:{},\u53d1\u751f\u5f02\u5e38\uff1a", (Object)importRecordNum, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u89e3\u6790\u5f02\u5e38");
        }
    }

    private List<CustomerListResp> buildCustomerList(List<CustomerUpdateTaskDetail> taskDetails, Long bizId) {
        List taskDetailIds = taskDetails.stream().map(CustomerUpdateTaskDetail::getId).collect(Collectors.toList());
        List detailTags = this.taskDetailTagMapper.selectByBizIdAndTaskDetailIds(bizId, taskDetailIds);
        Map<Object, Object> detailId2TagsMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)detailTags)) {
            detailId2TagsMap = detailTags.stream().collect(Collectors.groupingBy(CustomerUpdateTaskDetailTag::getTaskDetailId));
        }
        HashSet userIds = Sets.newHashSet();
        Set bindingUserIds = taskDetails.stream().map(CustomerUpdateTaskDetail::getBindingUserId).collect(Collectors.toSet());
        Set marketUserIds = taskDetails.stream().map(CustomerUpdateTaskDetail::getMarketUserId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(bindingUserIds)) {
            userIds.addAll(bindingUserIds);
        }
        if (CollectionUtils.isNotEmpty(marketUserIds)) {
            userIds.addAll(marketUserIds);
        }
        Map userId2NameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            userId2NameMap = this.userMapper.queryUserNameByIds((Collection)userIds);
        }
        Set unionIds = taskDetails.stream().map(CustomerUpdateTaskDetail::getUnionid).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Set mobiles = taskDetails.stream().map(CustomerUpdateTaskDetail::getMobile).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Map<Object, Object> groupByUnionIds = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(unionIds)) {
            List weworkContacts = this.weworkContactMapper.selectByUnionId(bizId, unionIds);
            groupByUnionIds = weworkContacts.stream().collect(Collectors.groupingBy(WeworkContact::getUnionid));
        }
        Map mobileCustomerNums = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(mobiles)) {
            mobileCustomerNums = this.customerNumService.batchGetCustomerNumByMobile(bizId, mobiles);
        }
        ArrayList resps = Lists.newArrayList();
        for (CustomerUpdateTaskDetail taskDetail : taskDetails) {
            CuHandlerStatusEnum handlerStatusEnum;
            String customerNum;
            CustomerListResp resp = new CustomerListResp();
            resps.add(resp);
            resp.setId(taskDetail.getNum());
            resp.setUnionid(taskDetail.getUnionid());
            resp.setMobile(taskDetail.getMobile());
            resp.setRemarkName(taskDetail.getRemarkName());
            resp.setDescription(taskDetail.getDescription());
            resp.setStageName(taskDetail.getStageName());
            resp.setChannelName(taskDetail.getChannelName());
            resp.setAssociateMobile(taskDetail.getCommunicationMobile());
            resp.setStatus(taskDetail.getValidateStatus());
            resp.setValidateStatus(taskDetail.getValidateStatus());
            ValidateStatusEnum validateStatusEnum = ValidateStatusEnum.get(taskDetail.getValidateStatus());
            if (validateStatusEnum != null) {
                resp.setValidateStatusDesc(validateStatusEnum.getDesc());
                if (validateStatusEnum.getValue() == ValidateStatusEnum.FAIL.getValue()) {
                    resp.setReason(taskDetail.getValidateFailReason());
                } else {
                    resp.setReason(taskDetail.getHandleFailReason());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)resp.getUnionid()) && MapUtils.isNotEmpty((Map)groupByUnionIds)) {
                List existWeworkContact = (List)groupByUnionIds.get(resp.getUnionid());
                if (CollectionUtils.isNotEmpty((Collection)existWeworkContact)) {
                    resp.setCustomerNum(((WeworkContact)existWeworkContact.get(0)).getCustomerNum());
                }
            } else if (StringUtils.isNotBlank((CharSequence)resp.getMobile()) && MapUtils.isNotEmpty((Map)mobileCustomerNums) && StringUtils.isNotBlank((CharSequence)(customerNum = (String)mobileCustomerNums.get(resp.getMobile())))) {
                resp.setCustomerNum(customerNum);
            }
            resp.setMarketUserName(taskDetail.getMarketUserName());
            resp.setBindingUserName(taskDetail.getBindingUserIdentifier());
            resp.setBindingUserIdentifier(taskDetail.getBindingUserIdentifier());
            resp.setP1(taskDetail.getP1());
            resp.setP2(taskDetail.getP2());
            resp.setP3(taskDetail.getP3());
            resp.setP4(taskDetail.getP4());
            resp.setP5(taskDetail.getP5());
            resp.setP6(taskDetail.getP6());
            resp.setP7(taskDetail.getP7());
            resp.setP8(taskDetail.getP8());
            resp.setP9(taskDetail.getP9());
            resp.setP10(taskDetail.getP10());
            resp.setP11(taskDetail.getP11());
            resp.setP12(taskDetail.getP12());
            resp.setP13(taskDetail.getP13());
            resp.setP14(taskDetail.getP14());
            resp.setP15(taskDetail.getP15());
            resp.setP16(taskDetail.getP16());
            resp.setP17(taskDetail.getP17());
            resp.setP18(taskDetail.getP18());
            resp.setP19(taskDetail.getP19());
            resp.setP20(taskDetail.getP20());
            resp.setCustomerName(taskDetail.getCustomerName());
            if (detailId2TagsMap.containsKey(taskDetail.getId())) {
                List tags = (List)detailId2TagsMap.get(taskDetail.getId());
                resp.setTagGroupName(((CustomerUpdateTaskDetailTag)tags.get(0)).getGroupName());
                List<String> tagNames = tags.stream().map(CustomerUpdateTaskDetailTag::getTagName).collect(Collectors.toList());
                resp.setTagNames(tagNames);
            }
            if (taskDetail.getBindingUserId() != null && userId2NameMap.containsKey(taskDetail.getBindingUserId())) {
                resp.setBindingUserName((String)userId2NameMap.get(taskDetail.getBindingUserId()));
            }
            if (taskDetail.getMarketUserId() != null && userId2NameMap.containsKey(taskDetail.getMarketUserId())) {
                resp.setMarketUserName((String)userId2NameMap.get(taskDetail.getMarketUserId()));
            }
            if (taskDetail.getHandleStatus() == null || CuHandlerStatusEnum.SUCCESS != (handlerStatusEnum = CuHandlerStatusEnum.get(taskDetail.getHandleStatus())) && CuHandlerStatusEnum.FAIL != handlerStatusEnum) continue;
            resp.setHandleStatus(taskDetail.getHandleStatus());
            resp.setHandleStatusDesc(handlerStatusEnum.getDesc());
        }
        return resps;
    }

    private void handleAddAgainManualInputCustomers(CustomerUpdateTask task, CurrentUserInfo userInfo, List<String> customers) {
        Channel channel = null;
        if (Objects.nonNull(task.getChannelId()) && task.getChannelId() > 0L && Objects.isNull(channel = (Channel)this.channelMapper.selectByPrimaryKey((Object)task.getChannelId()))) {
            log.info("taskId:{}\u518d\u6b21\u624b\u5de5\u8f93\u5165\u65f6\u6839\u636e\u6e20\u9053id:{}\u672a\u67e5\u8be2\u5230\u6e20\u9053", (Object)task.getId(), (Object)task.getChannelId());
        }
        List<String> tagIds = null;
        List tagGroupPairs = null;
        if (StringUtils.isNotBlank((CharSequence)task.getTagIds())) {
            tagIds = Arrays.asList(task.getTagIds().split(","));
            tagGroupPairs = this.weworkTagMapper.queryTagGroupPairByCorpIdAndTagIds(userInfo.getCorpId(), tagIds);
            if (CollectionUtils.isEmpty((Collection)tagGroupPairs)) {
                log.info("taskId:{}\u518d\u6b21\u624b\u5de5\u8f93\u5165\u65f6\u6839\u636etagIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)task.getId(), (Object)task.getTagIds());
            }
        }
        List<CustomerUpdateTaskDetail> taskDetails = this.buildManualInputCustomerDetails(customers, channel, userInfo, task.getId(), task.getTaskType());
        Lists.partition(taskDetails, (int)1000).forEach(part -> this.taskDetailMapper.batchInsertManualInputCustomers((Collection)part));
        if (CollectionUtils.isNotEmpty((Collection)tagGroupPairs)) {
            List<Long> taskDetailIds = taskDetails.stream().map(CustomerUpdateTaskDetail::getId).collect(Collectors.toList());
            List<CustomerUpdateTaskDetailTag> detailTags = this.buildManualInputCustomerDetailTags(taskDetailIds, tagGroupPairs, userInfo);
            Lists.partition(detailTags, (int)1000).forEach(part -> this.taskDetailTagMapper.batchInsert((Collection)part));
        }
        CustomerUpdateTaskDto taskDto = this.buildCustomerUpdateTaskDto(task, userInfo, channel, task.getProductLineId());
        List<CustomerUpdateDetailDto> taskDetailDtos = this.buildUpdateDetailDtos(taskDetails, channel, tagIds);
        if (CollectionUtils.isEmpty(taskDetailDtos)) {
            log.info("\u6ca1\u6709\u6821\u9a8c\u901a\u8fc7\u7684\u8bb0\u5f55\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f");
        }
        this.customerUpdateSupport.syncUpdateCustomerInfo(taskDto, taskDetailDtos);
    }

    private String handleAddAgainExcelImportCustomers(CustomerUpdateTask task, CurrentUserInfo userInfo, MultipartFile multipartFile) {
        Workbook workbook;
        File file = FileUtils.saveFile((MultipartFile)multipartFile);
        try {
            workbook = WorkbookFactory.create((File)file);
        }
        catch (Exception e) {
            log.error("Excel\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
            CustomerUpdateImportUtil.release(file, null);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "Excel\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Sheet sheet = ExcelUtil.getSheet((Workbook)workbook, (int)0);
        ArrayList headers = Lists.newArrayList();
        if (TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == task.getTaskType().intValue()) {
            headers.addAll(CustomerUpdateImportUtil.WEWORK_CUSTOMER_EXCEL_HEADER);
        } else {
            headers.addAll(CustomerUpdateImportUtil.MOBILE_CUSTOMER_EXCEL_FIXED_HEADER);
        }
        ArrayList leadsConfigResps = Lists.newArrayList();
        if (!this.validateHeader(sheet, headers, task.getTaskType(), userInfo.getBizId(), task.getProductLineId(), leadsConfigResps)) {
            CustomerUpdateImportUtil.release(file, workbook);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6a21\u677f\u5934\u90e8\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u6a21\u677f\u540e\u4e0a\u4f20");
        }
        if (sheet.getPhysicalNumberOfRows() <= 3) {
            CustomerUpdateImportUtil.release(file, workbook);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u4efb\u4f55\u6709\u6548\u6570\u636e");
        }
        List<ImportRow> data = CustomerUpdateImportUtil.scan(file, workbook, sheet, headers.size());
        if (CollectionUtils.isEmpty(data)) {
            CustomerUpdateImportUtil.release(file, workbook);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u4efb\u4f55\u6709\u6548\u6570\u636e");
        }
        CustomerUpdateImportRecord importRecord = this.buildCustomerUpdateImportRecord(task.getId(), userInfo, multipartFile);
        this.saveOriginFile(importRecord, file, userInfo.getCorpId());
        this.importRecordMapper.insertSelective((Object)importRecord);
        ImportProgress progress = new ImportProgress();
        progress.setTaskId(importRecord.getNum());
        progress.setTotalCount(data.size());
        progress.setState(ProcessState.ONGOING.getValue());
        this.updateImportProgress(progress);
        ImportContext context = this.buildImportContext(task, userInfo, progress, workbook, sheet, file, headers, data, leadsConfigResps);
        context.setImportRecordId(importRecord.getId());
        ImportTaskRunner runner = new ImportTaskRunner(task.getTaskType(), context);
        runner.setIdGen(this.idGen);
        runner.setChannelMapper(this.channelMapper);
        runner.setUserMapper(this.userMapper);
        runner.setUserInfo(userInfo);
        runner.setAliyunOss(this.aliyunOss);
        runner.setWeworkTagMapper(this.weworkTagMapper);
        runner.setTagGroupMapper(this.tagGroupMapper);
        runner.setCustomerStageMapper(this.customerStageMapper);
        runner.setTaskDetailMapper(this.taskDetailMapper);
        runner.setDetailTagMapper(this.taskDetailTagMapper);
        runner.setTask(task);
        runner.setProductLineService(this.productLineService);
        runner.setCustomerUpdateService(this);
        runner.setCustomerUpdateSupport(this.customerUpdateSupport);
        TraceExecutorWrapUtil.wrapSubmit((ExecutorService)this.executeService, (Runnable)runner);
        return importRecord.getNum();
    }

    private CustomerUpdateTaskDto buildCustomerUpdateTaskDto(CustomerUpdateTask task, CurrentUserInfo userInfo, Channel channel, Long productLineId) {
        CustomerUpdateTaskDto taskDto = new CustomerUpdateTaskDto();
        taskDto.setCorpId(userInfo.getCorpId());
        taskDto.setBizId(userInfo.getBizId());
        taskDto.setTaskId(task.getId());
        taskDto.setTaskType(task.getTaskType());
        if (productLineId != null && productLineId > 0L) {
            CrmProductLineResp crmProductLineResp = this.productLineService.getById(userInfo.getBizId(), productLineId);
            taskDto.setProductLineId(productLineId);
            taskDto.setProductLineNum(crmProductLineResp.getNum());
        }
        taskDto.setTagHandleWay(task.getTagHandleWay());
        if (task.getRemarkNameHandleWay() != null && task.getRemarkNameHandleWay() > 0) {
            taskDto.setRemarkNameHandleWay(task.getRemarkNameHandleWay());
        }
        taskDto.setInputType(task.getInputType());
        if (StringUtils.isNotBlank((CharSequence)task.getTagIds())) {
            taskDto.setTagIds(Arrays.asList(task.getTagIds().split(",")));
        }
        if (channel != null) {
            taskDto.setChannelId(channel.getId());
            taskDto.setChannelNum(channel.getNum());
        }
        taskDto.setOperatorUserId(userInfo.getId());
        return taskDto;
    }

    private List<CustomerUpdateDetailDto> buildUpdateDetailDtos(List<CustomerUpdateTaskDetail> taskDetails, Channel channel, List<String> tagIds) {
        ArrayList detailDtos = Lists.newArrayList();
        for (CustomerUpdateTaskDetail detail : taskDetails) {
            if (ValidateStatusEnum.SUCCESS.getValue() != detail.getValidateStatus().intValue()) continue;
            CustomerUpdateDetailDto detailDto = new CustomerUpdateDetailDto();
            detailDtos.add(detailDto);
            detailDto.setTaskDetailId(detail.getId());
            if (StringUtils.isNotBlank((CharSequence)detail.getUnionid())) {
                detailDto.setUnionid(detail.getUnionid());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getMobile())) {
                detailDto.setMobile(detail.getMobile());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getRemarkName())) {
                detailDto.setRemarkName(detail.getRemarkName());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getCustomerName())) {
                detailDto.setCustomerName(detail.getCustomerName());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getDescription())) {
                detailDto.setDescription(detail.getDescription());
            }
            if (Objects.nonNull(detail.getStageId()) && detail.getStageId() > 0L) {
                detailDto.setStageId(detail.getStageId());
                detailDto.setStageName(detail.getStageName());
            }
            if (channel != null) {
                detailDto.setChannelId(channel.getId());
                detailDto.setChannelNum(channel.getNum());
                detailDto.setChannelName(channel.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getCommunicationMobile())) {
                detailDto.setCommunicationMobile(detail.getCommunicationMobile());
            }
            if (Objects.nonNull(detail.getMarketUserId())) {
                detailDto.setMarketUserId(detail.getMarketUserId());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP1())) {
                detailDto.setP1(detail.getP1());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP2())) {
                detailDto.setP2(detail.getP2());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP3())) {
                detailDto.setP3(detail.getP3());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP4())) {
                detailDto.setP4(detail.getP4());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP5())) {
                detailDto.setP5(detail.getP5());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP6())) {
                detailDto.setP6(detail.getP6());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP7())) {
                detailDto.setP7(detail.getP7());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP8())) {
                detailDto.setP8(detail.getP8());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP9())) {
                detailDto.setP9(detail.getP9());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP10())) {
                detailDto.setP10(detail.getP10());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP11())) {
                detailDto.setP11(detail.getP11());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP12())) {
                detailDto.setP12(detail.getP12());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP13())) {
                detailDto.setP13(detail.getP13());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP14())) {
                detailDto.setP14(detail.getP14());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP15())) {
                detailDto.setP15(detail.getP15());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP16())) {
                detailDto.setP16(detail.getP16());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP17())) {
                detailDto.setP17(detail.getP17());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP18())) {
                detailDto.setP18(detail.getP18());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP19())) {
                detailDto.setP19(detail.getP19());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getP20())) {
                detailDto.setP20(detail.getP20());
            }
            if (CollectionUtils.isNotEmpty(tagIds)) {
                detailDto.setTagIds(tagIds);
            }
            if (!Objects.nonNull(detail.getBindingUserId()) || detail.getBindingUserId() <= 0L) continue;
            detailDto.setBindingUserId(detail.getBindingUserId());
        }
        return detailDtos;
    }
}

