/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.customerupdate.enums.InputTypeEnum;
import com.kuaike.scrm.customerupdate.enums.RemarkHandlerWayEnum;
import com.kuaike.scrm.customerupdate.enums.TagHandlerType;
import com.kuaike.scrm.customerupdate.enums.TaskTypeEnum;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class CustomerUpdateAddReq {
    private String id;
    private Integer taskType;
    private String productLineId;
    private String name;
    private Integer inputType;
    private List<String> customers;
    private List<String> tagIds;
    private Integer tagHandleWay;
    private String channelId;
    private Integer remarkNameHandleWay;

    public void validateParams(MultipartFile file) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.taskType), (Object)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        TaskTypeEnum taskTypeEnum = TaskTypeEnum.get(this.taskType);
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)taskTypeEnum), (Object)"\u4efb\u52a1\u7c7b\u578b\u503c\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.name) && !"null".equals(this.name) ? 1 : 0) != 0, (Object)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.inputType), (Object)"\u6dfb\u52a0\u5ba2\u6237\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        InputTypeEnum inputTypeEnum = InputTypeEnum.get(this.inputType);
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)inputTypeEnum), (Object)"\u6dfb\u52a0\u5ba2\u6237\u65b9\u5f0f\u503c\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.tagHandleWay), (Object)"\u6807\u7b7e\u5904\u7406\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        TagHandlerType tagHandleWayEnum = TagHandlerType.get(this.tagHandleWay);
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)tagHandleWayEnum), (Object)"\u6807\u7b7e\u5904\u7406\u65b9\u5f0f\u503c\u4e0d\u5408\u6cd5");
        if (TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue() == this.taskType.intValue()) {
            Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.productLineId) && !"null".equals(this.productLineId) ? 1 : 0) != 0, (Object)"\u9500\u552e\u7ebf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (InputTypeEnum.MANUAL_INPUT.getValue() == this.inputType.intValue()) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.customers), (Object)"\u5ba2\u6237\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.customers.size() <= 5000 ? 1 : 0) != 0, (Object)"\u5ba2\u6237\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc75000");
            if (CollectionUtils.isEmpty(this.tagIds) && (StringUtils.isBlank((CharSequence)this.channelId) || "null".equals(this.channelId))) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6807\u7b7e\u548c\u6570\u636e\u6e20\u9053\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
        } else {
            Preconditions.checkArgument((file != null && file.getSize() > 0L ? 1 : 0) != 0, (Object)"\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            if (TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == this.taskType.intValue()) {
                Preconditions.checkArgument((boolean)Objects.nonNull(this.remarkNameHandleWay), (Object)"\u5907\u6ce8\u540d\u5bfc\u5165\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                RemarkHandlerWayEnum remarkNameHandleWayEnum = RemarkHandlerWayEnum.get(this.remarkNameHandleWay);
                Preconditions.checkArgument((boolean)Objects.nonNull((Object)remarkNameHandleWayEnum), (Object)"\u5907\u6ce8\u540d\u5bfc\u5165\u503c\u4e0d\u5408\u6cd5");
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public String getProductLineId() {
        return this.productLineId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getInputType() {
        return this.inputType;
    }

    public List<String> getCustomers() {
        return this.customers;
    }

    public List<String> getTagIds() {
        return this.tagIds;
    }

    public Integer getTagHandleWay() {
        return this.tagHandleWay;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Integer getRemarkNameHandleWay() {
        return this.remarkNameHandleWay;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setProductLineId(String productLineId) {
        this.productLineId = productLineId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInputType(Integer inputType) {
        this.inputType = inputType;
    }

    public void setCustomers(List<String> customers) {
        this.customers = customers;
    }

    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    public void setTagHandleWay(Integer tagHandleWay) {
        this.tagHandleWay = tagHandleWay;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setRemarkNameHandleWay(Integer remarkNameHandleWay) {
        this.remarkNameHandleWay = remarkNameHandleWay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerUpdateAddReq)) {
            return false;
        }
        CustomerUpdateAddReq other = (CustomerUpdateAddReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Integer this$inputType = this.getInputType();
        Integer other$inputType = other.getInputType();
        if (this$inputType == null ? other$inputType != null : !((Object)this$inputType).equals(other$inputType)) {
            return false;
        }
        Integer this$tagHandleWay = this.getTagHandleWay();
        Integer other$tagHandleWay = other.getTagHandleWay();
        if (this$tagHandleWay == null ? other$tagHandleWay != null : !((Object)this$tagHandleWay).equals(other$tagHandleWay)) {
            return false;
        }
        Integer this$remarkNameHandleWay = this.getRemarkNameHandleWay();
        Integer other$remarkNameHandleWay = other.getRemarkNameHandleWay();
        if (this$remarkNameHandleWay == null ? other$remarkNameHandleWay != null : !((Object)this$remarkNameHandleWay).equals(other$remarkNameHandleWay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$productLineId = this.getProductLineId();
        String other$productLineId = other.getProductLineId();
        if (this$productLineId == null ? other$productLineId != null : !this$productLineId.equals(other$productLineId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$customers = this.getCustomers();
        List<String> other$customers = other.getCustomers();
        if (this$customers == null ? other$customers != null : !((Object)this$customers).equals(other$customers)) {
            return false;
        }
        List<String> this$tagIds = this.getTagIds();
        List<String> other$tagIds = other.getTagIds();
        if (this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        return !(this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomerUpdateAddReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Integer $inputType = this.getInputType();
        result = result * 59 + ($inputType == null ? 43 : ((Object)$inputType).hashCode());
        Integer $tagHandleWay = this.getTagHandleWay();
        result = result * 59 + ($tagHandleWay == null ? 43 : ((Object)$tagHandleWay).hashCode());
        Integer $remarkNameHandleWay = this.getRemarkNameHandleWay();
        result = result * 59 + ($remarkNameHandleWay == null ? 43 : ((Object)$remarkNameHandleWay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $productLineId = this.getProductLineId();
        result = result * 59 + ($productLineId == null ? 43 : $productLineId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $customers = this.getCustomers();
        result = result * 59 + ($customers == null ? 43 : ((Object)$customers).hashCode());
        List<String> $tagIds = this.getTagIds();
        result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        return result;
    }

    public String toString() {
        return "CustomerUpdateAddReq(id=" + this.getId() + ", taskType=" + this.getTaskType() + ", productLineId=" + this.getProductLineId() + ", name=" + this.getName() + ", inputType=" + this.getInputType() + ", customers=" + this.getCustomers() + ", tagIds=" + this.getTagIds() + ", tagHandleWay=" + this.getTagHandleWay() + ", channelId=" + this.getChannelId() + ", remarkNameHandleWay=" + this.getRemarkNameHandleWay() + ")";
    }
}

