/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionplan.service.impl;

import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.utils.PageAuthRedisUtil;
import cn.kinyun.scrm.page.auth.utils.WoauthParseUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.IsDraft;
import com.kuaike.scrm.common.enums.MarketingConfigType;
import com.kuaike.scrm.common.enums.OnLineType;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.marketing.dto.PlanQrcodeDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingConfig;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanDraftMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.dal.region.entity.RegionInfo;
import com.kuaike.scrm.dal.region.entity.RegionPlanWorkCycle;
import com.kuaike.scrm.dal.region.mapper.RegionInfoMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import com.kuaike.scrm.marketing.dto.MarketingListItemDto;
import com.kuaike.scrm.marketing.dto.MarketingListParams;
import com.kuaike.scrm.marketing.dto.MarketingPlanSwitchParams;
import com.kuaike.scrm.marketing.service.MarketingChannelService;
import com.kuaike.scrm.marketing.service.MarketingConfigService;
import com.kuaike.scrm.marketing.service.MarketingPlanGroupService;
import com.kuaike.scrm.marketing.service.MarketingPlanService;
import com.kuaike.scrm.marketing.service.MarketingReportService;
import com.kuaike.scrm.marketing.service.MarketingTagService;
import com.kuaike.scrm.marketing.utils.MarketingUtil;
import com.kuaike.scrm.regionplan.dto.CheckUserReq;
import com.kuaike.scrm.regionplan.dto.PlanQrcodeUserDto;
import com.kuaike.scrm.regionplan.dto.RegionPlanDetailDto;
import com.kuaike.scrm.regionplan.dto.RegionPlanDto;
import com.kuaike.scrm.regionplan.dto.RegionPlanQrcodeDto;
import com.kuaike.scrm.regionplan.dto.RegionQrcodeDto;
import com.kuaike.scrm.regionplan.dto.SelectRegionPlanQrcodeDto;
import com.kuaike.scrm.regionplan.service.AlternativeUserService;
import com.kuaike.scrm.regionplan.service.RegionPlanAutoPassService;
import com.kuaike.scrm.regionplan.service.RegionPlanCurUserService;
import com.kuaike.scrm.regionplan.service.RegionPlanCycleUserService;
import com.kuaike.scrm.regionplan.service.RegionPlanService;
import com.kuaike.scrm.regionplan.service.UserAddFriendLimitService;
import com.kuaike.scrm.regionplan.service.WorkCycleService;
import com.kuaike.scrm.regionplan.utils.LocationUtil;
import com.kuaike.scrm.system.service.ChannelService;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RegionPlanServiceImpl
implements RegionPlanService {
    private static final Logger log = LoggerFactory.getLogger(RegionPlanServiceImpl.class);
    @Resource
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private MarketingPlanDraftMapper marketingPlanDraftMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private RegionInfoMapper regionInfoMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private MarketingPlanService marketingPlanService;
    @Autowired
    private MarketingPlanGroupService marketingPlanGroupService;
    @Autowired
    private MarketingConfigService marketingConfigService;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private MarketingChannelService marketingChannelService;
    @Autowired
    private MarketingTagService marketingTagService;
    @Autowired
    private WorkCycleService workCycleService;
    @Autowired
    private UserAddFriendLimitService userAddFriendLimitService;
    @Autowired
    private AlternativeUserService alternativeUserService;
    @Autowired
    private RegionPlanCycleUserService regionPlanCycleUserService;
    @Autowired
    private RegionPlanAutoPassService regionPlanAutoPassService;
    @Autowired
    private RegionPlanCurUserService regionPlanCurUserService;
    @Autowired
    private PageAuthRedisUtil pageAuthRedisUtil;
    @Autowired
    private MarketingReportService marketingReportService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WoauthParseUtil woauthParseUtil;

    @Override
    @Transactional
    public String add(RegionPlanDto params) {
        log.info("region plan params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        if (this.marketingPlanService.isRepeatMarketingPlanName(corpId, params.getName(), null, PlanType.REGION_PLAN)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u540d\u5df2\u88ab\u4f7f\u7528");
        }
        MarketingPlan marketingPlan = this.insertRegionPlan(params);
        Long planId = marketingPlan.getId();
        Long planGroupId = this.marketingPlanGroupService.addDefaultGroup(bizId, corpId, userId, planId);
        this.workCycleService.saveWorkCycle(planId, planGroupId, params);
        if (params.getLimitAddFriend() == 1) {
            this.userAddFriendLimitService.saveAddFriendLimit(planId, planGroupId, params.getWeworkUserLimits());
        }
        this.alternativeUserService.saveAlternativeUser(planId, planGroupId, params.getAlternativeWeworkUserIds());
        this.marketingTagService.saveMarketingTag(bizId, corpId, userId, planId, planGroupId, params.getWeworkTagIds());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.AUTO_REMARK.getValue(), params.getAddFriendRemark());
        String configJson = JacksonUtil.obj2Str((Object)params.getAddFriendWelcome());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FRIEND_WELCOME.getValue(), configJson);
        List channelIdList = this.channelService.getChannelIdByNum(params.getChannelIds());
        if (CollectionUtils.isEmpty((Collection)channelIdList)) {
            channelIdList.add(-1L);
        }
        this.marketingChannelService.saveMarketingChannels(bizId, corpId, userId, planId, channelIdList, params.getStatisticType(), PlanType.REGION_PLAN);
        this.regionPlanCurUserService.assignWeworkUser(marketingPlan);
        return params.getId();
    }

    @Override
    @Transactional
    public String edit(RegionPlanDto params) {
        log.info("region plan params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params.getId() == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan.setType(Integer.valueOf(PlanType.REGION_PLAN.getValue()));
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        Long planId = marketingPlan.getId();
        if (this.marketingPlanService.isRepeatMarketingPlanName(corpId, params.getName(), planId, PlanType.REGION_PLAN)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u540d\u5df2\u88ab\u4f7f\u7528");
        }
        this.updateRegionPlan(params, marketingPlan);
        Long planGroupId = this.marketingPlanGroupService.getDefaultGroupId(corpId, planId);
        this.workCycleService.saveWorkCycle(planId, planGroupId, params);
        if (params.getLimitAddFriend() == 1) {
            this.userAddFriendLimitService.saveAddFriendLimit(planId, planGroupId, params.getWeworkUserLimits());
        }
        this.alternativeUserService.saveAlternativeUser(planId, planGroupId, params.getAlternativeWeworkUserIds());
        this.marketingTagService.saveMarketingTag(bizId, corpId, userId, planId, planGroupId, params.getWeworkTagIds());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.AUTO_REMARK.getValue(), params.getAddFriendRemark());
        String configJson = JacksonUtil.obj2Str((Object)params.getAddFriendWelcome());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FRIEND_WELCOME.getValue(), configJson);
        List channelIdList = this.channelService.getChannelIdByNum(params.getChannelIds());
        if (CollectionUtils.isEmpty((Collection)channelIdList)) {
            channelIdList.add(-1L);
        }
        this.marketingChannelService.saveMarketingChannels(bizId, corpId, userId, planId, channelIdList, params.getStatisticType(), PlanType.REGION_PLAN);
        this.regionPlanCurUserService.assignWeworkUser(marketingPlan);
        return params.getId();
    }

    @Override
    public Object detail(BaseDto params) {
        log.info("region plan params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params.getId() == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan.setType(Integer.valueOf(PlanType.REGION_PLAN.getValue()));
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        Long planId = marketingPlan.getId();
        if (marketingPlan.getIsDraft().intValue() == IsDraft.IS_DRAFT.getValue()) {
            String paramsConfig = this.marketingPlanDraftMapper.queryDraftJson(planId);
            return JSONObject.parseObject((String)paramsConfig);
        }
        RegionPlanDetailDto regionPlanDetailDto = new RegionPlanDetailDto();
        regionPlanDetailDto.setId(marketingPlan.getNum());
        regionPlanDetailDto.setName(marketingPlan.getName());
        regionPlanDetailDto.setInitNumber(marketingPlan.getInitNumbers());
        regionPlanDetailDto.setStatisticType(marketingPlan.getStatsType());
        regionPlanDetailDto.setTemplateType(marketingPlan.getTemplateType());
        regionPlanDetailDto.setIsDraft(marketingPlan.getIsDraft());
        regionPlanDetailDto.setIsEnabled(marketingPlan.getIsEnabled());
        regionPlanDetailDto.setOnLineType(marketingPlan.getOnLineType());
        regionPlanDetailDto.setLimitAddFriend(marketingPlan.getLimitAddFriend());
        MarketingConfig marketingConfig = this.marketingConfigService.getMarketingPlanConfig(bizId, corpId, planId, MarketingConfigType.AUTO_REMARK.getValue());
        regionPlanDetailDto.setAddFriendRemark(marketingConfig.getConfigJson());
        marketingConfig = this.marketingConfigService.getMarketingPlanConfig(bizId, corpId, planId, MarketingConfigType.FRIEND_WELCOME.getValue());
        try {
            FriendWelcomeDto friendWelcomeDto = (FriendWelcomeDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FriendWelcomeDto.class);
            regionPlanDetailDto.setAddFriendWelcome(friendWelcomeDto);
        }
        catch (IOException e) {
            log.error("getMarketingPlan json error: {}", (Throwable)e);
        }
        Map<Long, List<ChannelDto>> channelDtoMap = this.marketingChannelService.queryPlanOfChannel(corpId, Lists.newArrayList((Object[])new Long[]{planId}), YnEnum.YES.getValue());
        regionPlanDetailDto.setChannelList(channelDtoMap.getOrDefault(planId, Lists.newArrayList()));
        Long planGroupId = this.marketingPlanGroupService.getDefaultGroupId(corpId, planId);
        regionPlanDetailDto.setWeworkTagList(this.marketingTagService.getPlanGroupTag(planId, planGroupId));
        if (regionPlanDetailDto.getOnLineType().intValue() == OnLineType.DAY_LINE_TYPE.getValue()) {
            regionPlanDetailDto.setWeworkUserList(this.regionPlanCycleUserService.getCycleUserInfo(corpId, planId, planGroupId, null));
            regionPlanDetailDto.setAutoPass(this.regionPlanAutoPassService.getAutoPassConfig(corpId, planId, planGroupId, null));
        } else if (regionPlanDetailDto.getOnLineType().intValue() == OnLineType.TIME_LINE_TYPE.getValue()) {
            regionPlanDetailDto.setWorkCycles(this.workCycleService.getRegionPlanWorkCycleInfo(corpId, planId, planGroupId));
        }
        if (regionPlanDetailDto.getLimitAddFriend() == 1) {
            regionPlanDetailDto.setWeworkUserLimits(this.userAddFriendLimitService.getUserLimit(corpId, planId, planGroupId));
        }
        regionPlanDetailDto.setAlternativeWeworkUserList(this.alternativeUserService.getAlternativeUserList(corpId, planId, planGroupId));
        return regionPlanDetailDto;
    }

    @Override
    @Transactional
    public void enable(MarketingPlanSwitchParams params) {
        log.info("openOrClose params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1 || marketingPlan.getType().intValue() != PlanType.REGION_PLAN.getValue() || marketingPlan.getIsDraft() == 1 || marketingPlan.getIsEnabled() == params.getIsEnabled()) {
            return;
        }
        params.checkParams();
        marketingPlan.setIsEnabled(params.getIsEnabled());
        marketingPlan.setUpdateBy(userId);
        marketingPlan.setUpdateTime(new Date());
        this.marketingPlanMapper.updateByPrimaryKeySelective((Object)marketingPlan);
        if (params.getIsEnabled() == 0) {
            this.regionPlanCurUserService.delAssignWorkUser(marketingPlan);
        } else {
            this.regionPlanCurUserService.assignWeworkUser(marketingPlan);
        }
    }

    @Override
    public List<MarketingListItemDto> list(MarketingListParams params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        params.setType(PlanType.REGION_PLAN.getValue());
        List<MarketingListItemDto> result = this.marketingPlanService.list(params);
        for (MarketingListItemDto planItemDto : result) {
            List<Object> list = Lists.newArrayList();
            if (planItemDto.getOnLineType().intValue() == OnLineType.DAY_LINE_TYPE.getValue()) {
                list = this.regionPlanCycleUserService.getCycleUserInfo(corpId, planItemDto.getPlanId(), null, null);
            } else if (planItemDto.getOnLineType().intValue() == OnLineType.TIME_LINE_TYPE.getValue()) {
                List<RegionPlanWorkCycle> workCycleList = this.workCycleService.getRegionPlanWorkCycles(corpId, planItemDto.getPlanId(), null);
                List<Long> workCycleIds = workCycleList.stream().map(it -> it.getId()).collect(Collectors.toList());
                list = this.regionPlanCycleUserService.getTimeLineUserInfo(corpId, planItemDto.getPlanId(), null, workCycleIds);
            }
            planItemDto.setWeworkUserList(list);
        }
        return result;
    }

    @Override
    public RegionPlanQrcodeDto selectRegionPlanQrcode(HttpServletRequest request, SelectRegionPlanQrcodeDto params) {
        log.info("selectRegionPlanQrcode params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.checkParams();
        if (MarketingUtil.invalidToken(params.getToken())) {
            log.warn("invalid token:{}", (Object)params.getToken());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u975e\u6cd5\u8bf7\u6c42");
        }
        if (this.pageAuthRedisUtil.existsQrToken(params.getToken())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u975e\u6cd5\u8bf7\u6c42");
        }
        MarketingChannel marketingChannel = this.marketingChannelService.getMarketingChannel(params.getId());
        if (marketingChannel == null || marketingChannel.getIsDeleted() == 1) {
            return null;
        }
        Long planId = marketingChannel.getPlanId();
        String corpId = marketingChannel.getCorpId();
        Long channelId = marketingChannel.getChannelId();
        MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1 || marketingPlan.getIsEnabled() == 0 || marketingPlan.getIsDraft() == 1) {
            return null;
        }
        WoauthUserDto woauthUserDto = this.woauthParseUtil.getWoauthInfo(request);
        String uniqId = woauthUserDto.getUniqId();
        this.marketingReportService.updateReportLocation(planId, uniqId, params.getRegion());
        RegionPlanQrcodeDto regionPlanQrcodeDto = new RegionPlanQrcodeDto();
        regionPlanQrcodeDto.setId(marketingPlan.getNum());
        regionPlanQrcodeDto.setName(marketingPlan.getName());
        regionPlanQrcodeDto.setTemplateType(marketingPlan.getTemplateType());
        regionPlanQrcodeDto.setActiveNumber(marketingPlan.getInitNumbers());
        List qrcodeList = this.marketingQrcodeMapper.queryRegionPlanQrcodeList(corpId, planId, channelId);
        PlanQrcodeDto minQrcodeDto = this.selectMinDistance(params.getLongitude(), params.getLatitude(), qrcodeList);
        if (minQrcodeDto != null) {
            regionPlanQrcodeDto.setQrcode(minQrcodeDto.getQrcodeUrl());
            regionPlanQrcodeDto.setRegion(minQrcodeDto.getRegion());
        } else {
            log.warn("plan not qrcode planId: {}", (Object)planId);
        }
        return regionPlanQrcodeDto;
    }

    @Override
    public List<RegionQrcodeDto> regionQrcodeList(BaseDto params) {
        if (params == null) {
            return null;
        }
        String planNum = params.getId();
        log.info("regionQrcodeList planNum: {}", (Object)planNum);
        if (StringUtils.isEmpty((Object)planNum)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setCorpId(corpId);
        marketingPlan.setNum(planNum);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1 || marketingPlan.getIsDraft() == 1 || marketingPlan.getType().intValue() != PlanType.REGION_PLAN.getValue()) {
            return Lists.newArrayList();
        }
        List qrcodeList = this.marketingQrcodeMapper.getPlanGroupQrcodeByPlanId(marketingPlan.getId());
        List channelIds = qrcodeList.stream().map(item -> item.getChannelId()).collect(Collectors.toList());
        List regionIds = qrcodeList.stream().map(item -> item.getRegionInfoId()).collect(Collectors.toList());
        Map channelMap = this.channelMapper.selectIdAndNameByIds(bizId, channelIds);
        List regionInfos = this.regionInfoMapper.queryRegionList(regionIds);
        Map regionInfoMap = regionInfos.stream().collect(Collectors.toMap(RegionInfo::getId, Function.identity()));
        ArrayList result = Lists.newArrayList();
        for (MarketingQrcode marketingQrcode : qrcodeList) {
            RegionQrcodeDto regionQrcodeDto = new RegionQrcodeDto();
            regionQrcodeDto.setChannelName((String)channelMap.get(marketingQrcode.getChannelId()));
            RegionInfo regionInfo = (RegionInfo)regionInfoMap.get(marketingQrcode.getRegionInfoId());
            if (regionInfo != null) {
                regionQrcodeDto.setRegion(regionInfo.getRegion());
            }
            regionQrcodeDto.setQrcode(marketingQrcode.getQrCodeUrl());
            regionQrcodeDto.setErrorMsg(marketingQrcode.getSyncErrorMsg());
            List<PlanQrcodeUserDto> curQrcodeUser = this.regionPlanCurUserService.getCurQrcodeUser(corpId, marketingPlan.getId(), marketingQrcode.getId());
            if (CollectionUtils.isEmpty(curQrcodeUser)) continue;
            regionQrcodeDto.setAutoPass(curQrcodeUser.get(0).getAutoPass());
            List weworkUserNums = curQrcodeUser.stream().map(it -> it.getWeworkUserNum()).collect(Collectors.toList());
            List weworkUsers = this.weworkUserMapper.getWeworkUserIdsByNum(corpId, weworkUserNums);
            regionQrcodeDto.setWeworkUserList(this.transformDto(weworkUsers));
            result.add(regionQrcodeDto);
        }
        return result;
    }

    @Override
    public List<WeworkUserDto> checkWeworkUserRegion(CheckUserReq params) {
        if (params == null || CollectionUtils.isEmpty(params.getWeworkUserIds())) {
            return Lists.newArrayList();
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Map weworkUserRegionMap = this.departmentService.getWeworkUserRegionMap(corpId, params.getWeworkUserIds());
        ArrayList list = Lists.newArrayList();
        for (String weworkUserNum : params.getWeworkUserIds()) {
            if (weworkUserRegionMap.containsKey(weworkUserNum)) continue;
            list.add(weworkUserNum);
        }
        List weworkUsers = this.weworkUserMapper.queryInfoListByNums((Collection)list);
        ArrayList result = Lists.newArrayListWithCapacity((int)weworkUsers.size());
        for (WeworkUser weworkUser : weworkUsers) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(weworkUser.getNum());
            weworkUserDto.setNickname(weworkUser.getName());
            result.add(weworkUserDto);
        }
        return result;
    }

    private List<WeworkUserDto> transformDto(List<WeworkUser> weworkUsers) {
        ArrayList result = Lists.newArrayListWithCapacity((int)weworkUsers.size());
        for (WeworkUser weworkUser : weworkUsers) {
            WeworkUserDto userDto = new WeworkUserDto();
            userDto.setId(weworkUser.getNum());
            userDto.setAvatar(weworkUser.getAvatar());
            userDto.setNickname(weworkUser.getName());
            result.add(userDto);
        }
        return result;
    }

    private PlanQrcodeDto selectMinDistance(BigDecimal lng, BigDecimal lat, List<PlanQrcodeDto> qrcodeList) {
        double minDistance = Double.MAX_VALUE;
        double userLng = lng.doubleValue();
        double userLat = lat.doubleValue();
        PlanQrcodeDto minQrcodeDto = null;
        for (PlanQrcodeDto planQrcodeDto : qrcodeList) {
            double curLat;
            double curLng;
            double distance;
            if (planQrcodeDto.getLongitude() == null || planQrcodeDto.getLatitude() == null) {
                minQrcodeDto = planQrcodeDto;
                break;
            }
            if (StringUtils.isEmpty((Object)planQrcodeDto.getQrcodeUrl()) || !((distance = LocationUtil.getDistance(userLng, userLat, curLng = planQrcodeDto.getLongitude().doubleValue(), curLat = planQrcodeDto.getLatitude().doubleValue())) < minDistance)) continue;
            minDistance = distance;
            minQrcodeDto = planQrcodeDto;
        }
        return minQrcodeDto;
    }

    private MarketingPlan insertRegionPlan(RegionPlanDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Date curDate = new Date();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(this.idGen.getNum());
        marketingPlan.setBizId(userInfo.getBizId());
        marketingPlan.setCorpId(userInfo.getCorpId());
        marketingPlan.setName(params.getName());
        marketingPlan.setType(Integer.valueOf(PlanType.REGION_PLAN.getValue()));
        marketingPlan.setTemplateType(params.getTemplateType());
        marketingPlan.setInitNumbers(params.getInitNumber());
        marketingPlan.setStatsType(params.getStatisticType());
        marketingPlan.setOnLineType(params.getOnLineType());
        marketingPlan.setLimitAddFriend(params.getLimitAddFriend());
        marketingPlan.setIsDeleted(Integer.valueOf(0));
        marketingPlan.setIsDraft(Integer.valueOf(0));
        marketingPlan.setIsEnabled(Integer.valueOf(1));
        marketingPlan.setCreateBy(userInfo.getId());
        marketingPlan.setCreateTime(curDate);
        marketingPlan.setUpdateBy(userInfo.getId());
        marketingPlan.setUpdateTime(curDate);
        this.marketingPlanMapper.insertSelective((Object)marketingPlan);
        params.setId(marketingPlan.getNum());
        return marketingPlan;
    }

    private void updateRegionPlan(RegionPlanDto params, MarketingPlan marketingPlan) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        marketingPlan.setName(params.getName());
        marketingPlan.setTemplateType(params.getTemplateType());
        marketingPlan.setInitNumbers(params.getInitNumber());
        marketingPlan.setStatsType(params.getStatisticType());
        marketingPlan.setOnLineType(params.getOnLineType());
        marketingPlan.setLimitAddFriend(params.getLimitAddFriend());
        marketingPlan.setUpdateBy(userInfo.getId());
        marketingPlan.setUpdateTime(new Date());
        this.marketingPlanMapper.updateByPrimaryKeySelective((Object)marketingPlan);
    }
}

