/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionplan.dto;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.regionplan.dto.AutoPassDto;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkCycleDto {
    private String id;
    private List<String> weworkUserIds;
    private Set<Integer> cycle;
    private String startTime;
    private String endTime;
    private Integer isDeleted;
    private AutoPassDto autoPass;

    public void checkParams() {
        if (this.isDeleted != null && this.isDeleted == 1) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.id), (Object)"\u5468\u671fid\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserIds), (Object)"\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.cycle), (Object)"\u5de5\u4f5c\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        for (String weworkUserNum : this.weworkUserIds) {
            if (!StringUtils.isEmpty((CharSequence)weworkUserNum)) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6210\u5458\u9009\u62e9\u53c2\u6570\u9519\u8bef");
        }
        for (Integer workCycle : this.cycle) {
            if (workCycle <= 7 && workCycle >= 1) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5de5\u4f5c\u5468\u671f\u53c2\u6570\u9519\u8bef");
        }
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)this.startTime) || StringUtils.isNotEmpty((CharSequence)this.endTime) ? 1 : 0) != 0, (Object)"\u5de5\u4f5c\u5468\u671f\u4e0a\u7ebf\u65f6\u95f4\u6bb5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Date startDateTime = DateUtil.getDate((String)this.startTime, (String)"HH:mm");
            Date endDateTime = DateUtil.getDate((String)this.endTime, (String)"HH:mm");
            if (startDateTime == null || endDateTime == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5de5\u4f5c\u5468\u671f\u4e0a\u7ebf\u65f6\u95f4\u6bb5\u53c2\u6570\u9519\u8bef");
            }
            if (endDateTime.before(startDateTime)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5de5\u4f5c\u5468\u671f\u4e0a\u7ebf\u65f6\u95f4\u6bb5\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5de5\u4f5c\u5468\u671f\u4e0a\u7ebf\u65f6\u95f4\u6bb5\u53c2\u6570\u9519\u8bef");
        }
        Preconditions.checkArgument((this.autoPass != null ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u901a\u8fc7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.autoPass.checkParams();
    }

    public String getId() {
        return this.id;
    }

    public List<String> getWeworkUserIds() {
        return this.weworkUserIds;
    }

    public Set<Integer> getCycle() {
        return this.cycle;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public AutoPassDto getAutoPass() {
        return this.autoPass;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setWeworkUserIds(List<String> weworkUserIds) {
        this.weworkUserIds = weworkUserIds;
    }

    public void setCycle(Set<Integer> cycle) {
        this.cycle = cycle;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setAutoPass(AutoPassDto autoPass) {
        this.autoPass = autoPass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkCycleDto)) {
            return false;
        }
        WorkCycleDto other = (WorkCycleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$isDeleted = this.getIsDeleted();
        Integer other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$weworkUserIds = this.getWeworkUserIds();
        List<String> other$weworkUserIds = other.getWeworkUserIds();
        if (this$weworkUserIds == null ? other$weworkUserIds != null : !((Object)this$weworkUserIds).equals(other$weworkUserIds)) {
            return false;
        }
        Set<Integer> this$cycle = this.getCycle();
        Set<Integer> other$cycle = other.getCycle();
        if (this$cycle == null ? other$cycle != null : !((Object)this$cycle).equals(other$cycle)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        AutoPassDto this$autoPass = this.getAutoPass();
        AutoPassDto other$autoPass = other.getAutoPass();
        return !(this$autoPass == null ? other$autoPass != null : !((Object)this$autoPass).equals(other$autoPass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkCycleDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $weworkUserIds = this.getWeworkUserIds();
        result = result * 59 + ($weworkUserIds == null ? 43 : ((Object)$weworkUserIds).hashCode());
        Set<Integer> $cycle = this.getCycle();
        result = result * 59 + ($cycle == null ? 43 : ((Object)$cycle).hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        AutoPassDto $autoPass = this.getAutoPass();
        result = result * 59 + ($autoPass == null ? 43 : ((Object)$autoPass).hashCode());
        return result;
    }

    public String toString() {
        return "WorkCycleDto(id=" + this.getId() + ", weworkUserIds=" + this.getWeworkUserIds() + ", cycle=" + this.getCycle() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", isDeleted=" + this.getIsDeleted() + ", autoPass=" + this.getAutoPass() + ")";
    }
}

