/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.event.EventPage;
import cn.kinyun.customer.center.dto.req.event.EventVisitor;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.utils.WoauthParseUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannelReport;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.OauthShortUrl;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelReportMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.OauthShortUrlMapper;
import com.kuaike.scrm.marketing.dto.client.ClientParamsDto;
import com.kuaike.scrm.marketing.service.MarketingChannelService;
import com.kuaike.scrm.marketing.service.MarketingReportService;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketingReportServiceImp
implements MarketingReportService {
    private static final Logger log = LoggerFactory.getLogger(MarketingReportServiceImp.class);
    @Resource
    private MarketingChannelReportMapper marketingChannelReportMapper;
    @Autowired
    private MarketingChannelService marketingChannelService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Resource
    private OauthShortUrlMapper oauthShortUrlMapper;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private WoauthParseUtil woauthParseUtil;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${marketing.url.format}")
    private String marketingPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${region-plan.url.format}")
    private String regionPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${room-plan.url.format}")
    private String roomPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${friend-fission.url.format}")
    private String friendFissionUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.shortUrl}")
    private String oauthShortUrl;

    @Override
    @Transactional
    public void report(HttpServletRequest request, ClientParamsDto params) {
        log.info("report params: {}, ip: {}", (Object)params);
        String num = params.getId();
        params.validate();
        MarketingChannel marketingChannel = this.marketingChannelService.getMarketingChannel(num);
        if (marketingChannel == null || marketingChannel.getIsDeleted() == 1) {
            log.warn("marketingChannel is null or is deleted");
            return;
        }
        Enumeration referer = request.getHeaders("Referer");
        WoauthUserDto woauthInfo = this.woauthParseUtil.getWoauthInfo(request);
        String ip = woauthInfo.getIp();
        MarketingChannelReport channelReport = new MarketingChannelReport();
        channelReport.setBizId(marketingChannel.getBizId());
        channelReport.setCorpId(marketingChannel.getCorpId());
        channelReport.setPlanId(marketingChannel.getPlanId());
        channelReport.setChannelId(marketingChannel.getChannelId());
        channelReport.setAppId(woauthInfo.getAppId());
        channelReport.setOpenId(woauthInfo.getOpenId());
        channelReport.setUniqId(woauthInfo.getUniqId());
        channelReport.setUnionId(woauthInfo.getUniqueId());
        channelReport.setContactId(woauthInfo.getExternalUserId());
        channelReport.setNickName(woauthInfo.getName());
        channelReport.setHeadUrl(woauthInfo.getAvatar());
        channelReport.setSex(woauthInfo.getSex());
        channelReport.setCity(this.bjyPartnerService.getCityByIp(woauthInfo.getIp()));
        channelReport.setReportTime(new Date());
        channelReport.setCreateTime(new Date());
        channelReport.setIp(ip);
        this.redisTemplate.opsForValue().set((Object)(this.redisKeyPrefix + ":" + params.getAccessNum()), (Object)marketingChannel.getBizId().toString(), 60L, TimeUnit.SECONDS);
        this.marketingChannelReportMapper.insertSelective((Object)channelReport);
        this.customerCenterService.pushChannelReportCustomer(channelReport);
        channelReport = (MarketingChannelReport)this.marketingChannelReportMapper.selectByPrimaryKey((Object)channelReport.getId());
        String customerNum = channelReport.getCustomerNum();
        MarketingPlan plan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)channelReport.getPlanId());
        String originUrl = this.getChannelUrl(num, plan.getType());
        this.writeVisitPageEvent(customerNum, params.getAccessNum(), plan, originUrl, marketingChannel.getId(), woauthInfo, (String)referer.nextElement());
    }

    private void writeVisitPageEvent(String customerNum, String accessNum, MarketingPlan plan, String originUrl, Long channelId, WoauthUserDto woauthInfo, String referer) {
        if (StringUtils.isBlank((CharSequence)accessNum) || StringUtils.isBlank((CharSequence)customerNum)) {
            log.info("marketing plan report write event accessNum or customerNum is empty, {}, {}", (Object)accessNum, (Object)customerNum);
            return;
        }
        EventPage eventPage = new EventPage();
        eventPage.setTitle(plan.getName());
        eventPage.setIcon(plan.getBgImg());
        eventPage.setUrl(originUrl);
        OauthShortUrl oauthShort = this.oauthShortUrlMapper.queryShortUrlByOriginUrl(originUrl);
        if (oauthShort != null) {
            String shortUrl = MessageFormat.format(this.oauthShortUrl, oauthShort.getShortUrl());
            eventPage.setShortUrl(shortUrl);
        }
        EventModule module = new EventModule();
        module.setType(ModuleType.MARKETING_PLAN.getCode());
        module.setName(plan.getName());
        module.setNum(plan.getNum());
        module.setPlanType(PlanType.get((int)plan.getType()).getDesc());
        module.setChannelId(channelId);
        EventVisitor visitor = this.woauthParseUtil.buildVisitor(woauthInfo, referer);
        this.customerCenterService.saveVisitPage(plan.getBizId(), customerNum, accessNum, eventPage, module, null, visitor);
    }

    private String getChannelUrl(String num, int planType) {
        if (planType == PlanType.CHANNEL_PLAN.getValue()) {
            return MessageFormat.format(this.marketingPlanUrlFormat, num);
        }
        if (planType == PlanType.REGION_PLAN.getValue()) {
            return MessageFormat.format(this.regionPlanUrlFormat, num);
        }
        if (planType == PlanType.ROOM_PLAN.getValue()) {
            return MessageFormat.format(this.roomPlanUrlFormat, num);
        }
        if (planType == PlanType.FRIEND_FISSION_PLAN.getValue()) {
            return MessageFormat.format(this.friendFissionUrlFormat, num);
        }
        return null;
    }

    @Override
    @Transactional
    public void updateReportLocation(Long planId, String snsUniqId, String region) {
        if (StringUtils.isEmpty((CharSequence)snsUniqId)) {
            log.warn("updateReportLocation snsUniqId is null");
            return;
        }
        this.marketingChannelReportMapper.updateReportLocation(planId, snsUniqId, region);
    }
}

