/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.LongIdAndNameDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanGroup;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.marketing.dto.MarketingPlanGroupDetailDto;
import com.kuaike.scrm.marketing.dto.MarketingPlanGroupDto;
import com.kuaike.scrm.marketing.enums.MarketingAllocType;
import com.kuaike.scrm.marketing.service.MarketingAllocService;
import com.kuaike.scrm.marketing.service.MarketingPlanGroupService;
import com.kuaike.scrm.marketing.service.MarketingTagService;
import com.kuaike.scrm.marketing.service.MarketingUserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketingPlanGroupServiceImp
implements MarketingPlanGroupService {
    private static final Logger log = LoggerFactory.getLogger(MarketingPlanGroupServiceImp.class);
    @Resource
    private MarketingPlanGroupMapper marketingPlanGroupMapper;
    @Autowired
    private MarketingTagService marketingTagService;
    @Autowired
    private MarketingUserService marketingUserService;
    @Autowired
    private IdGen idGen;
    @Resource
    private MarketingAllocService marketingAllocService;

    @Override
    @Transactional
    public void addMarketingPlanGroup(Long bizId, String corpId, Long userId, Long planId, List<MarketingPlanGroupDto> groupList) {
        for (MarketingPlanGroupDto planGroupDto : groupList) {
            MarketingPlanGroup marketingPlanGroup = new MarketingPlanGroup();
            marketingPlanGroup.setNum(this.idGen.getNum());
            marketingPlanGroup.setBizId(bizId);
            marketingPlanGroup.setCorpId(corpId);
            marketingPlanGroup.setPlanId(planId);
            marketingPlanGroup.setName(planGroupDto.getName());
            marketingPlanGroup.setCreateBy(userId);
            marketingPlanGroup.setCreateTime(new Date());
            marketingPlanGroup.setUpdateBy(userId);
            marketingPlanGroup.setUpdateTime(new Date());
            marketingPlanGroup.setIsDeleted(Integer.valueOf(0));
            Integer allocType = planGroupDto.getAllocType();
            marketingPlanGroup.setAllocType(allocType == null ? MarketingAllocType.NO_ALLOC.getType() : allocType);
            this.marketingPlanGroupMapper.insertSelective((Object)marketingPlanGroup);
            planGroupDto.setGroupId(marketingPlanGroup.getId());
            if (CollectionUtils.isNotEmpty(planGroupDto.getWeworkUserIds()) || CollectionUtils.isNotEmpty(planGroupDto.getDeptIds())) {
                Map<String, Integer> weworkUserIdWeightMap = Collections.emptyMap();
                Map<Long, Integer> deptIdWeightMap = Collections.emptyMap();
                if (MarketingAllocType.WEIGHT.getType().equals(allocType)) {
                    weworkUserIdWeightMap = this.buildWeworkUserIdWeightMap(planGroupDto);
                    deptIdWeightMap = this.buildDeptIdWeightMap(planGroupDto);
                }
                this.marketingUserService.saveMarketingUser(bizId, corpId, userId, planId, marketingPlanGroup.getId(), planGroupDto.getWeworkUserIds(), planGroupDto.getDeptIds(), weworkUserIdWeightMap, deptIdWeightMap);
            }
            if (!CollectionUtils.isNotEmpty(planGroupDto.getWeworkTagIds())) continue;
            this.marketingTagService.saveMarketingTag(bizId, corpId, userId, planId, marketingPlanGroup.getId(), planGroupDto.getWeworkTagIds());
        }
    }

    private Map<String, Integer> buildWeworkUserIdWeightMap(MarketingPlanGroupDto planGroupDto) {
        List<WeworkUserDto> weworkUserList = planGroupDto.getWeworkUserList();
        HashMap<String, Integer> weightMap = new HashMap<String, Integer>();
        for (WeworkUserDto weworkUserDto : weworkUserList) {
            String weworkUserId = weworkUserDto.getId();
            Integer weight = weworkUserDto.getWeight();
            weightMap.put(weworkUserId, weight);
        }
        return weightMap;
    }

    private Map<Long, Integer> buildDeptIdWeightMap(MarketingPlanGroupDto planGroupDto) {
        List<LongIdAndNameDto> deptList = planGroupDto.getDeptList();
        HashMap<Long, Integer> weightMap = new HashMap<Long, Integer>();
        for (LongIdAndNameDto longIdAndNameDto : deptList) {
            Long deptId = longIdAndNameDto.getId();
            Integer weight = longIdAndNameDto.getWeight();
            weightMap.put(deptId, weight);
        }
        return weightMap;
    }

    @Override
    @Transactional
    public void updateMarketingPlanGroup(Long bizId, String corpId, Long userId, Long planId, List<MarketingPlanGroupDto> groupList) {
        for (MarketingPlanGroupDto planGroupDto : groupList) {
            boolean isUpdateGroupUser;
            MarketingPlanGroup marketingPlanGroup = new MarketingPlanGroup();
            marketingPlanGroup.setNum(planGroupDto.getId());
            marketingPlanGroup = (MarketingPlanGroup)this.marketingPlanGroupMapper.selectOne((Object)marketingPlanGroup);
            if (marketingPlanGroup == null) continue;
            marketingPlanGroup.setName(planGroupDto.getName());
            marketingPlanGroup.setUpdateBy(userId);
            marketingPlanGroup.setUpdateTime(new Date());
            Integer allocType = planGroupDto.getAllocType() == null ? MarketingAllocType.NO_ALLOC.getType() : planGroupDto.getAllocType();
            Integer oldAllocType = marketingPlanGroup.getAllocType();
            marketingPlanGroup.setAllocType(allocType);
            if (!MarketingAllocType.NO_ALLOC.getType().equals(oldAllocType) && MarketingAllocType.NO_ALLOC.getType().equals(allocType)) {
                this.marketingAllocService.delRedisAllocCache(planId, Collections.singleton(marketingPlanGroup.getId()));
            }
            this.marketingPlanGroupMapper.updateByPrimaryKey((Object)marketingPlanGroup);
            Map<String, Integer> weworkUserIdWeightMap = Collections.emptyMap();
            Map<Long, Integer> deptIdWeightMap = Collections.emptyMap();
            if (MarketingAllocType.WEIGHT.getType().equals(allocType)) {
                weworkUserIdWeightMap = this.buildWeworkUserIdWeightMap(planGroupDto);
                deptIdWeightMap = this.buildDeptIdWeightMap(planGroupDto);
            }
            if (isUpdateGroupUser = this.marketingUserService.saveMarketingUser(bizId, corpId, userId, planId, marketingPlanGroup.getId(), planGroupDto.getWeworkUserIds(), planGroupDto.getDeptIds(), weworkUserIdWeightMap, deptIdWeightMap)) {
                planGroupDto.setGroupId(marketingPlanGroup.getId());
            }
            this.marketingTagService.saveMarketingTag(bizId, corpId, userId, planId, marketingPlanGroup.getId(), planGroupDto.getWeworkTagIds());
        }
    }

    @Override
    @Transactional
    public void delMarketingPlanGorup(Long bizId, String corpId, Long userId, Long planId, List<Long> groupIdList) {
        if (CollectionUtils.isEmpty(groupIdList)) {
            return;
        }
        this.marketingPlanGroupMapper.batchDel(bizId, corpId, planId, userId, groupIdList);
        this.marketingUserService.delMarketingUserByPlanGroup(bizId, corpId, userId, planId, groupIdList);
        this.marketingTagService.delMarketingUserByPlanGroup(bizId, corpId, userId, planId, groupIdList);
    }

    @Override
    public List<MarketingPlanGroupDetailDto> getMarketingGroupDetail(Long planId) {
        List groups = this.marketingPlanGroupMapper.getPlanGroupsByPlanId(planId);
        ArrayList result = Lists.newArrayList();
        for (MarketingPlanGroup group : groups) {
            MarketingPlanGroupDetailDto groupDetailDto = new MarketingPlanGroupDetailDto();
            groupDetailDto.setId(group.getNum());
            groupDetailDto.setName(group.getName());
            groupDetailDto.setWeworkTagList(this.marketingTagService.getPlanGroupTag(planId, group.getId()));
            groupDetailDto.setWeworkUserList(this.marketingUserService.getPlanGroupUserInfo(planId, group.getId()));
            groupDetailDto.setDeptList(this.marketingUserService.getPlanGroupDeptInfo(planId, group.getId()));
            groupDetailDto.setAllocType(group.getAllocType());
            groupDetailDto.setPlanGroupId(group.getId());
            result.add(groupDetailDto);
        }
        return result;
    }

    @Override
    public List<Long> getGroupIdsByPlanId(Long planId) {
        if (planId == null) {
            return Lists.newArrayList();
        }
        return this.marketingPlanGroupMapper.getPlanGroupIdsByPlanId(planId);
    }

    @Override
    public List<Long> getPlanGroupIdsByNum(List<String> numList) {
        if (CollectionUtils.isEmpty(numList)) {
            return Lists.newArrayList();
        }
        return this.marketingPlanGroupMapper.getPlanGroupIdsByNum(numList);
    }

    @Override
    public Long addDefaultGroup(Long bizId, String corpId, Long userId, Long planId) {
        MarketingPlanGroup marketingPlanGroup = new MarketingPlanGroup();
        marketingPlanGroup.setNum(this.idGen.getNum());
        marketingPlanGroup.setBizId(bizId);
        marketingPlanGroup.setCorpId(corpId);
        marketingPlanGroup.setPlanId(planId);
        marketingPlanGroup.setCreateBy(userId);
        marketingPlanGroup.setName("");
        marketingPlanGroup.setCreateTime(new Date());
        marketingPlanGroup.setUpdateBy(userId);
        marketingPlanGroup.setUpdateTime(new Date());
        marketingPlanGroup.setIsDeleted(Integer.valueOf(0));
        this.marketingPlanGroupMapper.insertSelective((Object)marketingPlanGroup);
        return marketingPlanGroup.getId();
    }

    @Override
    public Long getDefaultGroupId(String corpId, Long planId) {
        MarketingPlanGroup marketingPlanGroup = new MarketingPlanGroup();
        marketingPlanGroup.setCorpId(corpId);
        marketingPlanGroup.setPlanId(planId);
        marketingPlanGroup.setIsDeleted(Integer.valueOf(0));
        MarketingPlanGroup planGroup = (MarketingPlanGroup)this.marketingPlanGroupMapper.selectOne((Object)marketingPlanGroup);
        return planGroup != null ? planGroup.getId() : null;
    }
}

