/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.friendfission.utils;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Object2MapUtils {
    private static final Logger log = LoggerFactory.getLogger(Object2MapUtils.class);

    private Object2MapUtils() {
    }

    public static Map<String, Object> object2Map(Object o) {
        if (Objects.isNull(o)) {
            return Maps.newHashMap();
        }
        TreeMap map = Maps.newTreeMap();
        for (Field field : o.getClass().getDeclaredFields()) {
            boolean accessFlag = field.isAccessible();
            field.setAccessible(true);
            String key = field.getName();
            try {
                Object value = field.get(o);
                field.setAccessible(accessFlag);
                map.put(key, value);
            }
            catch (IllegalAccessException e) {
                log.error("\u8bfb\u53d6\u5bf9\u8c61\u5c5e\u6027\u5931\u8d25, object={}", o, (Object)e);
            }
        }
        return map;
    }
}

