/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.databigscreen.service.impl;

import cn.kinyun.crm.common.enums.MapTypeEnum;
import cn.kinyun.crm.common.service.CrmCustomerService;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.ChannelDataReq;
import cn.kinyun.crm.common.service.dto.req.CustomerAreaReq;
import cn.kinyun.crm.common.service.dto.req.MobileCustomerDataReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsStatisticsResp;
import cn.kinyun.crm.common.service.dto.resp.LeadsChannelDataResp;
import cn.kinyun.crm.common.service.dto.resp.MobileCustomerDataResp;
import cn.kinyun.customer.center.dto.req.CcCustomerAreaReq;
import cn.kinyun.customer.center.dto.req.order.AmountStatisticsResp;
import cn.kinyun.customer.center.dto.req.order.BigScreenOrderReq;
import cn.kinyun.customer.center.dto.resp.CcCustomerStatisticsResp;
import cn.kinyun.customer.center.dto.resp.OrderSkuResp;
import cn.kinyun.customer.center.service.CcOrderStatisticsService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.databigscreen.dto.req.TimeBaseReq;
import com.kuaike.scrm.databigscreen.dto.resp.ChannelDataResp;
import com.kuaike.scrm.databigscreen.dto.resp.NewCustomerDataResp;
import com.kuaike.scrm.databigscreen.dto.resp.WeworkContactDataResp;
import com.kuaike.scrm.databigscreen.service.DataBigScreenService;
import com.kuaike.scrm.databigscreen.service.dto.SkuListResp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataBigScreenServiceImpl
implements DataBigScreenService {
    private static final Logger log = LoggerFactory.getLogger(DataBigScreenServiceImpl.class);
    @Resource
    private ScrmBizService scrmBizService;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Autowired
    private CcOrderStatisticsService ccOrderStatisticsService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private CrmCustomerService customerService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private ScrmUserService userService;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private ChannelMapper channelMapper;

    @Override
    public NewCustomerDataResp mobileData(TimeBaseReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("mobileData,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        NewCustomerDataResp resp = new NewCustomerDataResp();
        boolean isOpenCrm = this.scrmBizService.isOpenCrm(userInfo.getBizId());
        if (isOpenCrm) {
            MobileCustomerDataReq mobileCustomerDataReq = new MobileCustomerDataReq();
            mobileCustomerDataReq.setBizId(userInfo.getBizId());
            mobileCustomerDataReq.setStartTime(req.getStartTime());
            mobileCustomerDataReq.setEndTime(req.getEndTime());
            try {
                MobileCustomerDataResp mobileCustomerDataResp = this.crmLeadsService.getMobileCustomerDataByTime(mobileCustomerDataReq);
                resp.setNewAddCount(mobileCustomerDataResp.getNewAddCount());
                resp.setAddWeworkCount(mobileCustomerDataResp.getAddWeworkCount());
            }
            catch (Exception ex) {
                log.error("\u8c03\u7528crmLeadsService.getMobileCustomerDataByTime\u63a5\u53e3\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        } else {
            resp.setNewAddCount(NumberUtils.LONG_ZERO);
            resp.setAddWeworkCount(NumberUtils.LONG_ZERO);
        }
        return resp;
    }

    @Override
    public WeworkContactDataResp weworkContactData(TimeBaseReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("weworkContactData,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        Long weworkContactCount = this.weworkContactMapper.getCountByTime(userInfo.getBizId(), req.getStartTime(), req.getEndTime());
        Long remarkMobileCount = this.weworkContactMapper.getRemarkedMobileCountByTime(userInfo.getBizId(), userInfo.getCorpId(), req.getStartTime(), req.getEndTime());
        WeworkContactDataResp resp = new WeworkContactDataResp();
        resp.setWeworkContactCount(weworkContactCount);
        resp.setRemarkMobileCount(remarkMobileCount);
        return resp;
    }

    @Override
    public List<ChannelDataResp> channelData(TimeBaseReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("channelData,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateParams();
        List channels = this.channelMapper.queryIdAndNameByBizId(userInfo.getBizId());
        if (CollectionUtils.isEmpty((Collection)channels)) {
            return Collections.emptyList();
        }
        ArrayList channelDataResps = Lists.newArrayListWithCapacity((int)channels.size());
        boolean isOpenCrm = this.scrmBizService.isOpenCrm(userInfo.getBizId());
        if (isOpenCrm) {
            List<Long> channelIds = channels.stream().map(Channel::getId).collect(Collectors.toList());
            ChannelDataReq channelDataReq = req.convert2ChannelDataReq(channelIds, userInfo.getBizId());
            List leadsChannelDataResps = null;
            Map channelId2DataMap = null;
            try {
                leadsChannelDataResps = this.crmLeadsService.getChannelData(channelDataReq);
            }
            catch (Exception ex) {
                log.error("\u8c03\u7528crmLeadsService.getChannelData\u63a5\u53e3\u53d1\u751f\u5f02\u5e38,\u8bf7\u6c42\u53c2\u6570\uff1a{},\u5f02\u5e38\u4fe1\u606f:", (Object)channelDataReq, (Object)ex);
            }
            if (CollectionUtils.isNotEmpty((Collection)leadsChannelDataResps)) {
                channelId2DataMap = leadsChannelDataResps.stream().collect(Collectors.toMap(LeadsChannelDataResp::getChannelId, Functions.identity()));
            }
            for (Channel channel : channels) {
                ChannelDataResp channelDataResp = new ChannelDataResp();
                channelDataResps.add(channelDataResp);
                channelDataResp.setChannelName(channel.getName());
                if (!MapUtils.isNotEmpty(channelId2DataMap) || !channelId2DataMap.containsKey(channel.getId())) continue;
                LeadsChannelDataResp dataResp = (LeadsChannelDataResp)channelId2DataMap.get(channel.getId());
                channelDataResp.setLeadsCount(dataResp.getLeadsCount());
                channelDataResp.setFollowCount(dataResp.getFollowCount());
                channelDataResp.setAddWeworkCount(dataResp.getAddWeworkCount());
                channelDataResp.setContractCount(dataResp.getContractCount());
            }
            channelDataResps.sort(Comparator.comparing(ChannelDataResp::getLeadsCount).reversed());
        } else {
            for (Channel channel : channels) {
                ChannelDataResp channelDataResp = new ChannelDataResp();
                channelDataResps.add(channelDataResp);
                channelDataResp.setChannelName(channel.getName());
            }
        }
        return channelDataResps;
    }

    @Override
    public List<SkuListResp> orderList(BigScreenOrderReq bigScreenReq) {
        try {
            Set<Long> userIds = this.buildManagerUserIds(LoginUtils.getCurrentUserBizId(), bigScreenReq.getDepIds(), bigScreenReq.getUserIds());
            if (CollectionUtils.isEmpty(userIds)) {
                bigScreenReq.setUserIdLongs((List)Lists.newArrayList(userIds));
            }
            bigScreenReq.setBizId(LoginUtils.getCurrentUserBizId());
            List list = this.ccOrderStatisticsService.orderList(bigScreenReq);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Lists.newArrayList();
            }
            return list.stream().map(this::customerSkuRespConvertScrmSkuResp).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5ba2\u6237\u4e2d\u5fc3\u67e5\u8be2 \u8ba2\u5355\u5217\u8868\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public AmountStatisticsResp amountStatistics(BigScreenOrderReq bigScreenReq) {
        try {
            bigScreenReq.setBizId(LoginUtils.getCurrentUserBizId());
            bigScreenReq.validate();
            Set<Long> userIds = this.buildManagerUserIds(LoginUtils.getCurrentUserBizId(), bigScreenReq.getDepIds(), bigScreenReq.getUserIds());
            if (CollectionUtils.isNotEmpty(userIds)) {
                bigScreenReq.setUserIdLongs((List)Lists.newArrayList(userIds));
            }
            log.info("\u7edf\u8ba1\u8ba2\u5355\u6570\u636e param\uff1a{}", (Object)bigScreenReq);
            long start = System.currentTimeMillis();
            AmountStatisticsResp amountStatisticsResp = this.ccOrderStatisticsService.amountStatistics(bigScreenReq);
            long end = System.currentTimeMillis();
            log.info("\u7edf\u8ba1\u8ba2\u5355\u6570\u636e response\uff1a{}; totalCost:{}ms", (Object)JSON.toJSONString((Object)amountStatisticsResp), (Object)(end - start));
            return amountStatisticsResp;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5ba2\u6237\u4e2d\u5fc3\u67e5\u8be2 \u8ba2\u5355\u5217\u8868\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public List<CrmLeadsStatisticsResp> orderMapStatistics(CustomerAreaReq req) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u533a\u57df\u7edf\u8ba1\u6570\u636e :req:{}", (Object)req);
        if (Objects.isNull(req.getMapType())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5730\u56fe\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MapTypeEnum mapTypeEnum = MapTypeEnum.getByValue((int)req.getMapType());
        if (Objects.isNull(mapTypeEnum)) {
            log.error("\u7edf\u8ba1\u7c7b\u578b \u5728\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\uff1a{}", (Object)req.getMapType());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7edf\u8ba1\u7c7b\u578b \u5728\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u5bf9\u5e94\u7c7b\u578b");
        }
        req.setBizId(LoginUtils.getCurrentUserBizId());
        req.validateParam();
        List leadsAreaStatistics = null;
        try {
            if (MapTypeEnum.ORDER_MAP.equals((Object)mapTypeEnum)) {
                CcCustomerAreaReq customerAreaReq = this.crmAreaReqConvertCustomerAreaReq(req);
                List ccCustomerStatisticsResps = this.ccOrderStatisticsService.orderMapStatistics(customerAreaReq);
                log.info("\u67e5\u8be2\u5ba2\u6237\u4e2d\u5fc3 \u5ba2\u6237\u5206\u914d\u54cd\u5e94\u7ed3\u679c\uff1asize:{}", (Object)CollectionUtils.size((Object)ccCustomerStatisticsResps));
                leadsAreaStatistics = ccCustomerStatisticsResps.stream().map(this::customerStatisticsRespToCrmResp).filter(Objects::nonNull).collect(Collectors.toList());
            } else {
                leadsAreaStatistics = this.customerService.getLeadsAreaStatistics(req);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u5ba2\u6237\u5206\u5e03\u5f02\u5e38: reqType:{}; resp:{}", new Object[]{req.getMapType(), e.getMessage(), e});
        }
        return leadsAreaStatistics;
    }

    private Set<Long> buildManagerUserIds(Long bizId, List<String> deptIdStrs, List<String> userIdStrs) {
        List userInfoByNums;
        List userIds;
        HashSet manageUserIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(deptIdStrs)) {
            Set queryUserIds;
            Map idByNums = this.nodeService.getIdByNums(bizId, deptIdStrs);
            Collection parentNodes = idByNums.values();
            Set childNodeIds = this.nodeService.getPosterityIds(parentNodes, bizId);
            HashSet allNodes = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(parentNodes)) {
                allNodes.addAll(parentNodes);
            }
            if (CollectionUtils.isNotEmpty((Collection)childNodeIds)) {
                allNodes.addAll(childNodeIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)(queryUserIds = this.userService.queryIdsByNodeIds((Collection)allNodes)))) {
                manageUserIds.addAll(queryUserIds);
            }
        }
        if (CollectionUtils.isNotEmpty(userIdStrs) && CollectionUtils.isNotEmpty(userIds = (userInfoByNums = this.userService.getUserInfoByNums(userIdStrs)).stream().map(UserSimpleInfo::getId).collect(Collectors.toList()))) {
            manageUserIds.addAll(userIds);
        }
        return manageUserIds;
    }

    private SkuListResp customerSkuRespConvertScrmSkuResp(OrderSkuResp orderSkuResp) {
        if (Objects.isNull(orderSkuResp)) {
            return null;
        }
        SkuListResp skuListResp = new SkuListResp();
        skuListResp.setGoodsName(orderSkuResp.getSkuName());
        skuListResp.setGoodsImage(orderSkuResp.getSkuImgUrl());
        skuListResp.setOrderAmount(orderSkuResp.getSkuAmount());
        skuListResp.setOrderTime(orderSkuResp.getPaidTime());
        skuListResp.setOrderNo(orderSkuResp.getOrderNo());
        return skuListResp;
    }

    private CcCustomerAreaReq crmAreaReqConvertCustomerAreaReq(CustomerAreaReq req) {
        if (Objects.isNull(req)) {
            return null;
        }
        CcCustomerAreaReq customerAreaReq = new CcCustomerAreaReq();
        customerAreaReq.setCustomerNums(req.getCustomerNums());
        customerAreaReq.setBizId(req.getBizId());
        customerAreaReq.setEndTime(req.getEndTime());
        customerAreaReq.setStartTime(req.getStartTime());
        return customerAreaReq;
    }

    private CrmLeadsStatisticsResp customerStatisticsRespToCrmResp(CcCustomerStatisticsResp resp) {
        if (Objects.isNull(resp)) {
            return null;
        }
        CrmLeadsStatisticsResp crmLeadsStatisticsResp = new CrmLeadsStatisticsResp();
        crmLeadsStatisticsResp.setAddWechatCount(resp.getAddWechatCount());
        crmLeadsStatisticsResp.setBizId(resp.getBizId());
        crmLeadsStatisticsResp.setCustomerCount(resp.getCustomerCount());
        crmLeadsStatisticsResp.setAreaCode(resp.getAreaCode());
        crmLeadsStatisticsResp.setAreaName(resp.getAreaName());
        crmLeadsStatisticsResp.setAddWechatRate(resp.getAddWechatRate());
        crmLeadsStatisticsResp.setTotalRate(resp.getTotalRate());
        return crmLeadsStatisticsResp;
    }
}

