/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.service.runner;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.persistence.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldHolder {
    private static final Logger log = LoggerFactory.getLogger(FieldHolder.class);
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINESE);
    private final Field field;
    private final Class<?> clazz;
    private final String columnName;

    public FieldHolder(Field field) {
        field.setAccessible(true);
        this.field = field;
        this.clazz = field.getType();
        Column column = field.getAnnotation(Column.class);
        this.columnName = column != null ? column.name() : field.getName();
        log.debug("filed:{}, clazz:{}", (Object)this.columnName, this.clazz);
    }

    public String columnName() {
        return this.columnName;
    }

    public String safeGetString(Object object) {
        try {
            Object value = this.field.get(object);
            if (value == null) {
                return null;
            }
            if (this.clazz == String.class) {
                return String.valueOf(value);
            }
            if (this.clazz == Integer.class) {
                return String.format("%d", (Integer)value);
            }
            if (this.clazz == Long.class) {
                return String.format("%d", (Long)value);
            }
            if (this.clazz == Float.class) {
                return String.format("%f", (Float)value);
            }
            if (this.clazz == Double.class) {
                return String.format("%f", (Double)value);
            }
            if (this.clazz == Date.class) {
                this.setDate(object, value);
                return this.formatter.format((Date)value);
            }
            log.warn("Unsupported data type, column:{}, fieldType:{}, value:{}, valueType:{}", new Object[]{this.columnName, this.field.getType(), value, value.getClass()});
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void safeSetFieldValue(Object object, Object value) {
        try {
            if (this.clazz == String.class) {
                this.setString(object, value);
            } else if (this.clazz == Integer.class) {
                this.setInt(object, value);
            } else if (this.clazz == Long.class) {
                this.setLong(object, value);
            } else if (this.clazz == Float.class) {
                this.setFloat(object, value);
            } else if (this.clazz == Double.class) {
                this.setDouble(object, value);
            } else if (this.clazz == Date.class) {
                this.setDate(object, value);
            } else {
                log.warn("Unsupported data type, column:{}, fieldType:{}, value:{}, valueType:{}", new Object[]{this.columnName, this.field.getType(), value, value.getClass()});
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void setString(Object object, Object value) throws IllegalAccessException {
        if (value instanceof String) {
            this.field.set(object, value);
        } else {
            this.field.set(object, String.valueOf(value));
        }
    }

    private void setInt(Object object, Object value) throws IllegalAccessException {
        if (value instanceof Number) {
            Number num = (Number)value;
            this.field.set(object, num.intValue());
        } else {
            try {
                Integer iVal = Integer.parseInt(String.valueOf(value));
                this.field.set(object, iVal);
            }
            catch (Exception e) {
                this.field.set(object, 0);
                log.warn("expect Integer value for {}, but accept {} -> {}", new Object[]{this.columnName, value.getClass(), value});
            }
        }
    }

    private void setLong(Object object, Object value) throws IllegalAccessException {
        if (value instanceof Number) {
            Number num = (Number)value;
            this.field.set(object, num.longValue());
        } else {
            try {
                Long lVal = Long.parseLong(String.valueOf(value));
                this.field.set(object, lVal);
            }
            catch (Exception e) {
                this.field.set(object, 0L);
                log.warn("expect Long value for {}, but accept {} -> {}", new Object[]{this.columnName, value.getClass(), value});
            }
        }
    }

    private void setFloat(Object object, Object value) throws IllegalAccessException {
        if (value instanceof Number) {
            Number num = (Number)value;
            this.field.set(object, Float.valueOf(num.floatValue()));
        } else {
            try {
                Float fVal = Float.valueOf(Float.parseFloat(String.valueOf(value)));
                this.field.set(object, fVal);
            }
            catch (Exception e) {
                this.field.set(object, Float.valueOf(0.0f));
                log.warn("expect Float value for {}, but accept {} -> {}", new Object[]{this.columnName, value.getClass(), value});
            }
        }
    }

    private void setDouble(Object object, Object value) throws IllegalAccessException {
        if (value instanceof Number) {
            Number num = (Number)value;
            this.field.set(object, num.doubleValue());
        } else {
            try {
                Double dVal = Double.parseDouble(String.valueOf(value));
                this.field.set(object, dVal);
            }
            catch (Exception e) {
                this.field.set(object, 0.0);
                log.warn("expect Double value for {}, but accept {} -> {}", new Object[]{this.columnName, value.getClass(), value});
            }
        }
    }

    private void setDate(Object object, Object value) throws IllegalAccessException {
        if (value instanceof Date) {
            this.field.set(object, value);
        } else {
            try {
                Date dVal = this.formatter.parse(String.valueOf(value));
                this.field.set(object, dVal);
            }
            catch (ParseException e) {
                log.warn("expect Date value for {}, but accept {} -> {}", new Object[]{this.columnName, value.getClass(), value});
            }
        }
    }
}

