/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.dto.StrIdDto;
import com.kuaike.scrm.common.enums.SopTemplateTaskTypeEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.Md5Util;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.marketing.dto.SopTemplateQuery;
import com.kuaike.scrm.dal.marketing.entity.SopTemplate;
import com.kuaike.scrm.dal.marketing.entity.SopTemplateTimes;
import com.kuaike.scrm.dal.marketing.entity.SopTemplateTimesTask;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateTimesMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateTimesTaskMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.sop.dto.req.BatchAddFriendDto;
import com.kuaike.scrm.sop.dto.req.GroupSendDto;
import com.kuaike.scrm.sop.dto.req.ManualCallDto;
import com.kuaike.scrm.sop.dto.req.SmsDto;
import com.kuaike.scrm.sop.dto.req.SopTemplateAddReqDto;
import com.kuaike.scrm.sop.dto.req.SopTemplateEnableOrDisableReqDto;
import com.kuaike.scrm.sop.dto.req.SopTemplateListReqDto;
import com.kuaike.scrm.sop.dto.req.SopTemplateModReqDto;
import com.kuaike.scrm.sop.dto.req.TemplateTimesDto;
import com.kuaike.scrm.sop.dto.req.TemplateTimesTaskDto;
import com.kuaike.scrm.sop.dto.resp.SopTemplateDetailRespDto;
import com.kuaike.scrm.sop.dto.resp.SopTemplateRespDto;
import com.kuaike.scrm.sop.service.SopTaskExecuteService;
import com.kuaike.scrm.sop.service.SopTemplateService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SopTemplateServiceImpl
implements SopTemplateService {
    private static final Logger log = LoggerFactory.getLogger(SopTemplateServiceImpl.class);
    @Resource
    private SopTemplateMapper sopTemplateMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private SopTemplateTimesMapper sopTemplateTimesMapper;
    @Resource
    private SopTemplateTimesTaskMapper timesTaskMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private UserRoleCommonService userRoleCommonService;
    @Resource
    private IdGen idGen;
    @Resource
    private SopTaskExecuteService sopTaskExecuteService;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService marketingSopTemplateService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(10), (ThreadFactory)new NamedThreadFactory("marketingSopTemplateService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public List<SopTemplateRespDto> list(SopTemplateListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("sop template list params:{},operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        SopTemplateQuery query = reqDto.convert2Query(userInfo.getBizId(), manageUserIds);
        List sopTemplates = this.sopTemplateMapper.selectListByQuery(query);
        if (CollectionUtils.isEmpty((Collection)sopTemplates)) {
            log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6query:{}\u672a\u67e5\u8be2\u5230\u6a21\u677f", (Object)query);
            return Collections.emptyList();
        }
        if (Objects.nonNull(reqDto.getPageDto())) {
            int count = this.sopTemplateMapper.selectCountByQuery(query);
            reqDto.getPageDto().setCount(Integer.valueOf(count));
        }
        Set updatorIds = sopTemplates.stream().map(SopTemplate::getUpdateBy).collect(Collectors.toSet());
        Map userId2NameMap = this.userMapper.queryUserNameByIds(updatorIds);
        ArrayList respDtos = Lists.newArrayList();
        for (SopTemplate sopTemplate : sopTemplates) {
            SopTemplateRespDto respDto = new SopTemplateRespDto();
            respDtos.add(respDto);
            respDto.setId(sopTemplate.getNum());
            respDto.setTemplateName(sopTemplate.getTemplateName());
            respDto.setIsEnabled(sopTemplate.getIsEnabled());
            respDto.setUpdateTime(sopTemplate.getUpdateTime());
            if (!MapUtils.isNotEmpty((Map)userId2NameMap)) continue;
            respDto.setUpdatorName((String)userId2NameMap.get(sopTemplate.getUpdateBy()));
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SopTemplateAddReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("sop template add params:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        StrIdAndNameDto strIdAndNameDto = new StrIdAndNameDto();
        strIdAndNameDto.setName(reqDto.getTemplateName());
        boolean isTemplateNameIsExist = this.checkTemplateNameIsExist(strIdAndNameDto);
        if (isTemplateNameIsExist) {
            log.info("sop template name:{} is already exist", (Object)reqDto.getTemplateName());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "sop\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Date curTime = new Date();
        SopTemplate sopTemplate = this.buildSopTemplate(reqDto, userInfo.getBizId(), userInfo.getId(), curTime);
        this.sopTemplateMapper.insertSelective((Object)sopTemplate);
        this.addSaveTemplateTimesAndTask(reqDto.getTemplateTimes(), sopTemplate.getId(), userInfo);
    }

    @Override
    public SopTemplateDetailRespDto detail(StrIdDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("sop template detail params:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        if (StringUtils.isBlank((CharSequence)reqDto.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SopTemplate sopTemplate = this.sopTemplateMapper.selectByNum(reqDto.getId());
        if (Objects.isNull(sopTemplate)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        List templateTimes = this.sopTemplateTimesMapper.selectByTemplateId(userInfo.getBizId(), sopTemplate.getId());
        List timesTasks = this.timesTaskMapper.selectByTemplateId(userInfo.getBizId(), sopTemplate.getId());
        Map<Object, Object> timesId2TimesTasksMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)timesTasks)) {
            timesId2TimesTasksMap = timesTasks.stream().collect(Collectors.groupingBy(SopTemplateTimesTask::getTemplateTimesId));
        }
        SopTemplateDetailRespDto respDto = new SopTemplateDetailRespDto();
        respDto.setId(sopTemplate.getNum());
        respDto.setTemplateName(sopTemplate.getTemplateName());
        if (CollectionUtils.isEmpty((Collection)templateTimes)) {
            return respDto;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", Locale.SIMPLIFIED_CHINESE);
        ArrayList templateTimesDtoList = Lists.newArrayList();
        respDto.setTemplateTimes(templateTimesDtoList);
        for (SopTemplateTimes sopTemplateTimes : templateTimes) {
            TemplateTimesDto templateTimesDto = new TemplateTimesDto();
            templateTimesDtoList.add(templateTimesDto);
            templateTimesDto.setId(sopTemplateTimes.getNum());
            templateTimesDto.setTimesName(sopTemplateTimes.getName());
            templateTimesDto.setSort(sopTemplateTimes.getSort());
            List sopTemplateTimesTasks = (List)timesId2TimesTasksMap.get(sopTemplateTimes.getId());
            if (CollectionUtils.isEmpty((Collection)sopTemplateTimesTasks)) continue;
            ArrayList templateTimesTasks = Lists.newArrayList();
            templateTimesDto.setTemplateTimesTasks(templateTimesTasks);
            block15: for (SopTemplateTimesTask timesTask : sopTemplateTimesTasks) {
                String jsonContent;
                TemplateTimesTaskDto timesTaskDto = new TemplateTimesTaskDto();
                templateTimesTasks.add(timesTaskDto);
                timesTaskDto.setId(timesTask.getNum());
                timesTaskDto.setTaskType(timesTask.getTaskType());
                timesTaskDto.setTaskTime(dateFormat.format(timesTask.getTaskTime()));
                if (Objects.nonNull(timesTask.getRemindTime())) {
                    timesTaskDto.setRemindTime(dateFormat.format(timesTask.getRemindTime()));
                }
                if (Objects.nonNull(timesTask.getExpectCompleteTime())) {
                    timesTaskDto.setExpectCompleteTime(dateFormat.format(timesTask.getExpectCompleteTime()));
                }
                if (StringUtils.isBlank((CharSequence)(jsonContent = timesTask.getContent()))) continue;
                SopTemplateTaskTypeEnum templateTaskTypeEnum = SopTemplateTaskTypeEnum.get((int)timesTask.getTaskType());
                switch (templateTaskTypeEnum) {
                    case WEWORK_GROUP_SEND: {
                        try {
                            GroupSendDto groupSendDto = (GroupSendDto)JacksonUtil.str2Obj((String)jsonContent, GroupSendDto.class);
                            timesTaskDto.setGroupSendDto(groupSendDto);
                        }
                        catch (IOException ex) {
                            log.error("\u89e3\u6790\u4f01\u5fae\u7fa4\u53d1\u5185\u5bb9\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
                        }
                        break;
                    }
                    case MANUAL_CALL: {
                        try {
                            ManualCallDto manualCallDto = (ManualCallDto)JacksonUtil.str2Obj((String)jsonContent, ManualCallDto.class);
                            timesTaskDto.setManualCallDto(manualCallDto);
                        }
                        catch (IOException ex) {
                            log.error("\u89e3\u6790\u4eba\u5de5\u5916\u547c\u5185\u5bb9\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
                        }
                        break;
                    }
                    case SMS: {
                        try {
                            SmsDto smsDto = (SmsDto)JacksonUtil.str2Obj((String)jsonContent, SmsDto.class);
                            timesTaskDto.setSmsDto(smsDto);
                        }
                        catch (IOException ex) {
                            log.error("\u89e3\u6790\u77ed\u4fe1\u5185\u5bb9\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
                        }
                        break;
                    }
                    case BATCH_ADD_FRIEND: {
                        try {
                            BatchAddFriendDto batchAddFriendDto = (BatchAddFriendDto)JacksonUtil.str2Obj((String)jsonContent, BatchAddFriendDto.class);
                            timesTaskDto.setBatchAddFriendDto(batchAddFriendDto);
                            if (!CollectionUtils.isNotEmpty(batchAddFriendDto.getTagIds())) continue block15;
                            Map tagId2NameMap = this.weworkTagMapper.selectTagIdAndNameTagIds(userInfo.getCorpId(), batchAddFriendDto.getTagIds());
                            ArrayList tagList = Lists.newArrayList();
                            for (Map.Entry entry : tagId2NameMap.entrySet()) {
                                WeworkTagDto weworkTagDto = new WeworkTagDto();
                                tagList.add(weworkTagDto);
                                weworkTagDto.setId((String)entry.getKey());
                                weworkTagDto.setName((String)entry.getValue());
                            }
                            batchAddFriendDto.setTagList(tagList);
                        }
                        catch (IOException ex) {
                            log.error("\u89e3\u6790\u6279\u91cf\u52a0\u597d\u53cb\u5185\u5bb9\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
                        }
                        break;
                    }
                }
            }
        }
        return respDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(SopTemplateModReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("mod sop template params:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.checkParams();
        SopTemplate sopTemplate = this.sopTemplateMapper.selectByNum(reqDto.getId());
        if (Objects.isNull(sopTemplate)) {
            log.info("\u6839\u636e\u6a21\u677fnum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6a21\u677fid\u4e0d\u5408\u6cd5");
        }
        Date curTime = new Date();
        if (!reqDto.getTemplateName().equals(sopTemplate.getTemplateName())) {
            log.info("\u6a21\u677fnum:{}\u7f16\u8f91\u524d\u7684\u6a21\u677f\u540d\u79f0:{},\u7f16\u8f91\u540e\u7684\u6a21\u677f\u540d\u79f0:{}", new Object[]{reqDto.getId(), reqDto.getTemplateName(), sopTemplate.getTemplateName()});
            StrIdAndNameDto strIdAndNameDto = new StrIdAndNameDto();
            strIdAndNameDto.setId(reqDto.getId());
            strIdAndNameDto.setName(reqDto.getTemplateName());
            boolean isTemplateNameExist = this.checkTemplateNameIsExist(strIdAndNameDto);
            if (isTemplateNameExist) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6a21\u677f\u540d\u79f0\u91cd\u590d");
            }
            sopTemplate.setTemplateName(reqDto.getTemplateName());
            sopTemplate.setUpdateBy(userInfo.getId());
            sopTemplate.setUpdateTime(curTime);
            this.sopTemplateMapper.updateByPrimaryKey((Object)sopTemplate);
        }
        List sopTemplateTimesList = this.sopTemplateTimesMapper.selectByTemplateId(userInfo.getBizId(), sopTemplate.getId());
        Map templateTimesNum2IdMap = sopTemplateTimesList.stream().collect(Collectors.toMap(SopTemplateTimes::getNum, Functions.identity()));
        List sopTemplateTimesTasks = this.timesTaskMapper.selectByTemplateId(userInfo.getBizId(), sopTemplate.getId());
        Map<Object, Object> taskNum2TaskMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)sopTemplateTimesTasks)) {
            taskNum2TaskMap = sopTemplateTimesTasks.stream().collect(Collectors.toMap(SopTemplateTimesTask::getNum, Functions.identity()));
        }
        ArrayList needAddTemplateTimesList = Lists.newArrayList();
        ArrayList needAddTimesTaskList = Lists.newArrayList();
        ArrayList needDelTemplateNums = Lists.newArrayList();
        ArrayList needDelTemplateTimesTaskNums = Lists.newArrayList();
        ArrayList needUpdateTimesList = Lists.newArrayList();
        ArrayList needUpdateTimesTaskList = Lists.newArrayList();
        ArrayList templateTimesNums = Lists.newArrayList();
        ArrayList timesTaskNums = Lists.newArrayList();
        for (TemplateTimesDto templateTimesDto : reqDto.getTemplateTimes()) {
            String templateTimesNum = templateTimesDto.getId();
            if (StringUtils.isBlank((CharSequence)templateTimesNum)) {
                needAddTemplateTimesList.add(templateTimesDto);
                continue;
            }
            SopTemplateTimes beforeModSopTemplateTimes = (SopTemplateTimes)templateTimesNum2IdMap.get(templateTimesNum);
            if (Objects.isNull(beforeModSopTemplateTimes)) {
                log.warn("\u6a21\u677f\u6b21\u6570num:{}\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object)templateTimesNum);
                continue;
            }
            templateTimesNums.add(templateTimesNum);
            this.checkTemplateTimesPropertyIsChanged(needUpdateTimesList, templateTimesDto, beforeModSopTemplateTimes, userInfo.getId(), curTime);
            List<TemplateTimesTaskDto> timesTaskDtos = templateTimesDto.getTemplateTimesTasks();
            if (CollectionUtils.isEmpty(timesTaskDtos)) {
                log.warn("\u6a21\u677f\u6b21\u6570num:{}\u6ca1\u6709\u5bf9\u5e94\u7684\u4efb\u52a1", (Object)templateTimesNum);
                continue;
            }
            for (TemplateTimesTaskDto templateTimesTaskDto : timesTaskDtos) {
                SopTemplateTimesTask sopTemplateTimesTask;
                String timesTaskNum = templateTimesTaskDto.getId();
                if (StringUtils.isBlank((CharSequence)timesTaskNum)) {
                    sopTemplateTimesTask = this.buildSopTemplateTimesTask(templateTimesTaskDto, userInfo.getBizId(), userInfo.getId(), sopTemplate.getId(), beforeModSopTemplateTimes.getId(), curTime);
                    needAddTimesTaskList.add(sopTemplateTimesTask);
                    continue;
                }
                sopTemplateTimesTask = (SopTemplateTimesTask)taskNum2TaskMap.get(timesTaskNum);
                if (Objects.isNull(sopTemplateTimesTask)) {
                    log.warn("\u6a21\u677f\u4efb\u52a1num:{}\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object)timesTaskNum);
                    continue;
                }
                timesTaskNums.add(timesTaskNum);
                this.checkTimesTaskPropertyIsChanged(needUpdateTimesTaskList, templateTimesTaskDto, sopTemplateTimesTask, userInfo.getId(), curTime);
            }
        }
        for (String string : templateTimesNum2IdMap.keySet()) {
            if (templateTimesNums.contains(string)) continue;
            needDelTemplateNums.add(string);
        }
        for (String string : taskNum2TaskMap.keySet()) {
            if (timesTaskNums.contains(string)) continue;
            needDelTemplateTimesTaskNums.add(string);
        }
        if (CollectionUtils.isNotEmpty((Collection)needAddTemplateTimesList)) {
            this.addSaveTemplateTimesAndTask(needAddTemplateTimesList, sopTemplate.getId(), userInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)needAddTimesTaskList)) {
            this.timesTaskMapper.batchInsert((List)needAddTimesTaskList);
        }
        if (CollectionUtils.isNotEmpty((Collection)needDelTemplateNums)) {
            this.sopTemplateTimesMapper.logicDelByNums(userInfo.getId(), curTime, (Collection)needDelTemplateNums);
        }
        if (CollectionUtils.isNotEmpty((Collection)needDelTemplateTimesTaskNums)) {
            this.timesTaskMapper.logicDelByNums(userInfo.getId(), curTime, (Collection)needDelTemplateTimesTaskNums);
        }
        if (CollectionUtils.isNotEmpty((Collection)needUpdateTimesList)) {
            this.sopTemplateTimesMapper.batchUpdate((Collection)needUpdateTimesList);
        }
        if (CollectionUtils.isNotEmpty((Collection)needUpdateTimesTaskList)) {
            this.timesTaskMapper.batchUpdate((Collection)needUpdateTimesTaskList);
        }
        this.marketingSopTemplateService.submit(() -> {
            try {
                this.sopTaskExecuteService.doBusinessWhenSopTemplateEdit(sopTemplate.getId());
            }
            catch (Exception e) {
                log.error("mod sop template,doBusinessWhenSopTemplateEdit error", (Throwable)e);
            }
        });
    }

    @Override
    public void enableOrDisable(SopTemplateEnableOrDisableReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("sop template enableOrDisable params:{},operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        SopTemplate sopTemplate = this.sopTemplateMapper.selectByNum(reqDto.getId());
        if (sopTemplate == null) {
            log.info("\u6839\u636enum:{}\u672a\u67e5\u8be2\u5230sop\u6a21\u677f", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (sopTemplate.getIsEnabled().equals(reqDto.getIsEnabled())) {
            log.info("sop\u6a21\u677fnum:{}\u7684\u542f\u7528\u7981\u7528\u72b6\u6001\u5df2\u4e3a:{}", (Object)reqDto.getId(), (Object)reqDto.getIsEnabled());
            return;
        }
        sopTemplate.setIsEnabled(reqDto.getIsEnabled());
        sopTemplate.setUpdateBy(userInfo.getId());
        sopTemplate.setUpdateTime(new Date());
        this.sopTemplateMapper.updateByPrimaryKey((Object)sopTemplate);
    }

    @Override
    public boolean checkTemplateNameIsExist(StrIdAndNameDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (StringUtils.isBlank((CharSequence)reqDto.getName())) {
            log.info("checkTemplateNameIsExist \u6a21\u677f\u540d\u79f0\u4e3a\u7a7a");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a");
        }
        return this.sopTemplateMapper.checkTemplateNameIsExist(userInfo.getBizId(), reqDto.getId(), reqDto.getName());
    }

    private SopTemplate buildSopTemplate(SopTemplateAddReqDto reqDto, Long bizId, Long userId, Date curTime) {
        SopTemplate sopTemplate = new SopTemplate();
        sopTemplate.setNum(this.idGen.getNum());
        sopTemplate.setBizId(bizId);
        sopTemplate.setTemplateName(reqDto.getTemplateName());
        sopTemplate.setIsEnabled(NumberUtils.INTEGER_ONE);
        sopTemplate.setCreateBy(userId);
        sopTemplate.setCreateTime(curTime);
        sopTemplate.setUpdateBy(userId);
        sopTemplate.setUpdateTime(curTime);
        sopTemplate.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return sopTemplate;
    }

    private SopTemplateTimes buildSopTemplateTimes(TemplateTimesDto templateTimesDto, Long bizId, Long userId, Long sopTemplateId, Date curTime) {
        SopTemplateTimes sopTemplateTimes = new SopTemplateTimes();
        sopTemplateTimes.setNum(this.idGen.getNum());
        sopTemplateTimes.setBizId(bizId);
        sopTemplateTimes.setTemplateId(sopTemplateId);
        sopTemplateTimes.setName(templateTimesDto.getTimesName());
        sopTemplateTimes.setSort(templateTimesDto.getSort());
        sopTemplateTimes.setCreateBy(userId);
        sopTemplateTimes.setCreateTime(curTime);
        sopTemplateTimes.setUpdateBy(userId);
        sopTemplateTimes.setUpdateTime(curTime);
        sopTemplateTimes.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return sopTemplateTimes;
    }

    private SopTemplateTimesTask buildSopTemplateTimesTask(TemplateTimesTaskDto templateTimesTaskDto, Long bizId, Long userId, Long sopTemplateId, Long sopTemplateTimesId, Date curTime) {
        SopTemplateTimesTask sopTemplateTimesTask = new SopTemplateTimesTask();
        sopTemplateTimesTask.setNum(this.idGen.getNum());
        sopTemplateTimesTask.setBizId(bizId);
        sopTemplateTimesTask.setTemplateId(sopTemplateId);
        sopTemplateTimesTask.setTemplateTimesId(sopTemplateTimesId);
        sopTemplateTimesTask.setTaskType(templateTimesTaskDto.getTaskType());
        sopTemplateTimesTask.setContent(templateTimesTaskDto.getJsonContent());
        sopTemplateTimesTask.setTaskTime(DateUtil.getDate((String)templateTimesTaskDto.getTaskTime(), (String)"HH:mm:ss"));
        if (StringUtils.isNotBlank((CharSequence)templateTimesTaskDto.getRemindTime())) {
            sopTemplateTimesTask.setRemindTime(DateUtil.getDate((String)templateTimesTaskDto.getRemindTime(), (String)"HH:mm:ss"));
        }
        if (StringUtils.isNotBlank((CharSequence)templateTimesTaskDto.getExpectCompleteTime())) {
            sopTemplateTimesTask.setExpectCompleteTime(DateUtil.getDate((String)templateTimesTaskDto.getExpectCompleteTime(), (String)"HH:mm:ss"));
        }
        sopTemplateTimesTask.setCreateBy(userId);
        sopTemplateTimesTask.setCreateTime(curTime);
        sopTemplateTimesTask.setUpdateBy(userId);
        sopTemplateTimesTask.setUpdateTime(curTime);
        sopTemplateTimesTask.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return sopTemplateTimesTask;
    }

    private void addSaveTemplateTimesAndTask(List<TemplateTimesDto> templateTimesDtos, Long templateId, CurrentUserInfo userInfo) {
        Date curTime = new Date();
        ArrayList sopTemplateTimesTasks = Lists.newArrayList();
        for (TemplateTimesDto templateTimesDto : templateTimesDtos) {
            SopTemplateTimes sopTemplateTimes = this.buildSopTemplateTimes(templateTimesDto, userInfo.getBizId(), userInfo.getId(), templateId, curTime);
            this.sopTemplateTimesMapper.insertSelective((Object)sopTemplateTimes);
            List<TemplateTimesTaskDto> templateTimesTaskDtos = templateTimesDto.getTemplateTimesTasks();
            if (CollectionUtils.isEmpty(templateTimesTaskDtos)) continue;
            for (TemplateTimesTaskDto templateTimesTaskDto : templateTimesDto.getTemplateTimesTasks()) {
                SopTemplateTimesTask sopTemplateTimesTask = this.buildSopTemplateTimesTask(templateTimesTaskDto, userInfo.getBizId(), userInfo.getId(), templateId, sopTemplateTimes.getId(), curTime);
                sopTemplateTimesTasks.add(sopTemplateTimesTask);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)sopTemplateTimesTasks)) {
            Lists.partition((List)sopTemplateTimesTasks, (int)50).forEach(partitionTimesTasks -> this.timesTaskMapper.batchInsert(partitionTimesTasks));
        }
    }

    private void checkTemplateTimesPropertyIsChanged(List<SopTemplateTimes> needUpdateTimesList, TemplateTimesDto templateTimesDto, SopTemplateTimes beforeModSopTemplateTimes, Long userId, Date curTime) {
        if (Objects.isNull(templateTimesDto) || Objects.isNull(beforeModSopTemplateTimes)) {
            log.warn("templateTimesDto,beforeModSopTemplateTimes\u5bf9\u8c61\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (!templateTimesDto.getTimesName().equals(beforeModSopTemplateTimes.getName()) || !templateTimesDto.getSort().equals(beforeModSopTemplateTimes.getSort())) {
            beforeModSopTemplateTimes.setName(templateTimesDto.getTimesName());
            beforeModSopTemplateTimes.setSort(templateTimesDto.getSort());
            beforeModSopTemplateTimes.setUpdateBy(userId);
            beforeModSopTemplateTimes.setUpdateTime(curTime);
            needUpdateTimesList.add(beforeModSopTemplateTimes);
        }
    }

    private void checkTimesTaskPropertyIsChanged(List<SopTemplateTimesTask> needUpdateTimesTaskList, TemplateTimesTaskDto templateTimesTaskDto, SopTemplateTimesTask sopTemplateTimesTask, Long userId, Date curTime) {
        String oldTaskTime;
        String newTaskTime;
        String oldJsonContent;
        String newJsonContent;
        if (Objects.isNull(templateTimesTaskDto) || Objects.isNull(sopTemplateTimesTask)) {
            log.warn("templateTimesTaskDto,sopTemplateTimesTask\u5bf9\u8c61\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        boolean isNeedUpdate = false;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.SIMPLIFIED_CHINESE);
        if (!templateTimesTaskDto.getTaskType().equals(sopTemplateTimesTask.getTaskType())) {
            isNeedUpdate = true;
            sopTemplateTimesTask.setTaskType(templateTimesTaskDto.getTaskType());
        }
        if (!(newJsonContent = Md5Util.md5((String)templateTimesTaskDto.getJsonContent())).equals(oldJsonContent = Md5Util.md5((String)sopTemplateTimesTask.getContent()))) {
            isNeedUpdate = true;
            sopTemplateTimesTask.setContent(templateTimesTaskDto.getJsonContent());
        }
        if (!(newTaskTime = templateTimesTaskDto.getTaskTime()).equals(oldTaskTime = simpleDateFormat.format(sopTemplateTimesTask.getTaskTime()))) {
            isNeedUpdate = true;
            sopTemplateTimesTask.setTaskTime(DateUtil.getDate((String)templateTimesTaskDto.getTaskTime(), (String)"HH:mm:ss"));
        }
        String newRemindTime = templateTimesTaskDto.getRemindTime();
        String oldRemindTime = "";
        if (Objects.nonNull(sopTemplateTimesTask.getRemindTime())) {
            oldRemindTime = simpleDateFormat.format(sopTemplateTimesTask.getRemindTime());
        }
        if (!oldRemindTime.equals(newRemindTime)) {
            isNeedUpdate = true;
            sopTemplateTimesTask.setRemindTime(DateUtil.getDate((String)templateTimesTaskDto.getRemindTime(), (String)"HH:mm:ss"));
        }
        String newExpectCompleteTime = templateTimesTaskDto.getExpectCompleteTime();
        String oldExpectCompleteTime = "";
        if (Objects.nonNull(sopTemplateTimesTask.getExpectCompleteTime())) {
            oldExpectCompleteTime = simpleDateFormat.format(sopTemplateTimesTask.getExpectCompleteTime());
        }
        if (!oldExpectCompleteTime.equals(newExpectCompleteTime)) {
            isNeedUpdate = true;
            sopTemplateTimesTask.setExpectCompleteTime(DateUtil.getDate((String)templateTimesTaskDto.getExpectCompleteTime(), (String)"HH:mm:ss"));
        }
        if (isNeedUpdate) {
            sopTemplateTimesTask.setUpdateTime(curTime);
            sopTemplateTimesTask.setUpdateBy(userId);
            needUpdateTimesTaskList.add(sopTemplateTimesTask);
        }
    }
}

