/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.operators.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.OperatorResult;
import com.kuaike.scrm.common.dto.OperatorResultItemDto;
import com.kuaike.scrm.common.enums.ConditionOpEnum;
import com.kuaike.scrm.common.enums.IOperatorResultType;
import com.kuaike.scrm.common.enums.OperatorResultMemberType;
import com.kuaike.scrm.dal.marketing.entity.SopCondition;
import com.kuaike.scrm.dal.marketing.mapper.SopConditionMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopUserMapper;
import com.kuaike.scrm.sop.dto.OperatorCommonDto;
import com.kuaike.scrm.sop.dto.req.SopConditionParseDto;
import com.kuaike.scrm.sop.enums.ConditionTypeEnum;
import com.kuaike.scrm.sop.operators.convert.ConvertServiceImpl;
import com.kuaike.scrm.sop.operators.functions.IOperatorInvoke;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class OperatorInvokeService {
    private static final Logger log = LoggerFactory.getLogger(OperatorInvokeService.class);
    @Autowired
    private SopConditionMapper sopConditionMapper;
    @Autowired
    private SopUserMapper sopUserMapper;
    @Autowired
    private ConvertServiceImpl convertService;
    @Autowired
    private ApplicationContext applicationContext;
    private static Map<ConditionTypeEnum, IOperatorInvoke> invokeMap;

    @PostConstruct
    public void init() {
        Map map = this.applicationContext.getBeansOfType(IOperatorInvoke.class);
        invokeMap = Maps.newHashMap();
        for (IOperatorInvoke value : map.values()) {
            invokeMap.put(value.getConditionType(), value);
        }
    }

    public String conditionIdExecute(Long conditionId) {
        log.info("conditionIdExecute with conditionId={}", (Object)conditionId);
        if (Objects.isNull(conditionId)) {
            log.info("conditionId is null,exit", (Object)conditionId);
            return null;
        }
        SopCondition sopCondition = (SopCondition)this.sopConditionMapper.selectByPrimaryKey((Object)conditionId);
        if (Objects.isNull(sopCondition) || Objects.equals(sopCondition.getIsDeleted(), 1)) {
            log.info("sopCondition is not exist, conditionId={}", (Object)conditionId);
            return null;
        }
        Long bizId = sopCondition.getBizId();
        Long sopId = sopCondition.getSopId();
        List sopUsers = this.sopUserMapper.queryListBySopId(bizId, sopId);
        List<Long> userIds = sopUsers.stream().map(a -> a.getUserId()).collect(Collectors.toList());
        Map userId2UserNums = this.convertService.execConvert(bizId, userIds, (IOperatorResultType)OperatorResultMemberType.USER_ID, (IOperatorResultType)OperatorResultMemberType.WEWORK_USER_NUM);
        OperatorCommonDto commonDto = new OperatorCommonDto();
        commonDto.setBizId(bizId);
        commonDto.setUserIds(userIds);
        commonDto.setUserId2UserNums(userId2UserNums);
        IOperatorInvoke operatorInvoker = invokeMap.get((Object)ConditionTypeEnum.get(sopCondition.getConditionType()));
        if (Objects.isNull(operatorInvoker)) {
            log.error("\u8be5\u7b97\u5b50\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff0cconditionTime={}", (Object)sopCondition.getConditionType());
            throw new UnsupportedOperationException(sopCondition.getConditionType() + "\u8be5\u7b97\u5b50\u7c7b\u578b\u6682\u4e0d\u652f\u6301");
        }
        SopConditionParseDto conditionParseDto = null;
        try {
            conditionParseDto = (SopConditionParseDto)JacksonUtil.str2Obj((String)sopCondition.getConditionContent(), SopConditionParseDto.class);
        }
        catch (IOException e) {
            log.error("content parse error", (Throwable)e);
            return null;
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(conditionParseDto.getParam()), (Object)"param can not be null");
        return operatorInvoker.doInvoke(commonDto, JacksonUtil.obj2Str((Object)conditionParseDto.getParam()));
    }

    public OperatorResult execConditionOp(String requestId, OperatorResult left, OperatorResult right, Long conditionId) {
        log.info("execConditionOp with left requestId={}, left={}, right={}, conditionId={}", new Object[]{requestId, left, right, conditionId});
        Preconditions.checkArgument((boolean)Objects.nonNull(left), (Object)"left is null");
        Preconditions.checkArgument((boolean)Objects.nonNull(right), (Object)"right is null");
        Preconditions.checkArgument((boolean)Objects.nonNull(conditionId), (Object)"conditionId is null");
        left.validate();
        right.validate();
        Preconditions.checkArgument((boolean)Objects.equals(left.getCustomerType(), right.getCustomerType()), (Object)"customerType not match,please check");
        SopCondition sopCondition = (SopCondition)this.sopConditionMapper.selectByPrimaryKey((Object)conditionId);
        if (Objects.isNull(sopCondition) || Objects.equals(sopCondition.getIsDeleted(), 1)) {
            log.info("sopCondition is not exist, conditionId={}", (Object)conditionId);
            return null;
        }
        ConditionOpEnum op = ConditionOpEnum.getByOp((Integer)sopCondition.getConditionOp());
        if (Objects.isNull(op)) {
            log.error("op is not valid, conditionId={}", (Object)conditionId);
            return null;
        }
        OperatorResult result = new OperatorResult();
        result.setRequestId(requestId);
        result.setCustomerType(left.getCustomerType());
        result.setMemberType(this.getMemberType(left, right));
        result.setStatus(left.getStatus());
        result.setCreateTime(left.getCreateTime());
        result.setBizId(left.getBizId());
        HashMap customerId2MemberId = Maps.newHashMap();
        for (OperatorResultItemDto dto : left.getList()) {
            if (!StringUtils.isNotBlank((CharSequence)dto.getMemberId())) continue;
            customerId2MemberId.put(dto.getCustomerId(), dto.getMemberId());
        }
        for (OperatorResultItemDto dto : right.getList()) {
            if (!StringUtils.isNotBlank((CharSequence)dto.getMemberId()) || !Objects.isNull(customerId2MemberId.get(dto.getCustomerId()))) continue;
            customerId2MemberId.put(dto.getCustomerId(), dto.getMemberId());
        }
        List<Object> finalCustomerIds = Lists.newArrayList();
        List leftCustomerIds = left.getList().stream().map(a -> a.getCustomerId()).collect(Collectors.toList());
        List rightCustomerIds = right.getList().stream().map(a -> a.getCustomerId()).collect(Collectors.toList());
        switch (op) {
            case OR: {
                finalCustomerIds = CollectionUtils.union(leftCustomerIds, rightCustomerIds).stream().collect(Collectors.toList());
                break;
            }
            case AND: {
                finalCustomerIds = CollectionUtils.intersection(leftCustomerIds, rightCustomerIds).stream().collect(Collectors.toList());
                break;
            }
            case NOT: {
                finalCustomerIds = CollectionUtils.subtract(leftCustomerIds, rightCustomerIds).stream().collect(Collectors.toList());
                break;
            }
        }
        ArrayList finalResultItemDtos = Lists.newArrayListWithExpectedSize((int)finalCustomerIds.size());
        for (String finalCustomerId : finalCustomerIds) {
            OperatorResultItemDto dto = new OperatorResultItemDto();
            dto.setCustomerId(finalCustomerId);
            dto.setMemberId((String)customerId2MemberId.get(finalCustomerId));
            finalResultItemDtos.add(dto);
        }
        result.setList((List)finalResultItemDtos);
        result.setUpdateTime(new Date());
        return result;
    }

    private Integer getMemberType(OperatorResult left, OperatorResult right) {
        Integer memberType = OperatorResultMemberType.NOT_USE.getType();
        if (Objects.nonNull(left) && Objects.nonNull(left.getMemberType())) {
            memberType = left.getMemberType();
        }
        if (Objects.nonNull(right) && Objects.nonNull(right.getMemberType()) && Objects.equals(memberType, OperatorResultMemberType.NOT_USE.getType())) {
            memberType = right.getMemberType();
        }
        return memberType;
    }
}

