/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.operators.convert.customer;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.kuaike.scrm.common.enums.IOperatorResultType;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.sop.operators.convert.customer.AbstractCustomerNum2OtherConverter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerNum2MobileConverter
extends AbstractCustomerNum2OtherConverter {
    private static final Logger log = LoggerFactory.getLogger(CustomerNum2MobileConverter.class);
    @Autowired
    private CcCustomerNumService customerNumService;

    @Override
    public IOperatorResultType toResultType() {
        return OperatorResultCustomerType.MOBILE;
    }

    @Override
    public Map convert(Long bizId, Collection<?> ids) {
        List customerNums = ids.stream().map(String.class::cast).collect(Collectors.toList());
        return this.customerNumService.getMobileByCustomerNums(bizId, customerNums);
    }
}

