/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import cn.kinyun.customer.center.dto.req.IdAndNameDto;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.sop.SopContactType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.marketing.dto.sop.SopQuery;
import com.kuaike.scrm.dal.marketing.dto.sop.SopRemindCustomerQuery;
import com.kuaike.scrm.dal.marketing.dto.sop.SopStageCustomerDto;
import com.kuaike.scrm.dal.marketing.entity.Sop;
import com.kuaike.scrm.dal.marketing.entity.SopCondition;
import com.kuaike.scrm.dal.marketing.entity.SopContent;
import com.kuaike.scrm.dal.marketing.entity.SopRemind;
import com.kuaike.scrm.dal.marketing.entity.SopTemplate;
import com.kuaike.scrm.dal.marketing.entity.SopUser;
import com.kuaike.scrm.dal.marketing.mapper.SopConditionMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopContentMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopFinalCustomerMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopRemindMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopUserMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.sop.dto.SopAddOrModReq;
import com.kuaike.scrm.sop.dto.SopBaseReq;
import com.kuaike.scrm.sop.dto.SopConditionReq;
import com.kuaike.scrm.sop.dto.SopEnableReq;
import com.kuaike.scrm.sop.dto.SopListReq;
import com.kuaike.scrm.sop.dto.SopListResp;
import com.kuaike.scrm.sop.dto.SopStageDto;
import com.kuaike.scrm.sop.dto.SopStageReq;
import com.kuaike.scrm.sop.dto.req.SopRemindCustomerListReq;
import com.kuaike.scrm.sop.dto.resp.SopDetailResp;
import com.kuaike.scrm.sop.dto.resp.SopDetailUser;
import com.kuaike.scrm.sop.dto.resp.SopRemindCustomerListResp;
import com.kuaike.scrm.sop.service.SopService;
import com.kuaike.scrm.sop.service.SopTaskExecuteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SopServiceImpl
implements SopService {
    private static final Logger log = LoggerFactory.getLogger(SopServiceImpl.class);
    @Autowired
    private SopMapper sopMapper;
    @Autowired
    private SopContentMapper sopContentMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private SopConditionMapper sopConditionMapper;
    @Autowired
    private SopUserMapper sopUserMapper;
    @Autowired
    private SopFinalCustomerMapper sopFinalCustomerMapper;
    @Autowired
    private SopTemplateMapper sopTemplateMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private SettingService settingService;
    @Autowired
    private SopRemindMapper sopRemindMapper;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Resource
    private SopTaskExecuteService sopTaskExecuteService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService marketingSopService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(10), (ThreadFactory)new NamedThreadFactory("marketingSopService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public List<SopListResp> list(SopListReq params) {
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params.getPageDto() == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        SopQuery queryList = new SopQuery();
        queryList.setBizId(userInfo.getBizId());
        queryList.setName(params.getSopNameQuery());
        queryList.setManagerUserIds(userIds);
        queryList.setPageDto(params.getPageDto());
        log.info("sops: {}", (Object)queryList);
        List sops = this.sopMapper.list(queryList);
        if (params.getPageDto() != null) {
            int total = this.sopMapper.listCount(queryList);
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        if (CollectionUtils.isEmpty((Collection)sops)) {
            return Lists.newArrayList();
        }
        List sopIds = sops.stream().map(it -> it.getId()).collect(Collectors.toList());
        List sopStages = this.sopContentMapper.batchSopStageList(userInfo.getBizId(), sopIds);
        Map<Long, List<SopContent>> groupStage = this.groupSopStage(sopStages);
        return this.buildSopList(sops, groupStage);
    }

    private Map<Long, List<SopContent>> groupSopStage(List<SopContent> sopStages) {
        HashMap groupStage = Maps.newHashMap();
        for (SopContent sopStage : sopStages) {
            if (groupStage.containsKey(sopStage.getSopId())) {
                ((List)groupStage.get(sopStage.getSopId())).add(sopStage);
                continue;
            }
            groupStage.put(sopStage.getSopId(), Lists.newArrayList((Object[])new SopContent[]{sopStage}));
        }
        return groupStage;
    }

    private List<SopListResp> buildSopList(List<Sop> sops, Map<Long, List<SopContent>> groupStage) {
        ArrayList result = Lists.newArrayList();
        Set createByIds = sops.stream().map(it -> it.getCreateBy()).collect(Collectors.toSet());
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Map userMap = this.userMapper.selectUserIdAndNameByIds(userInfo.getBizId(), userInfo.getCorpId(), createByIds);
        Set sopIds = sops.stream().filter(it -> it.getSopType() == 1).map(it -> it.getId()).collect(Collectors.toSet());
        List sopStageCustomerList = this.sopFinalCustomerMapper.queryStageCustomerCount(userInfo.getBizId(), sopIds);
        HashMap sopStageGroupMap = Maps.newHashMap();
        for (SopStageCustomerDto customerDto : sopStageCustomerList) {
            if (sopStageGroupMap.containsKey(customerDto.getSopId())) {
                ((List)sopStageGroupMap.get(customerDto.getSopId())).add(customerDto);
                continue;
            }
            sopStageGroupMap.put(customerDto.getSopId(), Lists.newArrayList((Object[])new SopStageCustomerDto[]{customerDto}));
        }
        for (Sop sop : sops) {
            SopListResp resp = new SopListResp();
            resp.setSopNum(sop.getNum());
            resp.setSopName(sop.getSopName());
            resp.setSopType(sop.getSopType());
            resp.setIsEnable(sop.getIsEnable());
            resp.setCreateTime(sop.getCreateTime());
            resp.setUpdateTime(sop.getUpdateTime());
            resp.setCreateBy((String)userMap.get(sop.getCreateBy()));
            List<SopContent> sopStages = groupStage.get(sop.getId());
            List sopGroupList = (List)sopStageGroupMap.get(sop.getId());
            HashMap sopStageMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)sopGroupList)) {
                for (SopStageCustomerDto dto : sopGroupList) {
                    sopStageMap.put(dto.getSopContentId(), dto.getCustomerCount());
                }
            }
            if (CollectionUtils.isNotEmpty(sopStages)) {
                sopStages.sort((a, b) -> (int)(a.getStageSeq() - b.getStageSeq()));
                ArrayList stages = Lists.newArrayList();
                for (SopContent sopStage : sopStages) {
                    SopStageDto dto = new SopStageDto();
                    dto.setStageName(sopStage.getStageName());
                    dto.setCustomerCount((Integer)sopStageMap.get(sopStage.getId()));
                    stages.add(dto);
                }
                resp.setStages(stages);
            }
            result.add(resp);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSop(SopAddOrModReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("addSop get param: {}, bizId: {}", (Object)req, (Object)userInfo.getBizId());
        req.validateParam();
        Sop sop = this.buildSop(req, userInfo);
        Long sopId = sop.getId();
        log.info("addSop sopId: {}", (Object)sopId);
        List userNums = req.getUsers().stream().map(IdAndNameDto::getId).collect(Collectors.toList());
        ArrayList userIds = Lists.newArrayList();
        for (String userNum : userNums) {
            Long userId = this.userMapper.getIdByNum(userNum);
            userIds.add(userId);
        }
        log.info("addSop weworkUserIds: {}, userIds: {}", userNums, (Object)userIds);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            log.info("addSop get userIds is empty");
            return;
        }
        this.buildSopUser(sopId, userIds, userInfo);
        for (SopStageReq stageReq : req.getStages()) {
            this.buildSopContentAndCondition(sopId, stageReq, userInfo);
        }
        SopUser selectUser = new SopUser();
        selectUser.setSopId(sopId);
        List sopUsers = this.sopUserMapper.select((Object)selectUser);
        SopContent select = new SopContent();
        select.setSopId(sopId);
        select.setStageSeq(Long.valueOf(0L));
        select.setIsDeleted(Integer.valueOf(0));
        SopContent sopContent = (SopContent)this.sopContentMapper.selectOne((Object)select);
        this.marketingSopService.submit(() -> {
            try {
                this.sopTaskExecuteService.doBusinessWhenSopCreated(sop, sopUsers, sopContent);
            }
            catch (Exception e) {
                log.error("addSop,doBusinessWhenSopCreated error", (Throwable)e);
            }
        });
    }

    private Sop buildSop(SopAddOrModReq req, CurrentUserInfo userInfo) {
        Sop sop = new Sop();
        sop.setNum(this.idGen.getNum());
        sop.setBizId(userInfo.getBizId());
        sop.setSopName(req.getSopName());
        sop.setSopType(req.getSopType());
        sop.setIsEnable(Integer.valueOf(1));
        sop.setCreateBy(userInfo.getId());
        sop.setCreateTime(new Date());
        sop.setUpdateBy(userInfo.getId());
        sop.setUpdateTime(new Date());
        this.sopMapper.insertSelective((Object)sop);
        return sop;
    }

    private void buildSopUser(Long sopId, Collection<Long> addUserIds, CurrentUserInfo userInfo) {
        List users = this.userMapper.getUserInfoByIds(addUserIds);
        log.info("buildSopUser addUserIds: {}, userList size: {}", addUserIds, (Object)users.size());
        ArrayList userList = Lists.newArrayList();
        for (User dto : users) {
            SopUser sopUser = new SopUser();
            sopUser.setBizId(userInfo.getBizId());
            sopUser.setSopId(sopId);
            sopUser.setUserId(dto.getId());
            sopUser.setCreateBy(userInfo.getId());
            sopUser.setCreateTime(new Date());
            sopUser.setUpdateBy(userInfo.getId());
            sopUser.setUpdateTime(new Date());
            sopUser.setIsDeleted(Integer.valueOf(0));
            userList.add(sopUser);
        }
        this.sopUserMapper.batchInsert((List)userList);
    }

    private void buildSopContentAndCondition(Long sopId, SopStageReq stageReq, CurrentUserInfo userInfo) {
        SopContent content = new SopContent();
        content.setBizId(userInfo.getBizId());
        content.setSopId(sopId);
        content.setStageName(stageReq.getStageName());
        content.setStageSeq(stageReq.getStageSeq());
        if (StringUtils.isEmpty((CharSequence)stageReq.getSopTmpId())) {
            content.setRemindContent(stageReq.getRemindContent());
            content.setRemindTime(stageReq.getRemindDate());
        } else {
            Long tmpId = this.sopTemplateMapper.queryIdByNum(stageReq.getSopTmpId());
            content.setSopTmpId(tmpId);
            content.setFrequencyType(stageReq.getFrequencyType());
        }
        content.setRemindGap(stageReq.getRemindGap());
        content.setEndDate(stageReq.getEndDate());
        content.setCreateBy(userInfo.getId());
        content.setCreateTime(new Date());
        content.setUpdateBy(userInfo.getId());
        content.setUpdateTime(new Date());
        content.setIsDeleted(Integer.valueOf(0));
        this.sopContentMapper.insertSelective((Object)content);
        Long sopContentId = content.getId();
        log.info("buildSopContentAndCondition sopId: {}, sopContentId: {}", (Object)sopId, (Object)sopContentId);
        if (CollectionUtils.isEmpty(stageReq.getConditions())) {
            return;
        }
        ArrayList conditionList = Lists.newArrayList();
        for (SopConditionReq conditionReq : stageReq.getConditions()) {
            SopCondition condition = new SopCondition();
            condition.setBizId(userInfo.getBizId());
            condition.setSopId(sopId);
            condition.setSopContentId(sopContentId);
            condition.setConditionOp(conditionReq.getOpType());
            condition.setConditionType(conditionReq.getConditionType());
            condition.setConditionContent(conditionReq.getConditionContent());
            condition.setCreateBy(userInfo.getId());
            condition.setCreateTime(new Date());
            condition.setUpdateBy(userInfo.getId());
            condition.setUpdateTime(new Date());
            condition.setIsDeleted(Integer.valueOf(0));
            conditionList.add(condition);
        }
        this.sopConditionMapper.batchInsert((List)conditionList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modSop(SopAddOrModReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)req.getSopId()), (Object)"Id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("modSop get param: {}, bizId: {}", (Object)req, (Object)userInfo.getBizId());
        req.validateParam();
        Sop sop = this.sopMapper.queryByNum(req.getSopId());
        if (sop == null) {
            log.info("modSop query sop is null, num : {}", (Object)req.getSopId());
            return;
        }
        if (sop.getIsEnable() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "Sop\u542f\u7528\u72b6\u6001\u4e0b\u65e0\u6cd5\u7f16\u8f91");
        }
        sop.setSopName(req.getSopName());
        sop.setSopType(req.getSopType());
        sop.setUpdateBy(userInfo.getId());
        sop.setUpdateTime(new Date());
        this.sopMapper.updateByPrimaryKeySelective((Object)sop);
        List userList = this.sopUserMapper.queryListBySopId(userInfo.getBizId(), sop.getId());
        List userIds = userList.stream().map(SopUser::getUserId).collect(Collectors.toList());
        ArrayList newUserIds = Lists.newArrayList();
        for (IdAndNameDto dto : req.getUsers()) {
            Long userId = this.userMapper.getIdByNum(dto.getId());
            log.info("modSop get userId: {}, weworkUserId: {}, bizId: {}", new Object[]{userId, dto.getId(), userInfo.getBizId()});
            newUserIds.add(userId);
        }
        if (CollectionUtils.isEmpty((Collection)newUserIds)) {
            log.info("modSop get userIds is empty");
            return;
        }
        log.info("modSop exist userIds : {}, addUserIds: {}, sopId: {}", new Object[]{userIds, newUserIds, sop.getId()});
        Collection addUserIds = CollectionUtils.subtract((Iterable)newUserIds, userIds);
        Collection delUserIds = CollectionUtils.subtract(userIds, (Iterable)newUserIds);
        log.info("modSop addUserIds : {}, delUserIds: {}", (Object)addUserIds, (Object)delUserIds);
        if (CollectionUtils.isNotEmpty((Collection)delUserIds)) {
            this.sopUserMapper.delUserByIds(userInfo.getBizId(), sop.getId(), delUserIds, userInfo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)addUserIds)) {
            this.buildSopUser(sop.getId(), addUserIds, userInfo);
        }
        List contentList = this.sopContentMapper.sopStageList(userInfo.getBizId(), sop.getId());
        List contentIds = contentList.stream().map(SopContent::getId).collect(Collectors.toList());
        ArrayList editContentIds = Lists.newArrayList();
        for (SopStageReq stageReq : req.getStages()) {
            if (stageReq.getId() != null) {
                editContentIds.add(stageReq.getId());
                SopContent content = this.sopContentMapper.queryStageById(userInfo.getBizId(), stageReq.getId());
                if (content != null) {
                    content.setStageName(stageReq.getStageName());
                    content.setStageSeq(stageReq.getStageSeq());
                    if (StringUtils.isEmpty((CharSequence)stageReq.getSopTmpId())) {
                        content.setRemindContent(stageReq.getRemindContent());
                        content.setRemindTime(stageReq.getRemindDate());
                        content.setSopTmpId(Long.valueOf(0L));
                        content.setFrequencyType(Integer.valueOf(0));
                    } else {
                        Long tmpId = this.sopTemplateMapper.queryIdByNum(stageReq.getSopTmpId());
                        content.setSopTmpId(tmpId);
                        content.setFrequencyType(stageReq.getFrequencyType());
                        content.setRemindContent("");
                        content.setRemindTime("");
                    }
                    content.setRemindGap(stageReq.getRemindGap());
                    content.setEndDate(stageReq.getEndDate());
                    content.setUpdateBy(userInfo.getId());
                    content.setUpdateTime(new Date());
                    this.sopContentMapper.updateByPrimaryKey((Object)content);
                } else {
                    log.info("modSop get content is null, contentId: {}", (Object)stageReq.getId());
                }
                List conditionList = this.sopConditionMapper.queryConditionByContentId(userInfo.getBizId(), sop.getId(), stageReq.getId());
                if (CollectionUtils.isNotEmpty((Collection)conditionList)) {
                    List conditionIds = conditionList.stream().map(SopCondition::getId).collect(Collectors.toList());
                    log.info("modSop get conditionIds: {}, contentId: {}", conditionIds, (Object)stageReq.getId());
                    ArrayList editConditionIds = Lists.newArrayList();
                    if (CollectionUtils.isNotEmpty(stageReq.getConditions())) {
                        ArrayList addConditionList = Lists.newArrayList();
                        for (SopConditionReq conditionReq : stageReq.getConditions()) {
                            SopCondition condition;
                            if (conditionReq.getId() != null) {
                                editConditionIds.add(conditionReq.getId());
                                condition = this.sopConditionMapper.queryConditionById(userInfo.getBizId(), conditionReq.getId());
                                condition.setConditionOp(conditionReq.getOpType());
                                condition.setConditionType(conditionReq.getConditionType());
                                condition.setConditionContent(conditionReq.getConditionContent());
                                condition.setUpdateBy(userInfo.getId());
                                condition.setUpdateTime(new Date());
                                this.sopConditionMapper.updateByPrimaryKeySelective((Object)condition);
                                continue;
                            }
                            condition = new SopCondition();
                            condition.setBizId(userInfo.getBizId());
                            condition.setSopId(sop.getId());
                            condition.setSopContentId(stageReq.getId());
                            condition.setConditionOp(conditionReq.getOpType());
                            condition.setConditionType(conditionReq.getConditionType());
                            condition.setConditionContent(conditionReq.getConditionContent());
                            condition.setCreateBy(userInfo.getId());
                            condition.setCreateTime(new Date());
                            condition.setUpdateBy(userInfo.getId());
                            condition.setUpdateTime(new Date());
                            condition.setIsDeleted(Integer.valueOf(0));
                            addConditionList.add(condition);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)addConditionList)) {
                            this.sopConditionMapper.batchInsert((List)addConditionList);
                        }
                    }
                    Collection delConditionIds = CollectionUtils.subtract(conditionIds, (Iterable)editConditionIds);
                    log.info("modSop exist conditionIds : {}, editConditionIds: {}, delConditionIds: {},  sopContentId: {}", new Object[]{conditionIds, editConditionIds, delConditionIds, stageReq.getId()});
                    if (!CollectionUtils.isNotEmpty((Collection)delConditionIds)) continue;
                    this.sopConditionMapper.delConditionByIds(userInfo.getBizId(), delConditionIds, userInfo.getId());
                    continue;
                }
                log.info("modSop get conditionList is empty, contentId: {}", (Object)stageReq.getId());
                continue;
            }
            this.buildSopContentAndCondition(sop.getId(), stageReq, userInfo);
        }
        Collection delContentIds = CollectionUtils.subtract(contentIds, (Iterable)editContentIds);
        log.info("modSop exist contentIds : {}, editContentIds: {}, delContentIds: {},  sopId: {}", new Object[]{contentIds, editContentIds, delContentIds, sop.getId()});
        if (CollectionUtils.isNotEmpty((Collection)delContentIds)) {
            this.sopContentMapper.delStageById(userInfo.getBizId(), delContentIds, userInfo.getId());
            this.sopConditionMapper.delConditionByStageIds(userInfo.getBizId(), sop.getId(), delContentIds, userInfo.getId());
        }
    }

    @Override
    public void enableSop(SopEnableReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)req.getSopId()), (Object)"Id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("enableSop get param: {}, bizId: {}", (Object)req, (Object)userInfo.getBizId());
        Sop sop = this.sopMapper.queryByNum(req.getSopId());
        if (sop == null) {
            log.info("modSop query sop is null, num : {}", (Object)req.getSopId());
            return;
        }
        this.sopMapper.updateSopByEnable(userInfo.getBizId(), req.getSopId(), req.getIsEnable());
        this.marketingSopService.submit(() -> {
            if (req.getIsEnable() == 0) {
                try {
                    this.sopTaskExecuteService.clearWhenSopDisabled(sop.getId());
                }
                catch (Exception e) {
                    log.error("enableSop,clearWhenSopDisabled error", (Throwable)e);
                }
            } else if (req.getIsEnable() == 1) {
                try {
                    this.sopTaskExecuteService.startWhenSopEnabled(sop.getId());
                }
                catch (Exception e) {
                    log.error("enableSop,startWhenSopEnabled error", (Throwable)e);
                }
            }
        });
    }

    @Override
    public SopDetailResp sopDetail(SopBaseReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)req.getSopId()), (Object)"Id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("sopDetail get param: {}, bizId: {}", (Object)req, (Object)userInfo.getBizId());
        Sop sop = this.sopMapper.queryByNum(req.getSopId());
        if (sop == null) {
            log.info("sopDetail query sop is null, num : {}", (Object)req.getSopId());
            return null;
        }
        SopDetailResp resp = new SopDetailResp();
        resp.setSopId(sop.getNum());
        resp.setSopName(sop.getSopName());
        resp.setSopType(sop.getSopType());
        resp.setIsEnable(sop.getIsEnable());
        List userList = this.sopUserMapper.queryListBySopId(userInfo.getBizId(), sop.getId());
        List userIds = userList.stream().map(SopUser::getUserId).collect(Collectors.toList());
        List users = this.userMapper.getUserInfoByIds(userIds);
        ArrayList userResp = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            for (User user : users) {
                SopDetailUser dto = new SopDetailUser();
                userResp.add(dto);
                dto.setId(user.getNum());
                dto.setWeworkUserId(user.getWeworkUserId());
                dto.setName(user.getName());
            }
        }
        resp.setUsers(userResp);
        ArrayList stageList = Lists.newArrayList();
        resp.setStages(stageList);
        List contentList = this.sopContentMapper.sopStageList(userInfo.getBizId(), sop.getId());
        if (CollectionUtils.isNotEmpty((Collection)contentList)) {
            for (SopContent content : contentList) {
                SopStageReq stageResp = new SopStageReq();
                stageList.add(stageResp);
                stageResp.setId(content.getId());
                stageResp.setStageName(content.getStageName());
                stageResp.setStageSeq(content.getStageSeq());
                stageResp.setFrequencyType(content.getFrequencyType());
                stageResp.setEndDate(content.getEndDate());
                stageResp.setRemindGap(content.getRemindGap());
                stageResp.setRemindContent(content.getRemindContent());
                stageResp.setRemindDate(content.getRemindTime());
                if (content.getSopTmpId() != 0L) {
                    SopTemplate tmp = this.sopTemplateMapper.queryById(content.getSopTmpId());
                    stageResp.setSopTmpId(tmp.getNum());
                    stageResp.setSopTmpName(tmp.getTemplateName());
                }
                List conditionList = this.sopConditionMapper.queryConditionByContentId(userInfo.getBizId(), sop.getId(), content.getId());
                ArrayList conditionRespList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)conditionList)) {
                    for (SopCondition condition : conditionList) {
                        SopConditionReq conditionResp = new SopConditionReq();
                        conditionResp.setId(condition.getId());
                        conditionResp.setConditionType(condition.getConditionType());
                        conditionResp.setOpType(condition.getConditionOp());
                        conditionResp.setConditionContent(condition.getConditionContent());
                        conditionRespList.add(conditionResp);
                    }
                }
                stageResp.setConditions(conditionRespList);
            }
        }
        return resp;
    }

    @Override
    public List<SopRemindCustomerListResp> sidebarCustomerList(SopRemindCustomerListReq req) {
        Long bizId;
        BusinessCustomer biz;
        log.info("sidebarCustomerList: req:{}", (Object)req);
        req.validate();
        Long userId = req.getUserId();
        String mainNum = req.getMainNum();
        User user = this.userMapper.getUserInfoById(userId);
        if (user == null) {
            log.error("sidebarCustomerList: \u7528\u6237Id\u4e0d\u6b63\u786e: mainNum:{}, userId:{}", (Object)mainNum, (Object)userId);
            return Lists.newArrayList();
        }
        SopRemindCustomerQuery query = new SopRemindCustomerQuery();
        query.setMainNum(mainNum);
        query.setUserId(userId);
        query.setPageDto(req.getPageDto());
        List sopRemindList = this.sopRemindMapper.queryByMainNumAndUserId(query);
        if (CollectionUtils.isEmpty((Collection)sopRemindList)) {
            log.info("sidebarCustomerList: \u67e5\u8be2\u5217\u8868\u4e3a\u7a7a: mainNum:{}, userId:{}", (Object)mainNum, (Object)userId);
            return Lists.newArrayList();
        }
        if (req.getPageDto() != null) {
            int count = this.sopRemindMapper.countByMainNumAndUserId(mainNum, userId);
            req.getPageDto().setCount(Integer.valueOf(count));
            req.getPageDto().setCurPageCount(Integer.valueOf(sopRemindList.size()));
        }
        if ((biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)(bizId = ((SopRemind)sopRemindList.get(0)).getBizId()))) == null) {
            log.error("sidebarCustomerList: \u65e0\u6cd5\u67e5\u8be2\u5230\u5546\u6237, bizId:{}", (Object)bizId);
            return Lists.newArrayList();
        }
        String corpId = biz.getCorpId();
        if (StringUtils.isBlank((CharSequence)corpId)) {
            log.error("sidebarCustomerList: corpId\u4e3a\u7a7a, bizId:{}\uff0ccorpId:{}", (Object)bizId, (Object)corpId);
            return Lists.newArrayList();
        }
        Set customerIdSet = sopRemindList.stream().map(SopRemind::getCustomerId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        log.info("sidebarCustomerList: \u67e5\u8be2\u5ba2\u6237Id\u5217\u8868: bizId:{},mainNum:{}, userId:{}, customerIdSet:{}", new Object[]{bizId, mainNum, userId, customerIdSet});
        if (CollectionUtils.isEmpty(customerIdSet)) {
            log.info("sidebarCustomerList: \u5ba2\u6237Id\u5217\u8868\u4e3a\u7a7a: bizId:{},mainNum:{}, userId:{}", new Object[]{bizId, mainNum, userId});
            return Lists.newArrayList();
        }
        Set<Object> contactIds = Sets.newHashSet();
        Map customerNum2ContactIdMap = this.ccCustomerNumService.getWeworkContactId(bizId, customerIdSet);
        if (customerNum2ContactIdMap != null) {
            contactIds = customerNum2ContactIdMap.values().stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        }
        log.info("sidebarCustomerList: \u67e5\u8be2contactId\u5217\u8868: bizId:{},mainNum:{}, userId:{}, contactIds:{}", new Object[]{bizId, mainNum, userId, contactIds});
        Map<Object, Object> weworkContactRelationMap = Maps.newHashMap();
        Map<Object, Object> customerNum2ContactMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
            String weworkUserId = user.getWeworkUserId();
            if (StringUtils.isNotBlank((CharSequence)weworkUserId)) {
                List contactRelationList = this.weworkContactRelationMapper.queryListByContactIds(bizId, weworkUserId, (Collection)contactIds);
                weworkContactRelationMap = contactRelationList.stream().collect(Collectors.toMap(WeworkContactRelation::getContactId, a -> a, (k, v) -> v));
            }
            List weworkContactList = this.weworkContactMapper.queryWeworkContactList(corpId, (Collection)contactIds);
            customerNum2ContactMap = weworkContactList.stream().collect(Collectors.toMap(WeworkContact::getCustomerNum, a -> a, (k, v) -> v));
        }
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        ArrayList respList = Lists.newArrayList();
        for (String customerId : customerIdSet) {
            CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerId);
            if (detailResp == null) continue;
            SopRemindCustomerListResp resp = new SopRemindCustomerListResp();
            resp.setId(detailResp.getCustomerNum());
            ArrayList mobileList = Lists.newArrayList();
            String mobile1 = detailResp.getMobile1();
            String mobile2 = detailResp.getMobile2();
            if (StringUtils.isNotBlank((CharSequence)mobile1)) {
                mobileList.add(mobile1);
            }
            if (StringUtils.isNotBlank((CharSequence)mobile2)) {
                mobileList.add(mobile2);
            }
            if (mobileEncrypt) {
                MobileUtils.encryptMobile((List)mobileList);
            }
            resp.setCustomerMobiles(mobileList);
            resp.setType(SopContactType.CRM.getValue());
            resp.setNickname(detailResp.getName());
            if (customerNum2ContactMap.containsKey(customerId)) {
                WeworkContact weworkContact = (WeworkContact)customerNum2ContactMap.get(customerId);
                String contactId = weworkContact.getContactId();
                Integer contactType = weworkContact.getType();
                if (contactType != null) {
                    resp.setType(contactType);
                }
                resp.setAvatar(weworkContact.getAvatar());
                resp.setCorpName(weworkContact.getCorpName());
                resp.setNickname(weworkContact.getName());
                if (weworkContactRelationMap.containsKey(contactId)) {
                    WeworkContactRelation relation = (WeworkContactRelation)weworkContactRelationMap.get(contactId);
                    resp.setNickname(relation.getRemark());
                }
            }
            respList.add(resp);
        }
        return respList;
    }
}

