/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.OperatorResult;
import com.kuaike.scrm.common.enums.OperatorResultStatus;
import com.kuaike.scrm.common.utils.ThreadTools;
import com.kuaike.scrm.dal.marketing.entity.SopCalTask;
import com.kuaike.scrm.dal.marketing.entity.SopCalTaskDetail;
import com.kuaike.scrm.dal.marketing.entity.SopCondition;
import com.kuaike.scrm.dal.marketing.mapper.SopCalTaskMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopConditionMapper;
import com.kuaike.scrm.sop.dto.CallSopCalcTaskReq;
import com.kuaike.scrm.sop.service.OperatorConvertService;
import com.kuaike.scrm.sop.service.OperatorEngineService;
import com.kuaike.scrm.sop.service.OperatorResultService;
import com.kuaike.scrm.sop.service.SopCalTaskService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SopCalTaskServiceImpl
implements SopCalTaskService {
    private static final Logger log = LoggerFactory.getLogger(SopCalTaskServiceImpl.class);
    @Autowired
    private SopCalTaskMapper sopCalTaskMapper;
    @Autowired
    private OperatorResultService operatorResultService;
    @Autowired
    private OperatorEngineService operatorEngineService;
    @Autowired
    private SopConditionMapper sopConditionMapper;
    @Autowired
    private OperatorConvertService operatorConvertService;

    @Override
    public String callSopCalTask(CallSopCalcTaskReq req) {
        OperatorResult result;
        log.info("callSopCalTask with req={}", (Object)req);
        req.validate();
        String preRequestId = null;
        if (CollectionUtils.isNotEmpty(req.getCustomerList())) {
            preRequestId = UUID.randomUUID().toString().replace("-", "");
            result = new OperatorResult();
            this.operatorResultService.saveResult(result);
        } else if (StringUtils.isNotBlank((CharSequence)req.getPreRequestId())) {
            preRequestId = req.getPreRequestId();
        }
        result = null;
        String requestId = UUID.randomUUID().toString().replace("-", "");
        result = this.buildEmptyResult(req.getBizId(), requestId);
        if (StringUtils.isNotBlank((CharSequence)preRequestId)) {
            OperatorResult preResult = this.operatorResultService.queryByRequestId(preRequestId);
            preResult = this.operatorConvertService.resultConvert(preResult, req.getWantedResultType());
            result.setList(preResult.getList());
            result.setMemberType(preResult.getMemberType());
            result.setCustomerType(preResult.getCustomerType());
        }
        this.operatorResultService.saveResult(result);
        log.info("merge preRequest requestId={}, list size={}", (Object)result.getRequestId(), (Object)CollectionUtils.size((Object)result.getList()));
        SopCalTask task = new SopCalTask();
        task.setBizId(req.getBizId());
        task.setTaskStatus(OperatorResultStatus.WAITING.getStatus());
        task.setCreateBy(Long.valueOf(-1L));
        task.setUpdateBy(Long.valueOf(-1L));
        task.setPreRequestId(preRequestId);
        task.setLastTaskDetailId(null);
        task.setSopContentId(req.getSopContentId());
        task.setResultRequestId(requestId);
        task.setCreateTime(new Date());
        task.setIsDeleted(Boolean.valueOf(false));
        task.setWantedResultType(req.getWantedResultType());
        task.setUpdateTime(new Date());
        this.sopCalTaskMapper.insert((Object)task);
        ThreadTools.getIoTaskThreadPool().submit(() -> {
            try {
                this.operatorEngineService.startTask(task.getId());
            }
            catch (Exception e) {
                log.error("startTask with error", (Throwable)e);
            }
        });
        return requestId;
    }

    private OperatorResult buildEmptyResult(Long bizId, String requestId) {
        OperatorResult result = new OperatorResult();
        result.setList((List)Lists.newArrayList());
        result.setBizId(bizId);
        result.setUpdateTime(new Date());
        result.setCreateTime(new Date());
        result.setRequestId(requestId);
        result.setStatus(OperatorResultStatus.WAITING.getStatus());
        return result;
    }

    @Override
    public List<SopCalTaskDetail> splitTaskDetail(Long taskId) {
        log.info("splitTaskDetail with taskId={}", (Object)taskId);
        SopCalTask sopCalTask = (SopCalTask)this.sopCalTaskMapper.selectByPrimaryKey((Object)taskId);
        if (Objects.isNull(sopCalTask) || sopCalTask.getIsDeleted().booleanValue()) {
            log.warn("sopCalTask not exists,taskId={}", (Object)taskId);
            return Lists.newArrayList();
        }
        List conditions = this.sopConditionMapper.queryByContentId(sopCalTask.getSopContentId());
        if (CollectionUtils.isEmpty((Collection)conditions)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        int seq = 0;
        for (SopCondition condition : conditions) {
            SopCalTaskDetail item = new SopCalTaskDetail();
            item.setUpdateTime(new Date());
            item.setCreateTime(new Date());
            item.setStatus(OperatorResultStatus.WAITING.getStatus());
            item.setUpdateBy(Long.valueOf(-1L));
            item.setCreateBy(Long.valueOf(-1L));
            item.setBizId(condition.getBizId());
            item.setResultRequestId("");
            item.setTaskId(taskId);
            item.setIsDeleted(Boolean.valueOf(false));
            item.setSopConditionId(condition.getId());
            item.setSopContentId(sopCalTask.getSopContentId());
            item.setSeq(Integer.valueOf(seq));
            list.add(item);
            ++seq;
        }
        return list;
    }

    @Override
    public void retrySopCalTask() {
        log.info("retrySopCalTask start");
        List sopCalTasks = this.sopCalTaskMapper.queryTaskByStatus(OperatorResultStatus.WAITING.getStatus(), Integer.valueOf(8));
        if (CollectionUtils.isEmpty((Collection)sopCalTasks)) {
            log.info("not task need to retry");
            return;
        }
        for (SopCalTask sopCalTask : sopCalTasks) {
            this.operatorEngineService.startTask(sopCalTask.getId());
        }
        log.info("retrySopCalTask end");
    }

    @Override
    public OperatorResultStatus queryStatus(String requestId) {
        SopCalTask task = this.sopCalTaskMapper.queryByRequestId(requestId);
        if (Objects.isNull(task) || task.getIsDeleted().booleanValue()) {
            return null;
        }
        return OperatorResultStatus.getByStatus((Integer)task.getTaskStatus());
    }
}

