/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.operators.functions.impl;

import cn.kinyun.customer.center.dto.req.operator.CustomerTagQueryReq;
import cn.kinyun.customer.center.service.CcOperatorService;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.sop.dto.OperatorCommonDto;
import com.kuaike.scrm.sop.dto.req.SopTagParseDto;
import com.kuaike.scrm.sop.enums.ConditionTypeEnum;
import com.kuaike.scrm.sop.operators.functions.AbstractOperatorInvoker;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerTagInvoker
extends AbstractOperatorInvoker<List<SopTagParseDto>> {
    private static final Logger log = LoggerFactory.getLogger(CustomerTagInvoker.class);
    @Autowired
    private CcOperatorService ccOperatorService;

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.CUSTOMER_TAG;
    }

    @Override
    public List<SopTagParseDto> getParam(String json) {
        try {
            return JacksonUtil.str2List((String)json, SopTagParseDto.class);
        }
        catch (IOException e) {
            log.error("parse json with error", (Throwable)e);
            return null;
        }
    }

    @Override
    public void validate(List<SopTagParseDto> list) {
        Preconditions.checkArgument((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        for (SopTagParseDto tagParseDto : list) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tagParseDto.getTagId()), (Object)"tagId\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tagParseDto.getGroupId()), (Object)"groupId\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tagParseDto.getName()), (Object)"tagName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public String invoke(OperatorCommonDto commonDto, List<SopTagParseDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            log.warn("list is empty");
            return null;
        }
        CustomerTagQueryReq req = new CustomerTagQueryReq();
        req.setBizId(commonDto.getBizId());
        Map groupId2List = list.stream().collect(Collectors.groupingBy(SopTagParseDto::getGroupId, Collectors.mapping(SopTagParseDto::getTagId, Collectors.toList())));
        req.setTagGroups(groupId2List.values().stream().collect(Collectors.toList()));
        req.setUserId2WeworkUserNumMap(commonDto.getUserId2UserNums());
        return this.ccOperatorService.customerTagAsync(req);
    }
}

