/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import cn.kinyun.wework.sdk.api.external.MassMsgPushClient;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgParams;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgResp;
import cn.kinyun.wework.sdk.entity.external.msg.Attachment;
import cn.kinyun.wework.sdk.entity.external.msg.File;
import cn.kinyun.wework.sdk.entity.external.msg.Image;
import cn.kinyun.wework.sdk.entity.external.msg.Link;
import cn.kinyun.wework.sdk.entity.external.msg.MiniProgram;
import cn.kinyun.wework.sdk.entity.external.msg.Text;
import cn.kinyun.wework.sdk.entity.external.msg.Video;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.jsmsg.JsNewsDto;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.AutoChangeTaskType;
import com.kuaike.scrm.common.enums.GroupSendContactStatus;
import com.kuaike.scrm.common.enums.GroupSendFkType;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.enums.QueryType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.service.SopTaskStatusService;
import com.kuaike.scrm.dal.groupsend.dto.GroupSendMsgDto;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendDetail;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.entity.WeworkGroupMsgResult;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkGroupMsgResultMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardStageMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.groupsend.service.GroupSendDetailService;
import com.kuaike.scrm.groupsend.service.GroupSendExecuteService;
import com.kuaike.scrm.groupsend.service.GroupSendService;
import com.kuaike.scrm.material.dto.request.QueryMaterialReqDto;
import com.kuaike.scrm.material.dto.response.MaterialListRespDto;
import com.kuaike.scrm.material.dto.response.MaterialRespDto;
import com.kuaike.scrm.material.service.MaterialManagerService;
import com.kuaike.scrm.remind.dto.req.AddRemindReqDto;
import com.kuaike.scrm.remind.dto.req.RemindDetailReqDto;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.service.MeetingUrlCommonService;
import com.kuaike.scrm.service.MeetingUrlService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupSendExecuteServiceImpl
implements GroupSendExecuteService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendExecuteServiceImpl.class);
    @Autowired
    private MessageGroupSendTaskMapper groupSendTaskMapper;
    @Autowired
    private MessageGroupSendDetailMapper groupSendDetailMapper;
    @Autowired
    private GroupSendDetailService groupSendDetailService;
    @Autowired
    private MassMsgPushClient massMsgPushClient;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private MaterialManagerService materialManagerService;
    @Autowired
    private WeworkGroupMsgResultMapper msgResultMapper;
    @Autowired
    private GroupSendService groupSendService;
    @Autowired
    private RemindService remindService;
    @Autowired
    private MarketingRewardMapper marketingRewardMapper;
    @Autowired
    private MarketingRewardStageMapper marketingRewardStageMapper;
    @Autowired
    private SopTaskStatusService sopTaskStatusService;
    @Autowired
    private MeetingMapper meetingMapper;
    @Autowired
    private MeetingUrlService meetingUrlService;
    @Resource
    private MeetingUrlCommonService meetingUrlCommonService;
    @Resource
    private MeetingCacheService meetingCacheService;
    private static final String REMIND_STR = "\u60a8\u6709\u4e00\u9879\u300c\u5ba2\u6237\u7fa4\u53d1\u300d\u5f85\u529e\uff0c\u8bf7\u524d\u5f80\u4fa7\u8fb9\u680f\u3010\u767e\u5bb6\u4e91SCRM\u3011\u2014\u3010\u5f85\u529e\u4e8b\u9879\u3011\u5c3d\u5feb\u5b8c\u6210\u54e6~";
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemTaskSendStart() {
        log.info("systemTaskSendStart start");
        Object object = this.lock;
        synchronized (object) {
            List taskIds = this.groupSendDetailMapper.queryNeedSendTaskIds(GroupSendTaskType.QYAPI.getValue(), SendStatus.TO_BE_SEND.getValue());
            if (CollectionUtils.isEmpty((Collection)taskIds)) {
                return;
            }
            log.info("\u6709\u4e2a{}\u4efb\u52a1\u5f85\u53d1\u9001", (Object)taskIds.size());
            long startTime = System.currentTimeMillis();
            List tasks = this.groupSendTaskMapper.queryByIds((Collection)taskIds);
            Map<Long, MaterialListRespDto> taskId2MaterialList = this.getTaskMaterial(tasks);
            for (Long taskId : taskIds) {
                this.sendTask(taskId2MaterialList, taskId);
            }
            log.info("systemTaskSendStart end,wasteTime={}", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private Map<Long, MaterialListRespDto> getTaskMaterial(List<MessageGroupSendTask> tasks) {
        List reqDtos = tasks.stream().map(a -> {
            QueryMaterialReqDto dto = new QueryMaterialReqDto();
            dto.setFkId(a.getId());
            dto.setFkType(Integer.valueOf(1));
            return dto;
        }).collect(Collectors.toList());
        ArrayList materialListRespDtoList = Lists.newArrayList();
        Map<String, List<MessageGroupSendTask>> corpId2List = tasks.stream().collect(Collectors.groupingBy(MessageGroupSendTask::getCorpId));
        corpId2List.forEach((corpId, list) -> {
            Long bizId = ((MessageGroupSendTask)list.get(0)).getBizId();
            List temList = this.materialManagerService.query(bizId, corpId, reqDtos);
            materialListRespDtoList.addAll(temList);
        });
        return materialListRespDtoList.stream().collect(Collectors.toMap(MaterialListRespDto::getFkId, a -> a));
    }

    private void sendTask(Map<Long, MaterialListRespDto> taskId2MaterialList, Long taskId) {
        MessageGroupSendTask task = (MessageGroupSendTask)this.groupSendTaskMapper.selectByPrimaryKey((Object)taskId);
        List details = this.groupSendDetailMapper.queryNotSendSystemSendByTaskIds((List)Lists.newArrayList((Object[])new Long[]{taskId}), Integer.valueOf(GroupSendTaskType.QYAPI.getValue()));
        Map<String, List<MessageGroupSendDetail>> sendWeworkNums2List = details.stream().collect(Collectors.groupingBy(MessageGroupSendDetail::getSendWeworkNum));
        MaterialListRespDto materialListRespDto = taskId2MaterialList.get(taskId);
        Map<Object, Object> url2MediaId = Maps.newHashMap();
        if (materialListRespDto != null && CollectionUtils.isNotEmpty((Collection)materialListRespDto.getMaterialReqDtoList())) {
            url2MediaId = materialListRespDto.getMaterialReqDtoList().stream().collect(Collectors.toMap(MaterialRespDto::getFileUrl, MaterialRespDto::getMediaId, (a, b) -> a));
        }
        ArrayList<String> weworkUserNums = new ArrayList<String>(sendWeworkNums2List.keySet());
        Map userNum2UserId = this.weworkUserService.getWeworkUserIdMapByNums(weworkUserNums);
        Map<String, String> userNum2WeworkUserName = this.weworkUserService.queryWeworkUserInfoByNums(weworkUserNums).stream().collect(Collectors.toMap(a -> a.getWeworkNum(), a -> a.getWeworkName()));
        Map<Object, Object> finalUrl2MediaId = url2MediaId;
        sendWeworkNums2List.forEach((sendWeworkUserNum, list) -> {
            String weworkUserId = userNum2UserId.getOrDefault(sendWeworkUserNum, "");
            String weworkUserName = userNum2WeworkUserName.getOrDefault(sendWeworkUserNum, "");
            if (StringUtils.isBlank((CharSequence)weworkUserId)) {
                log.error("\u4e1a\u52a1\u5f02\u5e38:weworkUserId is empty, userNum={}", sendWeworkUserNum);
                return;
            }
            if (CollectionUtils.isEmpty(list = list.stream().filter(a -> a.getStatus().equals(SendStatus.TO_BE_SEND.getValue())).collect(Collectors.toList()))) {
                log.info("list is empty");
                return;
            }
            List partition = Lists.partition(list, (int)10000);
            for (List subList : partition) {
                List externalUserIds;
                String remark;
                MassMsgParams massMsgParams = this.buildMassMsgParams(task, (Map<String, String>)finalUrl2MediaId, (String)sendWeworkUserNum, subList, weworkUserId, weworkUserName);
                String msgId = null;
                ArrayList failList = Lists.newArrayList();
                List<String> neetChangedList = Lists.newArrayList();
                try {
                    log.info("massMsgParam={}", (Object)massMsgParams);
                    MassMsgResp resp = this.massMsgPushClient.massMsgSend(task.getCorpId(), massMsgParams);
                    log.info("massMsgSend with resp={}", (Object)resp);
                    msgId = resp.getMsgId();
                    neetChangedList = resp.getFailList();
                    remark = GroupSendContactStatus.LIMITED.getDesc();
                }
                catch (WeworkException e) {
                    log.error("call massMsgSend use massMsgParams={} with weworkError", (Object)massMsgParams, (Object)e);
                    if (e.getErrorCode().equals(41048)) {
                        externalUserIds = subList.stream().map(MessageGroupSendDetail::getReceiveId).collect(Collectors.toList());
                        neetChangedList.addAll(externalUserIds);
                        remark = GroupSendContactStatus.LIMITED.getDesc();
                        log.info("collect 41048 failList");
                    } else if (e.getErrorCode().equals(84061)) {
                        externalUserIds = subList.stream().map(MessageGroupSendDetail::getReceiveId).collect(Collectors.toList());
                        failList.addAll(externalUserIds);
                        remark = GroupSendContactStatus.NOT_FRIEND.getDesc();
                        log.info("collect 84061 failList");
                    } else {
                        externalUserIds = subList.stream().map(MessageGroupSendDetail::getReceiveId).collect(Collectors.toList());
                        failList.addAll(externalUserIds);
                        remark = StringUtils.abbreviate((String)e.getErrorMsg(), (int)64);
                        log.info("collect weworkException failList");
                    }
                }
                catch (Exception e) {
                    log.error("call massMsgSend use massMsgParams={} with error", (Object)massMsgParams, (Object)e);
                    externalUserIds = subList.stream().map(MessageGroupSendDetail::getReceiveId).collect(Collectors.toList());
                    failList.addAll(externalUserIds);
                    remark = StringUtils.abbreviate((String)e.getMessage(), (int)64);
                    log.info("collect exception failList");
                }
                this.updateTaskAndDetail(task, subList, msgId, neetChangedList, failList, remark);
            }
        });
    }

    private void updateTaskAndDetail(MessageGroupSendTask task, List<MessageGroupSendDetail> list, String msgId, List<String> neetChangedList, List<String> failList, String remark) {
        List successIds;
        log.info("updateTaskAndDetail msgId={}, failList={},needChangedList={}, remark={}", new Object[]{msgId, failList, neetChangedList, remark});
        HashSet ids = Sets.newHashSet();
        ArrayList remindDetailReqDtos = Lists.newArrayList();
        Map<Long, MessageGroupSendDetail> detailId2Entity = list.stream().collect(Collectors.toMap(MessageGroupSendDetail::getId, a -> a));
        if (CollectionUtils.isNotEmpty(failList) || CollectionUtils.isNotEmpty(neetChangedList)) {
            Set<Long> updateIds;
            HashSet finalFailSet = Sets.newHashSet(failList);
            HashSet finalNeetChangedList = Sets.newHashSet(neetChangedList);
            if (task.getTaskType().equals(GroupSendTaskType.QYAPI.getValue()) && task.getAutoChangeTaskType().equals(AutoChangeTaskType.CHANGE.getType())) {
                updateIds = list.stream().filter(a -> finalNeetChangedList.contains(a.getReceiveId())).map(MessageGroupSendDetail::getId).collect(Collectors.toSet());
                Date deadline = null;
                if (task.getTimeoutGap() != null && task.getTimeoutGap() > 0) {
                    deadline = DateUtils.addHours((Date)new Date(), (int)task.getTimeoutGap());
                }
                this.groupSendDetailMapper.updateTaskTypeByIds(updateIds, Integer.valueOf(GroupSendTaskType.SIDEBAR.getValue()), deadline);
                this.collectNeetRemindDetail(updateIds, remindDetailReqDtos, detailId2Entity);
                ids.addAll(updateIds);
            }
            if (task.getAutoChangeTaskType().intValue() == AutoChangeTaskType.DEFAULT.getType()) {
                finalFailSet.addAll(finalNeetChangedList);
            }
            if (CollectionUtils.isNotEmpty((Collection)finalFailSet)) {
                updateIds = list.stream().filter(a -> finalFailSet.contains(a.getReceiveId())).map(MessageGroupSendDetail::getId).collect(Collectors.toSet());
                GroupSendContactStatus contactStatus = GroupSendContactStatus.getByDesc((String)remark);
                this.groupSendDetailMapper.updateStatusByIds(updateIds, Integer.valueOf(SendStatus.SEND_FAIL.getValue()), remark, null, contactStatus != null ? Integer.valueOf(contactStatus.getValue()) : null);
                for (Long subTaskId : updateIds) {
                    MessageGroupSendDetail detail = detailId2Entity.get(subTaskId);
                    this.sopTaskStatusService.sendSopTaskStatusMsg(task.getId(), subTaskId, SopTaskType.GROUP_SEND, detail.getReceiveId(), Integer.valueOf(TaskRunStatusEnum.FAIL.getStatus()), remark, null);
                }
                ids.addAll(updateIds);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)remindDetailReqDtos)) {
            AddRemindReqDto addRemindReqDto = new AddRemindReqDto(Long.valueOf(-1L), task.getBizId(), task.getCorpId(), Integer.valueOf(2), Integer.valueOf(1), REMIND_STR, task.getId(), Long.valueOf(-1L), Integer.valueOf(0), (List)remindDetailReqDtos);
            this.remindService.addRemind(addRemindReqDto);
        }
        if (CollectionUtils.isNotEmpty(successIds = list.stream().map(MessageGroupSendDetail::getId).filter(id -> !ids.contains(id)).collect(Collectors.toList()))) {
            this.groupSendDetailMapper.updateStatusByIds(successIds, Integer.valueOf(SendStatus.SENDING.getValue()), null, msgId, null);
        }
        this.groupSendTaskMapper.updateSendStatus((Collection)Lists.newArrayList((Object[])new Long[]{task.getId()}), SendStatus.SENDING.getValue());
        this.groupSendService.updateTaskStatus(Lists.newArrayList((Object[])new Long[]{task.getId()}));
    }

    private void collectNeetRemindDetail(Set<Long> ids, List<RemindDetailReqDto> remindDetailReqDtos, Map<Long, MessageGroupSendDetail> detailId2Entity) {
        for (Long id : ids) {
            MessageGroupSendDetail detail = detailId2Entity.get(id);
            if (Objects.isNull(detail)) continue;
            RemindDetailReqDto remindDetailReqDto = detail.getReceiveType().equals(ReceiveType.CHATROOM.getType()) ? new RemindDetailReqDto(detail.getSendWeworkNum(), new Date(), detail.getReceiveId(), Integer.valueOf(2)) : new RemindDetailReqDto(detail.getSendWeworkNum(), new Date(), detail.getReceiveId(), Integer.valueOf(1));
            remindDetailReqDtos.add(remindDetailReqDto);
        }
    }

    private MassMsgParams buildMassMsgParams(MessageGroupSendTask task, Map<String, String> finalUrl2MediaId, String sendWeworkUserNum, List<MessageGroupSendDetail> list, String weworkUserId, String weworkUserName) {
        String chatType;
        MassMsgParams massMsgParams = new MassMsgParams();
        List<Object> externalUserIds = Lists.newArrayList();
        if (task.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
            chatType = "group";
        } else {
            chatType = "single";
            externalUserIds = list.stream().map(MessageGroupSendDetail::getReceiveId).collect(Collectors.toList());
        }
        String params = list.get(0).getExtField1();
        massMsgParams.setChatType(chatType);
        if ("emptyUserNum".equals(sendWeworkUserNum)) {
            massMsgParams.setSender("");
        } else {
            massMsgParams.setSender(weworkUserId);
        }
        massMsgParams.setExternalUserId((List)externalUserIds);
        List msgList = JSONArray.parseArray((String)task.getContent(), UniformMsgDto.class);
        Text text = new Text();
        ArrayList attachments = Lists.newArrayList();
        this.fillAttachment(finalUrl2MediaId, msgList, text, attachments, params, task, sendWeworkUserNum, weworkUserName);
        massMsgParams.setText(text);
        massMsgParams.setAttachments((List)attachments);
        return massMsgParams;
    }

    private void fillAttachment(Map<String, String> finalUrl2MediaId, List<UniformMsgDto> msgList, Text text, List<Attachment> attachments, String params, MessageGroupSendTask task, String weworkUserNum, String weworkUserName) {
        Map stageRewardCountMap = Maps.newHashMap();
        Map receiveStageRewardCountMap = Maps.newHashMap();
        if (task.getFkType().equals(GroupSendFkType.FRIEND_FISSION.getType())) {
            stageRewardCountMap = this.marketingRewardStageMapper.getStageRewardCountByPlanId(task.getFkTaskId());
            receiveStageRewardCountMap = this.marketingRewardMapper.getReceiveStageRewardCountByPlanId(task.getFkTaskId());
        }
        log.info("fillAttachment msgList = {}", msgList);
        for (UniformMsgDto dto : msgList) {
            JsMsgType jsMsgType = JsMsgType.get((String)dto.getMsgType());
            if (jsMsgType == null) {
                log.warn("\u4e0d\u652f\u6301\u7684msgType:{}", (Object)dto.getMsgType());
                continue;
            }
            if (jsMsgType.isText()) {
                if (jsMsgType == JsMsgType.MEETING) {
                    String wechatAuthMeetingCommerceUrl;
                    String meetingContent = dto.getContent();
                    Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)task.getFkTaskId());
                    if (Objects.nonNull(meeting) && meeting.getInviteInfoType() == 1) {
                        log.info("meetingContent replace before {}", (Object)meetingContent);
                        if (meeting.getLiveDeliverySwitch() == 1) {
                            wechatAuthMeetingCommerceUrl = this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), null, meeting.getNum(), weworkUserNum, false, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode());
                            meetingContent = meetingContent.replace(meeting.getMeetingUrl(), wechatAuthMeetingCommerceUrl);
                            try {
                                this.meetingCacheService.setInviteUserId(meeting.getBizId(), weworkUserNum, meeting.getEndTime(), null);
                            }
                            catch (Exception e) {
                                log.error("setInviteUserId error", (Throwable)e);
                            }
                        }
                        if (meetingContent.contains("${customstr}")) {
                            meetingContent = meetingContent.replace("${customstr}", "");
                        }
                        if (meetingContent.contains("{\u6210\u5458\u6635\u79f0}")) {
                            meetingContent = meetingContent.replace("{\u6210\u5458\u6635\u79f0}", weworkUserName);
                        }
                        log.info("meetingContent replace after {}", (Object)meetingContent);
                        JsNewsDto newsDto = new JsNewsDto();
                        try {
                            newsDto = (JsNewsDto)JacksonUtil.str2Obj((String)meetingContent, JsNewsDto.class);
                        }
                        catch (IOException e) {
                            log.error("parse JsNewsDto ", (Throwable)e);
                        }
                        dto.setContent(null);
                        dto.setMsgType(JsMsgType.NEWS.getValue());
                        dto.setNews(newsDto);
                        attachments.add(this.collectNews(dto));
                        continue;
                    }
                    log.info("meetingContent text replace before {}", (Object)meetingContent);
                    if (StringUtils.isNotBlank((CharSequence)params) && StringUtils.isNotBlank((CharSequence)meetingContent)) {
                        meetingContent = meetingContent.replace("${customstr}", params);
                    }
                    if (meetingContent.contains("{\u6210\u5458\u6635\u79f0}")) {
                        meetingContent = meetingContent.replace("{\u6210\u5458\u6635\u79f0}", weworkUserName);
                    }
                    if (meetingContent.contains("${customstr}")) {
                        meetingContent = meetingContent.replace("${customstr}", "");
                    }
                    if (Objects.nonNull(meeting) && meeting.getLiveDeliverySwitch() == 1) {
                        wechatAuthMeetingCommerceUrl = this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), null, meeting.getNum(), weworkUserNum, false, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode());
                        meetingContent = meetingContent.replace(meeting.getMeetingUrl(), wechatAuthMeetingCommerceUrl);
                        try {
                            this.meetingCacheService.setInviteUserId(meeting.getBizId(), weworkUserNum, meeting.getEndTime(), null);
                        }
                        catch (Exception e) {
                            log.error("setInviteUserId error", (Throwable)e);
                        }
                    }
                    log.info("meetingContent text replace after {}", (Object)meetingContent);
                    text.setContent(meetingContent);
                    continue;
                }
                if (jsMsgType == JsMsgType.FRIEND_FISSION_WORDS) {
                    String ffWordContent = dto.getContent();
                    if ((ffWordContent = this.replaceFriendFissionPlaceHolder(stageRewardCountMap, receiveStageRewardCountMap, ffWordContent)).contains("{\u6210\u5458\u6635\u79f0}")) {
                        ffWordContent = ffWordContent.replace("{\u6210\u5458\u6635\u79f0}", "");
                    }
                    text.setContent(ffWordContent);
                    continue;
                }
                String content = dto.getContent();
                if (content.contains("{\u6210\u5458\u6635\u79f0}")) {
                    content = content.replace("{\u6210\u5458\u6635\u79f0}", "");
                }
                text.setContent(content);
                continue;
            }
            Attachment attachment = new Attachment();
            switch (jsMsgType) {
                case IMAGE: {
                    attachment.setMsgType(dto.getMsgType());
                    Image image = new Image();
                    image.setMediaId(finalUrl2MediaId.get(dto.getFile().getFileUrl()));
                    attachment.setImage(image);
                    break;
                }
                case VIDEO: {
                    attachment.setMsgType(dto.getMsgType());
                    Video video = new Video();
                    video.setMediaId(finalUrl2MediaId.get(dto.getFile().getFileUrl()));
                    attachment.setVideo(video);
                    break;
                }
                case MINI_PROGRAM: {
                    attachment.setMsgType(dto.getMsgType());
                    MiniProgram miniProgram = new MiniProgram();
                    miniProgram.setAppId(dto.getMiniprogram().getAppid());
                    miniProgram.setPage(dto.getMiniprogram().getPage());
                    miniProgram.setTitle(dto.getMiniprogram().getTitle());
                    miniProgram.setPicMediaId(finalUrl2MediaId.get(dto.getMiniprogram().getImgUrl()));
                    attachment.setMiniProgram(miniProgram);
                    break;
                }
                case NEWS: {
                    attachment = this.collectNews(dto);
                    break;
                }
                case FILE: {
                    attachment.setMsgType(dto.getMsgType());
                    File file = new File();
                    file.setMediaId(finalUrl2MediaId.get(dto.getFile().getFileUrl()));
                    attachment.setFile(file);
                    break;
                }
            }
            attachments.add(attachment);
        }
    }

    private Attachment collectNews(UniformMsgDto dto) {
        Attachment attachment = new Attachment();
        attachment.setMsgType("link");
        Link link = new Link();
        link.setTitle(dto.getNews().getTitle());
        link.setDesc(dto.getNews().getDesc());
        link.setPicUrl(dto.getNews().getImgUrl());
        link.setUrl(dto.getNews().getLink());
        attachment.setLink(link);
        return attachment;
    }

    private String replaceFriendFissionPlaceHolder(Map<Integer, Integer> stageRewardCountMap, Map<Integer, Integer> receiveStageRewardCountMap, String ffWordContent) {
        int value;
        int firstStageReceiveCount;
        int firstStageRewardCount;
        if (ffWordContent.contains("${nickname}")) {
            ffWordContent = StringUtils.replace((String)ffWordContent, (String)"${nickname}", (String)"");
        }
        if (ffWordContent.contains("${remainReward-1}")) {
            firstStageRewardCount = stageRewardCountMap.getOrDefault(1, 0);
            firstStageReceiveCount = MapUtils.getIntValue(receiveStageRewardCountMap, (Object)1, (int)0);
            value = Math.max(firstStageRewardCount - firstStageReceiveCount, 0);
            ffWordContent = StringUtils.replace((String)ffWordContent, (String)"${remainReward-1}", (String)Integer.toString(value));
        }
        if (ffWordContent.contains("${remainReward-2}")) {
            firstStageRewardCount = stageRewardCountMap.getOrDefault(2, 0);
            firstStageReceiveCount = MapUtils.getIntValue(receiveStageRewardCountMap, (Object)2, (int)0);
            value = Math.max(firstStageRewardCount - firstStageReceiveCount, 0);
            ffWordContent = StringUtils.replace((String)ffWordContent, (String)"${remainReward-2}", (String)Integer.toString(value));
        }
        if (ffWordContent.contains("${remainReward-3}")) {
            firstStageRewardCount = stageRewardCountMap.getOrDefault(3, 0);
            firstStageReceiveCount = MapUtils.getIntValue(receiveStageRewardCountMap, (Object)3, (int)0);
            value = Math.max(firstStageRewardCount - firstStageReceiveCount, 0);
            ffWordContent = StringUtils.replace((String)ffWordContent, (String)"${remainReward-3}", (String)Integer.toString(value));
        }
        return ffWordContent;
    }

    @Override
    public void freshSendTime() {
        log.info("\u5237\u65b0\u53d1\u9001\u65f6\u95f4 start");
        Map msgId2TaskId = this.groupSendDetailMapper.queryNotFinishedMsgId();
        if (MapUtils.isEmpty((Map)msgId2TaskId)) {
            log.info("msgId2TaskId is empty,exit");
            return;
        }
        List msgResults = this.msgResultMapper.queryByMsgIds(msgId2TaskId.keySet());
        if (CollectionUtils.isEmpty((Collection)msgResults)) {
            log.info("\u6ca1\u6709\u5b8c\u6210\u7684msgId");
            return;
        }
        HashSet<Long> taskIds = new HashSet<Long>(msgId2TaskId.values());
        Map<Long, MessageGroupSendTask> taskId2Item = this.groupSendTaskMapper.queryByIds(taskIds).stream().collect(Collectors.toMap(MessageGroupSendTask::getId, a -> a));
        HashMap msgId2Task = Maps.newHashMap();
        msgId2TaskId.forEach((msgId, taskId) -> {
            MessageGroupSendTask cfr_ignored_0 = (MessageGroupSendTask)msgId2Task.put(msgId, taskId2Item.get(taskId));
        });
        Map corpId2WeworkUserIds = msgResults.stream().collect(Collectors.groupingBy(WeworkGroupMsgResult::getCorpId, Collectors.mapping(WeworkGroupMsgResult::getWeworkUserId, Collectors.toList())));
        HashMap weworkUserId2Num = Maps.newHashMap();
        corpId2WeworkUserIds.forEach((corpId, list) -> {
            Map map = this.weworkUserService.queryUserByWeworkUserIds(corpId, (Collection)list);
            map.forEach((weworkUserId, item) -> weworkUserId2Num.put(weworkUserId, item.getNum()));
        });
        HashSet successList = Sets.newHashSet();
        HashSet failList = Sets.newHashSet();
        this.fillList(msgResults, weworkUserId2Num, successList, failList, msgId2Task);
        if (CollectionUtils.isNotEmpty((Collection)successList)) {
            List partition = Lists.partition((List)Lists.newArrayList((Iterable)successList), (int)50);
            partition.forEach(subList -> this.groupSendDetailService.updateStatusAndCompleteTimeWithMsgId((List<GroupSendMsgDto>)subList));
            List detailList = this.groupSendDetailMapper.queryByMsgDto((List)Lists.newArrayList((Iterable)successList));
            for (MessageGroupSendDetail detail : detailList) {
                this.sopTaskStatusService.sendSopTaskStatusMsg(detail.getTaskId(), detail.getId(), SopTaskType.GROUP_SEND, detail.getReceiveId(), Integer.valueOf(TaskRunStatusEnum.SUCCESS.getStatus()), null, detail.getSendCompleteTime());
            }
        }
        ArrayList failResultList = Lists.newArrayList();
        ArrayList needChangeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)failList)) {
            List partition;
            for (GroupSendMsgDto groupSendMsgDto : failList) {
                MessageGroupSendTask task = (MessageGroupSendTask)msgId2Task.get(groupSendMsgDto.getMsgId());
                if (task != null && task.getTaskType().equals(GroupSendTaskType.QYAPI.getValue())) {
                    if (AutoChangeTaskType.CHANGE.getType() == task.getAutoChangeTaskType().intValue()) {
                        if (task.getTimeoutGap() != null && task.getTimeoutGap() > 0) {
                            groupSendMsgDto.setDeadline(DateUtils.addHours((Date)new Date(), (int)task.getTimeoutGap()));
                        }
                        groupSendMsgDto.setTaskType(Integer.valueOf(GroupSendTaskType.SIDEBAR.getValue()));
                        groupSendMsgDto.setSendStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
                        needChangeList.add(groupSendMsgDto);
                        continue;
                    }
                    failResultList.add(groupSendMsgDto);
                    continue;
                }
                failResultList.add(groupSendMsgDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)failResultList)) {
                partition = Lists.partition((List)failResultList, (int)50);
                partition.forEach(subList -> this.groupSendDetailMapper.updateStatusAndCompleteTimeWithMsgId((Collection)subList));
                log.info("failResultList: {}", (Object)failResultList);
                List detailList = this.groupSendDetailMapper.queryByMsgDto((List)Lists.newArrayList((Iterable)failResultList));
                for (MessageGroupSendDetail detail : detailList) {
                    this.sopTaskStatusService.sendSopTaskStatusMsg(detail.getTaskId(), detail.getId(), SopTaskType.GROUP_SEND, detail.getReceiveId(), Integer.valueOf(TaskRunStatusEnum.FAIL.getStatus()), detail.getRemark(), null);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)needChangeList)) {
                partition = Lists.partition((List)needChangeList, (int)50);
                partition.forEach(subList -> this.groupSendDetailMapper.updateStatusAndCompleteTimeWithMsgId((Collection)subList));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)needChangeList)) {
            this.sendRemind(needChangeList);
        }
        this.groupSendService.updateTaskStatus(taskIds);
        log.info("\u5237\u65b0\u53d1\u9001\u65f6\u95f4 end");
    }

    private void sendRemind(List<GroupSendMsgDto> needChangeList) {
        ArrayList remindDetailReqDtos = Lists.newArrayList();
        List list = this.groupSendDetailMapper.queryByMsgDto(needChangeList);
        Map<Long, List<MessageGroupSendDetail>> taskId2Details = list.stream().collect(Collectors.groupingBy(MessageGroupSendDetail::getTaskId));
        taskId2Details.forEach((taskId, details) -> {
            MessageGroupSendDetail tmpDetail = (MessageGroupSendDetail)details.get(0);
            Map<String, List<MessageGroupSendDetail>> sendWeworkUserNum2DetailList = details.stream().collect(Collectors.groupingBy(MessageGroupSendDetail::getSendWeworkNum));
            sendWeworkUserNum2DetailList.forEach((sendWeworkUserNum, detailList) -> {
                MessageGroupSendDetail detail = (MessageGroupSendDetail)detailList.get(0);
                RemindDetailReqDto remindDetailReqDto = detail.getReceiveType().equals(ReceiveType.CHATROOM.getType()) ? new RemindDetailReqDto(detail.getSendWeworkNum(), new Date(), detail.getReceiveId(), Integer.valueOf(2)) : new RemindDetailReqDto(detail.getSendWeworkNum(), new Date(), detail.getReceiveId(), Integer.valueOf(1));
                remindDetailReqDtos.add(remindDetailReqDto);
            });
            if (CollectionUtils.isNotEmpty((Collection)remindDetailReqDtos)) {
                AddRemindReqDto addRemindReqDto = new AddRemindReqDto(Long.valueOf(-1L), tmpDetail.getBizId(), tmpDetail.getCorpId(), Integer.valueOf(2), Integer.valueOf(1), REMIND_STR, taskId, Long.valueOf(-1L), Integer.valueOf(0), remindDetailReqDtos);
                this.remindService.addRemind(addRemindReqDto);
            }
        });
    }

    private void fillList(List<WeworkGroupMsgResult> msgResults, Map<String, String> weworkUserId2Num, Set<GroupSendMsgDto> sucessList, Set<GroupSendMsgDto> failList, Map<String, MessageGroupSendTask> msgId2Task) {
        HashMap msgId2sendWework2Targets = Maps.newHashMap();
        HashMap<String, Date> msgIdSendTimeMap = new HashMap<String, Date>();
        for (WeworkGroupMsgResult msgResult : msgResults) {
            GroupSendMsgDto item;
            String weworkUserNum = weworkUserId2Num.get(msgResult.getWeworkUserId());
            MessageGroupSendTask task = msgId2Task.get(msgResult.getMsgId());
            if (task.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
                Map sendWework2Targets = msgId2sendWework2Targets.getOrDefault(msgResult.getMsgId(), Maps.newHashMap());
                List sendTargetList = sendWework2Targets.getOrDefault(msgResult.getWeworkUserId(), Lists.newArrayList());
                sendTargetList.add(msgResult.getWeworkRoomId());
                sendWework2Targets.put(msgResult.getWeworkUserId(), sendTargetList);
                msgId2sendWework2Targets.put(msgResult.getMsgId(), sendWework2Targets);
                msgIdSendTimeMap.put(msgResult.getMsgId(), msgResult.getSendTime());
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)weworkUserNum)) continue;
            if (msgResult.getStatus().intValue() == GroupSendContactStatus.SENT.getValue()) {
                item = new GroupSendMsgDto();
                if (StringUtils.isNotBlank((CharSequence)msgResult.getContactId())) {
                    item.setReceiveId(msgResult.getContactId());
                    item.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
                } else {
                    item.setReceiveId("emptyReceiverId");
                    item.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
                }
                item.setMsgId(msgResult.getMsgId());
                item.setWeworkUserNum(weworkUserNum);
                item.setSendTime(msgResult.getSendTime());
                item.setSendStatus(Integer.valueOf(SendStatus.ALREADY_SEND.getValue()));
                sucessList.add(item);
                continue;
            }
            if (msgResult.getStatus().intValue() == GroupSendContactStatus.NOT_FRIEND.getValue()) {
                item = new GroupSendMsgDto();
                if (StringUtils.isNotBlank((CharSequence)msgResult.getContactId())) {
                    item.setReceiveId(msgResult.getContactId());
                    item.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
                } else {
                    item.setReceiveId("emptyReceiverId");
                    item.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
                }
                item.setMsgId(msgResult.getMsgId());
                item.setWeworkUserNum(weworkUserNum);
                item.setSendStatus(Integer.valueOf(SendStatus.SEND_FAIL.getValue()));
                item.setRemark(GroupSendContactStatus.get((Integer)msgResult.getStatus()).getDesc());
                item.setContactStatus(Integer.valueOf(GroupSendContactStatus.get((Integer)msgResult.getStatus()).getValue()));
                sucessList.add(item);
                continue;
            }
            if (msgResult.getStatus().intValue() != GroupSendContactStatus.LIMITED.getValue()) continue;
            item = new GroupSendMsgDto();
            item.setRemark(GroupSendContactStatus.get((Integer)msgResult.getStatus()).getDesc());
            item.setContactStatus(Integer.valueOf(GroupSendContactStatus.get((Integer)msgResult.getStatus()).getValue()));
            item.setSendStatus(Integer.valueOf(SendStatus.SEND_FAIL.getValue()));
            item.setMsgId(msgResult.getMsgId());
            item.setWeworkUserNum(weworkUserNum);
            if (StringUtils.isNotBlank((CharSequence)msgResult.getContactId())) {
                item.setReceiveId(msgResult.getContactId());
                item.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
                failList.add(item);
                continue;
            }
            item.setReceiveId("emptyReceiverId");
            item.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
            sucessList.add(item);
        }
        msgId2sendWework2Targets.forEach((msgId, map) -> map.forEach((sendWework, list) -> {
            String weworkUserNum = (String)weworkUserId2Num.get(sendWework);
            GroupSendMsgDto item = new GroupSendMsgDto();
            item.setRemark("");
            item.setSendStatus(Integer.valueOf(SendStatus.ALREADY_SEND.getValue()));
            item.setMsgId(msgId);
            item.setWeworkUserNum(weworkUserNum);
            item.setReceiveId("emptyReceiverId");
            item.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
            String sendTargetStr = StringUtils.join((Iterable)list, (String)",");
            item.setSendTarget(sendTargetStr);
            Date sendTime = (Date)msgIdSendTimeMap.get(msgId);
            if (sendTime != null) {
                item.setSendTime(sendTime);
            }
            sucessList.add(item);
        }));
    }
}

