/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GroupSendFkType;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.QueryType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.service.ParamEncryService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.service.dto.SelectedChatroom2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.resp.MeetingEncryRespDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.groupsend.dto.GroupSendMsgDto;
import com.kuaike.scrm.dal.groupsend.dto.GroupSendWeworkDto;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendDetail;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendDetailCriteria;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendWeworkMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSendDetailMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingTagMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.groupsend.dto.WeworkUserSendTargetPair;
import com.kuaike.scrm.groupsend.dto.request.AddOrModInnerGroupSendReq;
import com.kuaike.scrm.groupsend.dto.request.AddOrModReq;
import com.kuaike.scrm.groupsend.dto.request.GroupSendMarkReq;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchChatroomRespDto;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchContactResp;
import com.kuaike.scrm.groupsend.service.GroupSendDetailService;
import com.kuaike.scrm.groupsend.service.GroupSendTaskService;
import com.kuaike.scrm.groupsend.service.MultiSelectService;
import com.kuaike.scrm.service.MeetingCusParamEncryRelService;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupSendDetailServiceImpl
implements GroupSendDetailService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendDetailServiceImpl.class);
    @Autowired
    private MessageGroupSendDetailMapper groupSendDetailMapper;
    @Autowired
    private MessageGroupSendTaskMapper groupSendTaskMapper;
    @Autowired
    private MultiSelectService multiSelectService;
    @Autowired
    private ParamEncryService paramEncryService;
    @Autowired
    private GroupSendTaskService groupSendTaskService;
    @Autowired
    private MeetingTagMapper meetingTagMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MeetingMapper meetingMapper;
    @Autowired
    private MeetingSendDetailMapper meetingSendDetailMapper;
    @Resource
    private MeetingCusParamEncryRelService meetingCusParamEncryRelService;
    @Resource
    private MessageGroupSendWeworkMapper messageGroupSendWeworkMapper;
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.AbortPolicy());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDetail(AddOrModReq req, MessageGroupSendTask task, CurrentUserInfo currentUserInfo) {
        log.info("updateDetail with req={},task={},operatorId={}", new Object[]{req, task, currentUserInfo});
        MessageGroupSendDetailCriteria detailCriteria = new MessageGroupSendDetailCriteria();
        detailCriteria.createCriteria().andTaskIdEqualTo(task.getId()).andStatusIn((List)Lists.newArrayList((Object[])new Integer[]{SendStatus.TO_BE_SEND.getValue()}));
        this.groupSendDetailMapper.deleteByFilter(detailCriteria);
        List haveSendDetails = this.groupSendDetailMapper.queryByTaskIdAndStatus(task.getId(), (Collection)Lists.newArrayList((Object[])new Integer[]{SendStatus.ALREADY_SEND.getValue(), SendStatus.ALREADY_EXPIRE.getValue()}));
        Set<String> haveSendKeys = haveSendDetails.stream().map(a -> StringUtils.join((Object[])new String[]{a.getSendWeworkNum(), a.getReceiveId()}, (String)"$$")).collect(Collectors.toSet());
        ArrayList needAddDetails = Lists.newArrayList();
        String requestId = "";
        switch (GroupSendTaskType.getType((int)task.getTaskType())) {
            case SIDEBAR: 
            case QYAPI: 
            case VIP_GROUP_SEND_CUSTOMER: 
            case VIP_GROUP_SEND_CHATROOM: 
            case VIP_GROUP_SEND_NOTICE: {
                this.generateSendDetails(req, task, currentUserInfo, haveSendKeys, needAddDetails, requestId);
                break;
            }
            case CLIENT: {
                this.calClientSendDetails(task, req, haveSendKeys, needAddDetails);
                break;
            }
        }
        if (CollectionUtils.isEmpty((Collection)needAddDetails)) {
            this.groupSendTaskService.updateGroupSendTask(task, 0, SendStatus.ALREADY_SEND.getValue());
        } else {
            List partition = Lists.partition((List)needAddDetails, (int)50);
            for (List messageGroupSendDetails : partition) {
                this.fillExtField(task, messageGroupSendDetails);
                this.groupSendDetailMapper.batchInsert(messageGroupSendDetails);
            }
            this.groupSendTaskService.updateGroupSendTask(task, needAddDetails.size(), SendStatus.SENDING.getValue());
        }
    }

    private void calClientSendDetails(MessageGroupSendTask task, AddOrModReq req, Set<String> haveSendKeys, List<MessageGroupSendDetail> details) {
        Date nowTime = new Date();
        for (String weworkUserNum : req.getWeworkUserNums()) {
            MessageGroupSendDetail detail = new MessageGroupSendDetail();
            detail.setCorpId(task.getCorpId());
            detail.setSendTime(task.getSendTime());
            detail.setBizId(task.getBizId());
            detail.setCreateBy(Long.valueOf(-1L));
            detail.setCreateTime(nowTime);
            if (task.getFkType() == 1) {
                String param = "";
                detail.setExtField1(param);
            }
            detail.setReceiveId("emptyReceiverId");
            if (req.getQueryType().equals(QueryType.CONTACT.getType())) {
                detail.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
            } else {
                detail.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
            }
            detail.setSendWeworkNum(weworkUserNum);
            detail.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            detail.setTaskId(task.getId());
            detail.setUpdateBy(Long.valueOf(-1L));
            detail.setUpdateTime(nowTime);
            detail.setTaskType(task.getTaskType());
            detail.setDeadline(task.getDeadline());
            String key = StringUtils.join((Object[])new String[]{detail.getSendWeworkNum(), detail.getReceiveId()}, (String)"$$");
            if (haveSendKeys.contains(key)) continue;
            details.add(detail);
        }
    }

    private void calClientSendDetails2(MessageGroupSendTask task, AddOrModInnerGroupSendReq req, Set<String> haveSendKeys, List<MessageGroupSendDetail> details) {
        Date nowTime = new Date();
        for (String weworkUserNum : req.getWeworkUserNums()) {
            MessageGroupSendDetail detail = new MessageGroupSendDetail();
            detail.setCorpId(task.getCorpId());
            detail.setSendTime(task.getSendTime());
            detail.setBizId(task.getBizId());
            detail.setCreateBy(Long.valueOf(-1L));
            detail.setCreateTime(nowTime);
            if (task.getFkType() == 1) {
                String param = "";
                detail.setExtField1(param);
            }
            detail.setReceiveId("emptyReceiverId");
            detail.setReceiveType(req.getReceiveType());
            detail.setSendWeworkNum(weworkUserNum);
            detail.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            detail.setTaskId(task.getId());
            detail.setUpdateBy(Long.valueOf(-1L));
            detail.setUpdateTime(nowTime);
            detail.setTaskType(task.getTaskType());
            detail.setDeadline(task.getDeadline());
            String key = StringUtils.join((Object[])new String[]{detail.getSendWeworkNum(), detail.getReceiveId()}, (String)"$$");
            if (haveSendKeys.contains(key)) continue;
            details.add(detail);
        }
    }

    private String generateSendDetails(AddOrModReq req, MessageGroupSendTask task, CurrentUserInfo currentUserInfo, Set<String> haveSendKeys, List<MessageGroupSendDetail> needAddDetails, String requestId) {
        switch (QueryType.getByType((int)task.getQueryType())) {
            case CONTACT: {
                MultiSearchContactResp contactResp = this.multiSelectService.multiSearchContact(req.getGroupsendContact(), true);
                requestId = contactResp.getRequestId();
                if (CollectionUtils.isNotEmpty(contactResp.getList())) {
                    contactResp.setList(contactResp.getList().stream().filter(a -> !haveSendKeys.contains(StringUtils.join((Object[])new String[]{a.getWeworkNum(), a.getContactId()}, (String)"$$"))).collect(Collectors.toList()));
                }
                if (!CollectionUtils.isNotEmpty(contactResp.getList())) break;
                this.buildContactDetails(task, needAddDetails, contactResp, currentUserInfo);
                break;
            }
            case CHAT_ROOM: {
                if (req.getTaskType().equals(GroupSendTaskType.QYAPI.getValue()) || req.getTaskType().equals(GroupSendTaskType.CLIENT.getValue())) {
                    this.calClientSendDetails(task, req, haveSendKeys, needAddDetails);
                    break;
                }
                MultiSearchChatroomRespDto chatroomResp = this.multiSelectService.multiSearchChatroom(req.getGroupsendChatRoom(), true);
                requestId = chatroomResp.getRequestId();
                if (CollectionUtils.isNotEmpty(chatroomResp.getList())) {
                    chatroomResp.setList(chatroomResp.getList().stream().filter(a -> !haveSendKeys.contains(StringUtils.join((Object[])new String[]{a.getWeworkNum(), a.getChatroomId()}, (String)"$$"))).collect(Collectors.toList()));
                }
                if (!CollectionUtils.isNotEmpty(chatroomResp.getList())) break;
                this.buildChatroomDetails(task, needAddDetails, chatroomResp, currentUserInfo);
                break;
            }
            case QRCODE: {
                MultiSearchContactResp qrContactResp = this.multiSelectService.multiSearchQrcode(req.getGroupsendQrCodeContact(), true);
                requestId = qrContactResp.getRequestId();
                if (CollectionUtils.isNotEmpty(qrContactResp.getList())) {
                    qrContactResp.setList(qrContactResp.getList().stream().filter(a -> !haveSendKeys.contains(StringUtils.join((Object[])new String[]{a.getWeworkNum(), a.getContactId()}, (String)"$$"))).collect(Collectors.toList()));
                }
                if (!CollectionUtils.isNotEmpty(qrContactResp.getList())) break;
                this.buildContactDetails(task, needAddDetails, qrContactResp, currentUserInfo);
                break;
            }
        }
        task.setQueryRequestId(requestId);
        return requestId;
    }

    private void fillExtField(MessageGroupSendTask task, List<MessageGroupSendDetail> details) {
        if (task.getFkType().equals(GroupSendFkType.MEETING.getType())) {
            List paramsList = details.stream().map(a -> {
                if (task.getFkType().equals(GroupSendFkType.MEETING.getType())) {
                    return new MeetingParams(task.getFkTaskId(), task.getNum(), a.getSendWeworkNum(), a.getReceiveId(), a.getReceiveType(), Long.valueOf(0L));
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            List meetingEncryRespDtoList = this.paramEncryService.batchGenerateEncryMeetingParam(paramsList);
            try {
                this.meetingCusParamEncryRelService.batchInsertWhenGroupTaskFillExtField(task.getBizId(), meetingEncryRespDtoList);
            }
            catch (Exception e) {
                log.error("fillExtField \u63d2\u5165meetingCusParamEncryRel\u5f02\u5e38", (Throwable)e);
            }
            Map<String, String> encryKey2Params = meetingEncryRespDtoList.stream().collect(Collectors.toMap(a -> StringUtils.join((Object[])new Object[]{a.getGroupSendNum(), a.getMeetingId(), a.getWeworkUserNum(), a.getTargetId()}, (String)"$$"), MeetingEncryRespDto::getEncryParam));
            for (MessageGroupSendDetail item : details) {
                String key = StringUtils.join((Object[])new Object[]{task.getNum(), task.getFkTaskId(), item.getSendWeworkNum(), item.getReceiveId()}, (String)"$$");
                item.setExtField1(encryKey2Params.get(key));
            }
        }
    }

    private void buildChatroomDetails(MessageGroupSendTask task, List<MessageGroupSendDetail> details, MultiSearchChatroomRespDto chatroomResp, CurrentUserInfo currentUserInfo) {
        for (SelectedChatroom2WeworkUserDto selectedChatroom2WeworkUserDto : chatroomResp.getList()) {
            Date nowTime = new Date();
            MessageGroupSendDetail item = new MessageGroupSendDetail();
            item.setCorpId(task.getCorpId());
            item.setSendTime(task.getSendTime());
            item.setBizId(task.getBizId());
            item.setCreateBy(currentUserInfo.getId());
            item.setCreateTime(nowTime);
            if (task.getFkType() == 1) {
                String param = "";
                item.setExtField1(param);
            }
            item.setReceiveId(selectedChatroom2WeworkUserDto.getChatroomId());
            item.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
            item.setUserDigitId(selectedChatroom2WeworkUserDto.getWeworkUserDigitId());
            item.setReceiveDigitId(selectedChatroom2WeworkUserDto.getChatroomDigitId());
            item.setSendWeworkNum(selectedChatroom2WeworkUserDto.getWeworkNum());
            item.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            item.setTaskId(task.getId());
            item.setUpdateBy(currentUserInfo.getId());
            item.setUpdateTime(nowTime);
            item.setDeadline(task.getDeadline());
            item.setTaskType(task.getTaskType());
            details.add(item);
        }
    }

    private void buildContactDetails(MessageGroupSendTask task, List<MessageGroupSendDetail> details, MultiSearchContactResp contactResp, CurrentUserInfo currentUserInfo) {
        for (SelectedContact2WeworkUserDto selectedContact2WeworkUserDto : contactResp.getList()) {
            Date nowTime = new Date();
            MessageGroupSendDetail item = new MessageGroupSendDetail();
            item.setCorpId(task.getCorpId());
            item.setSendTime(task.getSendTime());
            item.setBizId(task.getBizId());
            item.setCreateBy(currentUserInfo.getId());
            item.setCreateTime(nowTime);
            if (task.getFkType().intValue() == GroupSendFkType.MEETING.getType()) {
                String param = "";
                item.setExtField1(param);
            }
            item.setReceiveId(selectedContact2WeworkUserDto.getContactId());
            item.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
            item.setUserDigitId(selectedContact2WeworkUserDto.getWeworkUserDigitId());
            item.setReceiveDigitId(selectedContact2WeworkUserDto.getContactDigitId());
            item.setSendWeworkNum(selectedContact2WeworkUserDto.getWeworkNum());
            item.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            item.setTaskId(task.getId());
            item.setUpdateBy(currentUserInfo.getId());
            item.setUpdateTime(nowTime);
            item.setDeadline(task.getDeadline());
            item.setTaskType(task.getTaskType());
            details.add(item);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDetails(Long taskId, CurrentUserInfo currentUserInfo) {
        log.info("deleteDetails with taskId={},operatorId={}", (Object)taskId, (Object)currentUserInfo.getId());
        MessageGroupSendDetailCriteria detailCriteria = new MessageGroupSendDetailCriteria();
        detailCriteria.createCriteria().andTaskIdEqualTo(taskId).andStatusIn((List)Lists.newArrayList((Object[])new Integer[]{SendStatus.TO_BE_SEND.getValue()}));
        this.groupSendDetailMapper.deleteByFilter(detailCriteria);
    }

    @Override
    public void deleteDetail(GroupSendMarkReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("deleteDetail with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validate();
        MessageGroupSendDetail detail = (MessageGroupSendDetail)this.groupSendDetailMapper.selectByPrimaryKey((Object)req.getDetailId());
        if (detail == null || detail.getIsDeleted() == 1) {
            log.info("detail\u4e0d\u5b58\u5728, group_send_detail.id={}", (Object)req.getDetailId());
            return;
        }
        detail.setIsDeleted(Integer.valueOf(1));
        this.groupSendDetailMapper.updateByPrimaryKey((Object)detail);
    }

    @Override
    public void updateDetail2(AddOrModInnerGroupSendReq req, MessageGroupSendTask task, CurrentUserInfo currentUserInfo) {
        log.info("updateDetail2 with req={},task={},operatorId={}", new Object[]{req, task, currentUserInfo});
        MessageGroupSendDetailCriteria detailCriteria = new MessageGroupSendDetailCriteria();
        detailCriteria.createCriteria().andTaskIdEqualTo(task.getId()).andStatusIn((List)Lists.newArrayList((Object[])new Integer[]{SendStatus.TO_BE_SEND.getValue()}));
        this.groupSendDetailMapper.deleteByFilter(detailCriteria);
        List haveSendDetails = this.groupSendDetailMapper.queryByTaskIdAndStatus(task.getId(), (Collection)Lists.newArrayList((Object[])new Integer[]{SendStatus.ALREADY_SEND.getValue(), SendStatus.ALREADY_EXPIRE.getValue()}));
        Set<String> haveSendKeys = haveSendDetails.stream().map(a -> StringUtils.join((Object[])new String[]{a.getSendWeworkNum(), a.getReceiveId()}, (String)"$$")).collect(Collectors.toSet());
        ArrayList needAddDetails = Lists.newArrayList();
        switch (GroupSendTaskType.getType((int)req.getTaskType())) {
            case QYAPI: {
                if (req.getReceiveType().equals(ReceiveType.CHATROOM.getType())) {
                    this.calClientSendDetails2(task, req, haveSendKeys, needAddDetails);
                    break;
                }
                this.buildDetails(req, task, currentUserInfo, haveSendKeys, needAddDetails);
                break;
            }
            case SIDEBAR: {
                this.buildDetails(req, task, currentUserInfo, haveSendKeys, needAddDetails);
                break;
            }
            case CLIENT: {
                this.calClientSendDetails2(task, req, haveSendKeys, needAddDetails);
                break;
            }
        }
        if (CollectionUtils.isEmpty((Collection)needAddDetails)) {
            this.groupSendTaskService.updateGroupSendTask(task, 0, SendStatus.ALREADY_SEND.getValue());
        } else {
            List partition = Lists.partition((List)needAddDetails, (int)50);
            for (List messageGroupSendDetails : partition) {
                this.fillExtField(task, messageGroupSendDetails);
                this.groupSendDetailMapper.batchInsert(messageGroupSendDetails);
            }
            this.groupSendTaskService.updateGroupSendTask(task, needAddDetails.size(), SendStatus.SENDING.getValue());
        }
    }

    private void buildDetails(AddOrModInnerGroupSendReq req, MessageGroupSendTask task, CurrentUserInfo currentUserInfo, Set<String> haveSendKeys, List<MessageGroupSendDetail> needAddDetails) {
        Date now = new Date();
        for (WeworkUserSendTargetPair sendTargetPair : req.getSendTargetPairs()) {
            MessageGroupSendDetail detail = new MessageGroupSendDetail();
            detail.setDeadline(req.getDeadlineTime());
            detail.setTaskType(req.getTaskType());
            detail.setReceiveType(req.getReceiveType());
            detail.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            detail.setSendWeworkNum(sendTargetPair.getWeworkUserNum());
            detail.setTaskId(task.getId());
            detail.setReceiveId(sendTargetPair.getTargetId());
            if (task.getFkType() == 1) {
                detail.setExtField1("");
            }
            detail.setBizId(req.getFkTaskId());
            detail.setSendTime(req.getSendTime());
            detail.setUpdateTime(now);
            detail.setCreateTime(now);
            detail.setUpdateBy(currentUserInfo.getId());
            detail.setCreateBy(currentUserInfo.getId());
            String key = StringUtils.join((Object[])new String[]{detail.getSendWeworkNum(), detail.getReceiveId()}, (String)"$$");
            if (haveSendKeys.contains(key)) continue;
            needAddDetails.add(detail);
        }
    }

    @Override
    public void updateSendCompleteByIds(MessageGroupSendTask task, List<Long> detailIds, Integer sendStatus) {
        if (CollectionUtils.isEmpty(detailIds)) {
            return;
        }
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        List details = this.groupSendDetailMapper.queryByIds(detailIds);
        this.groupSendDetailMapper.updateSendCompleteByIds(detailIds, Integer.valueOf(SendStatus.ALREADY_SEND.getValue()));
        if (GroupSendFkType.MEETING.getType() == task.getFkType().intValue()) {
            this.executorService.execute(() -> {
                try {
                    for (MessageGroupSendDetail detail : details) {
                        this.updateStatusAndModifyTag(task, detail, currentUserInfo);
                    }
                }
                catch (Exception ex) {
                    log.info("\u66f4\u65b0\u53d1\u9001\u72b6\u6001\u548c\u65b0\u589e\u6807\u7b7e\u5f02\u5e38:", (Throwable)ex);
                }
            });
        }
    }

    private void updateStatusAndModifyTag(MessageGroupSendTask task, MessageGroupSendDetail groupSendDetail, CurrentUserInfo currentUserInfo) {
        this.meetingSendDetailMapper.updateSendStatus(task.getFkTaskId(), task.getNum(), groupSendDetail.getSendWeworkNum(), groupSendDetail.getReceiveId());
        if (NumberUtils.INTEGER_ZERO.equals(groupSendDetail.getReceiveType())) {
            log.info("\u53d1\u9001\u5bf9\u8c61\u662f\u7fa4\uff0c\u4e0d\u9700\u8981\u6253\u6807\u7b7e");
            return;
        }
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)task.getFkTaskId());
        if (Objects.isNull(meeting)) {
            log.warn("updateStatusAndModifyTag,\u6839\u636e\u4f1a\u8baeid:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)task.getFkTaskId());
            return;
        }
        List tagIds = this.meetingTagMapper.selectTagIdsByMeetingIdAndType(meeting.getNum(), NumberUtils.INTEGER_ZERO);
        if (CollectionUtils.isEmpty((Collection)tagIds)) {
            log.info("\u4f1a\u8baeid:{}\u672a\u8bbe\u7f6e\u9884\u7ea6\u5ba2\u6237\u6807\u7b7e", (Object)task.getFkTaskId());
            return;
        }
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(groupSendDetail.getSendWeworkNum());
        ModifyTagDto modifyTagDto = new ModifyTagDto();
        modifyTagDto.setBizId(currentUserInfo.getBizId());
        modifyTagDto.setCorpId(currentUserInfo.getCorpId());
        modifyTagDto.setWeworkUserId(weworkUserId);
        modifyTagDto.setContactId(groupSendDetail.getReceiveId());
        modifyTagDto.setAddTagIds(tagIds);
        log.info("updateStatusAndModifyTag: \u6253\u6807\u7b7e:{}", (Object)modifyTagDto);
        this.contactOpService.modifyTag(modifyTagDto);
    }

    @Override
    public void updateStatusAndCompleteTimeWithMsgId(List<GroupSendMsgDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        log.info("updateStatusAndCompleteTimeWithMsgId with list size={}", (Object)list.size());
        this.groupSendDetailMapper.updateStatusAndCompleteTimeWithMsgId(list);
        list = list.stream().filter(a -> a.getSendStatus().equals(SendStatus.ALREADY_SEND.getValue())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            log.info("already send list is empty,exit");
            return;
        }
        List details = this.groupSendDetailMapper.queryListByMsgIdAndSendReceive(list);
        try {
            this.updateSendWeworkSendStatusToAlreadySend(details);
        }
        catch (Exception e) {
            log.error("updateStatusAndCompleteTimeWithMsgId,updateSendWeworkSendStatusToAlreadySend error", (Throwable)e);
        }
        Map<Long, List<MessageGroupSendDetail>> taskId2Details = details.stream().collect(Collectors.groupingBy(MessageGroupSendDetail::getTaskId));
        List tasks = this.groupSendTaskMapper.queryByIds(taskId2Details.keySet());
        tasks = tasks.stream().filter(a -> a.getFkType().equals(GroupSendFkType.MEETING.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tasks)) {
            log.info("not meeting task,exit");
            return;
        }
        for (MessageGroupSendTask task : tasks) {
            this.executorService.execute(() -> {
                try {
                    CurrentUserInfo currentUserInfo = new CurrentUserInfo();
                    currentUserInfo.setCorpId(task.getCorpId());
                    currentUserInfo.setBizId(task.getBizId());
                    for (MessageGroupSendDetail detail : details) {
                        this.updateStatusAndModifyTag(task, detail, currentUserInfo);
                    }
                }
                catch (Exception ex) {
                    log.info("\u66f4\u65b0\u53d1\u9001\u72b6\u6001\u548c\u65b0\u589e\u6807\u7b7e\u5f02\u5e38:", (Throwable)ex);
                }
            });
        }
    }

    private void updateSendWeworkSendStatusToAlreadySend(List<MessageGroupSendDetail> list) {
        log.info("updateSendWeworkSendStatusToAlreadySend,list:{}", (Object)list.size());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<GroupSendWeworkDto> batchUpdateList = new ArrayList<GroupSendWeworkDto>();
        HashSet<String> alreadySendKeys = new HashSet<String>();
        for (MessageGroupSendDetail messageGroupSendDetail : list) {
            String key;
            String sendWeworkNum;
            Long taskId;
            Integer status = messageGroupSendDetail.getStatus();
            if (SendStatus.ALREADY_SEND.getValue() != status.intValue() || (taskId = messageGroupSendDetail.getTaskId()) == null || StringUtils.isBlank((CharSequence)(sendWeworkNum = messageGroupSendDetail.getSendWeworkNum())) || alreadySendKeys.contains(key = taskId + "$" + sendWeworkNum)) continue;
            alreadySendKeys.add(key);
            GroupSendWeworkDto dto = new GroupSendWeworkDto();
            dto.setTaskId(taskId);
            dto.setWeworkUserNum(sendWeworkNum);
            dto.setSendTime(messageGroupSendDetail.getSendTime());
            log.info("updateSendWeworkSendStatusToAlreadySend,update:{}", (Object)dto);
            batchUpdateList.add(dto);
        }
        if (CollectionUtils.isEmpty(batchUpdateList)) {
            return;
        }
        this.messageGroupSendWeworkMapper.batchUpdateSendStatusToAlreadySend(batchUpdateList);
    }
}

