/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UpdateGroupSendReq {
    String taskNum;
    Integer fkType;
    Long fkId;
    Date deadline;
    List<UniformMsgDto> contents;
    Long operatorId;
    Integer source;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.taskNum), (Object)"taskNum is null or empty");
        Preconditions.checkArgument((this.fkType != null ? 1 : 0) != 0, (Object)"fkType is null");
        Preconditions.checkArgument((this.fkId != null ? 1 : 0) != 0, (Object)"fkId is null");
        Preconditions.checkArgument((this.deadline != null || CollectionUtils.isNotEmpty(this.contents) ? 1 : 0) != 0, (Object)"deadline,contents can not be null at same time");
        Preconditions.checkArgument((this.operatorId != null ? 1 : 0) != 0, (Object)"operatorId is null");
        if (CollectionUtils.isNotEmpty(this.contents)) {
            this.contents.forEach(a -> a.validate());
        }
    }

    public String getTaskNum() {
        return this.taskNum;
    }

    public Integer getFkType() {
        return this.fkType;
    }

    public Long getFkId() {
        return this.fkId;
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public List<UniformMsgDto> getContents() {
        return this.contents;
    }

    public Long getOperatorId() {
        return this.operatorId;
    }

    public Integer getSource() {
        return this.source;
    }

    public void setTaskNum(String taskNum) {
        this.taskNum = taskNum;
    }

    public void setFkType(Integer fkType) {
        this.fkType = fkType;
    }

    public void setFkId(Long fkId) {
        this.fkId = fkId;
    }

    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }

    public void setContents(List<UniformMsgDto> contents) {
        this.contents = contents;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGroupSendReq)) {
            return false;
        }
        UpdateGroupSendReq other = (UpdateGroupSendReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$fkType = this.getFkType();
        Integer other$fkType = other.getFkType();
        if (this$fkType == null ? other$fkType != null : !((Object)this$fkType).equals(other$fkType)) {
            return false;
        }
        Long this$fkId = this.getFkId();
        Long other$fkId = other.getFkId();
        if (this$fkId == null ? other$fkId != null : !((Object)this$fkId).equals(other$fkId)) {
            return false;
        }
        Long this$operatorId = this.getOperatorId();
        Long other$operatorId = other.getOperatorId();
        if (this$operatorId == null ? other$operatorId != null : !((Object)this$operatorId).equals(other$operatorId)) {
            return false;
        }
        Integer this$source = this.getSource();
        Integer other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$taskNum = this.getTaskNum();
        String other$taskNum = other.getTaskNum();
        if (this$taskNum == null ? other$taskNum != null : !this$taskNum.equals(other$taskNum)) {
            return false;
        }
        Date this$deadline = this.getDeadline();
        Date other$deadline = other.getDeadline();
        if (this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline)) {
            return false;
        }
        List<UniformMsgDto> this$contents = this.getContents();
        List<UniformMsgDto> other$contents = other.getContents();
        return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateGroupSendReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $fkType = this.getFkType();
        result = result * 59 + ($fkType == null ? 43 : ((Object)$fkType).hashCode());
        Long $fkId = this.getFkId();
        result = result * 59 + ($fkId == null ? 43 : ((Object)$fkId).hashCode());
        Long $operatorId = this.getOperatorId();
        result = result * 59 + ($operatorId == null ? 43 : ((Object)$operatorId).hashCode());
        Integer $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $taskNum = this.getTaskNum();
        result = result * 59 + ($taskNum == null ? 43 : $taskNum.hashCode());
        Date $deadline = this.getDeadline();
        result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
        List<UniformMsgDto> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateGroupSendReq(taskNum=" + this.getTaskNum() + ", fkType=" + this.getFkType() + ", fkId=" + this.getFkId() + ", deadline=" + this.getDeadline() + ", contents=" + this.getContents() + ", operatorId=" + this.getOperatorId() + ", source=" + this.getSource() + ")";
    }
}

