/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.impl.PlaceHolderService;
import com.kuaike.scrm.common.utils.BaijiacloudParamBuildUtils;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.UrlUtils;
import com.kuaike.scrm.dal.meeting.dto.MeetingSettingInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSettingMapper;
import com.kuaike.scrm.dto.req.SettingAddReqDto;
import com.kuaike.scrm.dto.req.SettingBaseDto;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.service.MeetingSettingService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MeetingSettingServiceImpl
implements MeetingSettingService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MeetingSettingServiceImpl.class);
    @Autowired
    private MeetingSettingMapper settingMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Resource
    private PlaceHolderService placeHolderService;
    @Resource
    private MeetingCacheService meetingCacheService;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService threadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024), (ThreadFactory)new NamedThreadFactory("meetingSettingService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public void addSetting(SettingAddReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        MeetingSetting setting = new MeetingSetting();
        setting.setNum(this.idGen.getNum());
        setting.setBizId(userInfo.getBizId());
        setting.setCorpId(userInfo.getCorpId());
        setting.setCreateBy(userInfo.getId());
        setting.setCreateTime(new Date());
        setting.setUpdateTime(new Date());
        setting.setDominSite(reqDto.getDominSite());
        setting.setBjyId(reqDto.getBjyId());
        setting.setBjyKey(reqDto.getBjyKey());
        String resultJson = null;
        try {
            resultJson = this.configInfoToBjy(userInfo.getBizId(), null, YnEnum.YES.getValue());
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0cbizId:{}", (Object)userInfo.getBizId(), (Object)e);
        }
        setting.setBjyJson(resultJson);
        this.settingMapper.saveSetting(setting);
        this.threadPool.submit(() -> {
            MeetingSetting meetingSetting = this.getSettingByBizId(userInfo.getBizId());
            this.meetingCacheService.setMeetingSetting(userInfo.getBizId(), meetingSetting);
        });
    }

    @Override
    public void modSetting(SettingBaseDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        MeetingSettingInfo settingInfo = new MeetingSettingInfo(reqDto.getDominSite(), reqDto.getBjyId(), reqDto.getBjyKey(), userInfo.getId(), reqDto.getId(), userInfo.getBizId());
        String resultJson = null;
        try {
            resultJson = this.configInfoToBjy(userInfo.getBizId(), null, YnEnum.YES.getValue());
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0cbizId:{}", (Object)userInfo.getBizId(), (Object)e);
        }
        settingInfo.setBjyJson(resultJson);
        this.settingMapper.updateSetting(settingInfo);
        this.threadPool.submit(() -> {
            MeetingSetting meetingSetting = this.getSettingByBizId(userInfo.getBizId());
            this.meetingCacheService.setMeetingSetting(userInfo.getBizId(), meetingSetting);
        });
    }

    @Override
    public SettingBaseDto getSettingDetail() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        MeetingSetting setting = this.settingMapper.getSetting(userInfo.getBizId());
        if (Objects.nonNull(setting)) {
            SettingBaseDto resp = SettingBaseDto.from(setting);
            return resp;
        }
        return null;
    }

    @Override
    public MeetingSetting getSettingByCorpId(String corpId) {
        return this.settingMapper.getSettingByCorpId(corpId);
    }

    @Override
    public MeetingSetting getSettingByBizId(Long bizId) {
        return this.settingMapper.getSetting(bizId);
    }

    public void afterPropertiesSet() throws Exception {
        List meetingSettings = this.settingMapper.queryUnboundSetting();
        if (CollectionUtils.isEmpty((Collection)meetingSettings)) {
            return;
        }
        for (MeetingSetting meetingSetting : meetingSettings) {
            String resultJson = null;
            try {
                resultJson = this.configInfoToBjy(meetingSetting.getBizId(), meetingSetting.getBjyId(), YnEnum.YES.getValue());
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0cbizId:{}", (Object)meetingSetting.getBizId(), (Object)e);
            }
            MeetingSettingInfo update = new MeetingSettingInfo();
            update.setId(meetingSetting.getId());
            update.setBjyJson(resultJson);
            this.settingMapper.updateBjyJsonById(update);
        }
    }

    public String configInfoToBjy(Long bizId, String bjyId, Integer isModify) {
        String domain = UrlUtils.assembleUrl((String)this.placeHolderService.getScrmProtocal(), (String)this.placeHolderService.getScrmMeetingBjyCallback());
        String keywordCallBackUrl = UrlUtils.assembleUrl((String)domain, (String)this.placeHolderService.getLiveChatKeywordCallBack());
        String userEventCallbackUrl = UrlUtils.assembleUrl((String)domain, (String)this.placeHolderService.getUserEventCallbackUrl());
        Map param = BaijiacloudParamBuildUtils.buildConfigParam((String)keywordCallBackUrl, (String)this.placeHolderService.getEnableLivechatKeyword(), (String)this.placeHolderService.getEnableUseEventCallback(), (String)userEventCallbackUrl, (String)this.placeHolderService.getEnableLiveSellPcStudent(), (String)this.placeHolderService.getEnabelUserLuckyBag());
        if (YnEnum.YES.getValue().equals(isModify) && StringUtils.isBlank((CharSequence)bjyId)) {
            MeetingSetting setting = this.settingMapper.getSetting(bizId);
            if (setting == null || setting.getIsDeleted() == 1 || StringUtils.isBlank((CharSequence)setting.getBjyId())) {
                log.info("not config meetingSetting bizId: {}", (Object)bizId);
                return null;
            }
            bjyId = setting.getBjyId();
        }
        JSONObject response = this.bjyPartnerService.bjyPost(bjyId, this.placeHolderService.getAccountConfigUrl(), param);
        HashMap result = Maps.newHashMap();
        result.put("param", JSON.toJSONString((Object)param));
        result.put("response", JSON.toJSONString((Object)response));
        result.put("url", JSON.toJSONString((Object)this.placeHolderService.getAccountConfigUrl()));
        return JSON.toJSONString((Object)result);
    }
}

