/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.order.service.impl;

import cn.kinyun.customer.center.dto.req.TuitionReportReq;
import cn.kinyun.customer.center.dto.resp.TuitionReportDto;
import cn.kinyun.customer.center.dto.resp.TuitionReportRespDto;
import cn.kinyun.customer.center.enums.TuitionReportTypeEnum;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.pay.business.dto.response.PayConfigChannelItem;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDto;
import cn.kinyun.pay.business.dto.response.PayConfigGroupItem;
import cn.kinyun.pay.business.dto.response.RefundMchInfo;
import cn.kinyun.pay.business.service.ScrmPayConfigService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.goods.model.ProductEsModel;
import com.kuaike.scrm.order.service.TuitionReportService;
import com.kuaike.scrm.system.dto.response.ExamTypeDto;
import com.kuaike.scrm.system.dto.response.SchoolInfo;
import com.kuaike.scrm.system.dto.response.SchoolListRespDto;
import com.kuaike.scrm.system.dto.response.SchoolRegionDto;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TuitionReportServiceImpl
implements TuitionReportService {
    private static final Logger log = LoggerFactory.getLogger(TuitionReportServiceImpl.class);
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerOrderService ccCustomerOrderService;
    @Autowired
    private ScrmNetSchoolService scrmNetSchoolService;
    @Autowired
    private ScrmPayConfigService scrmPayConfigService;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private ShopSpuMapper shopSpuMapper;
    @Value(value="${scrm.elasticsearch.shopProductIndex}")
    private String shopProductIndex;
    private static final String TYPE = "doc";
    public static final String DATA_SOURCE_NET_SCHOOL = "\u7f51\u6821";
    private static final String DATA_SOURCE_SCRM = "SCRM";

    @Override
    public List<TuitionReportDto> tuitionReport(TuitionReportReq req) {
        List examInfos;
        TuitionReportRespDto tuitionReportRespDto;
        Long bizId;
        log.info("tuitionReport,req:{}", (Object)req);
        if (!Objects.equals(Boolean.TRUE, req.getIsExport())) {
            CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
            req.setBizId(userInfo.getBizId());
            bizId = userInfo.getBizId();
            boolean isMainBiz = this.scrmBizService.isMainBiz(userInfo.getBizId());
            req.setIsMainBizId(Boolean.valueOf(isMainBiz));
            if (isMainBiz) {
                req.setExcludeBizIds(this.scrmBizService.excludeBizIds());
            }
        } else {
            bizId = req.getBizId();
        }
        if (StringUtils.isNotBlank((CharSequence)req.getProductNameQuery())) {
            String productName = req.getProductNameQuery().replaceFirst("^\u3010[^\u3011]*\u3011", "");
            List<String> productIds = this.queryProductIds(req.getBizId(), req.getExcludeBizIds(), productName);
            if (CollectionUtils.isEmpty(productIds)) {
                log.info("\u6839\u636e\u8bf7\u6c42\u53c2\u6570\u672a\u67e5\u8be2\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u5546\u54c1");
                return Collections.emptyList();
            }
            req.setSkuNos(productIds);
        }
        if ((tuitionReportRespDto = this.ccCustomerOrderService.tuitionReportList(req)) == null || CollectionUtils.isEmpty((Collection)tuitionReportRespDto.getTuitionReportDtos())) {
            log.info("\u6839\u636e\u67e5\u8be2\u6761\u4ef6req:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req);
            req.setPageDto(new PageDto());
            return Collections.emptyList();
        }
        req.setPageDto(tuitionReportRespDto.getPageDto());
        HashSet deptIds = Sets.newHashSet();
        HashSet productIds = Sets.newHashSet();
        HashSet schoolIds = Sets.newHashSet();
        HashSet payGroupKeys = Sets.newHashSet();
        HashSet refundSerialNos = Sets.newHashSet();
        for (TuitionReportDto tuitionReportDto : tuitionReportRespDto.getTuitionReportDtos()) {
            if (Objects.nonNull(tuitionReportDto.getAchieveDepartId())) {
                deptIds.add(tuitionReportDto.getAchieveDepartId());
            }
            productIds.add(tuitionReportDto.getSkuNo());
            schoolIds.add(tuitionReportDto.getSchoolId());
            payGroupKeys.add(tuitionReportDto.getPayGroupKey());
            if (!StringUtils.isNotBlank((CharSequence)tuitionReportDto.getRefundSerialNo())) continue;
            refundSerialNos.add(tuitionReportDto.getRefundSerialNo());
        }
        Map deptId2NameMap = null;
        if (CollectionUtils.isNotEmpty((Collection)deptIds)) {
            deptId2NameMap = this.organizationMapper.queryIdNameMapByIds((Collection)deptIds);
        }
        List shopSpus = this.shopSpuMapper.selectByProductIds((Collection)productIds);
        HashMap productId2Spu = Maps.newHashMap();
        HashSet examIds = Sets.newHashSet();
        for (ShopSpu shopSpu : shopSpus) {
            productId2Spu.put(shopSpu.getProductId(), shopSpu);
            if (Objects.nonNull(shopSpu.getExamType())) {
                examIds.add(shopSpu.getExamType());
            }
            if (!Objects.nonNull(shopSpu.getSpecificExam())) continue;
            examIds.add(shopSpu.getSpecificExam());
        }
        HashMap netSchoolId2Name = Maps.newHashMap();
        Map<Object, Object> schoolId2RegionNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)schoolIds)) {
            List schoolRegionDtos;
            SchoolListRespDto schoolListRespDto = this.scrmNetSchoolService.schoolSimpleInfo(bizId, (Set)schoolIds);
            if (schoolListRespDto != null && CollectionUtils.isNotEmpty((Collection)schoolListRespDto.getData())) {
                for (SchoolInfo schoolInfo : schoolListRespDto.getData()) {
                    netSchoolId2Name.put(Long.valueOf(schoolInfo.getId().intValue()), schoolInfo.getOrgName());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(schoolRegionDtos = this.scrmNetSchoolService.getSchoolRegionBySchoolIds((List)Lists.newArrayList((Iterable)schoolIds), bizId)))) {
                schoolId2RegionNameMap = schoolRegionDtos.stream().collect(Collectors.toMap(SchoolRegionDto::getSchoolId, SchoolRegionDto::getOrgName));
            }
        }
        Map<Object, Object> examId2NameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)examIds) && CollectionUtils.isNotEmpty((Collection)(examInfos = this.scrmNetSchoolService.getExamTypeByIds(bizId, (List)Lists.newArrayList((Iterable)examIds))))) {
            examId2NameMap = examInfos.stream().collect(Collectors.toMap(ExamTypeDto::getId, ExamTypeDto::getExamTypeName));
        }
        List payConfigGroupDtos = this.scrmPayConfigService.queryConfigGroupByGroupKeys((Set)payGroupKeys);
        Map<String, List> payGroupKey2PayConfigGroupItems = payConfigGroupDtos.stream().collect(Collectors.toMap(PayConfigGroupDto::getGroupKey, PayConfigGroupDto::getDetail));
        List refundMchInfos = refundSerialNos.isEmpty() ? Collections.emptyList() : this.scrmPayConfigService.getRefundMchInfo((Set)refundSerialNos);
        Map<String, RefundMchInfo> refundSerialNo2RefundMchInfo = refundMchInfos.stream().collect(Collectors.toMap(RefundMchInfo::getRefundSerialNo, refundMchInfo -> refundMchInfo));
        for (TuitionReportDto tuitionReportDto : tuitionReportRespDto.getTuitionReportDtos()) {
            RefundMchInfo refundMchInfo2;
            tuitionReportDto.setMerchantName((String)schoolId2RegionNameMap.get(tuitionReportDto.getSchoolId()));
            if (Objects.nonNull(tuitionReportDto.getAchieveDepartId()) && MapUtils.isNotEmpty((Map)deptId2NameMap)) {
                tuitionReportDto.setAchieveDepartDesc((String)deptId2NameMap.get(tuitionReportDto.getAchieveDepartId()));
            }
            if (TuitionReportTypeEnum.PAYMENT.getDesc().equals(tuitionReportDto.getBusinessDataType())) {
                Map payGroupKey2PayConfigGroupItem;
                List payConfigGroupItems = payGroupKey2PayConfigGroupItems.get(tuitionReportDto.getPayGroupKey());
                if (CollectionUtils.isNotEmpty((Collection)payConfigGroupItems) && (payGroupKey2PayConfigGroupItem = payConfigGroupItems.stream().collect(Collectors.toMap(PayConfigChannelItem::getPayChannelType, Function.identity(), (k, v) -> k))).containsKey(tuitionReportDto.getChannelType())) {
                    tuitionReportDto.setMerchantCode(((PayConfigGroupItem)payGroupKey2PayConfigGroupItem.get(tuitionReportDto.getChannelType())).getMchId());
                }
            } else if (StringUtils.isNotBlank((CharSequence)tuitionReportDto.getRefundSerialNo()) && (refundMchInfo2 = refundSerialNo2RefundMchInfo.get(tuitionReportDto.getRefundSerialNo())) != null) {
                tuitionReportDto.setMerchantCode(refundMchInfo2.getMchId());
            }
            tuitionReportDto.setSchoolName((String)netSchoolId2Name.get(tuitionReportDto.getSchoolId()));
            ShopSpu shopSpu = (ShopSpu)productId2Spu.get(tuitionReportDto.getSkuNo());
            if (shopSpu == null) {
                log.error("\u6839\u636e\u5546\u54c1id:{}\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f", (Object)tuitionReportDto.getSkuNo());
                tuitionReportDto.setDataSource(DATA_SOURCE_NET_SCHOOL);
                continue;
            }
            if (GoodsOrderSource.NET_SCHOOL.getSource() == shopSpu.getSource().intValue()) {
                tuitionReportDto.setDataSource(DATA_SOURCE_NET_SCHOOL);
            } else {
                tuitionReportDto.setDataSource(DATA_SOURCE_SCRM);
            }
            String skuName = (String)JSON.parseObject((String)shopSpu.getSpuBody()).get((Object)"title");
            tuitionReportDto.setSkuName(skuName);
            if (Objects.nonNull(shopSpu.getExamType())) {
                tuitionReportDto.setExamTypeName((String)examId2NameMap.get(shopSpu.getExamType()));
            }
            if (Objects.nonNull(shopSpu.getSpecificExam())) {
                tuitionReportDto.setSpecificExamName((String)examId2NameMap.get(shopSpu.getSpecificExam()));
            }
            if (StringUtils.isNotBlank((CharSequence)shopSpu.getCourseFormat())) {
                tuitionReportDto.setCourseFormat(shopSpu.getCourseFormat());
            }
            if (!StringUtils.isNotBlank((CharSequence)shopSpu.getLivePlatform())) continue;
            tuitionReportDto.setLivePlatform(shopSpu.getLivePlatform());
        }
        return tuitionReportRespDto.getTuitionReportDtos();
    }

    public List<String> queryProductIds(Long bizId, List<Long> excludeBizIds, String productNameQuery) {
        log.info("queryProductIds bizId: {},excludeBizIds:{}, productNameQuery:{}", new Object[]{bizId, excludeBizIds, productNameQuery});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty(excludeBizIds)) {
            queryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"bizId", excludeBizIds));
        } else {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)bizId));
        }
        if (StringUtils.isNotBlank((CharSequence)productNameQuery)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"title", (Object)productNameQuery));
        }
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("productId.keyword");
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopProductIndex});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        return this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
    }

    private List<String> executeQueryAndDealResult(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
        }
        ArrayList productIds = Lists.newArrayList();
        if (Objects.isNull(searchResponse)) {
            return productIds;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        long totalHits = hits.getTotalHits();
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            ProductEsModel productEsModel = (ProductEsModel)JSON.parseObject((String)sourceAsString, ProductEsModel.class);
            productIds.add(productEsModel.getProductId());
        });
        return productIds;
    }
}

