/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.goods.service.impl;

import cn.kinyun.customer.center.service.YongYouService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdDto;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.NetSchoolGoodsTypeEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.coupon.service.impl.HandleBjyApiService;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.meeting.dto.MeetingGoodsRelDto;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsRel;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGoodsRelMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.shop.dto.GoodsListQueryParam;
import com.kuaike.scrm.dal.shop.dto.SpuProductIdReq;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.goods.dto.SkuItemDto;
import com.kuaike.scrm.goods.enums.GoodsSkuStatus;
import com.kuaike.scrm.goods.enums.GoodsSpuStatus;
import com.kuaike.scrm.goods.model.ProductEsModel;
import com.kuaike.scrm.goods.req.DetailByMeetingReq;
import com.kuaike.scrm.goods.req.SpuCreateReq;
import com.kuaike.scrm.goods.req.SpuDetailReq;
import com.kuaike.scrm.goods.req.SpuListQueryParam;
import com.kuaike.scrm.goods.req.SpuUpdateReq;
import com.kuaike.scrm.goods.resp.SpuDetailResp;
import com.kuaike.scrm.goods.resp.SpuListItem;
import com.kuaike.scrm.goods.resp.SpuStatusStatisticResp;
import com.kuaike.scrm.goods.service.GoodsEsService;
import com.kuaike.scrm.goods.service.GoodsService;
import com.kuaike.scrm.order.service.GoodsOrderEsService;
import com.kuaike.scrm.system.dto.request.ExamTypeReq;
import com.kuaike.scrm.system.dto.response.ExamTypeDto;
import com.kuaike.scrm.system.dto.response.SchoolInfo;
import com.kuaike.scrm.system.dto.response.SchoolListRespDto;
import com.kuaike.scrm.system.dto.response.SchoolRegionDto;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsServiceImpl
implements GoodsService {
    private static final Logger log = LoggerFactory.getLogger(GoodsServiceImpl.class);
    @Resource
    private IdGen idGen;
    @Resource
    private ShopSpuMapper shopSpuMapper;
    @Resource
    private ShopSkuMapper skuMapper;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private GoodsEsService goodsEsService;
    @Resource
    private GoodsOrderEsService goodsOrderEsService;
    @Resource
    private MeetingGoodsRelMapper meetingGoodsRelMapper;
    @Resource
    private ScrmNetSchoolService scrmNetSchoolService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private YongYouService yongYouService;
    @Value(value="${main.biz.id}")
    private Long mainBizId;
    @Value(value="${exclude.biz.ids}")
    private List<Long> excludeBizIds;
    @Value(value="${course.formats}")
    private String courseFormatsConfig;
    @Value(value="${live.platforms}")
    private String livebackPlatformsConfig;
    private static final Set<Integer> MEETING_GOODS_SOURCES = Sets.newHashSet((Object[])new Integer[]{GoodsOrderSource.MEETING_COMMERCE.getSource(), GoodsOrderSource.NET_SCHOOL.getSource()});
    @Resource
    private HandleBjyApiService handleBjyApiService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(SpuCreateReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Long bizId = currentUserInfo.getBizId();
        Long operatorId = currentUserInfo.getId();
        log.info("create spu with req={}", (Object)req);
        req.validate();
        this.checkAndSetOutProductIdSkuId(req);
        if (req.getSource() == null) {
            req.setSource(GoodsOrderSource.MEETING_COMMERCE.getSource());
        }
        if (this.mainBizId.equals(bizId)) {
            List schoolRegionDtos = this.scrmNetSchoolService.getSchoolRegionBySchoolIds(Collections.singletonList(req.getNetSchoolId()), bizId);
            if (CollectionUtils.isEmpty((Collection)schoolRegionDtos)) {
                log.info("\u6839\u636e\u6821\u533aid:{}\u672a\u67e5\u8be2\u5230\u533a\u57df\u4fe1\u606f", (Object)req.getNetSchoolId());
            } else {
                Long regionId = ((SchoolRegionDto)schoolRegionDtos.get(0)).getId();
                Long regionBizId = this.businessCustomerMapper.queryBizIdByRegionId(regionId);
                if (Objects.nonNull(regionBizId)) {
                    bizId = regionBizId;
                }
            }
        }
        ShopSpu shopSpu = this.insertSpuDb(req, bizId, operatorId);
        Long minPrice = this.batchInsertSkuDb(shopSpu.getProductId(), req.getOutProductId(), req.getSkus(), bizId, operatorId, req.getSource());
        ProductEsModel model = this.shopSpuToEsModel(shopSpu, minPrice, req.getTitle(), req.getSubTitle());
        try {
            this.goodsEsService.writeProduct(model);
        }
        catch (IOException e) {
            log.error("create spu error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        log.info("create spu finish");
    }

    private ProductEsModel shopSpuToEsModel(ShopSpu shopSpu, Long minPrice, String title, String subTitle) {
        ProductEsModel model = new ProductEsModel();
        model.setAppId("-1");
        model.setProductId(shopSpu.getProductId());
        model.setOutProductId(shopSpu.getOutProductId());
        model.setTitle(title);
        model.setSubTitle(subTitle);
        model.setPrice(minPrice);
        model.setCategoryIdL1(null);
        model.setCategoryIdL2(null);
        model.setCategoryIdL3(null);
        model.setStatus(shopSpu.getStatus());
        model.setEditStatus(shopSpu.getEditStatus());
        model.setCreateTime(shopSpu.getCreateTime());
        model.setUpdateTime(shopSpu.getUpdateTime());
        model.setIsDeleted(shopSpu.getIsDeleted());
        model.setSource(shopSpu.getSource());
        model.setBizId(shopSpu.getBizId());
        model.setIsNetSchoolGoods(shopSpu.getIsNetSchoolGoods());
        model.setNetSchoolId(shopSpu.getNetSchoolId());
        model.setNetSchoolGoodsType(shopSpu.getNetSchoolGoodsType());
        model.setRealServicePeriod(shopSpu.getRealServicePeriod());
        model.setFreeServicePeriod(shopSpu.getFreeServicePeriod());
        model.setExamType(shopSpu.getExamType());
        model.setSpecificExam(shopSpu.getSpecificExam());
        if (StringUtils.isNotBlank((CharSequence)shopSpu.getCourseFormat())) {
            model.setCourseFormat(Arrays.asList(shopSpu.getCourseFormat().split(",")));
        }
        if (StringUtils.isNotBlank((CharSequence)shopSpu.getLivePlatform())) {
            model.setLivePlatform(Arrays.asList(shopSpu.getLivePlatform().split(",")));
        }
        return model;
    }

    private Long batchInsertSkuDb(String productId, String outProductId, List<SkuItemDto> skus, Long bizId, Long operatorId, Integer source) {
        Long minPrice = null;
        Date now = new Date();
        ArrayList<ShopSku> addSkus = new ArrayList<ShopSku>();
        for (SkuItemDto skuItemDto : skus) {
            if (StringUtils.isNotBlank((CharSequence)skuItemDto.getSkuId())) continue;
            ShopSku sku = this.buildShopSku(productId, outProductId, now, skuItemDto, bizId, operatorId, source);
            if (minPrice == null || sku.getSalePrice() < minPrice) {
                minPrice = sku.getSalePrice();
            }
            addSkus.add(sku);
        }
        if (CollectionUtils.isNotEmpty(addSkus)) {
            this.skuMapper.batchInsert(addSkus);
        }
        return minPrice;
    }

    private ShopSku buildShopSku(String productId, String outProductId, Date now, SkuItemDto skuItemDto, Long bizId, Long operatorId, Integer source) {
        ShopSku shopSku = new ShopSku();
        shopSku.setStatus(Integer.valueOf(GoodsSkuStatus.LISTING.getStatus()));
        shopSku.setProductId(productId);
        shopSku.setOutProductId(outProductId);
        shopSku.setSkuId(String.valueOf(this.idGen.nextId()));
        shopSku.setOutSkuId(skuItemDto.getOutSkuId());
        shopSku.setSkuBody(JSON.toJSONString((Object)skuItemDto));
        shopSku.setAppId("-1");
        shopSku.setCreateTime(now);
        shopSku.setCreateBy(operatorId);
        shopSku.setMarketPrice(Long.valueOf(skuItemDto.getMarketPrice() != null ? skuItemDto.getMarketPrice() : 0L));
        shopSku.setSalePrice(skuItemDto.getSalePrice());
        shopSku.setStockNum(skuItemDto.getStockNum());
        shopSku.setNum(this.idGen.getNum());
        shopSku.setBizId(bizId);
        shopSku.setSource(source);
        return shopSku;
    }

    private ShopSpu insertSpuDb(SpuCreateReq req, Long bizId, Long operatorId) {
        String productId = String.valueOf(this.idGen.nextId());
        Long yyProductId = this.yongYouService.productIdempotentSave(req.getTitle(), productId);
        Date now = new Date();
        ShopSpu item = new ShopSpu();
        item.setYyProductId(yyProductId);
        item.setNum(this.idGen.getNum());
        item.setAppId("-1");
        item.setProductId(productId);
        item.setOutProductId(req.getOutProductId());
        item.setSpuBody(JSON.toJSONString((Object)req));
        item.setCreateBy(operatorId);
        item.setCreateTime(now);
        item.setUpdateTime(now);
        item.setIsDeleted(Integer.valueOf(0));
        item.setStatus(Integer.valueOf(GoodsSpuStatus.LISTING.getStatus()));
        item.setEditStatus(Integer.valueOf(-1));
        item.setBizId(bizId);
        item.setSource(req.getSource());
        item.setIsNetSchoolGoods(Integer.valueOf(0));
        item.setNetSchoolId(req.getNetSchoolId());
        item.setNetSchoolGoodsType(Integer.valueOf(0));
        item.setRealServicePeriod(req.getRealServicePeriod());
        item.setFreeServicePeriod(req.getFreeServicePeriod());
        item.setExamType(req.getExamType());
        item.setSpecificExam(req.getSpecificExam());
        item.setCourseFormat(String.join((CharSequence)",", req.getCourseFormat()));
        item.setLivePlatform(String.join((CharSequence)",", req.getLivePlatform()));
        this.shopSpuMapper.insert((Object)item);
        return item;
    }

    private void checkAndSetOutProductIdSkuId(SpuCreateReq req) {
        if (StringUtils.isBlank((CharSequence)req.getOutProductId())) {
            req.setOutProductId(this.idGen.getNum());
        }
        if (CollectionUtils.isNotEmpty(req.getSkus())) {
            for (SkuItemDto sku : req.getSkus()) {
                if (!StringUtils.isBlank((CharSequence)sku.getOutSkuId())) continue;
                sku.setOutSkuId(this.idGen.getNum());
                sku.setOutProductId(req.getOutProductId());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SpuUpdateReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("update spu with req={}", (Object)req);
        req.validate();
        ShopSpu existSpu = new ShopSpu();
        existSpu.setProductId(req.getProductId());
        existSpu.setSource(req.getSource());
        ShopSpu shopSpu = (ShopSpu)this.shopSpuMapper.selectOne((Object)existSpu);
        Preconditions.checkArgument((shopSpu != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        Set reqSkuIds = req.getSkus().stream().map(SkuItemDto::getSkuId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        log.info("update goods,reqSkuIds:{}", reqSkuIds);
        ShopSku existSkus = new ShopSku();
        existSkus.setProductId(shopSpu.getProductId());
        existSkus.setSource(Integer.valueOf(2));
        List shopSkus = this.skuMapper.select((Object)existSkus);
        Set delSkuIds = shopSkus.stream().map(ShopSku::getSkuId).filter(skuId -> !reqSkuIds.contains(skuId)).collect(Collectors.toSet());
        log.info("update goods,delSkuIds:{}", reqSkuIds);
        if (CollectionUtils.isNotEmpty(delSkuIds)) {
            this.skuMapper.deleteByStringSkuIds(shopSpu.getProductId(), delSkuIds);
        }
        this.batchInsertSkuDb(shopSpu.getProductId(), shopSpu.getOutProductId(), req.getSkus(), shopSpu.getBizId(), currentUserInfo.getId(), req.getSource());
        Set<String> updateSkuIds = shopSkus.stream().map(ShopSku::getSkuId).filter(reqSkuIds::contains).collect(Collectors.toSet());
        log.info("update goods,updateSkuIds:{}", reqSkuIds);
        if (CollectionUtils.isNotEmpty(updateSkuIds)) {
            this.updateSku(updateSkuIds, req, currentUserInfo);
        }
        shopSpu.setUpdateTime(new Date());
        shopSpu.setUpdateBy(currentUserInfo.getId());
        if (req.getNetSchoolId() != null) {
            shopSpu.setNetSchoolId(req.getNetSchoolId());
        }
        shopSpu.setTitle(req.getTitle());
        shopSpu.setRealServicePeriod(req.getRealServicePeriod());
        shopSpu.setFreeServicePeriod(req.getFreeServicePeriod());
        shopSpu.setExamType(req.getExamType());
        shopSpu.setSpecificExam(req.getSpecificExam());
        shopSpu.setCourseFormat(String.join((CharSequence)",", req.getCourseFormat()));
        shopSpu.setLivePlatform(String.join((CharSequence)",", req.getLivePlatform()));
        ShopSpu updatedSpu = this.updateSpu(req, shopSpu, currentUserInfo);
        this.updateMeetingGoods(shopSpu.getProductId(), updatedSpu);
        Long minPrice = this.skuMapper.queryMinPrice(currentUserInfo.getBizId(), Integer.valueOf(GoodsSkuStatus.LISTING.getStatus()), shopSpu.getProductId());
        ProductEsModel model = this.shopSpuToEsModel(shopSpu, minPrice, req.getTitle(), req.getSubTitle());
        this.goodsEsService.updateProduct(model);
    }

    @Override
    public void updateMeetingGoods(String productId, ShopSpu shopSpu) {
        List meetingGoodsRels = this.meetingGoodsRelMapper.selNotCloseMeetingByMeetingIdAndProductIds(shopSpu.getBizId(), null, (Collection)Lists.newArrayList((Object[])new String[]{productId}));
        if (CollectionUtils.isEmpty((Collection)meetingGoodsRels)) {
            return;
        }
        List collect = meetingGoodsRels.stream().map(MeetingGoodsRel::getMeetingId).collect(Collectors.toList());
        log.info("\u5546\u54c1\u7f16\u8f91\u9875\uff0c\u7f16\u8f91\u5546\u54c1\u9700\u8981\u540c\u6b65\u5230\u76f4\u64ad\u95f4\u7684\u76f4\u64ad\u4e3b\u9898\u6709:productIds:{},meetingIds:{}", (Object)productId, (Object)JSON.toJSONString(collect));
        String corpId = this.businessCustomerMapper.getCorpIdById(shopSpu.getBizId());
        for (MeetingGoodsRel meetingGoodsRel : meetingGoodsRels) {
            List shopSkus = this.skuMapper.queryByStringProductId(productId);
            List sortedShopSkus = shopSkus.stream().filter(item -> Objects.nonNull(item.getSource()) && MEETING_GOODS_SOURCES.contains(item.getSource())).sorted(Comparator.comparing(ShopSku::getSalePrice)).collect(Collectors.toList());
            ShopSku shopSku = org.apache.commons.collections.CollectionUtils.isNotEmpty(sortedShopSkus) ? (ShopSku)sortedShopSkus.get(0) : new ShopSku();
            MeetingGoodsRelDto meetingGoodsRelDto = this.entityConvertToDto(shopSpu, shopSku, meetingGoodsRel);
            meetingGoodsRelDto.setCorpId(corpId);
            this.handleBjyApiService.handleEditBjyGoodsRoom(meetingGoodsRelDto);
        }
    }

    @Override
    public List<ExamTypeDto> getExamTypes() {
        ExamTypeReq req = new ExamTypeReq();
        req.setBizId(LoginUtils.getCurrentUserBizId());
        req.setExamType(NumberUtils.LONG_ZERO);
        return this.scrmNetSchoolService.getExamTypeList(req);
    }

    @Override
    public List<ExamTypeDto> getSpecificExams(IdDto idDto) {
        ExamTypeReq req = new ExamTypeReq();
        req.setBizId(LoginUtils.getCurrentUserBizId());
        req.setExamType(idDto.getId());
        return this.scrmNetSchoolService.getExamTypeList(req);
    }

    @Override
    public List<String> getCourseFormat() {
        if (StringUtils.isBlank((CharSequence)this.courseFormatsConfig)) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.courseFormatsConfig.split(","));
    }

    @Override
    public List<String> getLivePlatform() {
        if (StringUtils.isBlank((CharSequence)this.livebackPlatformsConfig)) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.livebackPlatformsConfig.split(","));
    }

    private Map<Long, String> buildExamTypeIdToNameMap(List<ShopSpu> shopSpus, CurrentUserInfo currentUserInfo) {
        ArrayList examTypeIds = Lists.newArrayList();
        for (ShopSpu shopSpu : shopSpus) {
            if (Objects.nonNull(shopSpu.getExamType())) {
                examTypeIds.add(shopSpu.getExamType());
            }
            if (!Objects.nonNull(shopSpu.getSpecificExam())) continue;
            examTypeIds.add(shopSpu.getSpecificExam());
        }
        if (CollectionUtils.isEmpty((Collection)examTypeIds)) {
            return Collections.emptyMap();
        }
        List examTypes = this.scrmNetSchoolService.getExamTypeByIds(currentUserInfo.getBizId(), (List)examTypeIds);
        return examTypes.stream().collect(Collectors.toMap(ExamTypeDto::getId, ExamTypeDto::getExamTypeName, (existing, replacement) -> existing + "," + replacement));
    }

    public MeetingGoodsRelDto entityConvertToDto(ShopSpu shopSpu, ShopSku shopSku, MeetingGoodsRel meetingGoodsRel) {
        String goodsUrl;
        MeetingGoodsRelDto meetingGoodsRelDto = new MeetingGoodsRelDto();
        String spuBody = shopSpu.getSpuBody();
        JSONObject jsonObject = JSON.parseObject((String)spuBody);
        String subTitle = jsonObject.getString("subTitle");
        String title = jsonObject.getString("title");
        JSONArray headImgs = jsonObject.getJSONArray("headImg");
        String string = goodsUrl = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)headImgs) ? (String)headImgs.get(0) : "";
        if (Objects.isNull(shopSku.getMarketPrice()) || shopSku.getMarketPrice() == 0L) {
            shopSku.setMarketPrice(shopSku.getSalePrice());
        }
        meetingGoodsRelDto.setGoodsDiscountPrice(shopSku.getSalePrice());
        meetingGoodsRelDto.setGoodsOriginPrice(shopSku.getMarketPrice());
        meetingGoodsRelDto.setGoodsDes(subTitle);
        meetingGoodsRelDto.setGoodsName(title);
        meetingGoodsRelDto.setMeetingId(meetingGoodsRel.getId());
        meetingGoodsRelDto.setRoomId(meetingGoodsRel.getRoomId());
        meetingGoodsRelDto.setGoodsUrl(goodsUrl);
        meetingGoodsRelDto.setGoodsDetailUrl(meetingGoodsRel.getGoodsDetailUrl());
        meetingGoodsRelDto.setGoodsSource(shopSpu.getSource());
        meetingGoodsRelDto.setBizId(shopSpu.getBizId());
        meetingGoodsRelDto.setGoodsProductId(shopSpu.getProductId());
        meetingGoodsRelDto.setBjyGoodsId(meetingGoodsRel.getBjyGoodsId());
        return meetingGoodsRelDto;
    }

    private ShopSpu updateSpu(SpuUpdateReq req, ShopSpu shopSpu, CurrentUserInfo userInfo) {
        ShopSpu update = new ShopSpu();
        update.setTitle(shopSpu.getTitle());
        update.setProductId(shopSpu.getProductId());
        update.setSpuBody(JSON.toJSONString((Object)req));
        update.setUpdateBy(userInfo.getId());
        update.setStatus(shopSpu.getStatus());
        update.setEditStatus(shopSpu.getEditStatus());
        update.setUpdateBy(shopSpu.getUpdateBy());
        update.setUpdateTime(shopSpu.getUpdateTime());
        update.setBizId(shopSpu.getBizId());
        update.setNetSchoolId(shopSpu.getNetSchoolId());
        update.setRealServicePeriod(shopSpu.getRealServicePeriod());
        update.setFreeServicePeriod(shopSpu.getFreeServicePeriod());
        update.setExamType(shopSpu.getExamType());
        update.setSpecificExam(shopSpu.getSpecificExam());
        update.setCourseFormat(shopSpu.getCourseFormat());
        update.setLivePlatform(shopSpu.getLivePlatform());
        this.shopSpuMapper.batchUpdate(Collections.singletonList(update));
        return update;
    }

    private void updateSku(Set<String> updateSkuIds, SpuUpdateReq req, CurrentUserInfo userInfo) {
        List<SkuItemDto> skus = req.getSkus();
        Map skuItemDtoMap = skus.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSkuId())).collect(Collectors.toMap(SkuItemDto::getSkuId, Function.identity()));
        ArrayList<ShopSku> updateSkus = new ArrayList<ShopSku>();
        for (String skuId : updateSkuIds) {
            SkuItemDto skuItemDto = (SkuItemDto)skuItemDtoMap.get(skuId);
            if (skuItemDto == null) continue;
            ShopSku shopSku = new ShopSku();
            shopSku.setStatus(Integer.valueOf(GoodsSkuStatus.LISTING.getStatus()));
            shopSku.setSkuId(skuItemDto.getSkuId());
            shopSku.setSkuBody(JSON.toJSONString((Object)skuItemDto));
            shopSku.setUpdateBy(userInfo.getId());
            shopSku.setMarketPrice(Long.valueOf(skuItemDto.getMarketPrice() != null ? skuItemDto.getMarketPrice() : 0L));
            shopSku.setSalePrice(skuItemDto.getSalePrice());
            shopSku.setStockNum(skuItemDto.getStockNum());
            updateSkus.add(shopSku);
        }
        if (CollectionUtils.isNotEmpty(updateSkus)) {
            this.skuMapper.batchUpdate(updateSkus);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SpuProductIdReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("del spu with req={}", (Object)req);
        req.validate();
        List meetingGoodsRels = this.meetingGoodsRelMapper.selNotCloseMeetingByMeetingIdAndProductIds(LoginUtils.getCurrentUserBizId(), null, (Collection)Lists.newArrayList((Object[])new String[]{req.getProductId()}));
        if (CollectionUtils.isNotEmpty((Collection)meetingGoodsRels)) {
            List meetings = meetingGoodsRels.stream().map(MeetingGoodsRel::getMeetingTitle).collect(Collectors.toList());
            String meetingTitles = String.join((CharSequence)",", meetings);
            meetingTitles = "\u3010" + meetingTitles + "\u3011";
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u76f4\u64ad\u95f4\u5df2\u7ed1\u5b9a" + meetingTitles + "; \u8bf7\u5230\u76f4\u64ad\u95f4\u79fb\u9664\u7ed1\u5b9a,\u518d\u5220\u9664");
        }
        ShopSpu item = this.shopSpuMapper.queryByProductIdReq(req);
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        req.setProductId(item.getProductId());
        req.setOutProductId(item.getOutProductId());
        this.deleteSpuDb(currentUserInfo, item);
        this.skuMapper.deleteByProductId(req.getProductId());
        this.goodsEsService.delProduct(item.getProductId(), item.getBizId());
    }

    private void deleteSpuDb(CurrentUserInfo currentUserInfo, ShopSpu item) {
        item.setUpdateBy(currentUserInfo.getId());
        item.setUpdateTime(new Date());
        item.setIsDeleted(Integer.valueOf(1));
        item.setStatus(Integer.valueOf(GoodsSpuStatus.LOGIC_DELETED.getStatus()));
        this.shopSpuMapper.updateByPrimaryKeySelective((Object)item);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deListing(SpuProductIdReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("deListing spu with req={}", (Object)req);
        req.validate();
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductIdReq(req);
        Preconditions.checkArgument((shopSpu != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        shopSpu.setStatus(Integer.valueOf(GoodsSpuStatus.SELF_DELISTING.getStatus()));
        shopSpu.setUpdateBy(currentUserInfo.getId());
        shopSpu.setUpdateTime(new Date());
        this.shopSpuMapper.updateByPrimaryKey((Object)shopSpu);
        this.goodsEsService.updateProductStatus(shopSpu.getProductId(), shopSpu.getBizId(), shopSpu.getStatus());
    }

    @Override
    public SpuDetailResp detailByMeeting(DetailByMeetingReq req) {
        log.info("detailByRoom spu with req={}", (Object)req);
        req.validate();
        List meetings = this.meetingMapper.selectByRoomIdUseMeeting(req.getRoomId());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)meetings), (Object)"\u76f4\u64ad\u4e0d\u5b58\u5728");
        MeetingGoodsRel select = new MeetingGoodsRel();
        select.setBizId(((Meeting)meetings.get(0)).getBizId());
        select.setGoodsProductId(String.valueOf(req.getProductId()));
        select.setRoomId(req.getRoomId());
        select.setStatus(YnEnum.YES.getValue());
        MeetingGoodsRel meetingGoodsRel = (MeetingGoodsRel)this.meetingGoodsRelMapper.selectOne((Object)select);
        Preconditions.checkArgument((meetingGoodsRel != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        String productId = req.getProductId().toString();
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductId(productId);
        Preconditions.checkArgument((shopSpu != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        List shopSkus = this.skuMapper.queryByStringProductId(shopSpu.getProductId());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)shopSkus), (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        return this.buildSpuDetailResp(shopSpu, shopSkus);
    }

    private SpuDetailResp buildSpuDetailResp(ShopSpu shopSpu, List<ShopSku> shopSkus) {
        SchoolListRespDto schoolListRespDto;
        SpuCreateReq spuCreateReq = (SpuCreateReq)JSON.parseObject((String)shopSpu.getSpuBody(), SpuCreateReq.class);
        SpuDetailResp resp = new SpuDetailResp();
        resp.setSpuStatus(shopSpu.getStatus());
        resp.setOutProductId(shopSpu.getOutProductId());
        resp.setProductId(shopSpu.getProductId());
        resp.setTitle(spuCreateReq.getTitle());
        resp.setSubTitle(spuCreateReq.getSubTitle());
        resp.setHeadImg(spuCreateReq.getHeadImg());
        resp.setDescInfo(spuCreateReq.getDescInfo());
        resp.setAttrs(spuCreateReq.getAttrs());
        resp.setModel(spuCreateReq.getModel());
        resp.setSource(shopSpu.getSource());
        resp.setProductType(spuCreateReq.getProductType() == null ? 1 : spuCreateReq.getProductType());
        resp.setSkus(spuCreateReq.getSkus());
        resp.setCouponcodeInfo(spuCreateReq.getCouponcodeInfo());
        resp.setNeedAddress(spuCreateReq.getNeedAddress());
        resp.setInitSaleCount(spuCreateReq.getInitSaleCount());
        Long realSaleCount = this.goodsOrderEsService.selectCountByProductId(Long.parseLong(shopSpu.getProductId()));
        resp.setSaleCount(realSaleCount + spuCreateReq.getInitSaleCount());
        String netSchoolName = "";
        if (shopSpu.getNetSchoolId() != null && (schoolListRespDto = this.scrmNetSchoolService.schoolSimpleInfo(shopSpu.getBizId(), (Set)Sets.newHashSet((Object[])new Long[]{shopSpu.getNetSchoolId()}))) != null && CollectionUtils.isNotEmpty((Collection)schoolListRespDto.getData())) {
            netSchoolName = ((SchoolInfo)schoolListRespDto.getData().get(0)).getOrgName();
        }
        if (shopSkus != null) {
            ArrayList<SkuItemDto> skus = new ArrayList<SkuItemDto>();
            for (ShopSku shopSku : shopSkus) {
                SkuItemDto skuItemDto = (SkuItemDto)JSON.parseObject((String)shopSku.getSkuBody(), SkuItemDto.class);
                skuItemDto.setProductId(shopSpu.getProductId());
                skuItemDto.setSkuId(shopSku.getSkuId());
                if (GoodsOrderSource.NET_SCHOOL.getSource() == shopSku.getSource().intValue()) {
                    skuItemDto.setMarketPrice(shopSku.getMarketPrice());
                    skuItemDto.setSalePrice(shopSku.getSalePrice());
                }
                skuItemDto.setNetSchoolId(shopSpu.getNetSchoolId());
                skuItemDto.setNetSchoolName(netSchoolName);
                skus.add(skuItemDto);
            }
            resp.setSkus(skus);
        }
        resp.setNetSchoolId(shopSpu.getNetSchoolId());
        resp.setNetSchoolName(netSchoolName);
        resp.setRealServicePeriod(shopSpu.getRealServicePeriod());
        resp.setFreeServicePeriod(shopSpu.getFreeServicePeriod());
        resp.setExamType(shopSpu.getExamType());
        resp.setSpecificExam(shopSpu.getSpecificExam());
        Map<Long, String> examTypeIdToNameMap = this.buildExamTypeIdToNameMap(Lists.newArrayList((Object[])new ShopSpu[]{shopSpu}), LoginUtils.getCurrentUser());
        resp.setExamTypeName(examTypeIdToNameMap.get(shopSpu.getExamType()));
        resp.setSpecificExamName(examTypeIdToNameMap.get(shopSpu.getSpecificExam()));
        ArrayList<String> courseFormatList = StringUtils.isNotBlank((CharSequence)shopSpu.getCourseFormat()) ? Arrays.asList(shopSpu.getCourseFormat().split(",")) : new ArrayList<String>();
        resp.setCourseFormat(courseFormatList);
        ArrayList<String> livePlatformList = StringUtils.isNotBlank((CharSequence)shopSpu.getLivePlatform()) ? Arrays.asList(shopSpu.getLivePlatform().split(",")) : new ArrayList<String>();
        resp.setLivePlatform(livePlatformList);
        return resp;
    }

    @Override
    public SpuDetailResp detail(SpuDetailReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("detail spu with req={}", (Object)req);
        req.validate();
        ShopSpu shopSpu = this.shopSpuMapper.queryByBizIdAndProductId(req.getProductId());
        Preconditions.checkArgument((shopSpu != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        List shopSkus = this.skuMapper.queryByStringProductId(shopSpu.getProductId());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)shopSkus), (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        return this.buildSpuDetailResp(shopSpu, shopSkus);
    }

    @Override
    public List<SpuListItem> queryList(SpuListQueryParam param) {
        SchoolListRespDto schoolListRespDto;
        List selectProductIds;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("queryList spu with param={}", (Object)param);
        param.validate();
        if (currentUserInfo.getBizId().equals(this.mainBizId)) {
            param.setBizId(null);
            param.setExcludeBizIds(this.excludeBizIds);
        } else {
            param.setBizId(currentUserInfo.getBizId());
        }
        if (StringUtils.isBlank((CharSequence)param.getProductCodeQuery()) && StringUtils.isBlank((CharSequence)param.getProductNameQuery()) && param.getMaxPrice() == null && param.getMinPrice() == null) {
            GoodsListQueryParam queryParam = new GoodsListQueryParam();
            queryParam.setBizId(param.getBizId());
            queryParam.setExcludeBizIds(param.getExcludeBizIds());
            queryParam.setAppId("-1");
            queryParam.setSource(param.getSource());
            queryParam.setStatus(param.getRealStatus());
            queryParam.setGoodsType(param.getGoodsType());
            queryParam.setSignTypeId(param.getSignTypeId());
            queryParam.setPageDto(param.getPageDto());
            log.info("queryList spu from db, queryParam:{}", (Object)queryParam);
            selectProductIds = this.shopSpuMapper.queryProductIdsByStatusAndPage(queryParam);
            int count = this.shopSpuMapper.countByStatusAndPage(queryParam);
            if (Objects.nonNull(param.getPageDto())) {
                param.getPageDto().setCount(Integer.valueOf(count));
                param.getPageDto().setCurPageCount(Integer.valueOf(selectProductIds.size()));
            }
        } else {
            Pair<List<ProductEsModel>, Long> pair = this.goodsEsService.queryProductList(param, false);
            if (Objects.nonNull(param.getPageDto())) {
                param.getPageDto().setCount(Integer.valueOf(((Long)pair.getRight()).intValue()));
                param.getPageDto().setCurPageCount(Integer.valueOf(((List)pair.getLeft()).size()));
            }
            List goodsEsModels = (List)pair.getLeft();
            selectProductIds = goodsEsModels.stream().map(ProductEsModel::getProductId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(selectProductIds)) {
            if (StringUtils.isNotBlank((CharSequence)param.getProductNameQuery())) {
                SpuListQueryParam queryByProductId = new SpuListQueryParam();
                BeanUtils.copyProperties((Object)param, (Object)queryByProductId);
                queryByProductId.setProductCodeQuery(param.getProductNameQuery());
                queryByProductId.setProductNameQuery(null);
                Pair<List<ProductEsModel>, Long> pair = this.goodsEsService.queryProductList(queryByProductId, false);
                List goodsEsModels = (List)pair.getLeft();
                selectProductIds = goodsEsModels.stream().map(ProductEsModel::getProductId).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(selectProductIds)) {
                log.error("\u901a\u8fc7\u5546\u54c1\u7f16\u53f7\u6ca1\u6709\u67e5\u5230\u5546\u54c1\u4fe1\u606f");
                return Lists.newArrayList();
            }
        }
        List shopSpus = this.shopSpuMapper.queryByProductIds("-1", selectProductIds);
        Map<String, ShopSpu> spuId2Spu = shopSpus.stream().collect(Collectors.toMap(ShopSpu::getProductId, a -> a));
        Map<Long, String> examTypeIdToNameMap = this.buildExamTypeIdToNameMap(shopSpus, currentUserInfo);
        HashSet schoolIds = Sets.newHashSet();
        HashMap productId2SchoolIdMap = Maps.newHashMap();
        Map<Long, String> schoolId2NameMap = null;
        for (ShopSpu shopSpu : shopSpus) {
            Long schoolId = shopSpu.getNetSchoolId();
            if (schoolId == null) continue;
            schoolIds.add(schoolId);
            productId2SchoolIdMap.put(shopSpu.getProductId(), schoolId);
        }
        if (CollectionUtils.isNotEmpty((Collection)schoolIds) && (schoolListRespDto = this.scrmNetSchoolService.schoolSimpleInfo(currentUserInfo.getBizId(), (Set)schoolIds)) != null && CollectionUtils.isNotEmpty((Collection)schoolListRespDto.getData()) && NumberUtils.INTEGER_ONE.equals(schoolListRespDto.getIsMoreSchool())) {
            schoolId2NameMap = schoolListRespDto.getData().stream().collect(Collectors.toMap(schoolInfo -> (long)schoolInfo.getId(), SchoolInfo::getOrgName));
        }
        ArrayList result = Lists.newArrayList();
        for (String productId : selectProductIds) {
            ShopSpu spu = spuId2Spu.get(productId);
            if (Objects.isNull(spu)) continue;
            SpuCreateReq spuCreateReq = (SpuCreateReq)JSON.parseObject((String)spu.getSpuBody(), SpuCreateReq.class);
            List<SkuItemDto> skus = spuCreateReq.getSkus();
            SkuItemDto minPriceSkuItemDto = skus.stream().min(Comparator.comparing(SkuItemDto::getSalePrice)).get();
            SpuListItem item = new SpuListItem();
            item.setBizId(spu.getBizId());
            item.setDescInfo(spuCreateReq.getDescInfo());
            item.setProductId(productId);
            item.setAuditStatus(spu.getEditStatus());
            item.setEditStatus(spu.getStatus());
            item.setOutProductId(spu.getOutProductId());
            item.setHeadImg(spuCreateReq.getHeadImg());
            item.setTitle(spuCreateReq.getTitle());
            item.setSubTitle(spuCreateReq.getSubTitle());
            item.setPrice(minPriceSkuItemDto.getSalePrice());
            Long orderCount = this.goodsOrderEsService.selectCountByProductId(Long.parseLong(productId));
            item.setOrderCount(orderCount);
            item.setSaleCount(orderCount);
            item.setUpdateTime(spu.getUpdateTime());
            item.setSource(spu.getSource());
            if (MapUtils.isNotEmpty(schoolId2NameMap) && productId2SchoolIdMap.containsKey(spu.getProductId())) {
                Long schoolId = (Long)productId2SchoolIdMap.get(spu.getProductId());
                String schoolName = schoolId2NameMap.get(schoolId);
                if (StringUtils.isNotBlank((CharSequence)schoolName)) {
                    item.setTitle("\u3010" + schoolName + "\u3011" + item.getTitle());
                }
                item.setNetSchoolId(schoolId);
                item.setNetSchoolName(schoolName);
            }
            item.setNeedAddress(spuCreateReq.getNeedAddress());
            item.setSectionNum(spuCreateReq.getSectionNum());
            item.setSignTypeId(spu.getNetSchoolSignTypeId());
            item.setSignTypeName(spu.getNetSchoolSignTypeName());
            item.setDispatchType(spuCreateReq.getDispatchType());
            item.setDispatchStartTime(spuCreateReq.getDispatchStartTime());
            item.setDispatchEndTime(spuCreateReq.getDispatchEndTime());
            item.setHtmlDetails(spuCreateReq.getHtmlDetails());
            item.setGoodsType(spu.getNetSchoolGoodsType());
            if (spu.getNetSchoolGoodsType() != null) {
                item.setGoodsTypeDesc(NetSchoolGoodsTypeEnum.getDesc((Integer)spu.getNetSchoolGoodsType()));
            }
            item.setClassPackItem(spuCreateReq.getClassPackItem());
            item.setValidType(spuCreateReq.getValidType());
            item.setValidTime(spuCreateReq.getValidTime());
            item.setRealServicePeriod(spu.getRealServicePeriod());
            item.setFreeServicePeriod(spu.getFreeServicePeriod());
            item.setExamType(examTypeIdToNameMap.get(spu.getExamType()));
            item.setSpecificExam(examTypeIdToNameMap.get(spu.getSpecificExam()));
            item.setCourseFormat(spuCreateReq.getCourseFormat());
            item.setLivePlatform(spuCreateReq.getLivePlatform());
            result.add(item);
        }
        return result;
    }

    @Override
    public SpuStatusStatisticResp statusCount() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Map status2Count = this.shopSpuMapper.countByStatusWithBizId(currentUserInfo.getBizId());
        SpuStatusStatisticResp resp = new SpuStatusStatisticResp();
        AtomicInteger totalCount = new AtomicInteger();
        status2Count.forEach((status, count) -> {
            switch (GoodsSpuStatus.getByStatus(status)) {
                case INIT: {
                    resp.setWaitListCount(resp.getWaitListCount() + count);
                    totalCount.getAndAdd((int)count);
                    break;
                }
                case RECYCLE_BIN: {
                    resp.setDeleteCount(resp.getDeleteCount() + count);
                    totalCount.getAndAdd((int)count);
                    break;
                }
                case LISTING: {
                    resp.setListingCount(resp.getListingCount() + count);
                    totalCount.getAndAdd((int)count);
                    break;
                }
                case SELF_DELISTING: 
                case SOLD_OUT_DELISTING: 
                case VIOLATION_DELISTING: {
                    resp.setDelistCount(resp.getDelistCount() + count);
                    totalCount.getAndAdd((int)count);
                    break;
                }
            }
        });
        resp.setTotalCount(totalCount.get());
        return resp;
    }
}

