/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.goods.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.service.dto.ClassPackItemDto;
import com.kuaike.scrm.goods.dto.AttrItem;
import com.kuaike.scrm.goods.dto.CouponCodeInfo;
import com.kuaike.scrm.goods.dto.SkuItemDto;
import com.kuaike.scrm.goods.dto.SpuDescInfo;
import com.kuaike.scrm.utils.HttpHeadUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SpuCreateReq {
    private Integer needAddress;
    private Long initSaleCount = 0L;
    private String outProductId;
    private String title;
    private String subTitle;
    private List<String> headImg;
    private SpuDescInfo descInfo;
    private List<AttrItem> attrs;
    private String model;
    private Integer source;
    private List<SkuItemDto> skus;
    private CouponCodeInfo couponcodeInfo;
    private Integer productType = 1;
    private String htmlDetails;
    private Long netSchoolId;
    private String netSchoolName;
    private Integer sectionNum;
    private Integer dispatchType;
    private Date dispatchStartTime;
    private Date dispatchEndTime;
    private List<ClassPackItemDto> classPackItem;
    private Integer validType;
    private Date validTime;
    private Integer realServicePeriod;
    private Integer freeServicePeriod;
    private Long examType;
    private Long specificExam;
    private List<String> courseFormat;
    private List<String> livePlatform;

    public void validate() {
        Preconditions.checkArgument((this.needAddress != null ? 1 : 0) != 0, (Object)"needAddress\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.initSaleCount != null ? 1 : 0) != 0, (Object)"initSaleCount\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.initSaleCount >= 0L && this.initSaleCount <= 10000000L ? 1 : 0) != 0, (Object)"initSaleCount\u53d6\u503c\u8303\u56f4[0,10000000]");
        Preconditions.checkArgument((this.needAddress == 0 || this.needAddress == 1 ? 1 : 0) != 0, (Object)"needAddress\u53d6\u503c\u8fd4\u56de\u4e0d\u6b63\u786e");
        Preconditions.checkArgument((this.netSchoolId != null ? 1 : 0) != 0, (Object)"\u6821\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.realServicePeriod != null && this.realServicePeriod >= 0 ? 1 : 0) != 0, (Object)"\u5b9e\u9645\u670d\u52a1\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.freeServicePeriod != null && this.freeServicePeriod >= 0 ? 1 : 0) != 0, (Object)"\u8d60\u9001\u670d\u52a1\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.examType != null ? 1 : 0) != 0, (Object)"\u8003\u8bd5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.courseFormat != null ? 1 : 0) != 0, (Object)"\u8bfe\u7a0b\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.livePlatform != null ? 1 : 0) != 0, (Object)"\u64ad\u653e\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.title) && StringUtils.length((CharSequence)this.title) <= 30 ? 1 : 0) != 0, (Object)"\u6807\u9898\u5fc5\u586b,\u4e14\u6700\u591a30\u4e2a\u5b57\u7b26");
        if (StringUtils.isNotBlank((CharSequence)this.subTitle)) {
            Preconditions.checkArgument((StringUtils.length((CharSequence)this.subTitle) <= 18 ? 1 : 0) != 0, (Object)"subTitle,\u526f\u6807\u9898\u6700\u591a18\u4e2a\u5b57\u7b26");
        }
        for (String img : this.headImg) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)img), (Object)"headImg\u4e2d\u4e0d\u80fd\u5b58\u5728\u7a7a\u7684\u56fe\u7247");
        }
        if (Objects.nonNull(this.descInfo) && CollectionUtils.isNotEmpty(this.descInfo.getImgs())) {
            Preconditions.checkArgument((CollectionUtils.size(this.descInfo.getImgs()) <= 20 ? 1 : 0) != 0, (Object)"\u5546\u54c1\u8be6\u60c5,\u76ee\u524d\u53ea\u652f\u6301\u56fe\u7247, \u6700\u591a20\u5f20");
            for (String img : this.descInfo.getImgs()) {
                if (HttpHeadUtils.isWxResource((String)img)) continue;
                HttpHeadUtils.checkImgAndSize((String)img, (String)"\u56fe\u7247\u683c\u5f0f\u4e0d\u6b63\u786e", (int)10, (String)"\u5546\u54c1\u8be6\u60c5\u56fe\u7247\u6700\u592710MB");
            }
        }
        if (CollectionUtils.isNotEmpty(this.attrs)) {
            for (AttrItem attr : this.attrs) {
                Preconditions.checkArgument((boolean)Objects.nonNull(attr), (Object)"attrs\u5143\u7d20\u4e0d\u80fd\u4e3a\u7a7a");
                attr.validate();
            }
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(this.productType), (Object)"productType\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.couponcodeInfo != null) {
            this.couponcodeInfo.validate();
        }
        if (CollectionUtils.isNotEmpty(this.skus)) {
            for (SkuItemDto dto : this.skus) {
                dto.validate();
            }
        }
    }

    public Integer getNeedAddress() {
        return this.needAddress;
    }

    public Long getInitSaleCount() {
        return this.initSaleCount;
    }

    public String getOutProductId() {
        return this.outProductId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public List<String> getHeadImg() {
        return this.headImg;
    }

    public SpuDescInfo getDescInfo() {
        return this.descInfo;
    }

    public List<AttrItem> getAttrs() {
        return this.attrs;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getSource() {
        return this.source;
    }

    public List<SkuItemDto> getSkus() {
        return this.skus;
    }

    public CouponCodeInfo getCouponcodeInfo() {
        return this.couponcodeInfo;
    }

    public Integer getProductType() {
        return this.productType;
    }

    public String getHtmlDetails() {
        return this.htmlDetails;
    }

    public Long getNetSchoolId() {
        return this.netSchoolId;
    }

    public String getNetSchoolName() {
        return this.netSchoolName;
    }

    public Integer getSectionNum() {
        return this.sectionNum;
    }

    public Integer getDispatchType() {
        return this.dispatchType;
    }

    public Date getDispatchStartTime() {
        return this.dispatchStartTime;
    }

    public Date getDispatchEndTime() {
        return this.dispatchEndTime;
    }

    public List<ClassPackItemDto> getClassPackItem() {
        return this.classPackItem;
    }

    public Integer getValidType() {
        return this.validType;
    }

    public Date getValidTime() {
        return this.validTime;
    }

    public Integer getRealServicePeriod() {
        return this.realServicePeriod;
    }

    public Integer getFreeServicePeriod() {
        return this.freeServicePeriod;
    }

    public Long getExamType() {
        return this.examType;
    }

    public Long getSpecificExam() {
        return this.specificExam;
    }

    public List<String> getCourseFormat() {
        return this.courseFormat;
    }

    public List<String> getLivePlatform() {
        return this.livePlatform;
    }

    public void setNeedAddress(Integer needAddress) {
        this.needAddress = needAddress;
    }

    public void setInitSaleCount(Long initSaleCount) {
        this.initSaleCount = initSaleCount;
    }

    public void setOutProductId(String outProductId) {
        this.outProductId = outProductId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setHeadImg(List<String> headImg) {
        this.headImg = headImg;
    }

    public void setDescInfo(SpuDescInfo descInfo) {
        this.descInfo = descInfo;
    }

    public void setAttrs(List<AttrItem> attrs) {
        this.attrs = attrs;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public void setSkus(List<SkuItemDto> skus) {
        this.skus = skus;
    }

    public void setCouponcodeInfo(CouponCodeInfo couponcodeInfo) {
        this.couponcodeInfo = couponcodeInfo;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public void setHtmlDetails(String htmlDetails) {
        this.htmlDetails = htmlDetails;
    }

    public void setNetSchoolId(Long netSchoolId) {
        this.netSchoolId = netSchoolId;
    }

    public void setNetSchoolName(String netSchoolName) {
        this.netSchoolName = netSchoolName;
    }

    public void setSectionNum(Integer sectionNum) {
        this.sectionNum = sectionNum;
    }

    public void setDispatchType(Integer dispatchType) {
        this.dispatchType = dispatchType;
    }

    public void setDispatchStartTime(Date dispatchStartTime) {
        this.dispatchStartTime = dispatchStartTime;
    }

    public void setDispatchEndTime(Date dispatchEndTime) {
        this.dispatchEndTime = dispatchEndTime;
    }

    public void setClassPackItem(List<ClassPackItemDto> classPackItem) {
        this.classPackItem = classPackItem;
    }

    public void setValidType(Integer validType) {
        this.validType = validType;
    }

    public void setValidTime(Date validTime) {
        this.validTime = validTime;
    }

    public void setRealServicePeriod(Integer realServicePeriod) {
        this.realServicePeriod = realServicePeriod;
    }

    public void setFreeServicePeriod(Integer freeServicePeriod) {
        this.freeServicePeriod = freeServicePeriod;
    }

    public void setExamType(Long examType) {
        this.examType = examType;
    }

    public void setSpecificExam(Long specificExam) {
        this.specificExam = specificExam;
    }

    public void setCourseFormat(List<String> courseFormat) {
        this.courseFormat = courseFormat;
    }

    public void setLivePlatform(List<String> livePlatform) {
        this.livePlatform = livePlatform;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpuCreateReq)) {
            return false;
        }
        SpuCreateReq other = (SpuCreateReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$needAddress = this.getNeedAddress();
        Integer other$needAddress = other.getNeedAddress();
        if (this$needAddress == null ? other$needAddress != null : !((Object)this$needAddress).equals(other$needAddress)) {
            return false;
        }
        Long this$initSaleCount = this.getInitSaleCount();
        Long other$initSaleCount = other.getInitSaleCount();
        if (this$initSaleCount == null ? other$initSaleCount != null : !((Object)this$initSaleCount).equals(other$initSaleCount)) {
            return false;
        }
        Integer this$source = this.getSource();
        Integer other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Integer this$productType = this.getProductType();
        Integer other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !((Object)this$productType).equals(other$productType)) {
            return false;
        }
        Long this$netSchoolId = this.getNetSchoolId();
        Long other$netSchoolId = other.getNetSchoolId();
        if (this$netSchoolId == null ? other$netSchoolId != null : !((Object)this$netSchoolId).equals(other$netSchoolId)) {
            return false;
        }
        Integer this$sectionNum = this.getSectionNum();
        Integer other$sectionNum = other.getSectionNum();
        if (this$sectionNum == null ? other$sectionNum != null : !((Object)this$sectionNum).equals(other$sectionNum)) {
            return false;
        }
        Integer this$dispatchType = this.getDispatchType();
        Integer other$dispatchType = other.getDispatchType();
        if (this$dispatchType == null ? other$dispatchType != null : !((Object)this$dispatchType).equals(other$dispatchType)) {
            return false;
        }
        Integer this$validType = this.getValidType();
        Integer other$validType = other.getValidType();
        if (this$validType == null ? other$validType != null : !((Object)this$validType).equals(other$validType)) {
            return false;
        }
        Integer this$realServicePeriod = this.getRealServicePeriod();
        Integer other$realServicePeriod = other.getRealServicePeriod();
        if (this$realServicePeriod == null ? other$realServicePeriod != null : !((Object)this$realServicePeriod).equals(other$realServicePeriod)) {
            return false;
        }
        Integer this$freeServicePeriod = this.getFreeServicePeriod();
        Integer other$freeServicePeriod = other.getFreeServicePeriod();
        if (this$freeServicePeriod == null ? other$freeServicePeriod != null : !((Object)this$freeServicePeriod).equals(other$freeServicePeriod)) {
            return false;
        }
        Long this$examType = this.getExamType();
        Long other$examType = other.getExamType();
        if (this$examType == null ? other$examType != null : !((Object)this$examType).equals(other$examType)) {
            return false;
        }
        Long this$specificExam = this.getSpecificExam();
        Long other$specificExam = other.getSpecificExam();
        if (this$specificExam == null ? other$specificExam != null : !((Object)this$specificExam).equals(other$specificExam)) {
            return false;
        }
        String this$outProductId = this.getOutProductId();
        String other$outProductId = other.getOutProductId();
        if (this$outProductId == null ? other$outProductId != null : !this$outProductId.equals(other$outProductId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subTitle = this.getSubTitle();
        String other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        List<String> this$headImg = this.getHeadImg();
        List<String> other$headImg = other.getHeadImg();
        if (this$headImg == null ? other$headImg != null : !((Object)this$headImg).equals(other$headImg)) {
            return false;
        }
        SpuDescInfo this$descInfo = this.getDescInfo();
        SpuDescInfo other$descInfo = other.getDescInfo();
        if (this$descInfo == null ? other$descInfo != null : !((Object)this$descInfo).equals(other$descInfo)) {
            return false;
        }
        List<AttrItem> this$attrs = this.getAttrs();
        List<AttrItem> other$attrs = other.getAttrs();
        if (this$attrs == null ? other$attrs != null : !((Object)this$attrs).equals(other$attrs)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<SkuItemDto> this$skus = this.getSkus();
        List<SkuItemDto> other$skus = other.getSkus();
        if (this$skus == null ? other$skus != null : !((Object)this$skus).equals(other$skus)) {
            return false;
        }
        CouponCodeInfo this$couponcodeInfo = this.getCouponcodeInfo();
        CouponCodeInfo other$couponcodeInfo = other.getCouponcodeInfo();
        if (this$couponcodeInfo == null ? other$couponcodeInfo != null : !((Object)this$couponcodeInfo).equals(other$couponcodeInfo)) {
            return false;
        }
        String this$htmlDetails = this.getHtmlDetails();
        String other$htmlDetails = other.getHtmlDetails();
        if (this$htmlDetails == null ? other$htmlDetails != null : !this$htmlDetails.equals(other$htmlDetails)) {
            return false;
        }
        String this$netSchoolName = this.getNetSchoolName();
        String other$netSchoolName = other.getNetSchoolName();
        if (this$netSchoolName == null ? other$netSchoolName != null : !this$netSchoolName.equals(other$netSchoolName)) {
            return false;
        }
        Date this$dispatchStartTime = this.getDispatchStartTime();
        Date other$dispatchStartTime = other.getDispatchStartTime();
        if (this$dispatchStartTime == null ? other$dispatchStartTime != null : !((Object)this$dispatchStartTime).equals(other$dispatchStartTime)) {
            return false;
        }
        Date this$dispatchEndTime = this.getDispatchEndTime();
        Date other$dispatchEndTime = other.getDispatchEndTime();
        if (this$dispatchEndTime == null ? other$dispatchEndTime != null : !((Object)this$dispatchEndTime).equals(other$dispatchEndTime)) {
            return false;
        }
        List<ClassPackItemDto> this$classPackItem = this.getClassPackItem();
        List<ClassPackItemDto> other$classPackItem = other.getClassPackItem();
        if (this$classPackItem == null ? other$classPackItem != null : !((Object)this$classPackItem).equals(other$classPackItem)) {
            return false;
        }
        Date this$validTime = this.getValidTime();
        Date other$validTime = other.getValidTime();
        if (this$validTime == null ? other$validTime != null : !((Object)this$validTime).equals(other$validTime)) {
            return false;
        }
        List<String> this$courseFormat = this.getCourseFormat();
        List<String> other$courseFormat = other.getCourseFormat();
        if (this$courseFormat == null ? other$courseFormat != null : !((Object)this$courseFormat).equals(other$courseFormat)) {
            return false;
        }
        List<String> this$livePlatform = this.getLivePlatform();
        List<String> other$livePlatform = other.getLivePlatform();
        return !(this$livePlatform == null ? other$livePlatform != null : !((Object)this$livePlatform).equals(other$livePlatform));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpuCreateReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $needAddress = this.getNeedAddress();
        result = result * 59 + ($needAddress == null ? 43 : ((Object)$needAddress).hashCode());
        Long $initSaleCount = this.getInitSaleCount();
        result = result * 59 + ($initSaleCount == null ? 43 : ((Object)$initSaleCount).hashCode());
        Integer $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Integer $productType = this.getProductType();
        result = result * 59 + ($productType == null ? 43 : ((Object)$productType).hashCode());
        Long $netSchoolId = this.getNetSchoolId();
        result = result * 59 + ($netSchoolId == null ? 43 : ((Object)$netSchoolId).hashCode());
        Integer $sectionNum = this.getSectionNum();
        result = result * 59 + ($sectionNum == null ? 43 : ((Object)$sectionNum).hashCode());
        Integer $dispatchType = this.getDispatchType();
        result = result * 59 + ($dispatchType == null ? 43 : ((Object)$dispatchType).hashCode());
        Integer $validType = this.getValidType();
        result = result * 59 + ($validType == null ? 43 : ((Object)$validType).hashCode());
        Integer $realServicePeriod = this.getRealServicePeriod();
        result = result * 59 + ($realServicePeriod == null ? 43 : ((Object)$realServicePeriod).hashCode());
        Integer $freeServicePeriod = this.getFreeServicePeriod();
        result = result * 59 + ($freeServicePeriod == null ? 43 : ((Object)$freeServicePeriod).hashCode());
        Long $examType = this.getExamType();
        result = result * 59 + ($examType == null ? 43 : ((Object)$examType).hashCode());
        Long $specificExam = this.getSpecificExam();
        result = result * 59 + ($specificExam == null ? 43 : ((Object)$specificExam).hashCode());
        String $outProductId = this.getOutProductId();
        result = result * 59 + ($outProductId == null ? 43 : $outProductId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        List<String> $headImg = this.getHeadImg();
        result = result * 59 + ($headImg == null ? 43 : ((Object)$headImg).hashCode());
        SpuDescInfo $descInfo = this.getDescInfo();
        result = result * 59 + ($descInfo == null ? 43 : ((Object)$descInfo).hashCode());
        List<AttrItem> $attrs = this.getAttrs();
        result = result * 59 + ($attrs == null ? 43 : ((Object)$attrs).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<SkuItemDto> $skus = this.getSkus();
        result = result * 59 + ($skus == null ? 43 : ((Object)$skus).hashCode());
        CouponCodeInfo $couponcodeInfo = this.getCouponcodeInfo();
        result = result * 59 + ($couponcodeInfo == null ? 43 : ((Object)$couponcodeInfo).hashCode());
        String $htmlDetails = this.getHtmlDetails();
        result = result * 59 + ($htmlDetails == null ? 43 : $htmlDetails.hashCode());
        String $netSchoolName = this.getNetSchoolName();
        result = result * 59 + ($netSchoolName == null ? 43 : $netSchoolName.hashCode());
        Date $dispatchStartTime = this.getDispatchStartTime();
        result = result * 59 + ($dispatchStartTime == null ? 43 : ((Object)$dispatchStartTime).hashCode());
        Date $dispatchEndTime = this.getDispatchEndTime();
        result = result * 59 + ($dispatchEndTime == null ? 43 : ((Object)$dispatchEndTime).hashCode());
        List<ClassPackItemDto> $classPackItem = this.getClassPackItem();
        result = result * 59 + ($classPackItem == null ? 43 : ((Object)$classPackItem).hashCode());
        Date $validTime = this.getValidTime();
        result = result * 59 + ($validTime == null ? 43 : ((Object)$validTime).hashCode());
        List<String> $courseFormat = this.getCourseFormat();
        result = result * 59 + ($courseFormat == null ? 43 : ((Object)$courseFormat).hashCode());
        List<String> $livePlatform = this.getLivePlatform();
        result = result * 59 + ($livePlatform == null ? 43 : ((Object)$livePlatform).hashCode());
        return result;
    }

    public String toString() {
        return "SpuCreateReq(needAddress=" + this.getNeedAddress() + ", initSaleCount=" + this.getInitSaleCount() + ", outProductId=" + this.getOutProductId() + ", title=" + this.getTitle() + ", subTitle=" + this.getSubTitle() + ", headImg=" + this.getHeadImg() + ", descInfo=" + this.getDescInfo() + ", attrs=" + this.getAttrs() + ", model=" + this.getModel() + ", source=" + this.getSource() + ", skus=" + this.getSkus() + ", couponcodeInfo=" + this.getCouponcodeInfo() + ", productType=" + this.getProductType() + ", htmlDetails=" + this.getHtmlDetails() + ", netSchoolId=" + this.getNetSchoolId() + ", netSchoolName=" + this.getNetSchoolName() + ", sectionNum=" + this.getSectionNum() + ", dispatchType=" + this.getDispatchType() + ", dispatchStartTime=" + this.getDispatchStartTime() + ", dispatchEndTime=" + this.getDispatchEndTime() + ", classPackItem=" + this.getClassPackItem() + ", validType=" + this.getValidType() + ", validTime=" + this.getValidTime() + ", realServicePeriod=" + this.getRealServicePeriod() + ", freeServicePeriod=" + this.getFreeServicePeriod() + ", examType=" + this.getExamType() + ", specificExam=" + this.getSpecificExam() + ", courseFormat=" + this.getCourseFormat() + ", livePlatform=" + this.getLivePlatform() + ")";
    }
}

