/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.coupon.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.component.RedisDistributeLock;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.GoodsValidType;
import com.kuaike.scrm.common.enums.RedissonLockType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.coupon.dto.CouponDiscountInfoDto;
import com.kuaike.scrm.coupon.dto.CouponExtInfoDto;
import com.kuaike.scrm.coupon.dto.CouponPromoteInfoDto;
import com.kuaike.scrm.coupon.dto.CouponReceiveInfoDto;
import com.kuaike.scrm.coupon.dto.CouponStockInfoDto;
import com.kuaike.scrm.coupon.dto.CouponValidInfoDto;
import com.kuaike.scrm.coupon.enums.CouponStatus;
import com.kuaike.scrm.coupon.enums.CouponUsageScenario;
import com.kuaike.scrm.coupon.req.CouponCreateOrUpdateReq;
import com.kuaike.scrm.coupon.req.CouponListReq;
import com.kuaike.scrm.coupon.req.CouponUpdateStatusReq;
import com.kuaike.scrm.coupon.req.CustomerCouponReq;
import com.kuaike.scrm.coupon.resp.BjyCouponResp;
import com.kuaike.scrm.coupon.resp.CouponListResp;
import com.kuaike.scrm.coupon.resp.CustomerCouponResp;
import com.kuaike.scrm.coupon.service.CouponService;
import com.kuaike.scrm.coupon.service.impl.HandleBjyApiService;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCouponRel;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerCoupon;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsRel;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCouponRelMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerCouponMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerParamEncryRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGoodsRelMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.shop.dto.coupon.CouponListQueryParams;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import com.kuaike.scrm.dal.shop.entity.ShopCouponProduct;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponProductMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponServiceImpl
implements CouponService {
    private static final Logger log = LoggerFactory.getLogger(CouponServiceImpl.class);
    @Resource
    private ShopCouponMapper shopCouponMapper;
    @Resource
    private ShopCouponProductMapper shopCouponProductMapper;
    @Resource
    private MeetingCustomerCouponMapper meetingCustomerCouponMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private MeetingGoodsRelMapper meetingGoodsRelMapper;
    @Resource
    private IdGen idGen;
    @Autowired
    private HandleBjyApiService handleBjyApiService;
    @Resource
    private MeetingCouponRelMapper meetingCouponRelMapper;
    @Resource
    private RedisDistributeLock lock;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private MeetingCustomerParamEncryRelationMapper meetingCustomerParamEncryRelationMapper;

    @Override
    public List<CouponListResp> list(CouponListReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("list,req:{}", (Object)req);
        CouponListQueryParams params = new CouponListQueryParams();
        params.setBizId(userInfo.getBizId());
        params.setIsDeleted(Integer.valueOf(0));
        params.setSource(Integer.valueOf(GoodsOrderSource.MEETING_COMMERCE.getSource()));
        if (req.getPageDto() != null) {
            ShopCoupon selectCount = new ShopCoupon();
            selectCount.setBizId(params.getBizId());
            selectCount.setIsDeleted(Integer.valueOf(0));
            selectCount.setSource(Integer.valueOf(GoodsOrderSource.MEETING_COMMERCE.getSource()));
            int total = this.shopCouponMapper.selectCount((Object)selectCount);
            req.getPageDto().setCount(Integer.valueOf(total));
        }
        params.setPageDto(req.getPageDto());
        List shopCoupons = this.shopCouponMapper.selectListByParams(params);
        if (CollectionUtils.isEmpty((Collection)shopCoupons)) {
            return Lists.newArrayList();
        }
        ArrayList<CouponListResp> respDtoList = new ArrayList<CouponListResp>(shopCoupons.size());
        for (ShopCoupon shopCoupon : shopCoupons) {
            respDtoList.add(this.buildResp(shopCoupon));
        }
        return respDtoList;
    }

    public CouponListResp buildResp(ShopCoupon shopCoupon) {
        CouponListResp respDto = new CouponListResp();
        respDto.setName(shopCoupon.getName());
        respDto.setCouponId(shopCoupon.getCouponId());
        respDto.setType(shopCoupon.getType());
        respDto.setStatus(shopCoupon.getStatus());
        respDto.setUsageScenario(shopCoupon.getUsageScenario());
        CouponValidInfoDto validInfoDto = new CouponValidInfoDto();
        validInfoDto.setValidType(shopCoupon.getValidType());
        validInfoDto.setValidDayNum(shopCoupon.getValidDayNum());
        validInfoDto.setValidStartTime(shopCoupon.getValidStartTime() != null ? DateUtil.dateToDateString((Date)shopCoupon.getValidStartTime()) : "");
        validInfoDto.setValidEndTime(shopCoupon.getValidEndTime() != null ? DateUtil.dateToDateString((Date)shopCoupon.getValidEndTime()) : "");
        respDto.setValidInfo(validInfoDto);
        CouponPromoteInfoDto promoteInfoDto = new CouponPromoteInfoDto();
        promoteInfoDto.setPromoteType(shopCoupon.getPromoteType());
        promoteInfoDto.setCustomizeChannel(shopCoupon.getCustomizeChannel());
        respDto.setPromoteInfo(promoteInfoDto);
        CouponDiscountInfoDto discountInfoDto = new CouponDiscountInfoDto();
        discountInfoDto.setDiscountNum(shopCoupon.getDiscountNum());
        discountInfoDto.setDiscountFee(shopCoupon.getDiscountFee());
        discountInfoDto.setProductCnt(shopCoupon.getProductCnt());
        discountInfoDto.setProductPrice(shopCoupon.getProductPrice());
        List productIds = this.shopCouponProductMapper.selectProductIdsByCouponId(shopCoupon.getBizId(), shopCoupon.getCouponId());
        discountInfoDto.setProductIds(productIds);
        respDto.setDiscountInfo(discountInfoDto);
        CouponReceiveInfoDto receiveInfoDto = new CouponReceiveInfoDto();
        receiveInfoDto.setStartTime(DateUtil.dateToDateString((Date)shopCoupon.getReceiveStartTime()));
        receiveInfoDto.setEndTime(DateUtil.dateToDateString((Date)shopCoupon.getReceiveEndTime()));
        receiveInfoDto.setTotalNum(shopCoupon.getTotalNum());
        receiveInfoDto.setLimitNumOnePerson(shopCoupon.getLimitNumOnePerson());
        respDto.setReceiveInfo(receiveInfoDto);
        CouponStockInfoDto stockInfoDto = new CouponStockInfoDto();
        stockInfoDto.setReceiveNum(shopCoupon.getReceiveNum());
        stockInfoDto.setTotalNum(shopCoupon.getTotalNum());
        stockInfoDto.setUsedNum(shopCoupon.getUsedNum());
        respDto.setStockInfo(stockInfoDto);
        CouponExtInfoDto extInfoDto = new CouponExtInfoDto();
        extInfoDto.setNotes(shopCoupon.getNotes());
        extInfoDto.setJumpProductId(shopCoupon.getJumpProductId());
        respDto.setExtInfo(extInfoDto);
        respDto.setUsageScenario(shopCoupon.getUsageScenario());
        return respDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void couponCreateOrUpdate(CouponCreateOrUpdateReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("createOrUpdate,dto:{}", (Object)req);
        req.validate();
        if (StringUtils.isNotBlank((CharSequence)req.getCouponId())) {
            this.updateCoupon(userInfo, req);
        } else {
            this.createCoupon(userInfo, req);
        }
    }

    private void createCoupon(CurrentUserInfo userInfo, CouponCreateOrUpdateReq req) {
        BjyCouponResp bjyCouponResp;
        String couponId = this.idGen.getNum();
        ShopCoupon shopCoupon = this.couponCreateReqToShopCoupon(req, userInfo, true, couponId);
        this.shopCouponMapper.insert((Object)shopCoupon);
        String couponBatchNo = null;
        if (CouponUsageScenario.MEETING.getType().equals(shopCoupon.getUsageScenario()) && Objects.nonNull(bjyCouponResp = this.handleBjyApiService.handleBjyCouponAdd(shopCoupon)) && StringUtils.isNotBlank((CharSequence)bjyCouponResp.getCouponBatchNo())) {
            ShopCoupon updateCoupon = new ShopCoupon();
            updateCoupon.setId(shopCoupon.getId());
            couponBatchNo = bjyCouponResp.getCouponBatchNo();
            updateCoupon.setCouponButchNo(couponBatchNo);
            updateCoupon.setUpdateBy(LoginUtils.getCurrentUserId());
            updateCoupon.setUpdateTime(new Date());
            this.shopCouponMapper.updateByPrimaryKeySelective((Object)updateCoupon);
        }
        this.handleBatchInsertCouponProduct(req.getDiscountInfo().getProductIds(), shopCoupon.getCouponId(), userInfo);
        List<String> productIds = req.getDiscountInfo().getProductIds();
        if (CollectionUtils.isEmpty(productIds)) {
            return;
        }
        if (StringUtils.isBlank(couponBatchNo)) {
            return;
        }
        List productIdStrs = productIds.stream().map(String::valueOf).collect(Collectors.toList());
        List meetingGoodsRels = this.meetingGoodsRelMapper.selNotCloseMeetingByMeetingIdAndProductIds(LoginUtils.getCurrentUserBizId(), null, productIdStrs);
        if (CollectionUtils.isEmpty((Collection)meetingGoodsRels)) {
            return;
        }
        Map<String, List<MeetingGoodsRel>> roomIdMap = meetingGoodsRels.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getRoomId())).collect(Collectors.groupingBy(MeetingGoodsRel::getRoomId));
        log.info("\u9700\u8981\u5173\u8054\u4f18\u60e0\u5238\uff1abathNo{} \u7684\u76f4\u64ad\u95f4\u6709\uff1a{},bizId:{}", new Object[]{couponBatchNo, JSON.toJSONString(roomIdMap), LoginUtils.getCurrentUserBizId()});
        for (Map.Entry<String, List<MeetingGoodsRel>> mapEntry : roomIdMap.entrySet()) {
            this.handleBjyApiService.handleBjyCouponAssociateMeeting(mapEntry.getKey(), Lists.newArrayList((Object[])new String[]{couponBatchNo}));
            MeetingCouponRel meetingCouponRel = new MeetingCouponRel();
            meetingCouponRel.setCouponBatchNo(couponBatchNo);
            meetingCouponRel.setCouponId(shopCoupon.getCouponId());
            meetingCouponRel.setStatus(YnEnum.YES.getValue());
            meetingCouponRel.setRoomId(mapEntry.getKey());
            meetingCouponRel.setCreateBy(userInfo.getId());
            meetingCouponRel.setUpdateTime(new Date());
            meetingCouponRel.setCreateTime(new Date());
            meetingCouponRel.setUpdateBy(userInfo.getId());
            meetingCouponRel.setNum(this.idGen.getNum());
            meetingCouponRel.setBizId(LoginUtils.getCurrentUserBizId());
            meetingCouponRel.setMeetingId(mapEntry.getValue().get(0).getMeetingId());
            try {
                this.meetingCouponRelMapper.insert((Object)meetingCouponRel);
            }
            catch (Exception e) {
                log.error("\u63d2\u5165\u5931\u8d25\uff0c\u6570\u636e\u56de\u6eda,param:{}", (Object)JSON.toJSONString(mapEntry), (Object)e);
                this.handleBjyApiService.handBjyCouponUnAssociateMeeting(mapEntry.getKey(), Lists.newArrayList());
            }
        }
    }

    private void updateCoupon(CurrentUserInfo userInfo, CouponCreateOrUpdateReq req) {
        ShopCoupon exist = new ShopCoupon();
        exist.setCouponId(req.getCouponId());
        exist.setBizId(userInfo.getBizId());
        exist.setIsDeleted(Integer.valueOf(0));
        ShopCoupon shopCoupon = (ShopCoupon)this.shopCouponMapper.selectOne((Object)exist);
        Preconditions.checkArgument((shopCoupon != null ? 1 : 0) != 0, (Object)"\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        ShopCoupon updateShopCoupon = this.couponCreateReqToShopCoupon(req, userInfo, false, null);
        updateShopCoupon.setUpdateBy(userInfo.getId());
        updateShopCoupon.setUpdateTime(new Date());
        updateShopCoupon.setId(shopCoupon.getId());
        if (CouponUsageScenario.MEETING.getType().equals(shopCoupon.getUsageScenario())) {
            this.handleBjyApiService.handleBjyCouponEdit(updateShopCoupon);
        }
        this.shopCouponMapper.updateByPrimaryKeySelective((Object)updateShopCoupon);
        this.updateCouponProduct(shopCoupon.getCouponId(), userInfo, req.getDiscountInfo().getProductIds());
    }

    private void updateCouponProduct(String couponId, CurrentUserInfo userInfo, List<String> productIds) {
        if (CollectionUtils.isEmpty(productIds)) {
            return;
        }
        ShopCouponProduct exist = new ShopCouponProduct();
        exist.setBizId(userInfo.getBizId());
        exist.setCouponId(couponId);
        List existsRelation = this.shopCouponProductMapper.select((Object)exist);
        if (CollectionUtils.isEmpty((Collection)existsRelation)) {
            this.handleBatchInsertCouponProduct(productIds, couponId, userInfo);
        } else {
            List<String> insertProducts;
            List existProductIds = existsRelation.stream().map(ShopCouponProduct::getProductId).collect(Collectors.toList());
            List delProducts = existProductIds.stream().filter(p -> !productIds.contains(p)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(delProducts)) {
                log.info("updateCouponProduct delProducts:{}", delProducts);
                this.shopCouponProductMapper.deleteByProductIds(delProducts, userInfo.getBizId());
            }
            if (CollectionUtils.isNotEmpty(insertProducts = productIds.stream().filter(p -> !existProductIds.contains(p)).collect(Collectors.toList()))) {
                this.handleBatchInsertCouponProduct(insertProducts, couponId, userInfo);
            }
        }
    }

    private void handleBatchInsertCouponProduct(List<String> productIds, String couponId, CurrentUserInfo userInfo) {
        if (CollectionUtils.isEmpty(productIds)) {
            return;
        }
        Date now = new Date();
        ArrayList<ShopCouponProduct> list = new ArrayList<ShopCouponProduct>();
        for (String productId : productIds) {
            ShopCouponProduct product = new ShopCouponProduct();
            product.setNum(this.idGen.getNum());
            product.setBizId(userInfo.getBizId());
            product.setCorpId(userInfo.getCorpId());
            product.setProductId(productId);
            product.setCouponId(couponId);
            product.setAppId("-1");
            product.setCreateBy(userInfo.getId());
            product.setCreateTime(now);
            product.setUpdateBy(userInfo.getId());
            product.setUpdateTime(now);
            product.setIsDeleted(Integer.valueOf(0));
            list.add(product);
        }
        this.shopCouponProductMapper.batchInsert(list);
    }

    private ShopCoupon couponCreateReqToShopCoupon(CouponCreateOrUpdateReq req, CurrentUserInfo userInfo, boolean isInsert, String couponId) {
        Date now = new Date();
        ShopCoupon shopCoupon = new ShopCoupon();
        shopCoupon.setUsageScenario(req.getUsageScenario());
        shopCoupon.setBizId(userInfo.getBizId());
        shopCoupon.setCorpId(userInfo.getCorpId());
        CouponPromoteInfoDto promoteInfo = req.getPromoteInfo();
        shopCoupon.setPromoteType(promoteInfo.getPromoteType());
        shopCoupon.setCustomizeChannel(promoteInfo.getCustomizeChannel());
        shopCoupon.setName(req.getName());
        shopCoupon.setType(req.getType());
        CouponDiscountInfoDto discountInfo = req.getDiscountInfo();
        shopCoupon.setDiscountNum(Integer.valueOf(discountInfo.getDiscountNum() != null ? discountInfo.getDiscountNum() : 0));
        shopCoupon.setDiscountFee(Long.valueOf(discountInfo.getDiscountFee() != null ? discountInfo.getDiscountFee() : 0L));
        shopCoupon.setProductCnt(Integer.valueOf(0));
        shopCoupon.setProductPrice(Long.valueOf(discountInfo.getProductPrice() != null ? discountInfo.getProductPrice() : 0L));
        CouponReceiveInfoDto receiveInfo = req.getReceiveInfo();
        Date receiveStartTime = DateUtil.getDate((String)receiveInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
        Date receiveEndTime = DateUtil.getDate((String)receiveInfo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
        shopCoupon.setReceiveStartTime(receiveStartTime);
        shopCoupon.setReceiveEndTime(receiveEndTime);
        CouponValidInfoDto validInfo = req.getValidInfo();
        shopCoupon.setValidType(validInfo.getValidType());
        shopCoupon.setValidDayNum(Integer.valueOf(validInfo.getValidDayNum() != null ? validInfo.getValidDayNum() : 0));
        shopCoupon.setTotalNum(receiveInfo.getTotalNum());
        shopCoupon.setLimitNumOnePerson(receiveInfo.getLimitNumOnePerson());
        CouponExtInfoDto extInfo = req.getExtInfo();
        if (GoodsValidType.COUPON_VALID_TYPE_TIME.getType().equals(validInfo.getValidType())) {
            shopCoupon.setValidStartTime(DateUtil.getDate((String)validInfo.getValidStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            shopCoupon.setValidEndTime(DateUtil.getDate((String)validInfo.getValidEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            shopCoupon.setValidStartTime(receiveStartTime);
            shopCoupon.setValidEndTime(DateUtil.getDateAddDay((Date)receiveEndTime, (int)validInfo.getValidDayNum()));
        }
        shopCoupon.setNotes(extInfo.getNotes());
        shopCoupon.setJumpProductId(extInfo.getJumpProductId());
        shopCoupon.setStatus(CouponStatus.EFFECTIVE.getStatus());
        shopCoupon.setUpdateBy(userInfo.getId());
        shopCoupon.setUpdateTime(now);
        if (isInsert) {
            shopCoupon.setNum(this.idGen.getNum());
            shopCoupon.setReceiveNum(Integer.valueOf(0));
            shopCoupon.setUsedNum(Integer.valueOf(0));
            shopCoupon.setCouponId(couponId);
            shopCoupon.setAppId("-1");
            shopCoupon.setCreateBy(userInfo.getId());
            shopCoupon.setCreateTime(now);
            shopCoupon.setIsDeleted(Integer.valueOf(0));
            shopCoupon.setSource(Integer.valueOf(GoodsOrderSource.MEETING_COMMERCE.getSource()));
        }
        return shopCoupon;
    }

    @Override
    public void updateStatus(CouponUpdateStatusReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("updateStatus,dto:{}", (Object)req);
        req.validate();
        ShopCoupon exist = new ShopCoupon();
        exist.setCouponId(req.getCouponId());
        exist.setBizId(userInfo.getBizId());
        exist.setIsDeleted(Integer.valueOf(0));
        ShopCoupon shopCoupon = (ShopCoupon)this.shopCouponMapper.selectOne((Object)exist);
        Preconditions.checkArgument((shopCoupon != null ? 1 : 0) != 0, (Object)"\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        Integer status = req.getStatus();
        if (shopCoupon.getStatus().equals(status)) {
            return;
        }
        ShopCoupon update = new ShopCoupon();
        update.setId(shopCoupon.getId());
        if (CouponStatus.DELETED.getStatus().equals(status)) {
            update.setIsDeleted(Integer.valueOf(1));
            this.handleBjyApiService.handleBjyCouponDel(shopCoupon);
            this.handUnAssociateCoupon(shopCoupon);
        } else if (CouponStatus.INVALIDATED.getStatus().equals(status)) {
            this.handleBjyApiService.handleBjyCouponDel(shopCoupon);
            this.handUnAssociateCoupon(shopCoupon);
        }
        update.setStatus(status);
        update.setUpdateBy(userInfo.getId());
        update.setUpdateTime(new Date());
        this.shopCouponMapper.updateByPrimaryKeySelective((Object)update);
    }

    public void handUnAssociateCoupon(ShopCoupon shopCoupon) {
        if (Objects.isNull(shopCoupon)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)shopCoupon.getCouponButchNo())) {
            return;
        }
        List meetingCouponRels = this.meetingCouponRelMapper.selectByCouponBatchNoAndBizid(LoginUtils.getCurrentUserBizId(), shopCoupon.getCouponButchNo());
        for (MeetingCouponRel meetingCouponRel : meetingCouponRels) {
            this.handleBjyApiService.handBjyCouponUnAssociateMeeting(meetingCouponRel.getRoomId(), Lists.newArrayList((Object[])new String[]{meetingCouponRel.getCouponBatchNo()}));
            MeetingCouponRel updateCouponRel = new MeetingCouponRel();
            updateCouponRel.setId(meetingCouponRel.getId());
            updateCouponRel.setUpdateBy(LoginUtils.getCurrentUserId());
            updateCouponRel.setUpdateTime(new Date());
            updateCouponRel.setStatus(YnEnum.NO.getValue());
            this.meetingCouponRelMapper.updateByPrimaryKeySelective((Object)updateCouponRel);
        }
    }

    @Override
    public List<CustomerCouponResp> customerCouponList(CustomerCouponReq req) {
        log.info("customerCouponList req:{}", (Object)req);
        req.validate();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{req.getCustomerStr(), req.getUserNumber()})) {
            return Collections.emptyList();
        }
        MeetingGoodsRel selectRelation = new MeetingGoodsRel();
        selectRelation.setRoomId(req.getRoomId());
        List meetingGoodsRels = this.meetingGoodsRelMapper.select((Object)selectRelation);
        Set productIds = meetingGoodsRels.stream().map(MeetingGoodsRel::getGoodsProductId).collect(Collectors.toSet());
        if (!productIds.contains(req.getProductId())) {
            log.warn("customerCouponList \u5f53\u524d\u76f4\u64ad\u95f4\u6ca1\u6709\u4e0e\u8be5\u5546\u54c1\u5173\u8054 \u4e0e\u76f4\u64ad\u95f4{}\u5173\u8054\u7684\u5546\u54c1\u6709{}", (Object)req.getRoomId(), productIds);
            return Collections.emptyList();
        }
        Long bizId = ((MeetingGoodsRel)meetingGoodsRels.get(0)).getBizId();
        MeetingCustomerInfo selectInfo = new MeetingCustomerInfo();
        ArrayList<String> customerInfoNums = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)req.getUserNumber())) {
            selectInfo = new MeetingCustomerInfo();
            selectInfo.setRoomId(req.getRoomId());
            selectInfo.setBizId(selectRelation.getBizId());
            selectInfo.setBjyNumber(req.getUserNumber());
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)selectInfo);
            if (CollectionUtils.isEmpty((Collection)meetingCustomerInfos)) {
                log.info("customerCouponList \u6839\u636ebjyNumber\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f customerStr:{} bjyNumber:{}", (Object)req.getCustomerStr(), (Object)req.getUserNumber());
                return Collections.emptyList();
            }
            customerInfoNums.addAll(meetingCustomerInfos.stream().map(MeetingCustomerInfo::getNum).collect(Collectors.toList()));
        } else {
            selectInfo.setCustomerStr(req.getCustomerStr());
            selectInfo.setRoomId(req.getRoomId());
            selectInfo.setBizId(bizId);
            List customerInfos = this.meetingCustomerInfoMapper.select((Object)selectInfo);
            if (CollectionUtils.isEmpty((Collection)customerInfos)) {
                List meetings = this.meetingMapper.selectByRoomId(req.getRoomId());
                if (CollectionUtils.isEmpty((Collection)meetings)) {
                    log.error("customerCouponList \u6839\u636eroomId\u67e5\u8be2\u4e0d\u5230\u4f1a\u8bae\u4fe1\u606f roomId:{}", (Object)req.getRoomId());
                    return Collections.emptyList();
                }
                List meetingIds = meetings.stream().map(Meeting::getId).collect(Collectors.toList());
                List relations = this.meetingCustomerParamEncryRelationMapper.queryByCustomerStrAndMeetingIds(bizId, req.getCustomerStr(), meetingIds);
                if (CollectionUtils.isEmpty((Collection)relations)) {
                    return Collections.emptyList();
                }
                selectInfo = new MeetingCustomerInfo();
                selectInfo.setRoomId(req.getRoomId());
                selectInfo.setBizId(selectRelation.getBizId());
                selectInfo.setBjyNumber(((MeetingCustomerParamEncryRelation)relations.get(0)).getBjyNumber());
                List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)selectInfo);
                if (CollectionUtils.isEmpty((Collection)meetingCustomerInfos)) {
                    log.info("customerCouponList \u6839\u636ecustomerStr\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f \u6839\u636ebjyNumber\u4e5f\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f customerStr:{} bjyNumber:{}", (Object)req.getCustomerStr(), (Object)((MeetingCustomerParamEncryRelation)relations.get(0)).getBjyNumber());
                    return Collections.emptyList();
                }
                customerInfoNums.addAll(meetingCustomerInfos.stream().map(MeetingCustomerInfo::getNum).collect(Collectors.toList()));
            } else {
                customerInfoNums.add(((MeetingCustomerInfo)customerInfos.get(0)).getNum());
            }
        }
        if (CollectionUtils.isEmpty(customerInfoNums)) {
            log.info("customerCouponList customerStr:{} bjyNumber:{} customerInfoNums isEmpty", (Object)req.getCustomerStr(), (Object)req.getUserNumber());
            return Collections.emptyList();
        }
        List meetingCustomerCoupons = this.meetingCustomerCouponMapper.queryUnUseByMeetingCustomerNums(bizId, customerInfoNums, null);
        if (CollectionUtils.isEmpty((Collection)meetingCustomerCoupons)) {
            log.info("customerCouponList customerStr:{} bjyNumber:{} \u7528\u6237\u6ca1\u6709\u4f18\u60e0\u5238 customerNums:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), customerInfoNums});
            return Collections.emptyList();
        }
        List couponIds = this.shopCouponProductMapper.selectCouponIdsByProductIds(bizId, Collections.singletonList(req.getProductId()));
        if (CollectionUtils.isEmpty((Collection)couponIds)) {
            log.info("customerCouponList customerStr:{} bjyNumber:{} \u5f53\u524d\u5546\u54c1\u6ca1\u6709\u5173\u8054\u7684\u4f18\u60e0\u5238 productId:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), req.getProductId()});
            return Collections.emptyList();
        }
        List shopCoupons = this.shopCouponMapper.selectByCouponIds(bizId, couponIds, null);
        if (CollectionUtils.isEmpty((Collection)shopCoupons)) {
            log.info("customerCouponList customerStr:{} bjyNumber:{} \u901a\u8fc7\u4f18\u60e0\u5238id \u67e5\u4e0d\u5230\u4f18\u60e0\u5238\u4fe1\u606f couponIds:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), couponIds});
            return Collections.emptyList();
        }
        Set couponNums = shopCoupons.stream().map(ShopCoupon::getNum).collect(Collectors.toSet());
        Map couponMap = shopCoupons.stream().collect(Collectors.toMap(ShopCoupon::getNum, Function.identity()));
        log.info("customerCouponList customerStr:{} bjyNumber:{} \u4e0e\u5546\u54c1\u6709\u5173\u7684\u4f18\u60e0\u5238couponNums:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), couponNums});
        ArrayList<CustomerCouponResp> respList = new ArrayList<CustomerCouponResp>();
        for (MeetingCustomerCoupon meetingCustomerCoupon : meetingCustomerCoupons) {
            if (!couponNums.contains(meetingCustomerCoupon.getCouponNum())) {
                log.info("customerCouponList customerStr:{} bjyNumber:{} \u7528\u6237\u9886\u53d6\u7684\u8be5\u4f18\u60e0\u5238 \u4e0e\u5f53\u524d\u5546\u54c1\u65e0\u5173 \u5f53\u524d\u4f18\u60e0\u5238:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), meetingCustomerCoupon.getCouponNum()});
                continue;
            }
            CustomerCouponResp resp = new CustomerCouponResp();
            resp.setCouponId(meetingCustomerCoupon.getCouponNum());
            ShopCoupon shopCoupon = (ShopCoupon)couponMap.get(meetingCustomerCoupon.getCouponNum());
            if (shopCoupon == null) {
                log.info("customerCouponList customerStr:{} bjyNumber:{} \u7528\u6237\u9886\u53d6\u7684\u8be5\u4f18\u60e0\u5238 \u67e5\u8be2\u4e0d\u5230\u4f18\u60e0\u5238\u4fe1\u606f \u5f53\u524d\u4f18\u60e0\u5238:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), meetingCustomerCoupon.getCouponNum()});
                continue;
            }
            Integer validType = shopCoupon.getValidType();
            Date now = new Date();
            if (GoodsValidType.COUPON_VALID_TYPE_TIME.getType().equals(validType)) {
                Date validStartTime = shopCoupon.getValidStartTime();
                if (now.before(validStartTime)) {
                    log.info("customerCouponList customerStr:{} bjyNumber:{} \u4f18\u60e0\u5238\u6682\u672a\u751f\u6548 \u65e0\u6cd5\u4f7f\u7528 now:{} validStartTime:{} \u4f18\u60e0\u5238couponNum:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), now, validStartTime, shopCoupon.getCouponId()});
                    continue;
                }
                Date validEndTime = shopCoupon.getValidEndTime();
                if (now.after(validEndTime)) {
                    log.info("customerCouponList customerStr:{} bjyNumber:{} \u4f18\u60e0\u5238\u5df2\u8fc7\u751f\u6548\u65f6\u95f4 \u65e0\u6cd5\u4f7f\u7528 now:{} validEndTime:{} \u4f18\u60e0\u5238couponNum:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), now, validEndTime, shopCoupon.getCouponId()});
                    continue;
                }
            } else {
                Date createTime = ((MeetingCustomerCoupon)meetingCustomerCoupons.get(0)).getCreateTime();
                Integer validDayNum = shopCoupon.getValidDayNum();
                int quotByDays = DateUtil.getQuotByDays((Date)createTime, (Date)now);
                if (quotByDays > validDayNum) {
                    log.info("customerCouponList customerStr:{} bjyNumber:{} \u4f18\u60e0\u5238\u5df2\u8fc7\u751f\u6548\u65f6\u95f4 \u65e0\u6cd5\u4f7f\u7528 now:{} \u9886\u53d6\u65f6\u95f4createTime:{}  {}\u5929\u5185\u6709\u6548  \u4f18\u60e0\u5238couponNum:{}", new Object[]{req.getCustomerStr(), req.getUserNumber(), now, createTime, validDayNum, shopCoupon.getCouponId()});
                    continue;
                }
            }
            resp.setName(shopCoupon.getName());
            resp.setProductPrice(shopCoupon.getProductPrice());
            resp.setDiscountFee(shopCoupon.getDiscountFee());
            resp.setType(shopCoupon.getType());
            resp.setCouponCode(meetingCustomerCoupon.getCouponCode());
            respList.add(resp);
        }
        log.info("customerCouponList,resp:{}", respList);
        return respList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMeetingCouponGet(Long bizId, String bjyCouponNo) {
        log.info("handleMeetingCouponGet bizId:{} bjyCouponNo:{}", (Object)bizId, (Object)bjyCouponNo);
        ShopCoupon shopCoupon = this.shopCouponMapper.queryCouponByBjyCouponNo(bizId, bjyCouponNo);
        if (shopCoupon == null) {
            log.error("handleMeetingCouponGet \u67e5\u8be2\u4e0d\u5230\u4f18\u60e0\u5238");
            return;
        }
        String key = "handleMeetingCouponGet:" + bizId + ":" + bjyCouponNo;
        try {
            this.lock.lock(key, RedissonLockType.REENTRANT_LOCK, 15000L, 5000L);
            ShopCoupon coupon = (ShopCoupon)this.shopCouponMapper.selectByPrimaryKey((Object)shopCoupon.getId());
            if (coupon == null) {
                log.error("handleMeetingCouponGet \u67e5\u8be2\u4e0d\u5230\u4f18\u60e0\u5238 couponId:{}", (Object)shopCoupon.getId());
                return;
            }
            shopCoupon.setReceiveNum(Integer.valueOf(shopCoupon.getReceiveNum() + 1));
            shopCoupon.setUpdateTime(new Date());
            this.shopCouponMapper.updateByPrimaryKey((Object)shopCoupon);
        }
        catch (Exception e) {
            log.error("handleMeetingCouponGet error couponId:{}", (Object)shopCoupon.getId(), (Object)e);
        }
        finally {
            this.lock.unlock(key);
        }
    }
}

