/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.order.service.impl;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.OrderNotifyTargetType;
import com.kuaike.scrm.common.enums.OrderNotifyType;
import com.kuaike.scrm.common.service.NotificationSettingService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.NotificationConfigDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.TemplateReplaceUtil;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.order.dto.OrderNotifyDto;
import com.kuaike.scrm.order.service.OrderPayNotificationService;
import com.kuaike.scrm.remind.service.RemindService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderPayNotificationServiceImpl
implements OrderPayNotificationService {
    private static final Logger log = LoggerFactory.getLogger(OrderPayNotificationServiceImpl.class);
    @Autowired
    private NotificationSettingService notificationSettingService;
    @Autowired
    private RemindService remindService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private SettingService settingService;
    @Value(value="${notify.pay.paid}")
    private String paidNotifyTemplate;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String scrmManagerHost;

    @Override
    public void sendPaySuccessNotify(OrderNotifyDto orderNotifyDto) {
        List weworkUserList;
        User user;
        log.info("sendPaySuccessNotify,orderNotify:{}", (Object)orderNotifyDto);
        HashSet<String> targetWeworkNum = new HashSet<String>();
        HashSet<String> targetWeworkIds = new HashSet<String>();
        String corpId = this.scrmBizService.getById(orderNotifyDto.getBizId()).getCorpId();
        NotificationConfigDto config = this.getNotificationConfigDto(orderNotifyDto.getBizId());
        if (config == null) {
            return;
        }
        if ((config.getTargetType() & OrderNotifyTargetType.INVITE.getValue()) != 0 && StringUtils.isNotEmpty((CharSequence)orderNotifyDto.getInviteNum())) {
            targetWeworkNum.add(orderNotifyDto.getInviteNum());
        }
        if ((config.getTargetType() & OrderNotifyTargetType.BIND.getValue()) != 0 && orderNotifyDto.getBindUserId() != null && StringUtils.isNotBlank((CharSequence)(user = this.userMapper.getUserInfoById(orderNotifyDto.getBindUserId())).getWeworkUserId())) {
            targetWeworkIds.add(user.getWeworkUserId());
        }
        if ((config.getTargetType() & OrderNotifyTargetType.DESIGNATE.getValue()) != 0) {
            targetWeworkNum.addAll(Arrays.asList(config.getTargets().split(",")));
        }
        if (!targetWeworkNum.isEmpty() && !(weworkUserList = this.weworkUserMapper.queryInfoListByNums(targetWeworkNum)).isEmpty()) {
            targetWeworkIds.addAll(weworkUserList.stream().map(WeworkUser::getWeworkUserId).collect(Collectors.toList()));
        }
        log.info("sendPaySuccessNotify, orderId:{}, corpId:{}, targetWeworkNum:{}, targetWeworkIds:{}, config:{}", new Object[]{orderNotifyDto.getOrderId(), corpId, targetWeworkNum, targetWeworkIds, config});
        String content = this.buildNotifyContent(orderNotifyDto, this.paidNotifyTemplate);
        log.info("sendPaySuccessNotify, orderId:{}, content:{}", (Object)orderNotifyDto.getOrderId(), (Object)content);
        this.remindService.sendMsg(corpId, String.join((CharSequence)"|", targetWeworkIds), content);
    }

    private NotificationConfigDto getNotificationConfigDto(Long bizId) {
        List configDtos;
        NotificationConfigDto config = null;
        try {
            configDtos = this.notificationSettingService.getConfig(bizId);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u901a\u77e5\u914d\u7f6e\u5931\u8d25 bizId:{}", (Object)bizId, (Object)e);
            return null;
        }
        for (NotificationConfigDto configDto : configDtos) {
            if (configDto.getType().intValue() != OrderNotifyType.MEETING_FINISH_PAY.getValue()) continue;
            config = configDto;
            break;
        }
        if (config == null) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u914d\u7f6e bizId:{}", (Object)bizId);
            return null;
        }
        if (config.getOpen() == 0) {
            log.info("\u901a\u77e5\u672a\u5f00\u542f config:{}", config);
            return null;
        }
        return config;
    }

    private String buildNotifyContent(OrderNotifyDto notifyDto, String template) {
        if (notifyDto.getCustomer() == null) {
            notifyDto.setCustomer(notifyDto.getWechatName());
        }
        String corpId = this.scrmBizService.getById(notifyDto.getBizId()).getCorpId();
        notifyDto.setCorpId(corpId);
        String customerNum = notifyDto.getCustomerNum();
        if (StringUtils.isEmpty((CharSequence)customerNum)) {
            customerNum = this.ccCustomerNumService.getCustomerNumByMobile(notifyDto.getBizId(), notifyDto.getPhone());
        }
        if (StringUtils.isNotBlank((CharSequence)customerNum)) {
            if (StringUtils.isBlank((CharSequence)notifyDto.getContactId())) {
                WeworkContact weworkContact;
                String weworkContactId = this.ccCustomerNumService.getWeworkContactId(notifyDto.getBizId(), customerNum);
                notifyDto.setContactId(weworkContactId);
                if (StringUtils.isNotBlank((CharSequence)weworkContactId) && (weworkContact = this.weworkContactMapper.queryContactByContactId(corpId, weworkContactId)) != null) {
                    notifyDto.setWechatName(weworkContact.getName());
                }
            }
            if (StringUtils.isBlank((CharSequence)notifyDto.getCustomer())) {
                CustomerDetailResp detailResp = this.ccCustomerDetailService.queryCustomerDetail(notifyDto.getBizId(), customerNum);
                notifyDto.setCustomer(detailResp.getName());
            }
        }
        notifyDto.wrapNull();
        ConcurrentMap params = Maps.newConcurrentMap();
        params.put("{orderTitle}", notifyDto.getOrderTitle());
        params.put("{name}", notifyDto.getCustomer());
        params.put("{wechat}", notifyDto.getWechatName());
        params.put("{orderId}", notifyDto.getOrderId());
        String orderAmountStr = "--";
        if (notifyDto.getOrderAmount() != null) {
            orderAmountStr = BigDecimal.valueOf(notifyDto.getOrderAmount()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_DOWN).toString();
        }
        params.put("{orderAmount}", orderAmountStr);
        params.put("{product}", notifyDto.getProduct());
        String phone = notifyDto.getPhone();
        if (this.settingService.getMobileEncrypt(notifyDto.getBizId())) {
            phone = MobileUtils.encryptMobile((String)notifyDto.getPhone());
        }
        params.put("{phone}", phone);
        String orderTimeStr = "--";
        if (notifyDto.getOrderTime() != null) {
            orderTimeStr = DateUtil.dateToDateString((Date)new Date(notifyDto.getOrderTime()));
        }
        params.put("{orderTime}", orderTimeStr);
        params.put("{saleman}", notifyDto.getWeworkUserName());
        String customerDetail = notifyDto.getContactId() != null && notifyDto.getCorpId() != null ? MessageFormat.format("<a href=\"{0}/clientSide?contactId={1}&corpId={2}\">\u5ba2\u6237\u8be6\u60c5</a>", this.scrmManagerHost, notifyDto.getContactId(), notifyDto.getCorpId()) : "";
        params.put("{customerDetail}", customerDetail);
        return TemplateReplaceUtil.render((String)template, (Map)params);
    }
}

