/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.order.service;

import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.OrderReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderPayStatusReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.enums.PayChannelType;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.wework.sdk.utils.JacksonUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.enums.meeting.MeetingLiveDeliveryAuthMode;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.goods.dto.SkuItemDto;
import com.kuaike.scrm.order.dto.AddressInfo;
import com.kuaike.scrm.order.dto.CouponInfoDto;
import com.kuaike.scrm.order.dto.DeliveryInfoDto;
import com.kuaike.scrm.order.dto.ExtInfo;
import com.kuaike.scrm.order.dto.JudgeOrderBelongUserIdDto;
import com.kuaike.scrm.order.dto.OrderDetailDto;
import com.kuaike.scrm.order.dto.PayInfoDto;
import com.kuaike.scrm.order.dto.PriceInfoDto;
import com.kuaike.scrm.order.dto.ProductInfo;
import com.kuaike.scrm.order.dto.ShopSkuDto;
import com.kuaike.scrm.order.enums.OrderStatus;
import com.kuaike.scrm.order.model.OrderEsModel;
import com.kuaike.scrm.order.service.GoodsOrderService;
import com.kuaike.scrm.system.utils.NetSchoolGoodsId;
import com.kuaike.trace.utils.TraceExecutorWrapUtil;
import com.kuaike.trace.utils.TraceIdUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.valuecount.ParsedValueCount;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GoodsOrderEsService {
    private static final Logger log = LoggerFactory.getLogger(GoodsOrderEsService.class);
    @Value(value="${scrm.elasticsearch.shopOrderIndex}")
    private String shopOrderIndex;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private PackageMapper packageMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Resource
    private CcCustomerDetailService ccCustomerDetailService;
    @Resource
    private CcCustomerOrderService ccCustomerOrderService;
    @Resource
    private CcCustomerEventService ccCustomerEventService;
    @Resource
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private GoodsOrderService goodsOrderService;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    private static final String TYPE = "doc";
    private static final String SOURCE = "scrm";
    private ExecutorService orderSaveExecutorService = new ThreadPoolExecutor(2, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("orderSaveExecutorService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.orderSaveExecutorService);
    }

    public Long selectCountByProductId(Long productId) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopOrderIndex});
        searchRequest.types(new String[]{TYPE});
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("orderDetail.productInfos.product_id.keyword");
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"orderDetail.productInfos.product_id.keyword", (Object)productId)).must((QueryBuilder)QueryBuilders.termQuery((String)"status", (Object)OrderStatus.PAID.getStatus()));
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("selectCountByProductId exec search error", (Throwable)e);
            return 0L;
        }
        Aggregations aggregations = searchResponse.getAggregations();
        List list = aggregations.asList();
        return ((ParsedValueCount)list.get(0)).getValue();
    }

    public OrderEsModel insertByShopOrder(ShopOrder shopOrder, List<ShopSkuDto> shopSkus, ExtInfo extInfo, OrderSource orderSource, MeetingCustomerInfo meetingCustomerInfo, PayChannelType payChannelType, Long shouldPayAmount) {
        log.info("insertByShopOrder shopOrder:{},shopSkus:{}", (Object)shopOrder, shopSkus);
        if (shopOrder == null) {
            return null;
        }
        boolean openCrm = this.openCrm(shopOrder.getBizId());
        OrderEsModel esModel = new OrderEsModel();
        esModel.setOrderId(shopOrder.getOrderId());
        esModel.setStatus(shopOrder.getStatus());
        esModel.setCreateTime(shopOrder.getCreateTime().getTime());
        esModel.setUpdateTime(shopOrder.getUpdateTime().getTime());
        esModel.setOpenId(shopOrder.getOpenId());
        esModel.setAppId(shopOrder.getAppId());
        OrderDetailDto orderDetailDto = new OrderDetailDto();
        esModel.setOrderDetail(orderDetailDto);
        orderDetailDto.setProductInfos(this.buildProductInfos(shopSkus));
        orderDetailDto.setPayInfo(this.buildPayInfo(shopOrder));
        orderDetailDto.setPriceInfo(this.buildPriceInfo(shopOrder));
        orderDetailDto.setDeliveryInfoDto(this.buildDeliveryInfo(shopOrder));
        orderDetailDto.setCouponInfo(this.buildCouponInfo(shopSkus));
        esModel.setExtInfo(extInfo);
        String addressInfoString = shopOrder.getAddressinfo();
        AddressInfo addressInfo = (AddressInfo)JSON.parseObject((String)addressInfoString, AddressInfo.class);
        String customerNum = null;
        try {
            customerNum = this.syncCustomerToCustomerCenter(esModel, shopOrder.getBizId(), shopOrder.getCorpId(), addressInfo.getTelNumber(), openCrm, meetingCustomerInfo);
            esModel.setCustomerNum(customerNum);
        }
        catch (Exception e) {
            log.error("GoodsOrder \u5ba2\u6237\u4fe1\u606f \u540c\u6b65\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38\uff0corderId:{}", (Object)esModel.getOrderId(), (Object)e);
        }
        if (customerNum != null) {
            try {
                this.syncToCustomerByAddOrder(shopOrder, customerNum, shopSkus.get(0), orderSource, extInfo.getCustomerName(), payChannelType, shouldPayAmount, extInfo.getCustomerStr());
            }
            catch (Exception e) {
                log.error("GoodsOrder \u8ba2\u5355\u4fe1\u606f \u540c\u6b65\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38\uff0corderId:{}", (Object)esModel.getOrderId(), (Object)e);
            }
            try {
                this.syncToCustomerEvent(shopOrder, customerNum, ModuleType.SHOP, shopSkus.get(0), addressInfo);
            }
            catch (Exception e) {
                log.error("GoodsOrder \u4e0b\u8ba2\u5355\u4e8b\u4ef6 \u540c\u6b65\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38\uff0corderId:{}", (Object)esModel.getOrderId(), (Object)e);
            }
        }
        this.batchWriteOrderAsync(Collections.singletonList(esModel));
        return esModel;
    }

    private DeliveryInfoDto buildDeliveryInfo(ShopOrder shopOrder) {
        DeliveryInfoDto dto = new DeliveryInfoDto();
        String addressInfoString = shopOrder.getAddressinfo();
        AddressInfo addressInfo = (AddressInfo)JSON.parseObject((String)addressInfoString, AddressInfo.class);
        dto.setAddressInfo(addressInfo);
        return dto;
    }

    private CouponInfoDto buildCouponInfo(List<ShopSkuDto> shopSkus) {
        CouponInfoDto couponInfoDto = new CouponInfoDto();
        ArrayList<String> couponIds = new ArrayList<String>();
        for (ShopSkuDto skus : shopSkus) {
            if (CollectionUtils.isEmpty(skus.getCouponIds())) continue;
            couponIds.addAll(skus.getCouponIds());
        }
        couponInfoDto.setCouponId(couponIds);
        return couponInfoDto;
    }

    public Map<String, OrderEsModel> queryOrderByOrderIds(List<String> orderIds, int from, int size) {
        if (CollectionUtils.isEmpty(orderIds)) {
            return null;
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)"orderId.keyword", orderIds));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.from(from);
        searchSourceBuilder.size(size);
        SearchResponse searchResponse = this.queryByQueryBuilder(queryBuilder, searchSourceBuilder);
        if (searchResponse == null) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        HashMap<String, OrderEsModel> map = new HashMap<String, OrderEsModel>();
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            OrderEsModel orderEsModel = (OrderEsModel)JSON.parseObject((String)sourceAsString, OrderEsModel.class);
            map.put(orderEsModel.getOrderId(), orderEsModel);
        });
        return map;
    }

    public Map<Long, Map<Integer, Integer>> orderStatistics(List<Long> meetingIds) {
        if (CollectionUtils.isEmpty(meetingIds)) {
            return Collections.emptyMap();
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"extInfo.meetingId", meetingIds));
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"meetingIds").field("extInfo.meetingId")).size(100);
        TermsAggregationBuilder subAgg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"status").field("status")).size(100);
        aggregationBuilder.subAggregation((AggregationBuilder)subAgg);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        searchSourceBuilder.size(0);
        SearchResponse searchResponse = this.queryByQueryBuilder(queryBuilder, searchSourceBuilder);
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getAggregations())) {
            return Maps.newHashMap();
        }
        Terms terms = (Terms)searchResponse.getAggregations().get("meetingIds");
        if (Objects.isNull(terms)) {
            return Maps.newHashMap();
        }
        List buckets = terms.getBuckets();
        HashMap statistics = Maps.newHashMap();
        for (Terms.Bucket bucket : buckets) {
            if (Objects.isNull(bucket.getAggregations())) continue;
            Terms statusAgg = (Terms)bucket.getAggregations().get("status");
            HashMap statusCount = Maps.newHashMap();
            for (Terms.Bucket statusAggBucket : statusAgg.getBuckets()) {
                Number statusKey = statusAggBucket.getKeyAsNumber();
                if (Objects.isNull(statusKey)) continue;
                Long docCount = statusAggBucket.getDocCount();
                statusCount.put(statusKey.intValue(), docCount.intValue());
            }
            statistics.put(bucket.getKeyAsNumber().longValue(), statusCount);
        }
        return statistics;
    }

    public List<OrderEsModel> queryMeetingOrderList(Long meetingId, String name, String skuName, PageDto pageDto) {
        if (meetingId == null) {
            log.warn("meetingId is null");
            return Lists.newArrayList();
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"extInfo.meetingId", (Object)meetingId));
        if (StringUtils.isNotBlank((CharSequence)name)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"extInfo.customerName", (Object)name));
        }
        if (StringUtils.isNotBlank((CharSequence)skuName)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orderDetail.productInfos.title", (Object)skuName));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (pageDto != null) {
            searchSourceBuilder.from(pageDto.getOffset());
            searchSourceBuilder.size(pageDto.getPageSize().intValue());
        }
        log.info("queryMeetingOrderList queryBuilder: {}", (Object)queryBuilder);
        SearchResponse searchResponse = this.queryByQueryBuilder(queryBuilder, searchSourceBuilder);
        if (searchResponse == null) {
            return Lists.newArrayList();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        ArrayList orderEsModelList = Lists.newArrayList();
        for (SearchHit searchHit : searchHits) {
            String sourceAsString = searchHit.getSourceAsString();
            OrderEsModel orderEsModel = (OrderEsModel)JSON.parseObject((String)sourceAsString, OrderEsModel.class);
            orderEsModelList.add(orderEsModel);
        }
        return orderEsModelList;
    }

    private SearchResponse queryByQueryBuilder(BoolQueryBuilder queryBuilder, SearchSourceBuilder searchSourceBuilder) {
        SearchResponse searchResponse;
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopOrderIndex});
        searchRequest.types(new String[]{TYPE});
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return null;
        }
        return searchResponse;
    }

    private PriceInfoDto buildPriceInfo(ShopOrder shopOrder) {
        PriceInfoDto priceInfoDto = new PriceInfoDto();
        priceInfoDto.setProductPrice(shopOrder.getProductPrice());
        priceInfoDto.setOrderPrice(shopOrder.getOrderPrice());
        priceInfoDto.setFreight(shopOrder.getFreight());
        priceInfoDto.setDiscountedPrice(shopOrder.getDiscountedPrice());
        priceInfoDto.setIsDiscounted(shopOrder.getIsDiscounted());
        priceInfoDto.setChangeDownPrice(shopOrder.getChangeDownPrice());
        return priceInfoDto;
    }

    private PayInfoDto buildPayInfo(ShopOrder shopOrder) {
        PayInfoDto payInfoDto = new PayInfoDto();
        payInfoDto.setPayMethod(shopOrder.getPayMethod());
        payInfoDto.setPrepayId(shopOrder.getPrepayId());
        payInfoDto.setTransactionId("");
        payInfoDto.setPrepayTime(DateUtil.dateToDateString((Date)shopOrder.getPrepayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        payInfoDto.setPayTime("");
        return payInfoDto;
    }

    private List<ProductInfo> buildProductInfos(List<ShopSkuDto> shopSkus) {
        ArrayList<ProductInfo> productInfos = new ArrayList<ProductInfo>();
        for (ShopSkuDto sku : shopSkus) {
            ProductInfo productInfo = new ProductInfo();
            productInfo.setProductId(sku.getProductId());
            productInfo.setSkuId(sku.getSkuId());
            String skuBody = sku.getSkuBody();
            SkuItemDto skuItemDto = (SkuItemDto)JSON.parseObject((String)skuBody, SkuItemDto.class);
            productInfo.setThumbImg(StringUtils.isBlank((CharSequence)skuItemDto.getThumbImg()) ? sku.getSpuFirstHeadImg() : skuItemDto.getThumbImg());
            productInfo.setSkuCnt(sku.getAmount().longValue());
            productInfo.setProductCnt(0L);
            productInfo.setOnAfterSaleSkuCnt(0);
            productInfo.setTitle(sku.getTitle());
            productInfo.setFinishAfterSaleSkuCnt(0);
            productInfo.setSalePrice(sku.getSalePrice());
            productInfo.setSkuAttrs(skuItemDto.getSkuAttrs());
            productInfos.add(productInfo);
        }
        return productInfos;
    }

    public void syncToCustomerEvent(ShopOrder shopOrder, String customerNum, ModuleType moduleType, ShopSkuDto shopSku, AddressInfo addressInfo) {
        CustomerEventReq req = new CustomerEventReq();
        req.setEventType(EventType.PURCHASE_ORDER.getCode());
        EventData eventData = new EventData();
        EventModule module = new EventModule();
        eventData.setModule(module);
        eventData.setOrderNo(String.valueOf(shopOrder.getOrderId()));
        eventData.setOrderType(moduleType.getCode());
        eventData.setOrderAmount(Long.valueOf(shopOrder.getOrderPrice() / 100L));
        module.setProductId(String.valueOf(shopSku.getSkuId()));
        module.setProductName(shopSku.getTitle());
        eventData.setMobile(addressInfo.getTelNumber());
        eventData.setCreateTime(shopOrder.getCreateTime());
        req.setEventTime(shopOrder.getCreateTime());
        module.setType(moduleType.getCode());
        module.setName(moduleType.getDesc());
        req.setBizId(shopOrder.getBizId());
        req.setProductLineId("");
        req.setSource(SOURCE);
        req.setUserId(Long.valueOf(-1L));
        req.setWeworkUserNum("");
        req.setCustomerNum(customerNum);
        req.setEventData(eventData);
        log.info("GoodsOrder \u540c\u6b65\u8ba2\u5355\u4e8b\u4ef6 req:{}", (Object)req);
        this.ccCustomerEventService.add(req);
    }

    private void syncToCustomerByAddOrder(ShopOrder shopOrder, String customerNum, ShopSkuDto shopSku, OrderSource orderSource, String customerName, PayChannelType payChannelType, Long shouldPayAmount, String customerStr) {
        OrderReq customerOrderReq = new OrderReq();
        customerOrderReq.setBizId(shopOrder.getBizId());
        customerOrderReq.setProductLineId("");
        customerOrderReq.setSource(orderSource.getValue());
        customerOrderReq.setOrderNo(shopOrder.getOrderId());
        customerOrderReq.setSkuNo(String.valueOf(shopSku.getSkuId()));
        customerOrderReq.setSkuName(shopSku.getTitle());
        customerOrderReq.setOrderAmount(shopOrder.getProductPrice());
        customerOrderReq.setPayStatus(Integer.valueOf(OrderStatus.PAID.getStatus().equals(shopOrder.getStatus()) ? PayStatusEnum.PAID.getValue() : PayStatusEnum.UNPAID.getValue()));
        customerOrderReq.setPaidAmount(Long.valueOf(0L));
        customerOrderReq.setShouldPayAmount(shouldPayAmount);
        customerOrderReq.setRefundNo("");
        customerOrderReq.setRefundStatus(Integer.valueOf(RefundStatusEnum.NONE.getValue()));
        customerOrderReq.setRefundAmount(Long.valueOf(0L));
        customerOrderReq.setCreateTime(shopOrder.getCreateTime());
        customerOrderReq.setDiscountAmount(shopOrder.getDiscountedPrice());
        String skuBody = shopSku.getSkuBody();
        SkuItemDto skuItemDto = (SkuItemDto)JSON.parseObject((String)skuBody, SkuItemDto.class);
        customerOrderReq.setSkuImgUrl(skuItemDto.getThumbImg());
        customerOrderReq.setStatus(Integer.valueOf(OrderStatus.PAID.getStatus().equals(shopOrder.getStatus()) ? OrderStatusEnum.HAD_PAY.getValue() : OrderStatusEnum.WAIT_PAY.getValue()));
        AddressInfo addressInfo = (AddressInfo)JSONObject.parseObject((String)shopOrder.getAddressinfo(), AddressInfo.class);
        if (addressInfo != null && StringUtils.isNotBlank((CharSequence)addressInfo.getDetailInfo())) {
            customerOrderReq.setDeliveryAddress(addressInfo.getDetailInfo().replaceAll("/", ""));
        }
        customerOrderReq.setIsDeleted(Integer.valueOf(0));
        customerOrderReq.setCustomerNum(customerNum);
        customerOrderReq.setCustomerName(customerName);
        customerOrderReq.setSkuCount(shopSku.getAmount());
        Long promoterId = this.ccCustomerDetailService.getPromoterIdByCustomerNum(shopOrder.getBizId(), customerNum);
        Long inviteUserId = this.goodsOrderService.selectInviteUserId(shopOrder.getBizId(), customerStr);
        if (promoterId == null) {
            log.info("syncToCustomerByAddOrder,promoterId is null,inviteUserId:{}", (Object)inviteUserId);
            if (inviteUserId != null) {
                promoterId = inviteUserId;
                this.ccCustomerDetailService.setPromoterIdByCustomerNum(shopOrder.getBizId(), promoterId, customerNum);
            }
        }
        customerOrderReq.setPromoterId(promoterId);
        Long netSchoolId = this.getNetSchoolIdByInviteUserId(shopOrder.getBizId(), inviteUserId);
        if (netSchoolId != null) {
            customerOrderReq.setSchoolId(netSchoolId);
        } else if (shopSku.getProductId() != null && shopSku.getSource() != null && shopSku.getSource().intValue() == GoodsOrderSource.NET_SCHOOL.getSource()) {
            customerOrderReq.setSchoolId(Long.valueOf(NetSchoolGoodsId.getSchoolId((String)shopSku.getProductId()).intValue()));
        }
        log.info("GoodsOrder\u8ba2\u5355\u63d2\u5165es \u540c\u6b65addOrder\u4fe1\u606f\u7ed9\u5ba2\u6237\u4e2d\u5fc3 req:{}", (Object)customerOrderReq);
        this.ccCustomerOrderService.addOrder(customerOrderReq);
        if (OrderStatus.PAID.getStatus().equals(shopOrder.getStatus())) {
            this.syncToCustomerOrderPay(shopOrder, PayStatusEnum.PAID.getValue(), payChannelType);
        }
    }

    private String syncCustomerToCustomerCenter(OrderEsModel orderEsModel, Long bizId, String corpId, String rserveMobile, boolean openCrm, MeetingCustomerInfo meetingCustomerInfo) {
        Long centerChannelId;
        CustomerDetailResp detailResp;
        String customerNum = "";
        Long channelId = this.channelMapper.querySysChannelId(SysChannelEnum.LIVE_COMMERCE.getCode());
        OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
        CustomerDetailReq customerDetailReq = new CustomerDetailReq();
        String addressMobile = null;
        DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        if (deliveryInfoDto != null) {
            String userName;
            AddressInfo addressInfo = deliveryInfoDto.getAddressInfo();
            addressMobile = addressInfo.getTelNumber();
            if (StringUtils.isNotBlank((CharSequence)addressMobile)) {
                log.info("syncToCustomerCenter sync addressMobile,bizId:{},orderId:{},addressMobile:{}", new Object[]{bizId, orderEsModel.getOrderId(), addressMobile});
                customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, addressMobile);
            }
            if (StringUtils.isNotBlank((CharSequence)(userName = addressInfo.getUserName()))) {
                customerDetailReq.setName(userName);
                crmLeadsReq.setName(userName);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)rserveMobile)) {
            log.info("syncToCustomerCenter sync rserveMobile,bizId:{},orderId:{},rserveMobile:{}", new Object[]{bizId, orderEsModel.getOrderId(), rserveMobile});
            customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, rserveMobile);
        }
        if (StringUtils.isNotBlank((CharSequence)customerNum)) {
            customerDetailReq.setBizId(bizId);
            customerDetailReq.setAvatar(meetingCustomerInfo.getAvatar());
            customerDetailReq.setCustomerNum(customerNum);
            log.info("syncToCustomerCenter sync customerDetail,orderId:{},customerDetailReq:{}", (Object)orderEsModel.getOrderId(), (Object)customerDetailReq);
            this.ccCustomerDetailService.add(customerDetailReq);
        }
        if (StringUtils.isNotBlank((CharSequence)meetingCustomerInfo.getAppId()) && StringUtils.isNotBlank((CharSequence)meetingCustomerInfo.getOpenId())) {
            try {
                Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)meetingCustomerInfo.getMeetingId());
                if (meeting != null) {
                    Integer liveDeliveryAuthMode = meeting.getLiveDeliveryAuthMode();
                    if (liveDeliveryAuthMode == null || MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.getValue().equals(liveDeliveryAuthMode)) {
                        this.bindOfficialAccountAndMobile(meetingCustomerInfo, StringUtils.isNotBlank((CharSequence)addressMobile) ? addressMobile : rserveMobile);
                    } else {
                        this.bindAppletAccountAndMobile(meetingCustomerInfo, StringUtils.isNotBlank((CharSequence)addressMobile) ? addressMobile : rserveMobile);
                    }
                    if (StringUtils.isBlank((CharSequence)customerNum)) {
                        int customerType = liveDeliveryAuthMode == null || MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.getValue().equals(liveDeliveryAuthMode) ? CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue() : CustomerIdType.MINI_PROGRAM_OPENID.getValue();
                        customerNum = this.ccCustomerNumService.getCustomerNumByType(meetingCustomerInfo.getBizId(), customerType, meetingCustomerInfo.getAppId(), meetingCustomerInfo.getOpenId(), meetingCustomerInfo.getUnionId());
                    }
                }
            }
            catch (Exception e) {
                log.error("bindOpenIdAndMobile error", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)customerNum) && (detailResp = this.ccCustomerDetailService.queryCustomerDetail(bizId, customerNum)) != null && detailResp.getChannelId() != null && (centerChannelId = this.channelMapper.getIdByNum(bizId, detailResp.getChannelId())) != null) {
            channelId = centerChannelId;
        }
        String traceId = TraceIdUtils.getTraceId();
        String finalCustomerNum = customerNum;
        Long finalChannelId = channelId;
        String finalAddressMobile = addressMobile;
        TraceExecutorWrapUtil.wrapCompletableFutureRunAsync(() -> {
            TraceIdUtils.setTraceId((String)traceId);
            try {
                this.syncToCRM(orderEsModel, bizId, corpId, rserveMobile, openCrm, meetingCustomerInfo, finalCustomerNum, finalChannelId, orderDetail, finalAddressMobile, crmLeadsReq);
            }
            catch (Exception e) {
                log.error("syncToCRM with error", (Throwable)e);
            }
        });
        return customerNum;
    }

    private void syncToCRM(OrderEsModel orderEsModel, Long bizId, String corpId, String rserveMobile, boolean openCrm, MeetingCustomerInfo meetingCustomerInfo, String customerNum, Long channelId, OrderDetailDto orderDetail, String addressMobile, CrmLeadsReq crmLeadsReq) {
        if (openCrm && (StringUtils.isNotBlank((CharSequence)rserveMobile) || StringUtils.isNotBlank((CharSequence)addressMobile))) {
            PriceInfoDto priceInfo;
            CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
            crmLeadsInfoReq.setMobile(StringUtils.isNotBlank((CharSequence)rserveMobile) ? rserveMobile : addressMobile);
            crmLeadsInfoReq.setCorpId(corpId);
            crmLeadsInfoReq.setBizId(bizId);
            List crmLeadsInfoResps = this.crmLeadsService.queryBindInfoByMobile(crmLeadsInfoReq);
            log.info("\u67e5\u8be2\u7ebf\u7d22\u7ed1\u5b9a\u5173\u7cfb  request:{},resp:{}", (Object)JSON.toJSONString((Object)crmLeadsInfoReq), (Object)JSON.toJSONString((Object)crmLeadsInfoResps));
            CrmLeadsReq params = new CrmLeadsReq();
            params.setCorpId(corpId);
            params.setMobile(StringUtils.isNotBlank((CharSequence)rserveMobile) ? rserveMobile : addressMobile);
            if (StringUtils.isNotBlank((CharSequence)meetingCustomerInfo.getCustomerStr())) {
                Long promoterId = this.ccCustomerDetailService.getPromoterIdByCustomerNum(bizId, customerNum);
                if (promoterId == null) {
                    Long inviteUserId = this.goodsOrderService.selectInviteUserId(bizId, meetingCustomerInfo.getCustomerStr());
                    log.info("syncCustomerToCustomerCenter,promoterId is null,inviteUserId:{}", (Object)inviteUserId);
                    if (inviteUserId != null) {
                        promoterId = inviteUserId;
                        this.ccCustomerDetailService.setPromoterIdByCustomerNum(bizId, promoterId, customerNum);
                    }
                }
                if (promoterId != null) {
                    crmLeadsReq.setMarketUserId(promoterId);
                    params.setMarketUserId(promoterId);
                }
            }
            this.crmLeadsService.modLeadsByNotEmptyField(params);
            JudgeOrderBelongUserIdDto userIdDto = this.goodsOrderService.judgeOrderBelongUserId(bizId, corpId, crmLeadsInfoReq.getMobile(), orderEsModel.getExtInfo().getCustomerStr());
            crmLeadsReq.setCorpId(corpId);
            crmLeadsReq.setMobile(StringUtils.isNotBlank((CharSequence)rserveMobile) ? rserveMobile : addressMobile);
            crmLeadsReq.setSourceType(Integer.valueOf(SourceType.LIVE_COMMERCE.getValue()));
            crmLeadsReq.setChannelId(channelId);
            if (userIdDto != null) {
                crmLeadsReq.setAllocUserId(userIdDto.getBelongUserId());
            }
            if (Objects.nonNull(priceInfo = orderDetail.getPriceInfo())) {
                crmLeadsReq.setTradeAmount(priceInfo.getOrderPrice());
            }
            log.info("syncToCustomerCenter sync crm,orderId:{},crmLeadsReq:{}", (Object)orderEsModel.getOrderId(), (Object)crmLeadsReq);
            try {
                this.crmLeadsService.addLeads(crmLeadsReq);
            }
            catch (Exception e) {
                log.error("syncToCustomerCenter,addLeads error", (Throwable)e);
            }
        }
    }

    private void bindAppletAccountAndMobile(MeetingCustomerInfo meetingCustomerInfo, String mobile) {
        boolean mobileBindAppletAccount;
        log.info("bindAppletAccountAndMobile meetingCustomerInfo:{} mobile:{}", (Object)meetingCustomerInfo, (Object)mobile);
        if (StringUtils.isBlank((CharSequence)mobile)) {
            log.warn("bindAppletAccountAndMobile mobile is null");
            return;
        }
        boolean exist = this.ccCustomerNumService.mobileIsExist(meetingCustomerInfo.getBizId(), mobile);
        if (!exist) {
            return;
        }
        String unionId = meetingCustomerInfo.getUnionId();
        String customerNumByType = this.ccCustomerNumService.getCustomerNumByType(meetingCustomerInfo.getBizId(), CustomerIdType.MINI_PROGRAM_OPENID.getValue(), meetingCustomerInfo.getAppId(), meetingCustomerInfo.getOpenId(), unionId);
        CustomerDetailResp customerDetailResp = this.ccCustomerInfoService.queryCustomerDetail(meetingCustomerInfo.getBizId(), customerNumByType);
        if (customerDetailResp == null) {
            return;
        }
        log.info("bindAppletAccountAndMobile customerNumByType:{} customerDetailResp:{}", (Object)customerNumByType, (Object)customerDetailResp);
        String mobile2 = customerDetailResp.getMobile2();
        String mobile1 = customerDetailResp.getMobile1();
        if (StringUtils.isNotBlank((CharSequence)mobile1) && StringUtils.isNotBlank((CharSequence)mobile2) && !mobile.equals(mobile1) && !mobile.equals(mobile2)) {
            log.info("bindAppletAccountAndMobile \u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u4e24\u4e2a\u624b\u673a\u53f7 \u4e14 \u5176\u4e2d\u7684\u4efb\u610f\u4e00\u4e2a\u90fd\u4e0d\u662f\u5f53\u524d\u4e0b\u5355\u7684\u624b\u673a\u53f7 \u4e0d\u505a\u6253\u901a");
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{mobile1, mobile2}) && !(mobileBindAppletAccount = this.ccCustomerNumService.mobileBindAppletAccount(meetingCustomerInfo.getBizId(), mobile))) {
            this.ccCustomerNumService.bindAppletAccountAndMobile(meetingCustomerInfo.getBizId(), meetingCustomerInfo.getAppId(), meetingCustomerInfo.getOpenId(), mobile, unionId);
            log.info("bindAppletAccountAndMobile \u5c06\u7528\u6237openId\u4e0e\u624b\u673a\u53f7\u505a\u6253\u901a mobile:{}", (Object)mobile);
        }
    }

    private void bindOfficialAccountAndMobile(MeetingCustomerInfo meetingCustomerInfo, String mobile) {
        boolean mobileBindOfficialAccount;
        log.info("bindOfficialAccountAndMobile meetingCustomerInfo:{} mobile:{}", (Object)meetingCustomerInfo, (Object)mobile);
        if (StringUtils.isBlank((CharSequence)mobile)) {
            log.warn("bindOfficialAccountAndMobile mobile is null");
            return;
        }
        boolean exist = this.ccCustomerNumService.mobileIsExist(meetingCustomerInfo.getBizId(), mobile);
        if (!exist) {
            return;
        }
        String customerNumByType = this.ccCustomerNumService.getCustomerNumByType(meetingCustomerInfo.getBizId(), CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue(), meetingCustomerInfo.getAppId(), meetingCustomerInfo.getOpenId(), meetingCustomerInfo.getUnionId());
        CustomerDetailResp customerDetailResp = this.ccCustomerInfoService.queryCustomerDetail(meetingCustomerInfo.getBizId(), customerNumByType);
        if (customerDetailResp == null) {
            return;
        }
        log.info("bindOfficialAccountAndMobile customerNumByType:{} customerDetailResp:{}", (Object)customerNumByType, (Object)customerDetailResp);
        String mobile2 = customerDetailResp.getMobile2();
        String mobile1 = customerDetailResp.getMobile1();
        if (StringUtils.isNotBlank((CharSequence)mobile1) && StringUtils.isNotBlank((CharSequence)mobile2) && !mobile.equals(mobile1) && !mobile.equals(mobile2)) {
            log.info("bindOfficialAccountAndMobile \u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u4e24\u4e2a\u624b\u673a\u53f7 \u4e14 \u5176\u4e2d\u7684\u4efb\u610f\u4e00\u4e2a\u90fd\u4e0d\u662f\u5f53\u524d\u4e0b\u5355\u7684\u624b\u673a\u53f7 \u4e0d\u505a\u6253\u901a");
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{mobile1, mobile2}) && !(mobileBindOfficialAccount = this.ccCustomerNumService.mobileBindOfficialAccount(meetingCustomerInfo.getBizId(), mobile))) {
            String unionId = meetingCustomerInfo.getUnionId();
            this.ccCustomerNumService.bindOfficialAccountAndMobile(meetingCustomerInfo.getBizId(), meetingCustomerInfo.getAppId(), meetingCustomerInfo.getOpenId(), mobile, unionId);
            log.info("bindOfficialAccountAndMobile \u5c06\u7528\u6237openId\u4e0e\u624b\u673a\u53f7\u505a\u6253\u901a mobile:{}", (Object)mobile);
        }
    }

    private boolean openCrm(Long bizId) {
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        log.info("isOpenCrm record: {}", (Object)businessCustomer);
        String pkgIdsStr = businessCustomer.getPkgIds();
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return false;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)businessCustomer.getId(), (Object)s);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    public void batchUpdateOrderAsync(List<OrderEsModel> orderEsModels) {
        if (CollectionUtils.isEmpty(orderEsModels)) {
            return;
        }
        List partition = Lists.partition(orderEsModels, (int)100);
        ArrayList resultFutureList = Lists.newArrayListWithExpectedSize((int)partition.size());
        for (List list : partition) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.batchUpdateOrder(list);
                }
                catch (IOException e) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
                }
            }, this.orderSaveExecutorService);
            resultFutureList.add(completableFuture);
        }
        ((CompletableFuture)CompletableFuture.allOf(resultFutureList.toArray(new CompletableFuture[partition.size()])).whenComplete((r, t) -> {
            if (t != null) {
                log.error("update order error", t);
            }
        })).join();
    }

    public void batchWriteOrderAsync(List<OrderEsModel> orderEsModels) {
        if (CollectionUtils.isEmpty(orderEsModels)) {
            return;
        }
        List partition = Lists.partition(orderEsModels, (int)100);
        ArrayList resultFutureList = Lists.newArrayListWithExpectedSize((int)partition.size());
        for (List list : partition) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.batchWriteOrder(list);
                }
                catch (IOException e) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
                }
            }, this.orderSaveExecutorService);
            resultFutureList.add(completableFuture);
        }
        ((CompletableFuture)CompletableFuture.allOf(resultFutureList.toArray(new CompletableFuture[partition.size()])).whenComplete((r, t) -> {
            if (t != null) {
                log.error("store order error", t);
            }
        })).join();
    }

    private void batchUpdateOrder(List<OrderEsModel> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (OrderEsModel model : list) {
            UpdateRequest request = new UpdateRequest(this.shopOrderIndex, TYPE, String.valueOf(model.getOrderId())).doc(JacksonUtils.writeValueAsString((Object)model), XContentType.JSON);
            bulkRequest.add(request);
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            log.info("update order id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }

    private void batchWriteOrder(List<OrderEsModel> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (OrderEsModel model : list) {
            IndexRequest indexRequest = new IndexRequest(this.shopOrderIndex, TYPE, String.valueOf(model.getOrderId()));
            try {
                indexRequest.source(JacksonUtils.writeValueAsString((Object)model), XContentType.JSON);
            }
            catch (JsonProcessingException e) {
                log.error("json error:{}", (Object)JSON.toJSONString((Object)model));
                continue;
            }
            bulkRequest.add(indexRequest);
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            log.info("write order id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }

    public OrderEsModel getOneById(String id) {
        SearchResponse searchResponse;
        log.info("getOneById id:{}", (Object)id);
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId.keyword", (String)id));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopOrderIndex});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length <= 0) {
            return null;
        }
        return (OrderEsModel)JSON.parseObject((String)searchHits[0].getSourceAsString(), OrderEsModel.class);
    }

    public void syncToCustomerOrderPay(ShopOrder shopOrder, Integer payStatus, PayChannelType payChannelType) {
        log.info("syncToCustomerOrderPay shopOrder:{} payStatus:{}", (Object)shopOrder, (Object)payStatus);
        SetOrderPayStatusReq req = new SetOrderPayStatusReq();
        req.setBizId(shopOrder.getBizId());
        req.setOrderNo(String.valueOf(shopOrder.getOrderId()));
        req.setProductLineId("");
        req.setSource(OrderSource.MEETING_ORDER.name());
        req.setPaidAmount(shopOrder.getOrderPrice());
        req.setPayStatus(payStatus);
        if (PayStatusEnum.PAID.getValue() == payStatus.intValue()) {
            req.setOrderStatus(Integer.valueOf(OrderStatusEnum.HAD_PAY.getValue()));
        }
        this.ccCustomerOrderService.setOrderPayStatus(req);
        OrderRecordReq recordReq = new OrderRecordReq();
        recordReq.setBizId(shopOrder.getBizId());
        recordReq.setSource(OrderSource.MEETING_ORDER.name());
        recordReq.setProductLineId("");
        recordReq.setPayAmount(shopOrder.getOrderPrice());
        recordReq.setPayTime(shopOrder.getPayTime());
        recordReq.setOrderNo(shopOrder.getOrderId().toString());
        recordReq.setPayNo(shopOrder.getOutOrderId());
        recordReq.setChannelType(payChannelType.getValue());
        log.info("syncToCustomerOrder|recordReq:{}", (Object)recordReq);
        this.ccCustomerOrderService.addOrderPayRecord(recordReq);
    }

    public List<OrderEsModel> queryMeetingOrderList(Long meetingId, Integer status, String name, String skuName, String mobile, Set<String> customerStrs, PageDto pageDto) {
        SearchResponse searchResponse;
        if (meetingId == null) {
            log.warn("meetingId is null");
            return Lists.newArrayList();
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"extInfo.meetingId", (Object)meetingId));
        if (StringUtils.isNotBlank((CharSequence)name) || CollectionUtils.isNotEmpty(customerStrs)) {
            BoolQueryBuilder tbSubQuery = QueryBuilders.boolQuery();
            tbSubQuery.minimumShouldMatch(1);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                tbSubQuery.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"extInfo.customerName", (Object)name));
            }
            if (CollectionUtils.isNotEmpty(customerStrs)) {
                tbSubQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"extInfo.customerStr.keyword", customerStrs));
            }
            if (StringUtils.isNotBlank((CharSequence)mobile)) {
                tbSubQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"orderDetail.deliveryInfoDto.addressInfo.tel_number.keyword", (String[])new String[]{mobile}));
            }
            queryBuilder.must((QueryBuilder)tbSubQuery);
        }
        if (status != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"status", (Object)status));
        }
        if (StringUtils.isNotBlank((CharSequence)skuName)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orderDetail.productInfos.title", (Object)skuName));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.sort("createTime", SortOrder.DESC);
        if (pageDto != null) {
            Integer from = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
            searchSourceBuilder.from(from.intValue());
            searchSourceBuilder.size(pageDto.getPageSize().intValue());
        }
        if ((searchResponse = this.queryByQueryBuilder(queryBuilder, searchSourceBuilder)) == null) {
            return Lists.newArrayList();
        }
        SearchHits hits = searchResponse.getHits();
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf((int)hits.getTotalHits()));
            pageDto.setCurPageCount(Integer.valueOf(hits.getHits().length));
        }
        SearchHit[] searchHits = hits.getHits();
        ArrayList orderEsModelList = Lists.newArrayList();
        for (SearchHit searchHit : searchHits) {
            String sourceAsString = searchHit.getSourceAsString();
            OrderEsModel orderEsModel = (OrderEsModel)JSON.parseObject((String)sourceAsString, OrderEsModel.class);
            orderEsModelList.add(orderEsModel);
        }
        return orderEsModelList;
    }

    public boolean batchUpdateStatusByOrderIds(List<String> orderIds, Integer status) {
        boolean flag = true;
        BulkRequest bulkRequest = new BulkRequest();
        orderIds.forEach(orderId -> {
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.type(TYPE);
            updateRequest.index(this.shopOrderIndex);
            updateRequest.id(orderId);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("status", status);
            updateRequest.doc(map);
            bulkRequest.add(updateRequest);
        });
        try {
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
            log.info("bulk response:{}", (Object)bulkResponse.status());
            Iterator responseIterator = bulkResponse.iterator();
            while (responseIterator.hasNext()) {
                flag = false;
                BulkItemResponse response = (BulkItemResponse)responseIterator.next();
                log.info("batchUpdateStatusByOrderIds id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
            }
        }
        catch (IOException e) {
            flag = false;
            log.error("batchUpdateStatusByOrderIds error", (Throwable)e);
        }
        return flag;
    }

    private Long getNetSchoolIdByInviteUserId(Long bizId, Long userId) {
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (user == null) {
            return null;
        }
        List organizations = this.organizationMapper.findAll(bizId);
        Map orgId2OrgMap = organizations.stream().collect(Collectors.toMap(Organization::getId, Functions.identity()));
        Organization organization = (Organization)orgId2OrgMap.get(user.getNodeId());
        while (organization != null) {
            if (organization.getNetSchoolId() != null) {
                return organization.getNetSchoolId();
            }
            organization = (Organization)orgId2OrgMap.get(organization.getPid());
        }
        return null;
    }
}

