/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.goods.service;

import cn.kinyun.wework.sdk.utils.JacksonUtils;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.goods.model.ProductEsModel;
import com.kuaike.scrm.goods.req.SpuListQueryParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GoodsEsService {
    private static final Logger log = LoggerFactory.getLogger(GoodsEsService.class);
    @Value(value="${scrm.elasticsearch.shopProductIndex}")
    private String shopProductIndex;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private Client client;
    private static final String TYPE = "doc";
    private final ExecutorService productSaveExecutorService = new ThreadPoolExecutor(2, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("productSaveExecutorService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.productSaveExecutorService);
    }

    public Pair<List<ProductEsModel>, Long> queryProductList(SpuListQueryParam queryParam, boolean direction) {
        log.info("queryProductList params: param:{}, direction:{}", (Object)queryParam, (Object)direction);
        queryParam.validate();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)queryParam.getBizId())).must((QueryBuilder)QueryBuilders.termsQuery((String)"status", queryParam.getRealStatus())).must((QueryBuilder)QueryBuilders.termQuery((String)"isDeleted", (int)0));
        if (Objects.nonNull(queryParam.getSource())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"source", queryParam.getSource()));
        } else {
            Collection all = GoodsOrderSource.all();
            all.remove(GoodsOrderSource.WX_SHOP.getSource());
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"source", (Collection)GoodsOrderSource.all()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryParam.getProductCodeQuery())) {
            BoolQueryBuilder productQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"productId", (Object)queryParam.getProductCodeQuery())).should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"outProductId", (Object)queryParam.getProductCodeQuery()));
            queryBuilder.must((QueryBuilder)productQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)queryParam.getProductNameQuery())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"title", (Object)queryParam.getProductNameQuery()));
        }
        if (Objects.nonNull(queryParam.getMinPrice()) || Objects.nonNull(queryParam.getMaxPrice())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"price");
            if (Objects.nonNull(queryParam.getMinPrice())) {
                rangeQueryBuilder.gte((Object)queryParam.getMinPrice());
            }
            if (Objects.nonNull(queryParam.getMaxPrice())) {
                rangeQueryBuilder.lte((Object)queryParam.getMaxPrice());
            }
            queryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("productId.keyword");
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopProductIndex});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        if (direction) {
            searchSourceBuilder.sort("updateTime", SortOrder.ASC);
        } else {
            searchSourceBuilder.sort("updateTime", SortOrder.DESC);
        }
        if (Objects.isNull(queryParam.getPageDto())) {
            searchSourceBuilder.size(20);
            searchSourceBuilder.from(0);
        } else {
            searchSourceBuilder.size(queryParam.getPageDto().getPageSize().intValue());
            searchSourceBuilder.from(queryParam.getPageDto().getOffset());
        }
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        return this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
    }

    private Pair<List<ProductEsModel>, Long> executeQueryAndDealResult(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        ArrayList productList = Lists.newArrayList();
        if (Objects.isNull(searchResponse)) {
            return new ImmutablePair((Object)productList, (Object)0L);
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        long totalHits = hits.getTotalHits();
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            ProductEsModel chatMsg = (ProductEsModel)JSON.parseObject((String)sourceAsString, ProductEsModel.class);
            productList.add(chatMsg);
        });
        return new ImmutablePair((Object)productList, (Object)totalHits);
    }

    public int writeProduct(ProductEsModel model) throws IOException {
        IndexRequest indexRequest = new IndexRequest(this.shopProductIndex, TYPE, String.valueOf(model.getProductId()));
        try {
            indexRequest.source(JacksonUtils.writeValueAsString((Object)model), XContentType.JSON);
        }
        catch (JsonProcessingException e) {
            log.error("json error:{}", (Object)JSON.toJSONString((Object)model));
        }
        IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, new Header[0]);
        return indexResponse.status().getStatus();
    }

    public Boolean updateProduct(ProductEsModel productEsModel) {
        log.info("updateProduct with:{}", (Object)productEsModel);
        boolean flag = false;
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("appId", productEsModel.getAppId());
        jsonMap.put("status", productEsModel.getStatus());
        jsonMap.put("title", productEsModel.getTitle());
        jsonMap.put("subTitle", productEsModel.getSubTitle());
        jsonMap.put("categoryIdL1", productEsModel.getCategoryIdL1());
        jsonMap.put("categoryIdL2", productEsModel.getCategoryIdL2());
        jsonMap.put("categoryIdL3", productEsModel.getCategoryIdL3());
        jsonMap.put("editStatus", productEsModel.getEditStatus());
        jsonMap.put("price", productEsModel.getPrice());
        jsonMap.put("updateTime", productEsModel.getUpdateTime().getTime());
        jsonMap.put("isDeleted", 0);
        UpdateRequest updateRequest = new UpdateRequest(this.shopProductIndex, TYPE, productEsModel.getProductId()).doc(jsonMap);
        updateRequest.retryOnConflict(3);
        try {
            UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, new Header[0]);
            if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                flag = true;
                log.info("updateProduct success productId:{}", (Object)productEsModel.getProductId());
            }
        }
        catch (IOException e) {
            log.error("updateProduct failed, productId={}", (Object)productEsModel.getProductId(), (Object)e);
        }
        return flag;
    }

    public Boolean delProduct(String productId, Long bizId) {
        log.info("delProduct productId:{} bizId:{}", (Object)productId, (Object)bizId);
        boolean flag = false;
        HashMap<String, Integer> jsonMap = new HashMap<String, Integer>();
        jsonMap.put("isDeleted", 1);
        UpdateRequest updateRequest = new UpdateRequest(this.shopProductIndex, TYPE, productId).doc(jsonMap);
        updateRequest.retryOnConflict(3);
        try {
            UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, new Header[0]);
            if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                flag = true;
                log.info("delProduct success productId:{}", (Object)productId);
            }
        }
        catch (IOException e) {
            log.error("delProduct failed, productId={}", (Object)productId, (Object)e);
        }
        return flag;
    }

    public Boolean updateProductStatus(String productId, Long bizId, Integer status) {
        log.info("updateProductStatus productId:{} bizId:{} status:{}", new Object[]{productId, bizId, status});
        boolean flag = false;
        HashMap<String, Integer> jsonMap = new HashMap<String, Integer>();
        jsonMap.put("status", status);
        UpdateRequest updateRequest = new UpdateRequest(this.shopProductIndex, TYPE, productId).doc(jsonMap);
        updateRequest.retryOnConflict(3);
        try {
            UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, new Header[0]);
            if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                flag = true;
                log.info("updateProductStatus success productId:{}", (Object)productId);
            }
        }
        catch (IOException e) {
            log.error("updateProductStatus failed, productId={}", (Object)productId, (Object)e);
        }
        return flag;
    }

    public void batchInsertProduct(List<ProductEsModel> productList) {
        if (CollectionUtils.isEmpty(productList)) {
            return;
        }
        List partition = Lists.partition(productList, (int)100);
        ArrayList resultFutureList = Lists.newArrayListWithExpectedSize((int)partition.size());
        for (List list : partition) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.batchWriteProduct(list);
                }
                catch (IOException e) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
                }
            }, this.productSaveExecutorService);
            resultFutureList.add(completableFuture);
        }
        ((CompletableFuture)CompletableFuture.allOf(resultFutureList.toArray(new CompletableFuture[0])).whenComplete((r, t) -> {
            if (t != null) {
                log.error("store product error", t);
            }
        })).join();
    }

    private void batchWriteProduct(List<ProductEsModel> productList) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (ProductEsModel model : productList) {
            IndexRequest indexRequest = new IndexRequest(this.shopProductIndex, TYPE, String.valueOf(model.getProductId()));
            try {
                indexRequest.source(JacksonUtils.writeValueAsString((Object)model), XContentType.JSON);
            }
            catch (JsonProcessingException e) {
                log.error("josn error:{}", (Object)JSON.toJSONString((Object)model));
                continue;
            }
            bulkRequest.add(indexRequest);
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            log.info("write product id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }
}

