/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.coupon.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.kuaike.common.utils.RestfulResult;
import com.kuaike.scrm.common.service.CommonBjyApiService;
import com.kuaike.scrm.common.service.impl.PlaceHolderService;
import com.kuaike.scrm.common.utils.BaijiacloudParamBuildUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.UrlUtils;
import com.kuaike.scrm.coupon.resp.BjyCouponResp;
import com.kuaike.scrm.coupon.resp.BjyGoodsResp;
import com.kuaike.scrm.coupon.resp.BjyMeetingCouponResp;
import com.kuaike.scrm.dal.meeting.dto.MeetingGoodsRelDto;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandleBjyApiService {
    private static final Logger log = LoggerFactory.getLogger(HandleBjyApiService.class);
    @Autowired
    private PlaceHolderService placeHolderService;
    @Autowired
    private CommonBjyApiService commonBjyApiService;
    TypeReference<RestfulResult<BjyCouponResp>> bjyCouponType = new TypeReference<RestfulResult<BjyCouponResp>>(){};
    TypeReference<RestfulResult<BjyMeetingCouponResp>> meetingCouponResp = new TypeReference<RestfulResult<BjyMeetingCouponResp>>(){};
    TypeReference<RestfulResult<BjyGoodsResp>> bjyGoodsResp = new TypeReference<RestfulResult<BjyGoodsResp>>(){};

    public BjyCouponResp handleBjyCouponAdd(ShopCoupon shopCoupon) {
        String callBackPreUrl = UrlUtils.assembleUrl((String)this.placeHolderService.getScrmProtocal(), (String)this.placeHolderService.getScrmMeetingBjyCallback());
        String callBackUrl = UrlUtils.assembleUrl((String)callBackPreUrl, (String)this.placeHolderService.getScrmCallbackUrl());
        Map param = BaijiacloudParamBuildUtils.buildBjyCouponAddParam((ShopCoupon)shopCoupon, (String)callBackUrl);
        return (BjyCouponResp)this.commonBjyApiService.postBjyApi(this.bjyCouponType, this.placeHolderService.getCouponAddUrl(), param, LoginUtils.getCurrentUserCorpId(), "\u65b0\u589e", "\u4f18\u60e0\u5238");
    }

    public void handleBjyCouponEdit(ShopCoupon shopCoupon) {
        String callBackPreUrl = UrlUtils.assembleUrl((String)this.placeHolderService.getScrmProtocal(), (String)this.placeHolderService.getScrmMeetingBjyCallback());
        String callBackUrl = UrlUtils.assembleUrl((String)callBackPreUrl, (String)this.placeHolderService.getScrmCallbackUrl());
        Map param = BaijiacloudParamBuildUtils.buildBjyCouponEditParam((ShopCoupon)shopCoupon, (String)callBackUrl);
        BjyCouponResp bjyCouponResp = (BjyCouponResp)this.commonBjyApiService.postBjyApi(this.bjyCouponType, this.placeHolderService.getCouponAddUrl(), param, LoginUtils.getCurrentUserCorpId(), "\u7f16\u8f91", "\u4f18\u60e0\u5238");
        if (Objects.isNull(bjyCouponResp)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)bjyCouponResp.getCouponBatchNo())) {
            shopCoupon.setCouponButchNo(bjyCouponResp.getCouponBatchNo());
        }
    }

    public void handleBjyCouponDel(ShopCoupon shopCoupon) {
        Map param = BaijiacloudParamBuildUtils.buildBjyCouponDelParam((ShopCoupon)shopCoupon);
        this.commonBjyApiService.postBjyApi(this.bjyCouponType, this.placeHolderService.getCouponDelUrl(), param, LoginUtils.getCurrentUserCorpId(), "\u5220\u9664", "\u4f18\u60e0\u5238");
    }

    public BjyMeetingCouponResp handleBjyCouponAssociateMeeting(String roomId, List<String> couponBatchNos) {
        Map param = BaijiacloudParamBuildUtils.buildBjyAssociateCouponParam(couponBatchNos, (String)roomId);
        return (BjyMeetingCouponResp)this.commonBjyApiService.postBjyApi(this.meetingCouponResp, this.placeHolderService.getCouponAssociateWithRoomUrl(), param, LoginUtils.getCurrentUserCorpId(), "\u7ed1\u5b9a", "\u4f18\u60e0\u5238\u5173\u8054\u76f4\u64ad\u95f4");
    }

    public BjyMeetingCouponResp handBjyCouponUnAssociateMeeting(String roomId, List<String> couponBatchNos) {
        Map param = BaijiacloudParamBuildUtils.buildCouponUnAssociaRoom(couponBatchNos, (String)roomId);
        return (BjyMeetingCouponResp)this.commonBjyApiService.postBjyApi(this.meetingCouponResp, this.placeHolderService.getCouponUnassociateUrl(), param, LoginUtils.getCurrentUserCorpId(), "\u89e3\u7ed1", "\u4f18\u60e0\u5238\u5173\u8054\u76f4\u64ad\u95f4");
    }

    public BjyGoodsResp handDelBjyGoodsRoom(MeetingGoodsRelDto dto) {
        Map param = BaijiacloudParamBuildUtils.buildDelBjyGoodsParam((MeetingGoodsRelDto)dto);
        return (BjyGoodsResp)this.commonBjyApiService.postBjyApi(this.bjyGoodsResp, this.placeHolderService.getDelGoodsUrl(), param, dto.getCorpId(), "\u5220\u9664", "\u5546\u54c1\u4fe1\u606f\u540c\u6b65");
    }

    public BjyGoodsResp handleAddBjyGoodsRoom(MeetingGoodsRelDto goodsRel) {
        Map param = BaijiacloudParamBuildUtils.buildAddBjyGoodsParam((MeetingGoodsRelDto)goodsRel);
        return (BjyGoodsResp)this.commonBjyApiService.postBjyApi(this.bjyGoodsResp, this.placeHolderService.getAddGoodsUrl(), param, LoginUtils.getCurrentUserCorpId(), "\u65b0\u589e", "\u5546\u54c1\u4fe1\u606f\u540c\u6b65");
    }

    public BjyGoodsResp handleEditBjyGoodsRoom(MeetingGoodsRelDto goodsRel) {
        Map param = BaijiacloudParamBuildUtils.buildEditGoods((MeetingGoodsRelDto)goodsRel);
        return (BjyGoodsResp)this.commonBjyApiService.postBjyApi(this.bjyGoodsResp, this.placeHolderService.getEditGoodsUrl(), param, goodsRel.getCorpId(), "\u7f16\u8f91\u5546\u54c1", "\u5546\u54c1\u4fe1\u606f\u540c\u6b65");
    }
}

