/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.external.service.impl;

import cn.kinyun.wework.sdk.api.MiniprogramClient;
import cn.kinyun.wework.sdk.entity.miniprogram.Jscode2sessionResp;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.external.dto.user.Jscode2sessionReqDto;
import com.kuaike.scrm.external.service.ExternalUserService;
import com.kuaike.scrm.permission.service.LoginService;
import com.kuaike.scrm.permission.service.QyapiLoginService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ExternalUserServiceImpl
implements ExternalUserService {
    private static final Logger log = LoggerFactory.getLogger(ExternalUserServiceImpl.class);
    private static final String TOKEN_KEY = "token";
    private static final String LOGIN_KEY = "SCRM_LOGIN_KEY_%s";
    @Autowired
    private MiniprogramClient miniprogramClient;
    @Autowired
    private LoginService loginService;
    @Autowired
    private QyapiLoginService qyapiLoginService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${spring.redis.externalRedisKey:%s:external:token:%s}")
    private String externalRedisKey;

    @Override
    public CurrentUserInfo jscode2session(Jscode2sessionReqDto reqDto) {
        reqDto.validateParam();
        Jscode2sessionResp jscode2sessionResp = this.miniprogramClient.jscode2session(reqDto.getCorpId(), reqDto.getCode());
        log.info("jscode2sessionResp: {}", (Object)jscode2sessionResp);
        this.qyapiLoginService.login(jscode2sessionResp.getCorpId(), jscode2sessionResp.getUserId());
        return this.loginService.getCurrentUserInfo();
    }

    @Override
    public void logout(HttpServletRequest req, HttpSession httpSession) {
        String token = (String)StringUtils.defaultIfBlank((CharSequence)req.getHeader(TOKEN_KEY), (CharSequence)req.getParameter(TOKEN_KEY));
        String externalTokenKey = String.format(this.externalRedisKey, this.redisKeyPrefix, token);
        HashOperations hash = this.redisTemplate.opsForHash();
        String sessionId = (String)hash.get((Object)externalTokenKey, (Object)"sessionId");
        Long userId = null;
        Object uid = hash.get((Object)externalTokenKey, (Object)"userId");
        if (uid != null) {
            userId = Long.valueOf(uid.toString());
        }
        LoginUtils.setExternalToken((String)token);
        LoginUtils.setSessionId((String)sessionId);
        LoginUtils.setLoginAccountId((Long)userId);
        this.redisTemplate.delete((Object)externalTokenKey);
        LoginUtils.deleteCurrentUser(this.redisTemplate, (String)this.redisKeyPrefix);
        LoginUtils.logout();
    }
}

