/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import cn.kinyun.scrm.vip.service.IdTranslateService;
import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalChat;
import com.kuaike.scrm.dal.vip.entity.VipWeworkContactDigitId;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkContactDigitIdMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.VipIdTranslateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipIdTranslateServiceImpl
implements VipIdTranslateService {
    private static final Logger log = LoggerFactory.getLogger(VipIdTranslateServiceImpl.class);
    @Autowired
    private VipWeworkContactDigitIdMapper vipWeworkContactDigitIdMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private IdTranslateService idTranslateService;

    @Override
    public void onAddExternalContact() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String weworkUserNum = ctx.getWeworkUserNum();
        String contactId = ctx.getContactId();
        int reset = this.vipWeworkAuthorizeAccountMapper.isAvailable(corpId, weworkUserNum);
        if (reset == 0) {
            log.info("not vip user, corpId:{}, weworkUserNum:{}", (Object)corpId, (Object)weworkUserNum);
            return;
        }
        VipWeworkContactDigitId digitId = this.vipWeworkContactDigitIdMapper.selectByContactId(corpId, contactId);
        if (digitId == null) {
            this.idTranslateService.addDescription(corpId, weworkUserId, contactId);
        }
    }

    @Override
    public void onCreateExternalChat(CreateExternalChat event) {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String chatId = ctx.getChatId();
        this.idTranslateService.matchChatRoomDigitId(bizId, corpId, chatId);
    }

    @Override
    public void onUpdateExternalChat(UpdateExternalChat event) {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String chatId = ctx.getChatId();
        this.idTranslateService.matchChatRoomDigitId(bizId, corpId, chatId);
    }
}

