/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.ContractCallbackReqDto;
import cn.kinyun.scrm.contract.dto.VerifyMsg;
import cn.kinyun.scrm.contract.enums.AuthenticationTypeEnum;
import cn.kinyun.scrm.contract.service.ContractCallbackService;
import cn.kinyun.scrm.contract.service.ContractService;
import cn.kinyun.scrm.contract.service.CorpVerifyService;
import cn.kinyun.scrm.contract.service.CustomerVerifyService;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ContractCallbackServiceImpl
implements ContractCallbackService {
    private static final Logger log = LoggerFactory.getLogger(ContractCallbackServiceImpl.class);
    @Resource
    private CorpVerifyService corpVerifyService;
    @Resource
    private CustomerVerifyService customerVerifyService;
    @Resource
    private ContractService contractService;

    @Override
    public void handleCallback(ContractCallbackReqDto reqDto) {
        log.info("handleCallback,reqDto:{}, msgType:{}", (Object)reqDto, (Object)reqDto.getType());
        reqDto.validateParams();
        switch (reqDto.getCallbackMsgTypeEnum()) {
            case VERIFY: {
                this.handleVerifyCallbackMsg(reqDto.getData());
                break;
            }
            case CONTRACT_SIGN: {
                this.contractService.handleSignCallbackMsg(reqDto.getData());
                break;
            }
            case CONTRACT_AUTO_SIGN: {
                this.corpVerifyService.handleContractAutoSignMsg(reqDto.getData());
                break;
            }
        }
    }

    private void handleVerifyCallbackMsg(String data) {
        VerifyMsg verifyMsg = (VerifyMsg)JSONObject.parseObject((String)data, VerifyMsg.class);
        verifyMsg.validateParams();
        AuthenticationTypeEnum authenticationTypeEnum = AuthenticationTypeEnum.get(verifyMsg.getAuthenticationType());
        if (AuthenticationTypeEnum.CORP == authenticationTypeEnum) {
            this.corpVerifyService.handleCorpVerifyMsg(verifyMsg);
        } else {
            this.customerVerifyService.handleCustomVerifyMsg(verifyMsg);
        }
    }
}

