/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.req.NameValuePair;
import cn.kinyun.scrm.contract.dto.resp.TemplateKeyRespDto;
import cn.kinyun.scrm.contract.enums.AuthenticationTypeEnum;
import cn.kinyun.scrm.contract.enums.ContractTemplateTypeEnum;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.enums.ContractStatus;
import com.kuaike.scrm.common.service.ScrmContractService;
import com.kuaike.scrm.common.service.dto.req.ContractSignReqDto;
import com.kuaike.scrm.common.service.dto.req.CreateContractReqDto;
import com.kuaike.scrm.common.service.dto.resp.ContractRespDto;
import com.kuaike.scrm.common.service.dto.resp.ContractSignRespDto;
import com.kuaike.scrm.dal.app.entity.App;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.app.mapper.AppMapper;
import com.kuaike.scrm.dal.contract.entity.ContractCorpVerifyInfo;
import com.kuaike.scrm.dal.contract.entity.ContractCustomerVerifyInfo;
import com.kuaike.scrm.dal.contract.entity.ContractInfo;
import com.kuaike.scrm.dal.contract.entity.ContractTemplate;
import com.kuaike.scrm.dal.contract.mapper.ContractCorpVerifyInfoMapper;
import com.kuaike.scrm.dal.contract.mapper.ContractCustomerVerifyInfoMapper;
import com.kuaike.scrm.dal.contract.mapper.ContractInfoMapper;
import com.kuaike.scrm.dal.contract.mapper.ContractTemplateMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScrmContractServiceImpl
implements ScrmContractService {
    private static final Logger log = LoggerFactory.getLogger(ScrmContractServiceImpl.class);
    @Resource
    private BjyPartnerService bjyPartnerService;
    @Resource
    private ContractCustomerVerifyInfoMapper customerVerifyInfoMapper;
    @Resource
    private ContractCorpVerifyInfoMapper contractCorpVerifyInfoMapper;
    @Resource
    private ContractTemplateMapper contractTemplateMapper;
    @Resource
    private ContractInfoMapper contractInfoMapper;
    @Resource
    private AppBindingsMapper appBindingsMapper;
    @Resource
    private AppMapper appMapper;
    @Value(value="${app.contract.registerUrl}")
    private String registerUrl;
    @Value(value="${app.center.getTemplateKeysUrl}")
    private String getTemplateKeysUrl;
    @Value(value="${app.center.generateContractUrl}")
    private String generateContractUrl;
    @Value(value="${app.center.contractSignUrl}")
    private String contractSignUrl;
    @Value(value="${app.contract.appCode}")
    private String appCode;
    @Value(value="${app.center.restMoneyUrl}")
    private String restMoneyUrl;

    public String registerCustomerAccount(Long bizId, String corpId, String fddOpenId) {
        log.info("registerCustomerAccount, bizId:{}, corpId:{}, fddOpenId:{}", new Object[]{bizId, corpId, fddOpenId});
        PartnerInfo partnerInfo = this.bjyPartnerService.getPartner(bizId);
        Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
        ContractCustomerVerifyInfo contractCustomerVerifyInfo = new ContractCustomerVerifyInfo();
        contractCustomerVerifyInfo.setBizId(bizId);
        contractCustomerVerifyInfo.setCorpId(corpId);
        contractCustomerVerifyInfo.setFddOpenId(fddOpenId);
        String customerId = this.registerFddAccount(partnerInfo, headerParams, fddOpenId);
        contractCustomerVerifyInfo.setCustomerId(customerId);
        contractCustomerVerifyInfo.setCreateTime(new Date());
        contractCustomerVerifyInfo.setUpdateTime(new Date());
        this.customerVerifyInfoMapper.insertSelective((Object)contractCustomerVerifyInfo);
        return customerId;
    }

    public boolean isCorpAutoSignAuthorized(Long bizId) {
        log.info("isCorpAutoSignAuthorized, bizId:{}", (Object)bizId);
        if (Objects.isNull(bizId)) {
            return false;
        }
        ContractCorpVerifyInfo contractCorpVerifyInfo = this.contractCorpVerifyInfoMapper.selectByBizId(bizId);
        if (Objects.isNull(contractCorpVerifyInfo)) {
            return false;
        }
        return contractCorpVerifyInfo.getAutoSignAuthorizeStatus() != 0;
    }

    public Set<String> getTemplateKeys(Long bizId, String corpId, String templateId, Integer templateType) {
        Map headerParams;
        log.info("getTemplateKeys,bizId:{}, corpId:{}, templateId:{}, templateType:{}", new Object[]{bizId, corpId, templateId, templateType});
        if (Objects.isNull(bizId) || StringUtils.isBlank((CharSequence)corpId) || Objects.isNull(templateType)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractTemplate contractTemplate = ContractTemplateTypeEnum.ABANDON.getValue() == templateType.intValue() ? this.contractTemplateMapper.selectAbandonTemplateByBizId(bizId) : this.contractTemplateMapper.selectByBizIdAndTemplateId(bizId, templateId);
        if (Objects.isNull(contractTemplate)) {
            log.info("\u6839\u636ebizId:{}, templateType:{}, templateId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", new Object[]{bizId, templateType, templateId});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        PartnerInfo partnerInfo = this.bjyPartnerService.getPartner(bizId);
        List<TemplateKeyRespDto> keyRespDtos = this.getFddTemplateKeys(partnerInfo, headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId()), contractTemplate.getTemplateId());
        if (CollectionUtils.isNotEmpty(keyRespDtos)) {
            return keyRespDtos.stream().map(TemplateKeyRespDto::getName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public ContractRespDto createContract(CreateContractReqDto reqDto) {
        log.info("createNormalContract, reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        ContractTemplate contractTemplate = NumberUtils.INTEGER_ONE.equals(reqDto.getContractType()) ? this.contractTemplateMapper.selectByBizIdAndTemplateId(reqDto.getBizId(), reqDto.getTemplateId()) : this.contractTemplateMapper.selectAbandonTemplateByBizId(reqDto.getBizId());
        if (Objects.isNull(contractTemplate)) {
            log.info("\u6839\u636ebizId:{}, templateId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getBizId(), (Object)reqDto.getTemplateId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5408\u540c\u6a21\u677f\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        reqDto.setTemplateId(contractTemplate.getTemplateId());
        ContractCorpVerifyInfo contractCorpVerifyInfo = this.contractCorpVerifyInfoMapper.selectByBizId(reqDto.getBizId());
        PartnerInfo partnerInfo = this.bjyPartnerService.getPartner(reqDto.getBizId());
        Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
        ContractInfo contractInfo = this.buildContractInfo(reqDto, contractTemplate.getTemplateName(), contractCorpVerifyInfo.getCustomerId());
        this.createFddContract(contractInfo, partnerInfo, headerParams);
        this.contractSign(contractInfo, partnerInfo, headerParams, reqDto.getIdNo());
        this.contractInfoMapper.insertSelective((Object)contractInfo);
        ContractRespDto contractRespDto = new ContractRespDto();
        BeanUtils.copyProperties((Object)contractInfo, (Object)contractRespDto);
        contractRespDto.setSignUrlCreateTime(new Date());
        return contractRespDto;
    }

    public void abandonContract(Long bizId, String contractId) {
        log.info("abandonContract, bizId:{}, contractId:{}", (Object)bizId, (Object)contractId);
        ContractInfo contractInfo = this.contractInfoMapper.selectByBizIdAndContractId(bizId, contractId);
        if (Objects.isNull(contractInfo)) {
            log.info("\u6839\u636ebizId:{}, contractId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)bizId, (Object)contractId);
            return;
        }
        this.contractInfoMapper.updateStatusById(Integer.valueOf(ContractStatus.ABANDONED.getValue()), NumberUtils.LONG_MINUS_ONE, contractInfo.getId());
    }

    public ContractSignRespDto getContractSignUrl(ContractSignReqDto reqDto) {
        log.info("contractSign, reqDto:{}", (Object)reqDto);
        PartnerInfo partnerInfo = this.bjyPartnerService.getPartner(reqDto.getBizId());
        Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
        ContractInfo contractInfo = this.contractInfoMapper.selectByBizIdAndContractId(reqDto.getBizId(), reqDto.getContractId());
        this.contractSign(contractInfo, partnerInfo, headerParams, reqDto.getIdNo());
        this.contractInfoMapper.updateSignUrlById(contractInfo.getFddSignUrl(), contractInfo.getTransactionNo(), contractInfo.getId());
        ContractSignRespDto contractSignRespDto = new ContractSignRespDto();
        contractSignRespDto.setSignUrl(contractInfo.getFddSignUrl());
        contractSignRespDto.setSignUrlCreateTime(new Date());
        contractSignRespDto.setTransactionNo(contractInfo.getTransactionNo());
        return contractSignRespDto;
    }

    public boolean isOpenedContract(Long bizId) {
        log.info("isOpenedContract, bizId:{}", (Object)bizId);
        if (Objects.isNull(bizId)) {
            return false;
        }
        App app = this.appMapper.selectByCode(this.appCode);
        if (Objects.isNull(app)) {
            log.info("\u6839\u636eappCode:{}\u672a\u67e5\u8be2\u5230app\u8bb0\u5f55", (Object)this.appCode);
            return false;
        }
        if (NumberUtils.INTEGER_ZERO.equals(app.getIsRelease())) {
            log.info("\u5e94\u7528appCode:{}\u5df2\u4e0b\u67b6", (Object)this.appCode);
            return false;
        }
        AppBindings appBindings = this.appBindingsMapper.selectByBizIdAndAppCode(bizId, this.appCode);
        if (Objects.isNull(appBindings)) {
            return false;
        }
        return appBindings.getIsOpen() == 1;
    }

    public int getAccountRestMoney(Long bizId) {
        JSONObject jsonObject;
        log.info("getAccountRestMoney,bizId:{}", (Object)bizId);
        PartnerInfo partnerInfo = this.bjyPartnerService.getPartner(bizId);
        Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.restMoneyUrl, queryParams, headerParams);
            log.info("get restMoney result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u83b7\u53d6\u5546\u6237\u4f59\u989d\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5546\u6237\u53ef\u7528\u4f59\u989d\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5546\u6237\u53ef\u7528\u4f59\u989d\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return jsonObject.getJSONObject("data").getIntValue("left_total_money");
    }

    private String registerFddAccount(PartnerInfo partnerInfo, Map<String, String> headerParams, String fddOpenId) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("open_id", fddOpenId);
        queryParams.put("account_type", String.valueOf(AuthenticationTypeEnum.PERSONAL.getValue()));
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.registerUrl, queryParams, headerParams);
            log.info("registerFddAccount result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u6ce8\u518c\u6cd5\u5927\u5927\u5e10\u53f7\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ce8\u518c\u5e10\u53f7\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return jsonObject.getJSONObject("data").getString("customer_id");
    }

    private List<TemplateKeyRespDto> getFddTemplateKeys(PartnerInfo partnerInfo, Map<String, String> headerParams, String templateId) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("template_id", templateId);
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.getTemplateKeysUrl, queryParams, headerParams);
            log.info("getFddTemplateKeys result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u83b7\u53d6\u6a21\u677fkey\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            String tipMsg = "\u83b7\u53d6\u6a21\u677fkey\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5";
            if (ex instanceof BusinessException) {
                tipMsg = ex.getMessage();
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, tipMsg);
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u6a21\u677fkey\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return JSONArray.parseArray((String)jsonObject.getString("data"), TemplateKeyRespDto.class);
    }

    private void createFddContract(ContractInfo contractInfo, PartnerInfo partnerInfo, Map<String, String> headerParams) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("template_id", contractInfo.getTemplateId());
        queryParams.put("parameter_map", contractInfo.getParameterMap());
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.generateContractUrl, queryParams, headerParams);
            log.info("createFddContract result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528createFddContract\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, ex.getMessage());
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u5408\u540c\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        jsonObject = jsonObject.getJSONObject("data");
        contractInfo.setContractId(jsonObject.getString("contract_id"));
        contractInfo.setViewUrl(jsonObject.getString("viewpdf_url"));
        contractInfo.setDownloadUrl(jsonObject.getString("download_url"));
    }

    private void contractSign(ContractInfo contractInfo, PartnerInfo partnerInfo, Map<String, String> headerParams, String idNo) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("contract_id", contractInfo.getContractId());
        queryParams.put("doc_title", contractInfo.getDocTitle());
        queryParams.put("customer_id_a", contractInfo.getCorpCustomerId());
        queryParams.put("customer_id_b", contractInfo.getPersonalCustomerId());
        queryParams.put("customer_name", contractInfo.getCustomerName());
        queryParams.put("customer_ident_no", idNo);
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.contractSignUrl, queryParams, headerParams);
            log.info("contractSign result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528contractSign\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, ex.getMessage());
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53d1\u8d77\u7b7e\u7f72\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        jsonObject = jsonObject.getJSONObject("data");
        contractInfo.setTransactionNo(jsonObject.getString("transaction_no"));
        contractInfo.setFddSignUrl(jsonObject.getString("url"));
    }

    private ContractInfo buildContractInfo(CreateContractReqDto reqDto, String templateName, String corpCustomerId) {
        ArrayList nameValuePairs = Lists.newArrayList();
        for (Map.Entry entry : reqDto.getParams().entrySet()) {
            NameValuePair nameValuePair = new NameValuePair();
            nameValuePair.setName((String)entry.getKey());
            nameValuePair.setValue(entry.getValue());
            nameValuePairs.add(nameValuePair);
        }
        ContractInfo contractInfo = new ContractInfo();
        contractInfo.setBizId(reqDto.getBizId());
        contractInfo.setCorpId(reqDto.getCorpId());
        contractInfo.setTemplateId(reqDto.getTemplateId());
        contractInfo.setOriginContractId(reqDto.getOriginContractId());
        contractInfo.setStatus(NumberUtils.INTEGER_ZERO);
        contractInfo.setContractType(reqDto.getContractType());
        contractInfo.setDocTitle(templateName);
        contractInfo.setParameterMap(JsonUtil.toStr((Object)nameValuePairs));
        contractInfo.setCorpCustomerId(corpCustomerId);
        contractInfo.setCorpSignStatus(NumberUtils.INTEGER_ZERO);
        contractInfo.setPersonalCustomerId(reqDto.getPersonalCustomerId());
        contractInfo.setPersonalSignStatus(NumberUtils.INTEGER_ZERO);
        contractInfo.setCustomerName(reqDto.getCustomerName());
        contractInfo.setIsArchived(NumberUtils.INTEGER_ZERO);
        contractInfo.setRemark("");
        contractInfo.setBusinessDataType(reqDto.getBusinessDateType());
        contractInfo.setBusinessDataId(reqDto.getBusinessDateId());
        contractInfo.setBusinessDataNo(reqDto.getBusinessDataNo());
        Date curDate = new Date();
        contractInfo.setCreateTime(curDate);
        contractInfo.setUpdateTime(curDate);
        contractInfo.setCreateBy(reqDto.getUserId());
        contractInfo.setUpdateBy(reqDto.getUserId());
        return contractInfo;
    }
}

