/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.req.ContractFieldInitReqDto;
import cn.kinyun.scrm.contract.dto.req.CustomFieldReqDto;
import cn.kinyun.scrm.contract.dto.resp.CustomFieldRespDto;
import cn.kinyun.scrm.contract.service.CustomFieldService;
import com.google.common.collect.Lists;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contract.entity.ContractCustomField;
import com.kuaike.scrm.dal.contract.mapper.ContractCustomFieldMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomFieldServiceImpl
implements CustomFieldService {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldServiceImpl.class);
    @Resource
    private ContractCustomFieldMapper customFieldMapper;

    @Override
    public void init(ContractFieldInitReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long userId = userInfo.getId();
        log.info("init custom field reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userId);
        reqDto.validateParams();
        ArrayList customFields = Lists.newArrayList();
        Date curDate = new Date();
        for (String field : reqDto.getFieldNames()) {
            ContractCustomField contractCustomField = new ContractCustomField();
            customFields.add(contractCustomField);
            contractCustomField.setBizId(reqDto.getBizId());
            contractCustomField.setCorpId(reqDto.getCorpId());
            contractCustomField.setFieldName(field);
            contractCustomField.setCreateBy(userId);
            contractCustomField.setUpdateBy(userId);
            contractCustomField.setCreateTime(curDate);
            contractCustomField.setUpdateTime(curDate);
        }
        this.customFieldMapper.batchInsert((List)customFields);
    }

    @Override
    public List<CustomFieldRespDto> list(CustomFieldReqDto reqDto) {
        List customFields;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long userId = userInfo.getId();
        log.info("custom field list, reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userId);
        Integer limit = null;
        Integer offset = null;
        if (Objects.nonNull(reqDto.getPageDto())) {
            PageDto pageDto = reqDto.getPageDto();
            offset = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
            limit = pageDto.getPageSize();
        }
        if (CollectionUtils.isEmpty((Collection)(customFields = this.customFieldMapper.selectListByParams(userInfo.getBizId(), reqDto.getFieldName(), limit, offset)))) {
            return Collections.emptyList();
        }
        int count = this.customFieldMapper.selectCountByParams(userInfo.getBizId(), reqDto.getFieldName());
        if (Objects.nonNull(reqDto.getPageDto())) {
            reqDto.getPageDto().setCount(Integer.valueOf(count));
        }
        return BeanUtil.convertToList((Collection)customFields, CustomFieldRespDto.class, (String[])new String[0]);
    }
}

