/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.AutoSignAuthorizeMsg;
import cn.kinyun.scrm.contract.dto.VerifyMsg;
import cn.kinyun.scrm.contract.dto.resp.AutoSignAuthorizeRespDto;
import cn.kinyun.scrm.contract.dto.resp.CorpVerifyRespDto;
import cn.kinyun.scrm.contract.enums.AuthenticationTypeEnum;
import cn.kinyun.scrm.contract.enums.AutoSignAuthorizeStatusEnum;
import cn.kinyun.scrm.contract.enums.CertStatusEnum;
import cn.kinyun.scrm.contract.enums.CorpVerifyStatusEnum;
import cn.kinyun.scrm.contract.service.CompanySignatureService;
import cn.kinyun.scrm.contract.service.CorpVerifyService;
import com.alibaba.fastjson.JSONObject;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contract.entity.ContractCorpVerifyInfo;
import com.kuaike.scrm.dal.contract.mapper.ContractCorpVerifyInfoMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.dal.sms.mapper.PartnerInfoMapper;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CorpVerifyServiceImpl
implements CorpVerifyService {
    private static final Logger log = LoggerFactory.getLogger(CorpVerifyServiceImpl.class);
    @Resource
    private BjyPartnerService bjyPartnerService;
    @Resource
    private CompanySignatureService companySignatureService;
    @Resource
    private ContractCorpVerifyInfoMapper corpVerifyInfoMapper;
    @Resource
    private PartnerInfoMapper partnerInfoMapper;
    @Value(value="${app.contract.registerUrl}")
    private String registerUrl;
    @Value(value="${app.contract.verifyUrl}")
    private String verifyUrl;
    @Value(value="${app.contract.autoSignAuthorizeUrl}")
    private String autoSignAuthorizeUrl;
    @Value(value="${app.contract.corpCertInfoUrl}")
    private String corpCertInfoUrl;
    private static final String PREFIX = "SCRM_";

    @Override
    public CorpVerifyRespDto register() {
        AutoSignAuthorizeStatusEnum autoSignAuthorizeStatusEnum;
        CertStatusEnum certStatusEnum;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("corp register, operatorId:{}", (Object)userInfo.getId());
        ContractCorpVerifyInfo corpVerifyInfo = this.corpVerifyInfoMapper.selectByBizId(userInfo.getBizId());
        if (Objects.isNull(corpVerifyInfo)) {
            PartnerInfo partnerInfo = this.bjyPartnerService.validPartner(userInfo.getBizId());
            Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
            corpVerifyInfo = new ContractCorpVerifyInfo();
            corpVerifyInfo.setBizId(userInfo.getBizId());
            corpVerifyInfo.setCorpId(userInfo.getCorpId());
            corpVerifyInfo.setVerifyStatus(NumberUtils.INTEGER_ZERO);
            corpVerifyInfo.setAutoSignAuthorizeStatus(NumberUtils.INTEGER_ZERO);
            corpVerifyInfo.setCertStatus(NumberUtils.INTEGER_ZERO);
            corpVerifyInfo.setFddOpenId(PREFIX + userInfo.getCorpId());
            this.registerFddAccount(partnerInfo, headerParams, corpVerifyInfo);
            this.getFddVerifyUrl(partnerInfo, headerParams, corpVerifyInfo);
            corpVerifyInfo.setCreateBy(userInfo.getId());
            corpVerifyInfo.setUpdateBy(userInfo.getId());
            Date curDate = new Date();
            corpVerifyInfo.setCreateTime(curDate);
            corpVerifyInfo.setUpdateTime(curDate);
            this.corpVerifyInfoMapper.insertSelective((Object)corpVerifyInfo);
        }
        CorpVerifyRespDto corpVerifyRespDto = new CorpVerifyRespDto();
        BeanUtils.copyProperties((Object)corpVerifyInfo, (Object)corpVerifyRespDto);
        CorpVerifyStatusEnum corpVerifyStatusEnum = CorpVerifyStatusEnum.get(corpVerifyInfo.getVerifyStatus());
        if (Objects.nonNull((Object)corpVerifyStatusEnum)) {
            corpVerifyRespDto.setVerifyStatusDesc(corpVerifyStatusEnum.getDesc());
        }
        if (Objects.nonNull((Object)(certStatusEnum = CertStatusEnum.get(corpVerifyInfo.getCertStatus())))) {
            corpVerifyRespDto.setCertStatusDesc(certStatusEnum.getDesc());
        }
        if (Objects.nonNull((Object)(autoSignAuthorizeStatusEnum = AutoSignAuthorizeStatusEnum.get(corpVerifyInfo.getAutoSignAuthorizeStatus())))) {
            corpVerifyRespDto.setAutoSignAuthorizeStatusDesc(autoSignAuthorizeStatusEnum.getDesc());
        }
        return corpVerifyRespDto;
    }

    @Override
    public CorpVerifyRespDto detail() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("corp verify detail, operatorId:{}", (Object)userInfo.getId());
        ContractCorpVerifyInfo corpVerifyInfo = this.corpVerifyInfoMapper.selectByBizId(userInfo.getBizId());
        CorpVerifyRespDto corpVerifyRespDto = new CorpVerifyRespDto();
        if (Objects.nonNull(corpVerifyInfo)) {
            AutoSignAuthorizeStatusEnum autoSignAuthorizeStatusEnum;
            CertStatusEnum certStatusEnum;
            BeanUtils.copyProperties((Object)corpVerifyInfo, (Object)corpVerifyRespDto);
            CorpVerifyStatusEnum corpVerifyStatusEnum = CorpVerifyStatusEnum.get(corpVerifyInfo.getVerifyStatus());
            if (Objects.nonNull((Object)corpVerifyStatusEnum)) {
                corpVerifyRespDto.setVerifyStatusDesc(corpVerifyStatusEnum.getDesc());
            }
            if (Objects.nonNull((Object)(certStatusEnum = CertStatusEnum.get(corpVerifyInfo.getCertStatus())))) {
                corpVerifyRespDto.setCertStatusDesc(certStatusEnum.getDesc());
            }
            if (Objects.nonNull((Object)(autoSignAuthorizeStatusEnum = AutoSignAuthorizeStatusEnum.get(corpVerifyInfo.getAutoSignAuthorizeStatus())))) {
                corpVerifyRespDto.setAutoSignAuthorizeStatusDesc(autoSignAuthorizeStatusEnum.getDesc());
            }
        }
        return corpVerifyRespDto;
    }

    @Override
    public AutoSignAuthorizeRespDto getAutoSignAuthorizeUrl() {
        JSONObject jsonObject;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("getAutoSignAuthorizeUrl, operatorId:{}", (Object)userInfo.getId());
        ContractCorpVerifyInfo corpVerifyInfo = this.corpVerifyInfoMapper.selectByBizId(userInfo.getBizId());
        if (Objects.isNull(corpVerifyInfo) || CorpVerifyStatusEnum.APPROVE_PASSED.getValue() != corpVerifyInfo.getVerifyStatus().intValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u4f01\u4e1a\u8fd8\u672a\u8fdb\u884c\u5b9e\u540d\u8ba4\u8bc1");
        }
        AutoSignAuthorizeRespDto autoSignAuthorizeRespDto = new AutoSignAuthorizeRespDto();
        autoSignAuthorizeRespDto.setAutoSignAuthorizeStatus(corpVerifyInfo.getAutoSignAuthorizeStatus());
        AutoSignAuthorizeStatusEnum autoSignAuthorizeStatusEnum = AutoSignAuthorizeStatusEnum.get(corpVerifyInfo.getAutoSignAuthorizeStatus());
        autoSignAuthorizeRespDto.setAutoSignAuthorizeStatusDesc(autoSignAuthorizeStatusEnum.getDesc());
        if (AutoSignAuthorizeStatusEnum.AUTHORIZED.getValue() == corpVerifyInfo.getAutoSignAuthorizeStatus().intValue()) {
            return autoSignAuthorizeRespDto;
        }
        PartnerInfo partnerInfo = this.bjyPartnerService.validPartner(userInfo.getBizId());
        Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("customer_id", corpVerifyInfo.getCustomerId());
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.autoSignAuthorizeUrl, queryParams, headerParams);
            log.info("getAutoSignAuthorizeUrl result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u83b7\u53d6\u81ea\u52a8\u7b7e\u6388\u6743\u5730\u5740\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u81ea\u52a8\u7b7e\u6388\u6743\u5730\u5740,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u81ea\u52a8\u7b7e\u6388\u6743\u5730\u5740,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        autoSignAuthorizeRespDto.setAuthorizeUrl(jsonObject.getJSONObject("data").getString("url"));
        return autoSignAuthorizeRespDto;
    }

    @Override
    public void handleContractAutoSignMsg(String data) {
        log.info("handleContractAutoSignMsg,data:{}", (Object)data);
        AutoSignAuthorizeMsg autoSignAuthorizeMsg = (AutoSignAuthorizeMsg)JSONObject.parseObject((String)data, AutoSignAuthorizeMsg.class);
        if (Objects.isNull(autoSignAuthorizeMsg)) {
            log.warn("\u5c06data\u8f6c\u6362\u6210AutoSignAuthorizeMsg\u5bf9\u8c61\u5931\u8d25");
            return;
        }
        autoSignAuthorizeMsg.validateParams();
        PartnerInfo partnerInfo = this.partnerInfoMapper.selectByPartnerId(autoSignAuthorizeMsg.getPartnerId());
        if (Objects.isNull(partnerInfo)) {
            log.warn("\u6839\u636epartnerId:{}\u672a\u67e5\u8be2\u5230PartnerInfo", (Object)autoSignAuthorizeMsg.getPartnerId());
            return;
        }
        ContractCorpVerifyInfo corpVerifyInfo = this.corpVerifyInfoMapper.selectByBizId(partnerInfo.getBizId());
        if (Objects.isNull(corpVerifyInfo)) {
            log.warn("\u6839\u636ebizId:{}\u672a\u67e5\u8be2\u5230ContractCorpVerifyInfo", (Object)partnerInfo.getBizId());
            return;
        }
        if (!Objects.equals(corpVerifyInfo.getCustomerId(), autoSignAuthorizeMsg.getCustomerId())) {
            log.warn("\u672c\u5730customerId:{}\u4e0e\u6d88\u606f\u4f53\u4e2d\u7684customerId:{}\u4e0d\u4e00\u81f4", (Object)corpVerifyInfo.getCustomerId(), (Object)autoSignAuthorizeMsg.getCustomerId());
            return;
        }
        this.corpVerifyInfoMapper.updateAuthorizeStatusById(autoSignAuthorizeMsg.getStatus(), NumberUtils.LONG_MINUS_ONE, corpVerifyInfo.getId());
    }

    @Override
    public void handleCorpVerifyMsg(VerifyMsg verifyMsg) {
        log.info("handleCorpVerifyMsg,verifyMsg:{}", (Object)verifyMsg);
        PartnerInfo partnerInfo = this.partnerInfoMapper.selectByPartnerId(verifyMsg.getPartnerId());
        if (Objects.isNull(partnerInfo)) {
            log.warn("\u6839\u636epartnerId:{}\u672a\u67e5\u8be2\u5230PartnerInfo", (Object)verifyMsg.getPartnerId());
            return;
        }
        ContractCorpVerifyInfo corpVerifyInfo = this.corpVerifyInfoMapper.selectByBizId(partnerInfo.getBizId());
        if (Objects.isNull(corpVerifyInfo)) {
            log.warn("\u6839\u636ebizId:{}\u672a\u67e5\u8be2\u5230ContractCorpVerifyInfo", (Object)partnerInfo.getBizId());
            return;
        }
        if (!Objects.equals(corpVerifyInfo.getCustomerId(), verifyMsg.getCustomerId())) {
            log.warn("\u672c\u5730customerId:{}\u4e0e\u6d88\u606f\u4f53\u4e2d\u7684customerId:{}\u4e0d\u4e00\u81f4", (Object)corpVerifyInfo.getCustomerId(), (Object)verifyMsg.getCustomerId());
            return;
        }
        if (!Objects.equals(corpVerifyInfo.getTransactionNo(), verifyMsg.getTransactionNo())) {
            log.warn("\u672c\u5730transactionNo:{}\u4e0e\u6d88\u606f\u4f53\u4e2d\u7684transactionNo:{}\u4e0d\u4e00\u81f4", (Object)corpVerifyInfo.getTransactionNo(), (Object)verifyMsg.getTransactionNo());
            return;
        }
        corpVerifyInfo.setVerifyStatus(verifyMsg.getStatus());
        corpVerifyInfo.setCertStatus(verifyMsg.getCertStatus());
        corpVerifyInfo.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
        corpVerifyInfo.setUpdateTime(new Date());
        if (CertStatusEnum.APPLY_SUCCESS.getValue() == verifyMsg.getCertStatus().intValue() && StringUtils.isBlank((CharSequence)corpVerifyInfo.getVerifyInfo())) {
            Map headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId());
            for (int i = 0; i < 3; ++i) {
                try {
                    TimeUnit.SECONDS.sleep(i);
                    String companyName = this.getCorpVerifyInfo(partnerInfo, headerParams, corpVerifyInfo);
                    this.companySignatureService.createCustomSignature(companyName, corpVerifyInfo.getCustomerId(), partnerInfo, headerParams);
                    break;
                }
                catch (Exception ex) {
                    log.info("\u6267\u884c\u6b21\u6570:{}, \u5f02\u5e38\u4fe1\u606f\uff1a", (Object)i, (Object)ex);
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
        }
        this.corpVerifyInfoMapper.updateByPrimaryKey((Object)corpVerifyInfo);
    }

    private void registerFddAccount(PartnerInfo partnerInfo, Map<String, String> headerParams, ContractCorpVerifyInfo corpVerifyInfo) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("open_id", corpVerifyInfo.getFddOpenId());
        queryParams.put("account_type", String.valueOf(AuthenticationTypeEnum.CORP.getValue()));
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.registerUrl, queryParams, headerParams);
            log.info("registerFddAccount result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u6ce8\u518c\u6cd5\u5927\u5927\u5e10\u53f7\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ce8\u518c\u5e10\u53f7\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        jsonObject = jsonObject.getJSONObject("data");
        corpVerifyInfo.setCustomerId(jsonObject.getString("customer_id"));
    }

    private void getFddVerifyUrl(PartnerInfo partnerInfo, Map<String, String> headerParams, ContractCorpVerifyInfo corpVerifyInfo) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("customer_id", corpVerifyInfo.getCustomerId());
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.verifyUrl, queryParams, headerParams);
            log.info("registerFddAccount result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u6ce8\u518c\u6cd5\u5927\u5927\u5e10\u53f7\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        jsonObject = jsonObject.getJSONObject("data");
        corpVerifyInfo.setTransactionNo(jsonObject.getString("transaction_no"));
        corpVerifyInfo.setVerifyUrl(jsonObject.getString("url"));
    }

    private String getCorpVerifyInfo(PartnerInfo partnerInfo, Map<String, String> headerParams, ContractCorpVerifyInfo corpVerifyInfo) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("transaction_no", corpVerifyInfo.getTransactionNo());
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.corpCertInfoUrl, queryParams, headerParams);
            log.info("getCorpVerifyInfo result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        jsonObject = jsonObject.getJSONObject("data");
        corpVerifyInfo.setVerifyInfo(jsonObject.toJSONString());
        return jsonObject.getJSONObject("company").getString("companyName");
    }
}

