/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.dto;

import cn.kinyun.scrm.contract.enums.AuthenticationTypeEnum;
import cn.kinyun.scrm.contract.enums.CertStatusEnum;
import cn.kinyun.scrm.contract.enums.CorpVerifyStatusEnum;
import cn.kinyun.scrm.contract.enums.PersonalVerifyStatusEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class VerifyMsg {
    @JsonProperty(value="partner_id")
    private String partnerId;
    @JsonProperty(value="transaction_no")
    private String transactionNo;
    @JsonProperty(value="customer_id")
    private String customerId;
    @JsonProperty(value="status")
    private Integer status;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="cert_status")
    private Integer certStatus;
    @JsonProperty(value="authentication_type")
    private Integer authenticationType;

    public void validateParams() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.partnerId), (Object)"partnerId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.customerId), (Object)"customerId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.transactionNo), (Object)"transactionNo\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.status), (Object)"status\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.certStatus), (Object)"certStatus\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.authenticationType), (Object)"authenticationType\u4e3a\u7a7a");
        CertStatusEnum certStatusEnum = CertStatusEnum.get(this.certStatus);
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)certStatusEnum), (Object)"certStatus\u503c\u4e0d\u5408\u6cd5");
        AuthenticationTypeEnum authenticationTypeEnum = AuthenticationTypeEnum.get(this.authenticationType);
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)authenticationTypeEnum));
        if (authenticationTypeEnum == AuthenticationTypeEnum.CORP) {
            CorpVerifyStatusEnum corpVerifyStatusEnum = CorpVerifyStatusEnum.get(this.status);
            Preconditions.checkArgument((boolean)Objects.nonNull((Object)corpVerifyStatusEnum), (Object)"status\u4e0d\u5408\u6cd5");
        } else {
            PersonalVerifyStatusEnum personalVerifyStatusEnum = PersonalVerifyStatusEnum.get(this.status);
            Preconditions.checkArgument((boolean)Objects.nonNull((Object)personalVerifyStatusEnum), (Object)"status\u4e0d\u5408\u6cd5");
        }
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getTransactionNo() {
        return this.transactionNo;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getCertStatus() {
        return this.certStatus;
    }

    public Integer getAuthenticationType() {
        return this.authenticationType;
    }

    @JsonProperty(value="partner_id")
    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    @JsonProperty(value="transaction_no")
    public void setTransactionNo(String transactionNo) {
        this.transactionNo = transactionNo;
    }

    @JsonProperty(value="customer_id")
    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    @JsonProperty(value="status")
    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="cert_status")
    public void setCertStatus(Integer certStatus) {
        this.certStatus = certStatus;
    }

    @JsonProperty(value="authentication_type")
    public void setAuthenticationType(Integer authenticationType) {
        this.authenticationType = authenticationType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifyMsg)) {
            return false;
        }
        VerifyMsg other = (VerifyMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$certStatus = this.getCertStatus();
        Integer other$certStatus = other.getCertStatus();
        if (this$certStatus == null ? other$certStatus != null : !((Object)this$certStatus).equals(other$certStatus)) {
            return false;
        }
        Integer this$authenticationType = this.getAuthenticationType();
        Integer other$authenticationType = other.getAuthenticationType();
        if (this$authenticationType == null ? other$authenticationType != null : !((Object)this$authenticationType).equals(other$authenticationType)) {
            return false;
        }
        String this$partnerId = this.getPartnerId();
        String other$partnerId = other.getPartnerId();
        if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) {
            return false;
        }
        String this$transactionNo = this.getTransactionNo();
        String other$transactionNo = other.getTransactionNo();
        if (this$transactionNo == null ? other$transactionNo != null : !this$transactionNo.equals(other$transactionNo)) {
            return false;
        }
        String this$customerId = this.getCustomerId();
        String other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$updatedAt = this.getUpdatedAt();
        String other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VerifyMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $certStatus = this.getCertStatus();
        result = result * 59 + ($certStatus == null ? 43 : ((Object)$certStatus).hashCode());
        Integer $authenticationType = this.getAuthenticationType();
        result = result * 59 + ($authenticationType == null ? 43 : ((Object)$authenticationType).hashCode());
        String $partnerId = this.getPartnerId();
        result = result * 59 + ($partnerId == null ? 43 : $partnerId.hashCode());
        String $transactionNo = this.getTransactionNo();
        result = result * 59 + ($transactionNo == null ? 43 : $transactionNo.hashCode());
        String $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String toString() {
        return "VerifyMsg(partnerId=" + this.getPartnerId() + ", transactionNo=" + this.getTransactionNo() + ", customerId=" + this.getCustomerId() + ", status=" + this.getStatus() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", url=" + this.getUrl() + ", certStatus=" + this.getCertStatus() + ", authenticationType=" + this.getAuthenticationType() + ")";
    }
}

