/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.chat.dto.ChatSecretConfigReqDto;
import com.kuaike.scrm.chat.dto.ChatSecretConfigRespDto;
import com.kuaike.scrm.chat.service.ChatConfigService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.IsDelete;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.agent.entity.AgentToken;
import com.kuaike.scrm.dal.agent.mapper.AgentTokenMapper;
import com.kuaike.scrm.dal.chat.dto.ChatConfigDto;
import com.kuaike.scrm.dal.chat.entity.WeworkChatKey;
import com.kuaike.scrm.dal.chat.entity.WeworkChatSecret;
import com.kuaike.scrm.dal.chat.mapper.WeworkChatKeyMapper;
import com.kuaike.scrm.dal.chat.mapper.WeworkChatSecretMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChatConfigServiceImpl
implements ChatConfigService {
    private static final Logger log = LoggerFactory.getLogger(ChatConfigServiceImpl.class);
    @Value(value="${agent.proxy.address:}")
    private String proxyAddress;
    @Value(value="${agent.proxy.port:0}")
    private Integer proxyPort;
    @Autowired
    private WeworkChatSecretMapper weworkChatSecretMapper;
    @Autowired
    private WeworkChatKeyMapper weworkChatKeyMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private AgentTokenMapper agentTokenMapper;
    private static List<ChatConfigDto> allChatConfig;

    @Override
    public List<ChatConfigDto> getConfigCache() {
        return allChatConfig;
    }

    public void initLoadCache() {
        this.loadCache();
    }

    @Override
    public void loadCache() {
        log.info("loadCache");
        allChatConfig = this.selectAllChatConfig();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(ChatSecretConfigReqDto reqDto) {
        WeworkChatSecret weworkChatSecret;
        log.info("chat config addOrMod:{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.validate();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        Long operatorId = currentUser.getId();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        String corpId = currentUser.getCorpId();
        if (weworkCorp.getIsNewDkf() != null && weworkCorp.getIsNewDkf() == 1) {
            AgentToken agentToken = this.agentTokenMapper.queryByBizId(currentUser.getBizId());
            if (Objects.isNull(agentToken) || StringUtils.isBlank((CharSequence)agentToken.getCorpId())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u5148\u914d\u7f6e\u81ea\u5efa\u5e94\u7528\u3002");
            }
            corpId = agentToken.getCorpId();
        }
        if (Objects.nonNull(weworkChatSecret = this.selectSecretByBizId(bizId))) {
            this.updateSetSecret(weworkChatSecret, operatorId, reqDto);
            this.insertOrUpdateChatKey(reqDto, bizId, operatorId, corpId);
        } else {
            this.insertSecret(reqDto, bizId, operatorId, corpId);
        }
    }

    @Override
    public List<ChatConfigDto> selectAllChatConfig() {
        return this.weworkChatSecretMapper.selectAllConfig();
    }

    @Override
    public WeworkChatSecret selectSecretByBizId(Long bizId) {
        WeworkChatSecret select = new WeworkChatSecret();
        select.setBizId(bizId);
        return (WeworkChatSecret)this.weworkChatSecretMapper.selectOne((Object)select);
    }

    @Override
    public List<ChatConfigDto> selectChatConfigDtoByCorpId(Long bizId, String corpId) {
        return this.weworkChatSecretMapper.selectByCorpIdAndBizId(corpId, bizId);
    }

    private void insertSecret(ChatSecretConfigReqDto reqDto, Long bizId, Long operatorId, String corpId) {
        WeworkChatSecret newChatSecret = new WeworkChatSecret();
        newChatSecret.setBizId(bizId);
        newChatSecret.setCorpId(corpId);
        newChatSecret.setIsDeleted(Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()));
        newChatSecret.setUpdateBy(operatorId);
        newChatSecret.setUpdateTime(new Date());
        newChatSecret.setCreateBy(operatorId);
        newChatSecret.setCreateTime(new Date());
        newChatSecret.setSecret(reqDto.getSecret());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getProxyAddress()) && reqDto.getProxyPort() != null && reqDto.getProxyPort() > 0) {
            newChatSecret.setProxyAddress(reqDto.getProxyAddress());
            newChatSecret.setProxyPort(reqDto.getProxyPort());
        } else if (StringUtils.isNotBlank((CharSequence)this.proxyAddress) && this.proxyPort != null && this.proxyPort > 0) {
            newChatSecret.setProxyAddress(this.proxyAddress);
            newChatSecret.setProxyPort(this.proxyPort);
        }
        this.weworkChatSecretMapper.insertSelective((Object)newChatSecret);
    }

    private void insertOrUpdateChatKey(ChatSecretConfigReqDto reqDto, Long bizId, Long operatorId, String corpId) {
        WeworkChatKey weworkChatKey = this.selectChatKeyByBizId(bizId, reqDto.getVersion());
        if (Objects.nonNull(weworkChatKey)) {
            WeworkChatKey update = new WeworkChatKey();
            update.setId(weworkChatKey.getId());
            update.setPrivateKey(reqDto.getPrivateKey());
            update.setPublicKey(reqDto.getPublicKey());
            update.setUpdateBy(operatorId);
            update.setUpdateTime(new Date());
            update.setIsDeleted(Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()));
            update.setSecret(reqDto.getSecret());
            this.weworkChatKeyMapper.updateByPrimaryKeySelective((Object)update);
        } else {
            this.insertNewChatKey(reqDto, bizId, operatorId, corpId);
        }
    }

    private WeworkChatKey selectChatKeyByBizId(Long bizId, Integer version) {
        WeworkChatKey selectKey = new WeworkChatKey();
        selectKey.setBizId(bizId);
        selectKey.setVersion(version);
        return (WeworkChatKey)this.weworkChatKeyMapper.selectOne((Object)selectKey);
    }

    private void insertNewChatKey(ChatSecretConfigReqDto reqDto, Long bizId, Long operatorId, String corpId) {
        WeworkChatKey newChatKey = new WeworkChatKey();
        newChatKey.setPrivateKey(reqDto.getPrivateKey());
        newChatKey.setPublicKey(reqDto.getPublicKey());
        newChatKey.setUpdateBy(operatorId);
        newChatKey.setUpdateTime(new Date());
        newChatKey.setBizId(bizId);
        newChatKey.setCorpId(corpId);
        newChatKey.setCreateBy(operatorId);
        newChatKey.setCreateTime(new Date());
        newChatKey.setVersion(reqDto.getVersion());
        newChatKey.setSecret(reqDto.getSecret());
        this.weworkChatKeyMapper.insertSelective((Object)newChatKey);
    }

    private void updateSetSecret(WeworkChatSecret weworkChatSecret, Long operatorId, ChatSecretConfigReqDto reqDto) {
        WeworkChatSecret update = new WeworkChatSecret();
        update.setId(weworkChatSecret.getId());
        update.setIsDeleted(Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()));
        update.setUpdateBy(operatorId);
        update.setUpdateTime(new Date());
        update.setSecret(reqDto.getSecret());
        update.setVersion(reqDto.getVersion());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getProxyAddress()) && reqDto.getProxyPort() != null && reqDto.getProxyPort() > 0) {
            update.setProxyAddress(reqDto.getProxyAddress());
            update.setProxyPort(reqDto.getProxyPort());
        }
        this.weworkChatSecretMapper.updateByPrimaryKeySelective((Object)weworkChatSecret);
    }

    @Override
    public ChatSecretConfigRespDto detail() {
        ChatSecretConfigRespDto respDto = new ChatSecretConfigRespDto();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        WeworkChatSecret weworkChatSecret = this.selectSecretByBizId(currentUser.getBizId());
        if (Objects.nonNull(weworkChatSecret)) {
            respDto.setCorpId(weworkChatSecret.getCorpId());
            respDto.setSecret(weworkChatSecret.getSecret());
            respDto.setVersion(weworkChatSecret.getVersion());
            respDto.setProxyType(weworkChatSecret.getProxyType());
            respDto.setProxyAddress(weworkChatSecret.getProxyAddress());
            respDto.setProxyPort(weworkChatSecret.getProxyPort());
            WeworkChatKey weworkChatKey = this.selectChatKeyByBizId(currentUser.getBizId(), weworkChatSecret.getVersion());
            if (Objects.nonNull(weworkChatKey)) {
                respDto.setPrivateKey(weworkChatKey.getPrivateKey());
                respDto.setPublicKey(weworkChatKey.getPublicKey());
            }
        }
        return respDto;
    }
}

