/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.api.FinanceApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.entity.chat.PermitUserDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.chat.dto.OpenChatConfigDto;
import com.kuaike.scrm.chat.service.ChatConfigService;
import com.kuaike.scrm.chat.service.WeworkUserChatConfigService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.IsDelete;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.chat.dto.ChatConfigDto;
import com.kuaike.scrm.dal.chat.entity.WeworkChatSecret;
import com.kuaike.scrm.dal.chat.entity.WeworkUserChatConfig;
import com.kuaike.scrm.dal.chat.entity.WeworkUserChatConfigCriteria;
import com.kuaike.scrm.dal.chat.mapper.WeworkUserChatConfigMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeworkUserChatConfigServiceImpl
implements WeworkUserChatConfigService {
    private static final Logger log = LoggerFactory.getLogger(WeworkUserChatConfigServiceImpl.class);
    @Autowired
    private WeworkUserChatConfigMapper weworkUserChatConfigMapper;
    @Autowired
    private FinanceApi financeApi;
    @Autowired
    private ChatConfigService chatConfigService;
    @Autowired
    private AccessTokenApi accessTokenApi;

    @Override
    public Set<String> getPermitUserList(Long bizId) {
        WeworkUserChatConfig weworkUserChatConfig = new WeworkUserChatConfig();
        weworkUserChatConfig.setBizId(bizId);
        weworkUserChatConfig.setIsDeleted(Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()));
        return this.weworkUserChatConfigMapper.select((Object)weworkUserChatConfig).stream().map(WeworkUserChatConfig::getWeworkUserId).collect(Collectors.toSet());
    }

    public PermitUserDto getPermitUserList(Integer type) {
        log.info("getPermitUserList type:{}", (Object)type);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        WeworkChatSecret weworkChatSecret = this.chatConfigService.selectSecretByBizId(currentUser.getBizId());
        Preconditions.checkArgument((boolean)Objects.nonNull(weworkChatSecret), (Object)"\u8bf7\u5148\u914d\u7f6e\u4f1a\u8bdd\u5b58\u6863\u7684secret");
        AccessToken accessToken = this.accessTokenApi.getAccessToken(currentUser.getCorpId(), weworkChatSecret.getSecret());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessToken.getAccessToken()), (Object)"\u83b7\u53d6accessToken\u5931\u8d25");
        return this.financeApi.getPermitUserList(accessToken.getAccessToken(), type);
    }

    public List<OpenChatConfigDto> list(Integer type) {
        ArrayList result = Lists.newArrayList();
        PermitUserDto permitUserList = this.getPermitUserList(type);
        if (CollectionUtils.isEmpty((Collection)permitUserList.getIds())) {
            return result;
        }
        for (String weworkUserId : permitUserList.getIds()) {
            OpenChatConfigDto configDto = new OpenChatConfigDto();
            configDto.setWeworkUserId(weworkUserId);
            result.add(configDto);
        }
        return result;
    }

    @Override
    public void pullChatStorePermitUserList() {
        log.info("pullChatStorePermitUserList start");
        long startTime = System.currentTimeMillis();
        List<ChatConfigDto> list = this.chatConfigService.selectAllChatConfig();
        log.info("allChatConfig size={}", (Object)list.size());
        for (ChatConfigDto chatConfigDto : list) {
            try {
                this.pullCorpChatStorePermitAndUpdate(chatConfigDto);
            }
            catch (Exception e) {
                log.info("getPermitUserList with corpId={}, error", (Object)chatConfigDto.getCorpId(), (Object)e);
            }
        }
        log.info("pullChatStorePermitUserList end,wasteTime={}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void pullCorpChatStorePermitAndUpdate(ChatConfigDto chatConfigDto) {
        PermitUserDto dto = this.financeApi.getPermitUserList(chatConfigDto.getAccessToken(), null);
        if (dto.getErrCode() == 0) {
            Date now;
            Set newUserIds = dto.getIds();
            List weworkUserChatConfigs = this.weworkUserChatConfigMapper.queryByCorpId(chatConfigDto.getCorpId());
            Set oldUserIds = weworkUserChatConfigs.stream().filter(a -> a.getIsDeleted() == 0 && a.getOpenChatConfig() == 1).map(a -> a.getWeworkUserId()).collect(Collectors.toSet());
            Collection needAddUserIds = CollectionUtils.subtract((Iterable)newUserIds, oldUserIds);
            Collection needRemoveUserIds = CollectionUtils.subtract(oldUserIds, (Iterable)newUserIds);
            log.info("pullCorpChatStorePermitAndUpdate needAddUserIds: {}, needRemoveUserIds: {}", (Object)needAddUserIds, (Object)needRemoveUserIds);
            if (CollectionUtils.isNotEmpty((Collection)needAddUserIds)) {
                now = new Date();
                this.updateExistsEnable(weworkUserChatConfigs, needAddUserIds, now);
                this.insertNewUser(chatConfigDto, weworkUserChatConfigs, needAddUserIds, now);
            }
            if (CollectionUtils.isNotEmpty((Collection)needRemoveUserIds)) {
                now = new Date();
                this.updateRemove(weworkUserChatConfigs, needRemoveUserIds, now);
            }
        }
    }

    private void updateRemove(List<WeworkUserChatConfig> weworkUserChatConfigs, Collection<String> needRemoveUserIds, Date now) {
        List needRemoveIds = weworkUserChatConfigs.stream().filter(a -> needRemoveUserIds.contains(a.getWeworkUserId())).filter(a -> a.getIsDeleted() == 0 && a.getOpenChatConfig() == 1).map(a -> a.getId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needRemoveIds)) {
            WeworkUserChatConfig item = new WeworkUserChatConfig();
            item.setUpdateTime(now);
            item.setIsDeleted(Integer.valueOf(1));
            item.setOpenChatConfig(Integer.valueOf(0));
            WeworkUserChatConfigCriteria criteria = new WeworkUserChatConfigCriteria();
            criteria.createCriteria().andIdIn(needRemoveIds);
            this.weworkUserChatConfigMapper.updateByExampleSelective((Object)item, (Object)criteria);
        }
    }

    private void insertNewUser(ChatConfigDto chatConfigDto, List<WeworkUserChatConfig> weworkUserChatConfigs, Collection<String> needAddUserIds, Date now) {
        Set needEnableUserIds = weworkUserChatConfigs.stream().filter(a -> a.getOpenChatConfig() == 0 || a.getIsDeleted() == 1).filter(a -> needAddUserIds.contains(a.getWeworkUserId())).map(a -> a.getWeworkUserId()).collect(Collectors.toSet());
        needAddUserIds.removeAll(needEnableUserIds);
        for (String addItem : needAddUserIds) {
            WeworkUserChatConfig config = this.buildWeworkUserChatConfig(chatConfigDto, now, addItem);
            this.weworkUserChatConfigMapper.insertSelective((Object)config);
        }
    }

    private void updateExistsEnable(List<WeworkUserChatConfig> weworkUserChatConfigs, Collection<String> needAddUserIds, Date now) {
        List needEnableIds = weworkUserChatConfigs.stream().filter(a -> a.getOpenChatConfig() == 0 || a.getIsDeleted() == 1).filter(a -> needAddUserIds.contains(a.getWeworkUserId())).map(a -> a.getId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needEnableIds)) {
            WeworkUserChatConfig item = new WeworkUserChatConfig();
            item.setUpdateTime(now);
            item.setIsDeleted(Integer.valueOf(0));
            item.setOpenChatConfig(Integer.valueOf(1));
            WeworkUserChatConfigCriteria criteria = new WeworkUserChatConfigCriteria();
            criteria.createCriteria().andIdIn(needEnableIds);
            this.weworkUserChatConfigMapper.updateByExampleSelective((Object)item, (Object)criteria);
        }
    }

    private WeworkUserChatConfig buildWeworkUserChatConfig(ChatConfigDto chatConfigDto, Date now, String addItem) {
        WeworkUserChatConfig config = new WeworkUserChatConfig();
        config.setCorpId(chatConfigDto.getCorpId());
        config.setBizId(chatConfigDto.getBizId());
        config.setCreateBy(Long.valueOf(-1L));
        config.setWeworkUserId(addItem);
        config.setIsDeleted(Integer.valueOf(0));
        config.setCreateTime(now);
        config.setOpenChatConfig(Integer.valueOf(1));
        config.setOpenTime(now);
        config.setUpdateBy(Long.valueOf(-1L));
        config.setUpdateTime(now);
        return config;
    }
}

