/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.callback.corp.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelFollowUser;
import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.enums.ChatMsgType;
import cn.kinyun.wework.sdk.enums.TalkerType;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.chat.check.CorpWordTree;
import com.kuaike.scrm.chat.check.MatchedResult;
import com.kuaike.scrm.chat.check.MatchedType;
import com.kuaike.scrm.chat.check.MatchedWord;
import com.kuaike.scrm.chat.service.CacheService;
import com.kuaike.scrm.chat.service.ChatMsgRedisDelayQueueManager;
import com.kuaike.scrm.chat.service.QualityCheckService;
import com.kuaike.scrm.common.dto.CorpSensitiveWordBehaviorDto;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.common.enums.QualityCheckType;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkContactIdMapper;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkUserIdMapper;
import com.kuaike.scrm.dal.chat.entity.WeworkConversation;
import com.kuaike.scrm.dal.chat.mapper.WeworkConversationMapper;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckBehaviorSetting;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckLog;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckNotification;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckLogMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckNotificationMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckNotificationScopeMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckWordGroupMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkNumPair;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkPair;
import com.kuaike.scrm.dal.wework.dto.UserContactInfo;
import com.kuaike.scrm.dal.wework.dto.WeworkContactRelationDto;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUserStatisticsRecord;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserStatisticsRecordMapper;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.wework.insight.service.WeworkInsightService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;

@Deprecated
public class QualityCheckServiceImpl
implements QualityCheckService {
    private static final Logger log = LoggerFactory.getLogger(QualityCheckServiceImpl.class);
    @Autowired
    private CorpWordTree corpWordTree;
    @Autowired
    private CacheService cacheService;
    @Resource
    private WeworkInsightService weworkInsightService;
    @Resource
    private QualityCheckLogMapper qualityCheckLogMapper;
    @Autowired
    private ChatMsgRedisDelayQueueManager delayQueueManager;
    @Autowired
    private IdGen idGen;
    @Autowired
    private RemindService remindService;
    @Autowired
    private NodeService nodeService;
    @Resource
    private WeworkContactRelationMapper contactRelationMapper;
    @Resource
    private QualityCheckNotificationMapper notificationMapper;
    @Resource
    private QualityCheckNotificationScopeMapper notificationScopeMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private QualityCheckBehaviorSettingMapper behaviorSettingMapper;
    @Resource
    private QualityCheckWordGroupMapper wordGroupMapper;
    @Resource
    private WeworkConversationMapper weworkConversationMapper;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Resource
    private AgentDecryptWeworkUserIdMapper agentDecryptWeworkUserIdMapper;
    @Resource
    private AgentDecryptWeworkContactIdMapper agentDecryptWeworkContactIdMapper;
    @Resource
    private WeworkUserStatisticsRecordMapper weworkUserStatisticsRecordMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String scrmManagerHost;
    private static final Set<String> SENSITIVE_TYPES = Sets.newHashSet((Object[])new String[]{ChatMsgType.TEXT.getValue(), ChatMsgType.CARD.getValue(), ChatMsgType.REDPACKET.getValue(), ChatMsgType.EXTERNAL_REDPACKET.getValue()});
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final String REMIND_STR = "\u3010\u5ba2\u6237\u6d41\u5931\u63d0\u9192\u3011\n [%s]\u5220\u9664\u4e86\u4f60\u7684\u4f01\u4e1a\u5fae\u4fe1\uff0c\u8bf7\u5173\u6ce8\u5e76\u53ca\u65f6\u8ddf\u8fdb\uff0c\u907f\u514d\u5ba2\u6237\u6d41\u5931\n\n>><a href=\"%s/clientSide?corpId=%s&contactId=%s\">\u67e5\u770b\u5ba2\u6237\u8be6\u60c5</a>";
    private static final String NOTIFICATION_FORMAT = "\u3010\u8fdd\u89c4\u901a\u77e5\u3011\n \u5458\u5de5[%s] %s [%s] %s\uff01\n\n ";
    private static final String CONTEXT_FORMAT = ">><a href=\"%s/sessionContext?corpId=%s&weworkUserId=%s&conversationId=%s&msgId=%s\">\u67e5\u770b\u4e0a\u4e0b\u6587</a>";
    private static final String CONTACT_FORMAT = "   >><a href=\"%s/clientSide?corpId=%s&contactId=%s\">\u67e5\u770b\u5ba2\u6237\u8be6\u60c5</a>";
    private static final String BATCH_NOTIFY_TEMPLATE = "\u5458\u5de5 [%s] %s [%s] %s \n";
    private static final String BATCH_NOTIFY_DETAILS = "\u5171%s\u6761\u8fdd\u89c4\u8bb0\u5f55\uff0c >><a href=\"%s/viloationNotice?corpId=%s&batchNo=%s\">\u67e5\u770b\u8be6\u60c5</a>";

    @Override
    public void handleMessage(ChatMsg chatMsg) {
        if (chatMsg == null) {
            return;
        }
        if (chatMsg.getAction().equals("recall")) {
            this.delayQueueManager.dealRecallMsg(chatMsg);
            return;
        }
        if (!chatMsg.getAction().equals("send") || !SENSITIVE_TYPES.contains(chatMsg.getMsgType())) {
            log.info("\u4e0d\u662f\u5173\u6ce8\u7684\u6d88\u606f\u7c7b\u578b,msgId={}", (Object)chatMsg.getMsgId());
            return;
        }
        int useAgent = this.queryNewDKF(chatMsg.getBizId());
        String corpId = chatMsg.getCorpId();
        String weworkUserId = chatMsg.getFrom();
        String contactId = (String)chatMsg.getTolist().get(0);
        if (useAgent == 1) {
            WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(chatMsg.getBizId());
            if (weworkCorp == null) {
                log.warn("weworkCorp is null corpId: {}", (Object)corpId);
                return;
            }
            corpId = weworkCorp.getCorpId();
            weworkUserId = this.agentDecryptWeworkUserIdMapper.queryByDecryptUserId(chatMsg.getBizId(), weworkUserId);
            contactId = this.agentDecryptWeworkContactIdMapper.queryByDecryptContactId(chatMsg.getBizId(), contactId);
        }
        chatMsg.setEncryptCorpId(corpId);
        chatMsg.setEncryptFormId(weworkUserId);
        chatMsg.setEncryptToId(contactId);
        String weworkUserNum = this.cacheService.queryUserNum(corpId, weworkUserId);
        switch (ChatMsgType.getType((String)chatMsg.getMsgType())) {
            case TEXT: {
                Set<Integer> departmentIds = this.cacheService.queryUserNode(corpId, weworkUserId);
                if (CollectionUtils.isEmpty(departmentIds)) {
                    log.info("\u672a\u627e\u5230\u53d1\u9001\u4eba\u6240\u5c5e\u90e8\u95e8,msgId={},from={}", (Object)chatMsg.getMsgId(), (Object)chatMsg.getFrom());
                    return;
                }
                if (!this.matchSensitiveWord(chatMsg, departmentIds, weworkUserNum)) break;
                return;
            }
            case CARD: {
                Integer cardBehavior = QualityBehaviorType.CARD.getType();
                CorpSensitiveWordBehaviorDto behaviorDto = this.corpWordTree.getBehaviorDto(chatMsg.getBizId());
                if (Objects.isNull(behaviorDto) || !behaviorDto.isSendCardCheck()) {
                    log.info("\u672a\u5f00\u542f\u540d\u7247\u68c0\u6d4b\u5f00\u5173,msgId={},from={}", (Object)chatMsg.getMsgId(), (Object)chatMsg.getFrom());
                    return;
                }
                if (!this.buildBehaviorLog(chatMsg, weworkUserNum, cardBehavior, chatMsg.getCard(), QualityBehaviorType.CARD.getDesc())) break;
                return;
            }
            case EXTERNAL_REDPACKET: 
            case REDPACKET: {
                this.weworkInsightService.handleRedPacketMsg(chatMsg);
                CorpSensitiveWordBehaviorDto behaviorDto2 = this.corpWordTree.getBehaviorDto(chatMsg.getBizId());
                if (Objects.isNull(behaviorDto2) || !behaviorDto2.isSendHongbaoCheck()) {
                    log.info("\u672a\u5f00\u542f\u7ea2\u5305\u68c0\u6d4b\u5f00\u5173,msgId={},from={}", (Object)chatMsg.getMsgId(), (Object)chatMsg.getFrom());
                    return;
                }
                Integer redPacketBehavior = QualityBehaviorType.RED_PACKAGE.getType();
                if (!this.buildBehaviorLog(chatMsg, weworkUserNum, redPacketBehavior, chatMsg.getRedPacket(), QualityBehaviorType.RED_PACKAGE.getDesc())) break;
                return;
            }
        }
        log.info("qualityCheck find msgId={}", (Object)chatMsg.getMsgId());
    }

    public void test(ChatMsg chatMsg) {
        String weworkUserNum = this.cacheService.queryUserNum(chatMsg.getCorpId(), chatMsg.getFrom());
        Set<Integer> departmentIds = this.cacheService.queryUserNode(chatMsg.getCorpId(), chatMsg.getFrom());
        if (CollectionUtils.isEmpty(departmentIds)) {
            log.info("\u672a\u627e\u5230\u53d1\u9001\u4eba\u6240\u5c5e\u90e8\u95e8,msgId={},from={}", (Object)chatMsg.getMsgId(), (Object)chatMsg.getFrom());
            return;
        }
        MatchedResult result = this.corpWordTree.matchSensitiveWord(chatMsg.getBizId(), chatMsg.getText().getContent());
        if (result == null) {
            log.info("\u672a\u5339\u914d\u5230\u654f\u611f\u8bcd, msgId={}", (Object)chatMsg.getMsgId());
            return;
        }
        ArrayList matchList = Lists.newArrayList();
        for (MatchedWord matchedWord : result.getMatchedWordList()) {
            for (MatchedType item : matchedWord.getTypes()) {
                QualityCheckLog dto;
                Set<Integer> nodeIds = this.corpWordTree.getNodeIdsByGroupId(chatMsg.getBizId(), item.getGroupId());
                Set<Integer> allDepartmentIds = this.cacheService.queryAllDepartment(chatMsg.getCorpId(), nodeIds);
                if (!CollectionUtils.containsAny(departmentIds, allDepartmentIds) || (dto = this.buildLog(chatMsg, matchedWord, item, weworkUserNum)) == null) continue;
                matchList.add(dto);
            }
        }
        log.info("matchList:{}", (Object)matchList);
    }

    private boolean matchSensitiveWord(ChatMsg chatMsg, Set<Integer> departmentIds, String weworkUserNum) {
        MatchedResult result = this.corpWordTree.matchSensitiveWord(chatMsg.getBizId(), chatMsg.getText().getContent());
        if (result == null) {
            log.info("\u672a\u5339\u914d\u5230\u654f\u611f\u8bcd, msgId={}", (Object)chatMsg.getMsgId());
            return true;
        }
        ArrayList matchList = Lists.newArrayList();
        for (MatchedWord matchedWord : result.getMatchedWordList()) {
            for (MatchedType item : matchedWord.getTypes()) {
                QualityCheckLog dto;
                Set<Integer> nodeIds = this.corpWordTree.getNodeIdsByGroupId(chatMsg.getBizId(), item.getGroupId());
                Set<Integer> allDepartmentIds = this.cacheService.queryAllDepartment(chatMsg.getEncryptCorpId(), nodeIds);
                if (!CollectionUtils.containsAny(departmentIds, allDepartmentIds) || (dto = this.buildLog(chatMsg, matchedWord, item, weworkUserNum)) == null) continue;
                matchList.add(dto);
            }
        }
        if (CollectionUtils.isEmpty((Collection)matchList)) {
            log.info("\u5339\u914d\u5230\u654f\u611f\u8bcd,\u4f46\u6ca1\u6709\u548c\u76d1\u542c\u90e8\u95e8\u6ca1\u6709\u4ea4\u96c6,corpId={},words={}", (Object)result.getCorpId(), result.getMatchedWordList());
            return true;
        }
        log.info("matchSensitiveWord insert trigger");
        this.handleWeworkContactTriggerReplyMsg(chatMsg.getBizId(), new Date(chatMsg.getMsgTime()), chatMsg.getEncryptFormId(), QualityCheckType.WORD.getType());
        this.qualityCheckLogMapper.batchInsert((Collection)matchList);
        String contactId = null;
        if (TalkerType.CONTACT.getValue() == chatMsg.getTalkerType().intValue()) {
            contactId = chatMsg.getEncryptToId();
        }
        Set wordGroupIds = matchList.stream().map(QualityCheckLog::getTriggerGroupId).collect(Collectors.toSet());
        List wordNums = this.wordGroupMapper.queryGroupNumByIds(chatMsg.getEncryptCorpId(), wordGroupIds);
        this.notification((QualityCheckLog)matchList.get(0), wordNums, null, null, contactId);
        return false;
    }

    private boolean buildBehaviorLog(ChatMsg chatMsg, String weworkUserNum, Integer behavior, Object content, String behaviorType) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return true;
        }
        QualityCheckLog dto = new QualityCheckLog();
        dto.setNum(this.idGen.getNum());
        dto.setBizId(chatMsg.getBizId());
        dto.setCorpId(chatMsg.getEncryptCorpId());
        dto.setContent(JSON.toJSONString((Object)content));
        dto.setExternalType(Integer.valueOf(chatMsg.getExternalContact() != false ? 1 : 0));
        dto.setIsRevoke(Integer.valueOf(chatMsg.getIsRevoked() != null && chatMsg.getIsRevoked() != false ? 1 : 0));
        dto.setRevokeTime(new Date(chatMsg.getMsgTime()));
        dto.setTriggerBehavior(behavior);
        dto.setTriggerWord("");
        dto.setTriggerGroupId(Long.valueOf(0L));
        dto.setCreateTime(new Date());
        dto.setMsgId(chatMsg.getMsgId());
        dto.setMsgTime(new Date(chatMsg.getMsgTime()));
        dto.setMsgType(chatMsg.getMsgType());
        dto.setSendWeworkUserId(chatMsg.getEncryptFormId());
        dto.setTargetType(chatMsg.getTalkerType());
        String contactId = null;
        if (TalkerType.CONTACT.getValue() == chatMsg.getTalkerType().intValue()) {
            dto.setReceiveTargetId(chatMsg.getEncryptToId());
            contactId = chatMsg.getEncryptToId();
        } else if (TalkerType.CHATROOM.getValue() == chatMsg.getTalkerType().intValue()) {
            dto.setReceiveTargetId(chatMsg.getRoomId());
        } else {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)dto.getReceiveTargetId())) {
            return true;
        }
        dto.setType(QualityCheckType.BEHAVIOR.getType());
        dto.setSendWeworkUserNum(weworkUserNum);
        dto.setUpdateTime(new Date());
        dto.setConversationId(chatMsg.getConversationId());
        this.qualityCheckLogMapper.insertSelective((Object)dto);
        if (this.checkBehaviorOpen(chatMsg.getBizId(), behaviorType)) {
            log.info("send card or redPacket insert trigger");
            this.handleWeworkContactTriggerReplyMsg(chatMsg.getBizId(), new Date(chatMsg.getMsgTime()), chatMsg.getEncryptFormId(), QualityCheckType.BEHAVIOR.getType());
        }
        String behaviorNum = this.behaviorSettingMapper.queryBehaviorNum(chatMsg.getEncryptCorpId(), behavior);
        this.notification(dto, null, behaviorNum, null, contactId);
        return false;
    }

    private QualityCheckLog buildLog(ChatMsg chatMsg, MatchedWord matchedWord, MatchedType item, String weworkUserNum) {
        QualityCheckLog dto = new QualityCheckLog();
        dto.setNum(this.idGen.getNum());
        dto.setBizId(chatMsg.getBizId());
        dto.setCorpId(chatMsg.getEncryptCorpId());
        dto.setContent(chatMsg.getText().getContent());
        dto.setExternalType(Integer.valueOf(chatMsg.getExternalContact() != false ? 1 : 0));
        dto.setIsRevoke(Integer.valueOf(chatMsg.getIsRevoked() != null && chatMsg.getIsRevoked() != false ? 1 : 0));
        dto.setRevokeTime(new Date(chatMsg.getMsgTime()));
        dto.setTriggerGroupId(item.getGroupId());
        dto.setTriggerWord(matchedWord.getWord());
        dto.setTriggerBehavior(QualityBehaviorType.NONE.getType());
        dto.setCreateTime(new Date());
        dto.setMsgId(chatMsg.getMsgId());
        dto.setMsgTime(new Date(chatMsg.getMsgTime()));
        dto.setMsgType(chatMsg.getMsgType());
        dto.setSendWeworkUserId(chatMsg.getEncryptFormId());
        dto.setTargetType(chatMsg.getTalkerType());
        if (TalkerType.CONTACT.getValue() == chatMsg.getTalkerType().intValue()) {
            dto.setReceiveTargetId(chatMsg.getEncryptToId());
        } else if (TalkerType.CHATROOM.getValue() == chatMsg.getTalkerType().intValue()) {
            dto.setReceiveTargetId(chatMsg.getRoomId());
        } else {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)dto.getReceiveTargetId())) {
            log.info("receiveTargetId is empty, dto: {}", (Object)dto);
            return null;
        }
        dto.setType(QualityCheckType.WORD.getType());
        dto.setSendWeworkUserNum(weworkUserNum);
        dto.setUpdateTime(new Date());
        dto.setConversationId(chatMsg.getConversationId());
        return dto;
    }

    @Override
    public void handleDelContact(DelExternalContact event) {
        log.info("handleDelContact with event={}", (Object)event);
        this.executorService.submit(() -> {
            try {
                this.delContactTask(event);
            }
            catch (Exception e) {
                log.error("delContactTask with error", (Throwable)e);
            }
        });
    }

    private void delContactTask(DelExternalContact event) {
        String corpId = event.getToUserName();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByCorpId(corpId);
        if (weworkCorp == null) {
            log.warn("not find weworkCorp, corpId: {}", (Object)corpId);
            return;
        }
        Long bizId = this.weworkCorpMapper.getByCorpId(corpId).getBizId();
        CorpSensitiveWordBehaviorDto behaviorDto = this.corpWordTree.getBehaviorDto(bizId);
        if (behaviorDto == null || !behaviorDto.isDelContactCheck()) {
            log.info("corpId={}\u672a\u5f00\u542f\u5220\u9664\u597d\u53cb\u654f\u611f\u884c\u4e3a\u76d1\u63a7", (Object)corpId);
            return;
        }
        String weworkUserId = event.getUserId();
        String contactId = event.getExternalUserId();
        int useAgent = this.queryNewDKF(bizId);
        if (useAgent == 1) {
            weworkUserId = this.agentDecryptWeworkUserIdMapper.queryByEncryptUserId(bizId, weworkUserId);
            contactId = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactId(bizId, contactId);
        }
        WeworkConversation conversation = this.weworkConversationMapper.queryConversion(corpId, weworkUserId, contactId);
        QualityCheckLog dto = new QualityCheckLog();
        dto.setNum(this.idGen.getNum());
        dto.setBizId(this.cacheService.queryBizId(corpId));
        dto.setCorpId(event.getToUserName());
        dto.setExternalType(Integer.valueOf(1));
        dto.setIsRevoke(Integer.valueOf(0));
        dto.setTriggerBehavior(QualityBehaviorType.DEL_CONTACT.getType());
        dto.setContent("");
        dto.setTriggerWord("");
        dto.setMsgId(this.idGen.getNum());
        dto.setTriggerGroupId(Long.valueOf(0L));
        dto.setCreateTime(new Date());
        dto.setMsgTime(new Date(event.getCreateTime() * 1000L));
        dto.setMsgType(null);
        dto.setSendWeworkUserId(event.getUserId());
        dto.setTargetType(Integer.valueOf(TalkerType.CONTACT.getValue()));
        dto.setReceiveTargetId(event.getExternalUserId());
        dto.setType(QualityCheckType.BEHAVIOR.getType());
        dto.setSendWeworkUserNum(this.cacheService.queryUserNum(dto.getCorpId(), dto.getSendWeworkUserId()));
        dto.setUpdateTime(new Date());
        if (conversation != null) {
            dto.setConversationId(ChatMsg.getConversationId(null, (String)conversation.getWeworkUserId(), (String)conversation.getTalkerId()));
            dto.setMsgId(conversation.getMsgId());
        }
        if (this.checkBehaviorOpen(this.cacheService.queryBizId(corpId), QualityBehaviorType.DEL_CONTACT.getDesc())) {
            log.info("del contact insert trigger");
            this.handleWeworkContactTriggerReplyMsg(this.cacheService.queryBizId(corpId), new Date(event.getCreateTime()), event.getUserId(), QualityCheckType.BEHAVIOR.getType());
        }
        this.qualityCheckLogMapper.insertSelective((Object)dto);
        String behaviorNum = this.behaviorSettingMapper.queryBehaviorNum(corpId, QualityBehaviorType.DEL_CONTACT.getType());
        this.notification(dto, null, behaviorNum, null, event.getExternalUserId());
        log.info("delContact weworkUserId={},contactId={}", (Object)dto.getSendWeworkUserId(), (Object)dto.getReceiveTargetId());
    }

    @Override
    public void handleDelByContact(DelFollowUser event) {
        log.info("handleDelByContact with event={}", (Object)event);
        this.executorService.submit(() -> {
            try {
                QualityCheckLog checkLog = this.delByContactTask(event);
                String corpId = event.getToUserName();
                String weworkUserId = event.getUserId();
                String contactId = event.getExternalUserId();
                Long bizId = this.cacheService.queryBizId(corpId);
                if (this.checkBehaviorOpen(bizId, QualityBehaviorType.DEL_BY_CONTACT.getDesc())) {
                    log.info("del by contact insert trigger");
                    this.handleWeworkContactTriggerReplyMsg(bizId, new Date(event.getCreateTime()), weworkUserId, QualityCheckType.BEHAVIOR.getType());
                }
                ArrayList weworkPairs = Lists.newArrayList();
                ContactWeworkPair pair = new ContactWeworkPair(weworkUserId, contactId);
                weworkPairs.add(pair);
                List userContactInfos = this.contactRelationMapper.queryContactInfoByWeworkUserIdAndNameQuery(corpId, null, (Collection)weworkPairs);
                if (CollectionUtils.isEmpty((Collection)userContactInfos)) {
                    log.warn("contact not exist,corpId={},contactId={}, weworkUserId={}", new Object[]{corpId, contactId, weworkUserId});
                    return;
                }
                String contactRemark = ((UserContactInfo)userContactInfos.get(0)).getRemarkFirst();
                String content = String.format(REMIND_STR, contactRemark, this.scrmManagerHost, corpId, contactId);
                log.info("ready to send qyremind with corpId={}, weworkUserId={}, content={}", new Object[]{corpId, weworkUserId, content});
                this.remindService.sendMsg(corpId, weworkUserId, content);
                String behaviorNum = this.behaviorSettingMapper.queryBehaviorNum(corpId, QualityBehaviorType.DEL_BY_CONTACT.getType());
                if (checkLog != null) {
                    this.notification(checkLog, null, behaviorNum, null, contactId);
                }
            }
            catch (Exception e) {
                log.error("delByContactTask with error", (Throwable)e);
            }
        });
    }

    @Override
    public void notification(QualityCheckLog checkLog, List<String> wordNums, String behaviorNum, Integer isNotifyTimeout, String contactId) {
        WeworkUser innerUser;
        List notifications;
        log.info("notification checkLog: {}, wordNums: {}, behaviorNum: {}, isNotifyTimeout: {}, contactId: {}", new Object[]{checkLog, wordNums, behaviorNum, isNotifyTimeout, contactId});
        String corpId = checkLog.getCorpId();
        Long bizId = checkLog.getBizId();
        ArrayList behaviorNums = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)behaviorNum)) {
            behaviorNums.add(behaviorNum);
        }
        if (CollectionUtils.isEmpty((Collection)(notifications = this.notificationMapper.queryMatchNotification(corpId, wordNums, (Collection)behaviorNums, isNotifyTimeout)))) {
            log.info("not find match notification corpId: {}", (Object)corpId);
            return;
        }
        Set<Integer> departmentIds = this.cacheService.queryUserNode(corpId, checkLog.getSendWeworkUserId());
        List weworkUserOfOrgIds = this.organizationMapper.queryOrgIdByDepartmentIds(bizId, departmentIds);
        QualityCheckNotification matchNotification = this.matchNotification(notifications, checkLog.getSendWeworkUserNum(), weworkUserOfOrgIds);
        if (matchNotification == null) {
            log.info("not find notification, corpId: {}", (Object)corpId);
            return;
        }
        log.info("match notification num:{}", (Object)matchNotification.getNum());
        if (matchNotification.getNotifyType() == 2) {
            checkLog.setBatchNotify(Integer.valueOf(1));
            checkLog.setNotificationId(matchNotification.getId());
            log.info("update checkLog id: {}", (Object)checkLog.getId());
            if (checkLog.getId() != null) {
                this.qualityCheckLogMapper.updateByPrimaryKeySelective((Object)checkLog);
            } else {
                this.qualityCheckLogMapper.updateBatchNotifyByMsgId(corpId, checkLog.getMsgId(), matchNotification.getId());
            }
            return;
        }
        String weworkUserName = (String)this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, (Collection)Lists.newArrayList((Object[])new String[]{checkLog.getSendWeworkUserNum()})).get(checkLog.getSendWeworkUserNum());
        WeworkContactRelation relation = this.weworkContactRelationMapper.get(corpId, checkLog.getSendWeworkUserId(), checkLog.getReceiveTargetId());
        String contactName = "";
        if (relation != null) {
            contactName = relation.getRemark();
        }
        if (checkLog.getExternalType() == 0 && checkLog.getTargetType() == 1 && (innerUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, checkLog.getReceiveTargetId())) != null) {
            contactName = innerUser.getName();
        }
        WeworkChatRoom weworkChatRoom = this.weworkChatRoomMapper.getWeworkChatRoom(corpId, checkLog.getReceiveTargetId());
        String chatRoomName = "";
        if (weworkChatRoom != null) {
            chatRoomName = weworkChatRoom.getName();
        }
        String action = "";
        if (checkLog.getType() == 0) {
            action = "\u804a\u5929\u6d88\u606f\u8fdd\u89c4 [" + checkLog.getTriggerWord() + "]";
        } else if (checkLog.getType() == 1) {
            action = QualityBehaviorType.getByType((int)checkLog.getTriggerBehavior()).getDesc();
        }
        StringBuilder sb = new StringBuilder();
        if (checkLog.getTargetType() == 1) {
            sb.append(String.format(NOTIFICATION_FORMAT, weworkUserName, "\u5bf9\u597d\u53cb", contactName, action));
        } else if (checkLog.getTargetType() == 2) {
            sb.append(String.format(NOTIFICATION_FORMAT, weworkUserName, "\u5728\u7fa4\u91cc", chatRoomName, action));
        }
        if (StringUtils.isNotBlank((CharSequence)checkLog.getConversationId())) {
            sb.append(String.format(CONTEXT_FORMAT, this.scrmManagerHost, corpId, checkLog.getSendWeworkUserNum(), checkLog.getConversationId(), checkLog.getMsgId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)contactId)) {
            sb.append(String.format(CONTACT_FORMAT, this.scrmManagerHost, corpId, contactId));
        }
        String notificationMsg = sb.toString();
        List chargeNums = Splitter.on((String)",").splitToList((CharSequence)matchNotification.getChargeNum());
        List chargeIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)chargeNums);
        if (CollectionUtils.isNotEmpty((Collection)chargeIds)) {
            for (String chargeId : chargeIds) {
                this.remindService.asyncSendMsg(corpId, chargeId, notificationMsg);
            }
        }
        String departMasterNum = matchNotification.getDepartMasterNum();
        List departMasterNums = Lists.newArrayList();
        List departMasterIds = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)departMasterNum)) {
            departMasterNums = Splitter.on((String)",").splitToList((CharSequence)departMasterNum);
            departMasterIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)departMasterNums);
            for (String departMasterId : departMasterIds) {
                if (chargeIds.contains(departMasterId)) continue;
                this.remindService.asyncSendMsg(corpId, departMasterId, notificationMsg);
            }
        }
        if (matchNotification.getIsNotify() == 1 && !chargeIds.contains(checkLog.getSendWeworkUserId()) && !departMasterIds.contains(checkLog.getSendWeworkUserId())) {
            this.remindService.asyncSendMsg(corpId, checkLog.getSendWeworkUserId(), notificationMsg);
        }
    }

    private QualityCheckNotification matchNotification(List<QualityCheckNotification> notifications, String weworkUserNum, List<Long> weworkUserOfOrgIds) {
        QualityCheckNotification result = null;
        for (QualityCheckNotification notification : notifications) {
            if (notification.getScope() == 0) {
                result = notification;
                break;
            }
            if (notification.getScope() != 1) continue;
            int count = this.notificationScopeMapper.matchWeworkUserList(notification.getCorpId(), notification.getNum(), weworkUserNum);
            if (count > 0) {
                result = notification;
                break;
            }
            List orgNums = (List)this.notificationScopeMapper.queryNotificationOrgMap(notification.getCorpId(), (Collection)Lists.newArrayList((Object[])new String[]{notification.getNum()})).get(notification.getNum());
            if (CollectionUtils.isEmpty((Collection)orgNums)) break;
            Collection orgIds = this.nodeService.getIdByNums(notification.getBizId(), (Collection)orgNums).values();
            Set managerOrgIds = this.nodeService.getPosterityIds(orgIds, notification.getBizId());
            Collection intersection = CollectionUtils.intersection((Iterable)managerOrgIds, weworkUserOfOrgIds);
            if (!CollectionUtils.isNotEmpty((Collection)intersection)) continue;
            result = notification;
            break;
        }
        return result;
    }

    private QualityCheckLog delByContactTask(DelFollowUser event) {
        String corpId = event.getToUserName();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByCorpId(corpId);
        if (weworkCorp == null) {
            log.warn("weworkCorp is null corpId: {}", (Object)corpId);
            return null;
        }
        Long bizId = weworkCorp.getBizId();
        CorpSensitiveWordBehaviorDto behaviorDto = this.corpWordTree.getBehaviorDto(bizId);
        if (behaviorDto == null || !behaviorDto.isDelByContactCheck()) {
            log.info("corpId={}\u672a\u5f00\u542f\u88ab\u597d\u53cb\u5220\u9664\u654f\u611f\u884c\u4e3a\u76d1\u63a7", (Object)corpId);
            return null;
        }
        String weworkUserId = event.getUserId();
        String contactId = event.getExternalUserId();
        int useAgent = this.queryNewDKF(bizId);
        if (useAgent == 1) {
            weworkUserId = this.agentDecryptWeworkUserIdMapper.queryByEncryptUserId(bizId, weworkUserId);
            contactId = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactId(bizId, contactId);
        }
        WeworkConversation conversation = this.weworkConversationMapper.queryConversion(corpId, weworkUserId, contactId);
        QualityCheckLog dto = new QualityCheckLog();
        dto.setNum(this.idGen.getNum());
        dto.setBizId(this.cacheService.queryBizId(corpId));
        dto.setCorpId(event.getToUserName());
        dto.setExternalType(Integer.valueOf(1));
        dto.setIsRevoke(Integer.valueOf(0));
        dto.setTriggerBehavior(QualityBehaviorType.DEL_BY_CONTACT.getType());
        dto.setContent("");
        dto.setTriggerWord("");
        dto.setMsgId(this.idGen.getNum());
        dto.setTriggerGroupId(Long.valueOf(0L));
        dto.setCreateTime(new Date());
        dto.setMsgTime(new Date(event.getCreateTime() * 1000L));
        dto.setMsgType(null);
        dto.setSendWeworkUserId(event.getUserId());
        dto.setTargetType(Integer.valueOf(TalkerType.CONTACT.getValue()));
        dto.setReceiveTargetId(event.getExternalUserId());
        dto.setType(QualityCheckType.BEHAVIOR.getType());
        dto.setSendWeworkUserNum(this.cacheService.queryUserNum(dto.getCorpId(), dto.getSendWeworkUserId()));
        dto.setUpdateTime(new Date());
        if (conversation != null) {
            dto.setConversationId(ChatMsg.getConversationId(null, (String)conversation.getWeworkUserId(), (String)conversation.getTalkerId()));
            dto.setMsgId(conversation.getMsgId());
        }
        this.qualityCheckLogMapper.insertSelective((Object)dto);
        log.info("delByContact weworkUserId={},contactId={}", (Object)dto.getSendWeworkUserId(), (Object)dto.getReceiveTargetId());
        return dto;
    }

    private Integer queryNewDKF(Long bizId) {
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        return Objects.equals(weworkCorp.getIsNewDkf(), 1) ? 1 : 0;
    }

    private void handleWeworkContactTriggerReplyMsg(Long bizId, Date msgTime, String weworkUserId, Integer type) {
        log.info("handleWeworkContactTriggerReplyMsg bizId: {}, weworkUserId: {}, type: {}", new Object[]{bizId, weworkUserId, type});
        Calendar calendar = Calendar.getInstance();
        if (msgTime != null) {
            calendar.setTime(msgTime);
        } else {
            calendar.setTime(new Date());
        }
        WeworkUserStatisticsRecord statisticsRecord = new WeworkUserStatisticsRecord();
        statisticsRecord.setBizId(bizId);
        statisticsRecord.setNum(this.idGen.getNum());
        statisticsRecord.setYear(Integer.valueOf(calendar.get(1)));
        statisticsRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
        statisticsRecord.setWeek(Integer.valueOf(calendar.get(3)));
        statisticsRecord.setStatisticTime(msgTime);
        statisticsRecord.setCreateTime(new Date());
        statisticsRecord.setUpdateTime(new Date());
        statisticsRecord.setWeworkUserId(weworkUserId);
        if (type.equals(QualityCheckType.BEHAVIOR.getType())) {
            this.weworkUserStatisticsRecordMapper.insertOrUpdateTriggerBehaviorData(statisticsRecord);
        }
        if (type.equals(QualityCheckType.WORD.getType())) {
            this.weworkUserStatisticsRecordMapper.insertOrUpdateTriggerWordData(statisticsRecord);
        }
    }

    private boolean checkBehaviorOpen(Long bizId, String behaviorType) {
        log.info("Qualitycheck Behavior bizId: {}, behaviorType: {}", (Object)bizId, (Object)behaviorType);
        List settingList = this.behaviorSettingMapper.queryBehaviorListByBizId(bizId);
        if (CollectionUtils.isEmpty((Collection)settingList)) {
            log.info("Qualitycheck Behavior  get settingList is null");
            return false;
        }
        List settings = settingList.stream().filter(a -> a.getCheckDesc().equals(behaviorType)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(settings)) {
            log.info("Qualitycheck Behavior setting is null");
            return false;
        }
        QualityCheckBehaviorSetting setting = (QualityCheckBehaviorSetting)settings.get(0);
        log.info("checkBehaviorOpen bizId: {}, behaviorType: {}, status: {}", new Object[]{bizId, behaviorType, setting.getCheckStatus()});
        return setting.getCheckStatus() == 1;
    }

    @Override
    public void batchNotification() {
        List qualityCheckLogs = this.qualityCheckLogMapper.queryBatchNotify();
        if (CollectionUtils.isEmpty((Collection)qualityCheckLogs)) {
            log.info("wait batch notify is empty");
            return;
        }
        qualityCheckLogs = Lists.reverse((List)qualityCheckLogs);
        HashMap notifyGroupMap = Maps.newHashMap();
        for (QualityCheckLog log : qualityCheckLogs) {
            List list = notifyGroupMap.getOrDefault(log.getNotificationId(), Lists.newArrayList());
            list.add(log);
            notifyGroupMap.put(log.getNotificationId(), list);
        }
        Set notificationIds = notifyGroupMap.keySet();
        List notifications = this.notificationMapper.queryByIds(notificationIds);
        HashMap notificationMap = Maps.newHashMap();
        for (QualityCheckNotification notification : notifications) {
            notificationMap.put(notification.getId(), notification);
        }
        for (Long notificationId : notifyGroupMap.keySet()) {
            QualityCheckNotification notification = (QualityCheckNotification)notificationMap.get(notificationId);
            List checkList = (List)notifyGroupMap.get(notificationId);
            if (!this.batchNotify(notification)) continue;
            this.doBatchNotification(notification, checkList);
        }
    }

    private boolean batchNotify(QualityCheckNotification notification) {
        String key = this.redisKeyPrefix + "notificationNum:" + notification.getNum();
        String lastBatchNotifyTime = (String)this.redisTemplate.opsForValue().get((Object)key);
        Long lastNotifyTime = notification.getUpdateTime().getTime();
        if (StringUtils.isNotEmpty((CharSequence)lastBatchNotifyTime)) {
            lastNotifyTime = Long.parseLong(lastBatchNotifyTime);
        }
        Long curTime = System.currentTimeMillis();
        long waitTime = 0L;
        if (notification.getWaitTime() != null) {
            waitTime = notification.getWaitTime() * 60 * 1000;
        }
        return curTime - lastNotifyTime >= waitTime;
    }

    private void doBatchNotification(QualityCheckNotification notification, List<QualityCheckLog> checkList) {
        String corpId = notification.getCorpId();
        String batchNotifyNo = this.idGen.getNum();
        String notifyContent = this.buildBatchNotificationTemplate(corpId, batchNotifyNo, checkList);
        Long curTime = System.currentTimeMillis();
        List chargeNums = Splitter.on((String)",").splitToList((CharSequence)notification.getChargeNum());
        List chargeIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)chargeNums);
        if (CollectionUtils.isNotEmpty((Collection)chargeIds)) {
            for (String chargeId : chargeIds) {
                this.remindService.asyncSendMsg(corpId, chargeId, notifyContent);
            }
        }
        String departMasterNum = notification.getDepartMasterNum();
        List departMasterNums = Lists.newArrayList();
        List departMasterIds = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)departMasterNum)) {
            departMasterNums = Splitter.on((String)",").splitToList((CharSequence)departMasterNum);
            departMasterIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)departMasterNums);
            for (Object departMasterId : departMasterIds) {
                if (chargeIds.contains(departMasterId)) continue;
                this.remindService.asyncSendMsg(corpId, (String)departMasterId, notifyContent);
            }
        }
        HashSet touchUserIds = Sets.newHashSet();
        if (notification.getIsNotify() == 1) {
            for (QualityCheckLog checkLog : checkList) {
                if (chargeIds.contains(checkLog.getSendWeworkUserId()) || departMasterIds.contains(checkLog.getSendWeworkUserId()) || touchUserIds.contains(checkLog.getSendWeworkUserId())) continue;
                this.remindService.asyncSendMsg(corpId, checkLog.getSendWeworkUserId(), notifyContent);
                touchUserIds.add(checkLog.getSendWeworkUserId());
            }
        }
        Set ids = checkList.stream().map(QualityCheckLog::getId).collect(Collectors.toSet());
        this.qualityCheckLogMapper.updateCheckLogBatchNotify(ids, batchNotifyNo);
        String key = this.redisKeyPrefix + "notificationNum:" + notification.getNum();
        this.redisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(curTime));
    }

    private String buildBatchNotificationTemplate(String corpId, String batchNotifyNo, List<QualityCheckLog> checkList) {
        HashSet weworkUserNums = Sets.newHashSet();
        HashSet contactIds = Sets.newHashSet();
        HashSet chatRoomIds = Sets.newHashSet();
        HashSet innerUserIds = Sets.newHashSet();
        HashSet contactWeworkPairs = Sets.newHashSet();
        for (QualityCheckLog log : checkList) {
            weworkUserNums.add(log.getSendWeworkUserNum());
            if (log.getTargetType() == 1) {
                if (log.getExternalType() == 0) {
                    innerUserIds.add(log.getReceiveTargetId());
                    continue;
                }
                contactIds.add(log.getReceiveTargetId());
                ContactWeworkNumPair pair = new ContactWeworkNumPair(log.getSendWeworkUserNum(), log.getReceiveTargetId());
                contactWeworkPairs.add(pair);
                continue;
            }
            if (log.getTargetType() != 2) continue;
            chatRoomIds.add(log.getReceiveTargetId());
        }
        Map weworkUserNameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, (Collection)weworkUserNums);
        HashMap contactRemarkNameMap = Maps.newHashMap();
        List pairList = this.weworkContactRelationMapper.queryContactRelationByPair(corpId, (Collection)contactWeworkPairs);
        for (WeworkContactRelationDto pair : pairList) {
            contactRemarkNameMap.put(pair.getContactId(), pair.getRemark());
        }
        Map chatRoomNameMap = this.weworkChatRoomMapper.queryNameMap(corpId, (Collection)chatRoomIds);
        Map innerUserNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)innerUserIds)) {
            innerUserNameMap = this.weworkUserMapper.queryWeworkUserNameMap(corpId, (Collection)innerUserIds);
        }
        StringBuilder str = new StringBuilder("\u3010\u8fdd\u89c4\u901a\u77e5\u3011 \n");
        int count = checkList.size();
        for (int i = 0; i < count && i < 5; ++i) {
            QualityCheckLog checkLog = checkList.get(i);
            String weworkUserName = (String)weworkUserNameMap.get(checkLog.getSendWeworkUserNum());
            String contactName = (String)contactRemarkNameMap.get(checkLog.getReceiveTargetId());
            if (checkLog.getExternalType() == 0) {
                contactName = (String)innerUserNameMap.get(checkLog.getReceiveTargetId());
            }
            String chatRoomName = (String)chatRoomNameMap.get(checkLog.getReceiveTargetId());
            String action = "";
            if (checkLog.getType() == 0) {
                action = "\u804a\u5929\u6d88\u606f\u8fdd\u89c4 [" + checkLog.getTriggerWord() + "]";
            } else if (checkLog.getType() == 1) {
                action = QualityBehaviorType.getByType((int)checkLog.getTriggerBehavior()).getDesc();
            }
            if (checkLog.getTargetType() == 1) {
                str.append(String.format(BATCH_NOTIFY_TEMPLATE, weworkUserName, "\u5bf9\u597d\u53cb", contactName, action));
                continue;
            }
            if (checkLog.getTargetType() != 2) continue;
            str.append(String.format(BATCH_NOTIFY_TEMPLATE, weworkUserName, "\u5728\u7fa4\u91cc", chatRoomName, action));
        }
        if (count > 5) {
            str.append("..... \n");
        }
        str.append(String.format(BATCH_NOTIFY_DETAILS, count, this.scrmManagerHost, corpId, batchNotifyNo));
        return str.toString();
    }
}

