/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.utils;

import com.google.common.collect.Lists;
import com.kuaike.scrm.call.dto.req.CallTaskReqDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.call.entity.CallTaskDetail;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CustomerAllocateUtil {
    private static final Logger log = LoggerFactory.getLogger(CustomerAllocateUtil.class);
    private List<CallTaskDetail> taskDetails;
    private final UserMapper userMapper;
    private final IdGen idGen;
    private final Map<String, Long> phoneBindUserMap;

    public CustomerAllocateUtil(List<CallTaskDetail> taskDetails, UserMapper userMapper, IdGen idGen, Map<String, Long> phoneBindUserMap) {
        this.taskDetails = taskDetails;
        this.userMapper = userMapper;
        this.idGen = idGen;
        this.phoneBindUserMap = phoneBindUserMap;
    }

    public CustomerAllocateUtil(UserMapper userMapper, IdGen idGen, Map<String, Long> phoneBindUserMap) {
        this.userMapper = userMapper;
        this.idGen = idGen;
        this.phoneBindUserMap = phoneBindUserMap;
    }

    public List<CallTaskDetail> allocate(Integer mode, List<CustomerDto> customers, List<Long> userIds, List<Integer> allocRatio, CurrentUserInfo currentUser, Long callTaskId, CallTaskReqDto reqDto) {
        if (mode == 0) {
            allocRatio = Lists.newArrayList();
            for (int i = 0; i < userIds.size(); ++i) {
                allocRatio.add(1);
            }
            allocRatio = CustomerAllocateUtil.rate2Num(allocRatio, customers);
            return this.ratioAllocate(customers, userIds, allocRatio, currentUser, callTaskId);
        }
        if (mode == -1) {
            return this.allocateByUserId(customers, reqDto, callTaskId);
        }
        return this.ratioAllocate(customers, userIds, allocRatio, currentUser, callTaskId);
    }

    public List<CallTaskDetail> ratioAllocate(List<CustomerDto> customers, List<Long> userIds, List<Integer> allocRatio, CurrentUserInfo currentUser, Long callTaskId) {
        log.info("ratioAllocate allocRatio: {}, userIds:{}, customers:{}", new Object[]{allocRatio, userIds, customers});
        if (CollectionUtils.isEmpty(this.taskDetails)) {
            this.taskDetails = Lists.newArrayListWithCapacity((int)customers.size());
        }
        Map userNameMap = this.userMapper.selectUserIdAndNameByIds(currentUser.getBizId(), currentUser.getCorpId(), userIds);
        Map phoneNameMap = customers.stream().collect(HashMap::new, (map, customer) -> map.put(customer.getPhone(), customer.getName()), HashMap::putAll);
        if (MapUtils.isNotEmpty(this.phoneBindUserMap)) {
            for (Map.Entry<String, Long> longEntry : this.phoneBindUserMap.entrySet()) {
                Long tempUserId = longEntry.getValue();
                if (!userIds.contains(tempUserId)) continue;
                customers.removeIf(customer -> ((String)longEntry.getKey()).equals(customer.getPhone()));
                CustomerDto tempCustomer = new CustomerDto(longEntry.getKey(), (String)phoneNameMap.get(longEntry.getKey()));
                int i = userIds.indexOf(tempUserId);
                Integer ratio = allocRatio.get(i);
                if (ratio > 0) {
                    allocRatio.set(i, ratio - 1);
                }
                CallTaskDetail taskDetail = this.buildTaskDetail(currentUser, callTaskId, tempUserId, tempCustomer, (String)userNameMap.get(tempUserId), null, null);
                this.taskDetails.add(taskDetail);
            }
        }
        if (customers.size() == 0) {
            return this.taskDetails;
        }
        int cursor = 0;
        boolean end = false;
        for (int i = 0; i < allocRatio.size(); ++i) {
            Integer ratio = allocRatio.get(i);
            if (ratio <= 0) continue;
            int offset = cursor + ratio;
            if (offset > customers.size()) {
                offset = customers.size();
                end = true;
            }
            Long userId = userIds.get(i);
            String userName = (String)userNameMap.get(userId);
            List<CustomerDto> customerDtoList = customers.subList(cursor, offset);
            for (CustomerDto customerDto : customerDtoList) {
                CallTaskDetail taskDetail = this.buildTaskDetail(currentUser, callTaskId, userId, customerDto, userName, null, null);
                this.taskDetails.add(taskDetail);
            }
            if (end) break;
            cursor += ratio.intValue();
        }
        return this.taskDetails;
    }

    public List<CallTaskDetail> allocateByUserId(List<CustomerDto> customers, CallTaskReqDto reqDto, Long callTaskId) {
        log.info("allocateByUserId callTaskId: {}, reqDto:{}, customers:{}", new Object[]{callTaskId, reqDto, customers});
        if (CollectionUtils.isEmpty(this.taskDetails)) {
            this.taskDetails = Lists.newArrayListWithCapacity((int)customers.size());
        }
        List userIds = customers.stream().map(CustomerDto::getUserId).collect(Collectors.toList());
        Map userNameMap = this.userMapper.selectUserIdAndNameByIds(reqDto.getBizId(), reqDto.getCorpId(), userIds);
        if (customers.size() == 0) {
            return this.taskDetails;
        }
        for (CustomerDto customerDto : customers) {
            String userName = (String)userNameMap.get(customerDto.getUserId());
            CallTaskDetail taskDetail = this.buildTaskDetail(null, callTaskId, customerDto.getUserId(), customerDto, userName, reqDto.getBizId(), reqDto.getCorpId());
            this.taskDetails.add(taskDetail);
        }
        return this.taskDetails;
    }

    private CallTaskDetail buildTaskDetail(CurrentUserInfo currentUser, Long callTaskId, Long userId, CustomerDto customer, String userName, Long bizId, String corpId) {
        if (bizId == null) {
            return CallTaskDetail.builder().num(this.idGen.getNum()).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).name(customer.getName()).phone(customer.getPhone()).callTaskId(callTaskId).userId(userId).userName(userName).callCount(Integer.valueOf(0)).callSuccessCount(Integer.valueOf(0)).createTime(new Date()).createBy(currentUser.getId()).updateTime(new Date()).updateBy(currentUser.getId()).build();
        }
        return CallTaskDetail.builder().num(this.idGen.getNum()).bizId(bizId).corpId(corpId).name(customer.getName()).phone(customer.getPhone()).callTaskId(callTaskId).userId(userId).userName(userName).callCount(Integer.valueOf(0)).callSuccessCount(Integer.valueOf(0)).createTime(new Date()).createBy(Long.valueOf(-1L)).updateTime(new Date()).updateBy(Long.valueOf(-1L)).build();
    }

    public static List<Integer> rate2Num(List<Integer> allocRatio, List<CustomerDto> customers) {
        ArrayList allocNum = Lists.newArrayList();
        int customerCount = customers.size();
        int sum = allocRatio.stream().mapToInt(Integer::intValue).sum();
        for (Integer integer : allocRatio) {
            double rate = (double)integer.intValue() / (double)sum;
            double num = (double)customerCount * rate;
            allocNum.add((int)num);
        }
        int allocSum = allocNum.stream().mapToInt(Integer::intValue).sum();
        if (customerCount > allocSum) {
            int left = customerCount - allocSum;
            int index = allocRatio.size() - 1;
            allocNum.set(index, (Integer)allocNum.get(index) + left);
        }
        return allocNum;
    }
}

