/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.req.CallRecordReqDto;
import com.kuaike.scrm.call.dto.req.CallTaskReqDto;
import com.kuaike.scrm.call.dto.resp.CallTaskRespDto;
import com.kuaike.scrm.call.enums.StatusEnum;
import com.kuaike.scrm.call.enums.VoiceCallStatusEnum;
import com.kuaike.scrm.call.service.CallCommonService;
import com.kuaike.scrm.call.service.CallTaskService;
import com.kuaike.scrm.call.utils.CustomerAllocateUtil;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.enums.NoticeType;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.enums.voicecall.VoiceContentTypeEnum;
import com.kuaike.scrm.common.enums.voicecall.VoiceMaterialTypeEnum;
import com.kuaike.scrm.common.excel.ExcelHeader;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.CachePhoneService;
import com.kuaike.scrm.common.service.CustomerDetailSupportService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.NoticeService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.service.dto.req.AddNoticeReq;
import com.kuaike.scrm.common.service.dto.req.notice.NoticeExtendParam;
import com.kuaike.scrm.common.service.dto.resp.BatchPhoneDto;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.utils.BackendExcelUtils;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.biz.dto.BizListDto;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.call.dto.CallTaskQueryParams;
import com.kuaike.scrm.dal.call.entity.CallMember;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallTask;
import com.kuaike.scrm.dal.call.entity.CallTaskCriteria;
import com.kuaike.scrm.dal.call.entity.CallTaskDetail;
import com.kuaike.scrm.dal.call.entity.CallTaskDetailCriteria;
import com.kuaike.scrm.dal.call.entity.CallTaskUser;
import com.kuaike.scrm.dal.call.entity.CallTaskUserCriteria;
import com.kuaike.scrm.dal.call.entity.CallVoiceMaterial;
import com.kuaike.scrm.dal.call.entity.SmsNoticeContent;
import com.kuaike.scrm.dal.call.entity.VoiceContent;
import com.kuaike.scrm.dal.call.mapper.CallMemberMapper;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskDetailMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskUserMapper;
import com.kuaike.scrm.dal.call.mapper.CallVoiceMaterialMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.sms.entity.SmsTemplate;
import com.kuaike.scrm.dal.sms.mapper.SmsTemplateMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.remind.service.RemindService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CallTaskServiceImpl
extends CallCommonService
implements CallTaskService {
    private static final Logger log = LoggerFactory.getLogger(CallTaskServiceImpl.class);
    private static final int HEADER_ROWS = 1;
    private static final int MAX_ROWS = 5000;
    private static final String HEADER_FIRST_CELL_STR = "\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09";
    private static final String IMPORT_FILE_DIR = "./importDir/call";
    private final String REMIND_STR = "\u3010\u4eba\u5de5\u5916\u547c\u3011\u4efb\u52a1\u901a\u77e5\n [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\uff0c";
    private final String NOTICE_STR = " [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\uff0c";
    private final String NOTICE_STR4 = " [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\u3002";
    private final String REMIND_STR1 = "\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u662f%s\uff0c\u8bf7\u767b\u9646\u767e\u5bb6\u4e91SCRM\u8fdb\u884c\u67e5\u770b\u3002";
    private final String REMIND_STR2 = "\u8bf7\u767b\u9646\u767e\u5bb6\u4e91SCRM\u8fdb\u884c\u67e5\u770b\u3002";
    private final String REMIND_STR3 = "\n\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u662f%s\u3002";
    @Autowired
    private AliyunOss aliyunOss;
    @Autowired
    private CallTaskMapper callTaskMapper;
    @Autowired
    private CallTaskUserMapper callTaskUserMapper;
    @Autowired
    private CallTaskDetailMapper callTaskDetailMapper;
    @Autowired
    private CallMemberMapper callMemberMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CachePhoneService cachePhoneService;
    @Autowired
    private RemindService remindService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private PackageMapper packageMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Value(value="${app.call.voiceCallUrl}")
    private String voiceCallUrl;
    @Value(value="${app.call.voiceCallTimeout}")
    private Integer voiceCallTimeout;
    @Autowired
    private DistributedLock lock;
    @Resource
    private CallRecordMapper callRecordMapper;
    @Resource
    private CallVoiceMaterialMapper callVoiceMaterialMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    private static final String VOICE_TASK_LIMIT_PHONES_KEY = "voiceTaskLimitPhones:";
    private static final String VOICE_TASK_SPEED_LIMIT_SLEEP_KEY = "voiceTaskSpeedLimitSleep:";
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private SmsTemplateMapper smsTemplateMapper;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CustomerDetailSupportService customerDetailSupportService;
    @Autowired
    private ScrmBizService scrmBizService;
    private int size = Runtime.getRuntime().availableProcessors();
    private ExecutorService executeVoiceTaskService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("executeVoiceTaskService"), new ThreadPoolExecutor.CallerRunsPolicy());

    public CallTaskServiceImpl(UserRoleCommonService userRoleCommonService, ScrmUserService scrmUserService, NodeService nodeService) {
        this.userRoleCommonService = userRoleCommonService;
        this.scrmUserService = scrmUserService;
        this.nodeService = nodeService;
    }

    @Override
    public List<CallTaskRespDto> list(CallTaskReqDto reqDto) {
        Collection<Long> userIds;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateListParams(currentUser);
        Long bizId = currentUser.getBizId();
        log.info("task list reqDto:{}, bizId:{}", (Object)reqDto, (Object)bizId);
        CallTaskQueryParams params = reqDto.to(bizId);
        if (reqDto.getType() == null || CallTypeEnum.VOICE.getValue() != reqDto.getType().intValue()) {
            userIds = this.getManageUserIds(bizId, reqDto.getNodeId(), reqDto.getUserId());
            Collection<Long> memberUserIds = this.getManageUserIds(bizId, reqDto.getMemberNodeId(), reqDto.getMemberUserId());
            params.setUserIds(userIds);
            params.setMemberIds(memberUserIds);
        } else if (CallTypeEnum.VOICE.getValue() == reqDto.getType().intValue()) {
            userIds = this.getManageUserIds(bizId, reqDto.getNodeId(), reqDto.getUserId());
            params.setUserIds(userIds);
        }
        params.setType(reqDto.getType());
        log.info("task list params:{}", (Object)params);
        List tasks = this.callTaskMapper.queryList(params);
        ArrayList<CallTaskRespDto> resultList = new ArrayList<CallTaskRespDto>();
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.callTaskMapper.queryCount(params)));
            params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
        }
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            for (CallTask task : tasks) {
                resultList.add(CallTaskRespDto.from(task));
            }
        }
        return resultList;
    }

    @Override
    public CallTask taskInfo(Long taskId) {
        return (CallTask)this.callTaskMapper.selectByPrimaryKey((Object)taskId);
    }

    @Override
    public List<CallTaskRespDto> taskOption(CallTaskReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateOptionParams(currentUser);
        Long bizId = currentUser.getBizId();
        Long id = currentUser.getId();
        log.info("task option reqDto:{}, bizId:{}", (Object)reqDto, (Object)bizId);
        CallTaskQueryParams params = reqDto.to(bizId);
        if (reqDto.getType() != null && CallTypeEnum.VOICE.getValue() != reqDto.getType().intValue()) {
            params.setMemberIds((Collection)Lists.newArrayList((Object[])new Long[]{id}));
        }
        params.setUserIds((Collection)Lists.newArrayList((Object[])new Long[]{id}));
        List taskList = this.callTaskMapper.queryList(params);
        ArrayList<CallTaskRespDto> respDtoList = new ArrayList<CallTaskRespDto>();
        if (!CollectionUtils.isEmpty((Collection)taskList)) {
            for (CallTask task : taskList) {
                VoiceContentTypeEnum voiceContentTypeEnum;
                CallTaskRespDto from = CallTaskRespDto.from(task);
                respDtoList.add(from);
                VoiceContent voiceContent = (VoiceContent)JSON.parseObject((String)task.getVoiceContent(), VoiceContent.class);
                if (voiceContent == null || !VoiceContentTypeEnum.VOICE_MATERIAL_ID.equals((Object)(voiceContentTypeEnum = VoiceContentTypeEnum.get((Integer)voiceContent.getVoiceContentType())))) continue;
                CallVoiceMaterial select = new CallVoiceMaterial();
                select.setNum(voiceContent.getVoiceMaterialId());
                CallVoiceMaterial callVoiceMaterial = (CallVoiceMaterial)this.callVoiceMaterialMapper.selectOne((Object)select);
                if (callVoiceMaterial == null) continue;
                VoiceMaterialTypeEnum materialType = VoiceMaterialTypeEnum.get((Integer)callVoiceMaterial.getType());
                if (VoiceMaterialTypeEnum.TEXT.equals((Object)materialType)) {
                    voiceContent.setVoiceContent(callVoiceMaterial.getContent());
                } else if (VoiceMaterialTypeEnum.VOICE.equals((Object)materialType)) {
                    voiceContent.setVoiceUrl(callVoiceMaterial.getContent());
                }
                from.setVoiceContent(JSON.toJSONString((Object)voiceContent));
            }
        }
        return respDtoList;
    }

    @Override
    public List<CallTaskRespDto> detail(CallTaskReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateDetailParams(currentUser);
        Long bizId = currentUser.getBizId();
        log.info("detail reqDto:{}, bizId:{}", (Object)reqDto, (Object)bizId);
        CallTask callTask = (CallTask)this.callTaskMapper.selectByPrimaryKey((Object)reqDto.getCallTaskId());
        if (callTask == null) {
            return Collections.emptyList();
        }
        if (CallTypeEnum.VOICE.getValue() == callTask.getType().intValue() && StringUtils.isNotBlank((CharSequence)reqDto.getUserId())) {
            return Collections.emptyList();
        }
        CallTaskQueryParams params = reqDto.to(bizId);
        if (callTask.getType() == null || CallTypeEnum.VOICE.getValue() != callTask.getType().intValue()) {
            Collection<Long> userIds = this.getManageUserIds(bizId, reqDto.getNodeId(), reqDto.getUserId());
            params.setUserIds(userIds);
        }
        List taskDetails = this.callTaskDetailMapper.queryList(params);
        ArrayList<CallTaskRespDto> resultList = new ArrayList<CallTaskRespDto>();
        String paramValue = this.settingService.getSettingDetail(bizId, SettingEnum.MOBILE_ENCRYPT.getName());
        boolean mobileEncrypt = false;
        if (paramValue != null && paramValue.equals("1")) {
            mobileEncrypt = true;
        }
        if (!ObjectUtils.isEmpty((Object)reqDto.getSelectMode()) && 1 == reqDto.getSelectMode()) {
            mobileEncrypt = false;
        }
        List mobiles = taskDetails.stream().map(CallTaskDetail::getPhone).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)taskDetails)) {
            for (CallTaskDetail taskDetail : taskDetails) {
                String customerPhone = taskDetail.getPhone();
                CallTaskRespDto respDto = CallTaskRespDto.from(taskDetail, mobileEncrypt, callTask.getType());
                respDto.setIsLimit(this.judgePhoneIsLimit(currentUser.getBizId(), taskDetail.getPhone()) ? 1 : 0);
                respDto.setPhone(customerPhone);
                resultList.add(respDto);
            }
            this.customerDetailSupportService.setCustomerDetailParams(bizId, mobiles, resultList);
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.callTaskDetailMapper.queryCount(params)));
            params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
        }
        return resultList;
    }

    @Override
    @Transactional
    public Long create(CallTaskReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateAddParams(currentUser);
        log.info("save task: {}", (Object)reqDto);
        List customers = reqDto.getCustomers();
        if (CollectionUtils.isEmpty(customers)) {
            customers = this.cachePhoneService.getCustomer(reqDto.getBatchId());
        }
        for (CustomerDto customer : customers) {
            String name = customer.getName();
            if (StringUtils.isNotBlank((CharSequence)name) && name.length() > 20) {
                customer.setName(name.substring(0, 20));
            }
            Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)customer.getPhone()), (Object)"\u624b\u673a\u53f7\u4e0d\u89c4\u8303");
        }
        Long callTaskId = reqDto.getCallTaskId();
        if (callTaskId == null && reqDto.getAllocMode() == 1) {
            Preconditions.checkArgument((!CollectionUtils.isEmpty(reqDto.getAllocRatio()) ? 1 : 0) != 0, (Object)"\u5206\u914d\u6bd4\u91cd\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((reqDto.getUserIds().size() == reqDto.getAllocRatio().size() ? 1 : 0) != 0, (Object)"\u76ee\u6807\u4e0e\u5206\u914d\u6bd4\u91cd\u4e0d\u4e00\u81f4");
        }
        CallTypeEnum callTypeEnum = CallTypeEnum.get((Integer)reqDto.getType());
        if (ObjectUtils.isEmpty((Object)callTaskId)) {
            if (CallTypeEnum.MANUAL.equals((Object)callTypeEnum)) {
                callTaskId = this.createNewManualTask(reqDto, currentUser, customers);
            } else if (CallTypeEnum.VOICE.equals((Object)callTypeEnum)) {
                callTaskId = this.createNewVoiceTask(reqDto, currentUser, customers);
            }
        } else if (CallTypeEnum.MANUAL.equals((Object)callTypeEnum)) {
            this.addExistManualTask(reqDto, currentUser, customers, callTaskId);
        } else if (CallTypeEnum.VOICE.equals((Object)callTypeEnum)) {
            this.addExistVoiceTask(reqDto, currentUser, customers, callTaskId);
        }
        return callTaskId;
    }

    @Override
    public void detailExport(CallTaskReqDto reqDto, HttpServletResponse response) {
        List<CallTaskRespDto> detail = this.detail(reqDto);
        try {
            BackendExcelUtils.doListToExcel((HttpServletResponse)response, detail, this.buildExportHeader(), (String)"\u8bed\u97f3\u6d88\u606f\u5bfc\u51fa", (String)"\u8bed\u97f3\u6d88\u606f\u5bfc\u51fa");
        }
        catch (Exception e) {
            log.error("detailExport error", (Throwable)e);
        }
    }

    private List<ExcelHeader> buildExportHeader() {
        ArrayList headers = Lists.newArrayList();
        headers.add(new ExcelHeader("customerName", "\u5ba2\u6237\u540d\u79f0"));
        headers.add(new ExcelHeader("customerPhone", "\u624b\u673a\u53f7"));
        headers.add(new ExcelHeader("callCount", "\u901a\u8bdd\u6b21\u6570"));
        headers.add(new ExcelHeader("createTime", "\u6700\u65b0\u901a\u8bdd\u65f6\u95f4", "yyyy-MM-dd HH:mm:ss"));
        headers.add(new ExcelHeader("voiceTaskStatusStr", "\u6700\u65b0\u901a\u8bdd\u72b6\u6001"));
        headers.add(new ExcelHeader("calledSuccessCount", "\u6700\u65b0\u901a\u8bdd\u65f6\u957f"));
        return headers;
    }

    private void addExistVoiceTask(CallTaskReqDto reqDto, CurrentUserInfo currentUser, List<CustomerDto> customers, Long callTaskId) {
        List phones = customers.stream().map(CustomerDto::getPhone).collect(Collectors.toList());
        log.info("addExistVoiceTask phones : {}", phones);
        if (CollectionUtils.isEmpty(phones)) {
            return;
        }
        List existDetails = this.callTaskDetailMapper.queryByTaskIdAndPhones(callTaskId, phones);
        List existPhones = existDetails.stream().map(CallTaskDetail::getPhone).collect(Collectors.toList());
        ArrayList<CallTaskDetail> batchUpdateList = new ArrayList<CallTaskDetail>();
        Date now = new Date();
        for (CallTaskDetail detail : existDetails) {
            Integer voiceTaskVersion = detail.getVoiceTaskVersion();
            detail.setUpdateBy(currentUser.getId());
            detail.setUpdateTime(now);
            detail.setVoiceTaskExecuteTime(reqDto.getPlanCompleteTime() == null ? now : reqDto.getPlanCompleteTime());
            detail.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.NOT_EXECUTE.getValue()));
            detail.setVoiceTaskVersion(Integer.valueOf(voiceTaskVersion + 1));
            detail.setApiCallId(null);
            batchUpdateList.add(detail);
        }
        if (!CollectionUtils.isEmpty(batchUpdateList)) {
            this.callTaskDetailMapper.batchUpdateByAgainAddVoiceTask(batchUpdateList);
        }
        phones.removeAll(existPhones);
        if (!CollectionUtils.isEmpty(phones)) {
            Map collect = customers.stream().collect(Collectors.toMap(CustomerDto::getPhone, Function.identity()));
            log.info("addExistVoiceTask collect : {}", collect);
            ArrayList<CallTaskDetail> list = new ArrayList<CallTaskDetail>();
            for (String phone : phones) {
                CallTaskDetail detail = new CallTaskDetail();
                detail.setNum(this.idGen.getNum());
                detail.setBizId(currentUser.getBizId());
                detail.setCorpId(currentUser.getCorpId());
                detail.setName(((CustomerDto)collect.get(phone)).getName());
                detail.setPhone(phone);
                detail.setCallTaskId(callTaskId);
                detail.setUserId(Long.valueOf(-1L));
                detail.setUserName("");
                detail.setCreateBy(currentUser.getId());
                detail.setCreateTime(now);
                detail.setUpdateBy(currentUser.getId());
                detail.setUpdateTime(now);
                detail.setCallCount(Integer.valueOf(0));
                detail.setCallSuccessCount(Integer.valueOf(0));
                detail.setVoiceTaskExecuteTime(reqDto.getPlanCompleteTime() == null ? now : reqDto.getPlanCompleteTime());
                detail.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.NOT_EXECUTE.getValue()));
                list.add(detail);
            }
            this.callTaskDetailMapper.batchInsert(list);
        }
        this.callTaskMapper.updateByPrimaryKeySelective((Object)CallTask.builder().id(callTaskId).planCompleteTime(reqDto.getPlanCompleteTime()).name(reqDto.getName()).progress(Double.valueOf(this.getProgressByVoice(callTaskId))).updateTime(new Date()).build());
    }

    @Override
    public Long createNewVoiceTask(CallTaskReqDto reqDto, CurrentUserInfo currentUser, List<CustomerDto> customers) {
        reqDto.validateAddParams(LoginUtils.getCurrentUser());
        SmsNoticeContent smsNoticeContent = null;
        if (reqDto.getSmsNotice() == 1) {
            SmsTemplate template = SmsTemplate.builder().id(reqDto.getSmsId()).bizId(currentUser.getBizId()).build();
            SmsTemplate smsTemplate = (SmsTemplate)this.smsTemplateMapper.selectOne((Object)template);
            Preconditions.checkArgument((smsTemplate != null ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u63d0\u9192\u6a21\u677fid\u4e0d\u5b58\u5728");
            smsNoticeContent = new SmsNoticeContent();
            smsNoticeContent.setSmsNoticeType(reqDto.getSmsNoticeType());
            smsNoticeContent.setSmsId(reqDto.getSmsId());
        }
        VoiceContentTypeEnum voiceContentTypeEnum = VoiceContentTypeEnum.get((Integer)reqDto.getVoiceContentType());
        VoiceContent voiceContent = new VoiceContent();
        voiceContent.setVoiceContentType(Integer.valueOf(voiceContentTypeEnum.getValue()));
        if (voiceContentTypeEnum.equals((Object)VoiceContentTypeEnum.TEXT)) {
            voiceContent.setVoiceContent(reqDto.getVoiceContent());
        } else if (voiceContentTypeEnum.equals((Object)VoiceContentTypeEnum.VOICE_URL)) {
            voiceContent.setVoiceUrl(reqDto.getVoiceContent());
        } else if (voiceContentTypeEnum.equals((Object)VoiceContentTypeEnum.VOICE_MATERIAL_ID)) {
            voiceContent.setVoiceMaterialId(reqDto.getVoiceContent());
        }
        CallTask callTask = reqDto.backwardByVoice(currentUser, this.idGen.getNum(), voiceContent);
        callTask.setSmsNotice(reqDto.getSmsNotice());
        if (smsNoticeContent != null) {
            callTask.setSmsNoticeContent(JSON.toJSONString((Object)smsNoticeContent));
        }
        log.info("createNewVoiceTask, insert callTask, callTask:{}", (Object)callTask);
        this.callTaskMapper.insertSelective((Object)callTask);
        ArrayList<CallTaskDetail> list = new ArrayList<CallTaskDetail>();
        Date now = new Date();
        for (CustomerDto customerDto : customers) {
            CallTaskDetail detail = new CallTaskDetail();
            detail.setNum(this.idGen.getNum());
            detail.setBizId(currentUser.getBizId());
            detail.setCorpId(currentUser.getCorpId());
            detail.setName(customerDto.getName());
            detail.setPhone(customerDto.getPhone());
            detail.setCallTaskId(callTask.getId());
            detail.setUserId(Long.valueOf(-1L));
            detail.setUserName("");
            detail.setCreateBy(currentUser.getId());
            detail.setCreateTime(now);
            detail.setUpdateBy(currentUser.getId());
            detail.setUpdateTime(now);
            detail.setCallCount(Integer.valueOf(0));
            detail.setCallSuccessCount(Integer.valueOf(0));
            detail.setVoiceTaskExecuteTime(reqDto.getPlanCompleteTime() == null ? now : reqDto.getPlanCompleteTime());
            detail.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.NOT_EXECUTE.getValue()));
            list.add(detail);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.callTaskDetailMapper.batchInsert(list);
        }
        CallTaskUser callTaskUser = new CallTaskUser();
        callTaskUser.setNum(this.idGen.getNum());
        callTaskUser.setBizId(currentUser.getBizId());
        callTaskUser.setCorpId(currentUser.getCorpId());
        callTaskUser.setCallTaskId(callTask.getId());
        callTaskUser.setUserId(callTask.getCreateBy());
        callTaskUser.setCreateBy(callTask.getCreateBy());
        callTaskUser.setCreateTime(now);
        callTaskUser.setUpdateBy(Long.valueOf(-1L));
        callTaskUser.setUpdateTime(now);
        this.callTaskUserMapper.insert((Object)callTaskUser);
        return callTask.getId();
    }

    private void addExistManualTask(CallTaskReqDto reqDto, CurrentUserInfo currentUser, List<CustomerDto> customers, Long callTaskId) {
        List<Object> allocatedUser;
        List callTaskDetails = this.callTaskDetailMapper.select((Object)CallTaskDetail.builder().callTaskId(callTaskId).build());
        List phones = callTaskDetails.stream().map(CallTaskDetail::getPhone).collect(Collectors.toList());
        List detailUserIds = callTaskDetails.stream().map(CallTaskDetail::getUserId).collect(Collectors.toList());
        List callTaskUsers = this.callTaskUserMapper.select((Object)CallTaskUser.builder().callTaskId(callTaskId).build());
        ArrayList userIds = callTaskUsers.stream().map(CallTaskUser::getUserId).collect(Collectors.toList());
        CallTask callTask = (CallTask)this.callTaskMapper.selectByPrimaryKey((Object)callTaskId);
        if (detailUserIds.size() == userIds.size()) {
            allocatedUser = Lists.newArrayList();
        } else if (detailUserIds.size() < userIds.size()) {
            allocatedUser = detailUserIds;
        } else {
            TreeMap userMap = Maps.newTreeMap();
            for (Long detailUserId : detailUserIds) {
                if (!userMap.containsKey(detailUserId)) {
                    userMap.put(detailUserId, 1);
                    continue;
                }
                userMap.put(detailUserId, (Integer)userMap.get(detailUserId) + 1);
            }
            ArrayList list = new ArrayList(userMap.entrySet());
            Collections.sort(list, (o1, o2) -> -((Integer)o1.getValue()).compareTo((Integer)o2.getValue()));
            int index = detailUserIds.size() % userIds.size();
            allocatedUser = list.subList(0, index).stream().map(Map.Entry::getKey).collect(Collectors.toList());
        }
        List customerDtoList = callTaskDetails.stream().map(callTaskDetail -> {
            CustomerDto customerDto = new CustomerDto();
            BeanUtils.copyProperties((Object)callTaskDetail, (Object)customerDto);
            return customerDto;
        }).collect(Collectors.toList());
        ArrayList allocatedCustomer = Lists.newArrayList(customerDtoList);
        ArrayList realCustomer = Lists.newArrayList();
        for (CustomerDto customer : customers) {
            if (phones.contains(customer.getPhone())) continue;
            customerDtoList.add(customer);
            realCustomer.add(customer);
        }
        if (!CollectionUtils.isEmpty((Collection)realCustomer)) {
            log.info("addExistManualTask realCustomer: {}", (Object)realCustomer);
            List<Object> allocRatio = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)callTask.getAllocRatio())) {
                List tmps = Splitter.on((String)",").splitToList((CharSequence)callTask.getAllocRatio());
                for (Object tmp : tmps) {
                    allocRatio.add(Integer.valueOf((String)tmp));
                }
                allocRatio = CustomerAllocateUtil.rate2Num((List<Integer>)allocRatio, realCustomer);
                log.info("addExistManualTask allocRatio: {}", allocRatio);
                userIds = Lists.newArrayList();
                List users = Splitter.on((String)",").splitToList((CharSequence)callTask.getAllocUser());
                for (String user : users) {
                    userIds.add(Long.valueOf(user));
                }
            }
            Map<String, Long> phoneBindUserMap = this.getPhoneBindUserMap(currentUser.getBizId(), realCustomer, userIds);
            CustomerAllocateUtil customerAllocateUtil = new CustomerAllocateUtil(callTaskDetails, this.userMapper, this.idGen, phoneBindUserMap);
            List<Object> callTaskDetailList = customerAllocateUtil.allocate(callTask.getAllocMode(), realCustomer, userIds, allocRatio, currentUser, callTaskId, null);
            callTaskDetailList = callTaskDetailList.stream().filter(callTaskDetail -> ObjectUtils.isEmpty((Object)callTaskDetail.getId())).collect(Collectors.toList());
            this.callTaskDetailMapper.batchInsert(callTaskDetailList);
            this.callTaskMapper.updateByPrimaryKeySelective((Object)CallTask.builder().id(callTaskId).planCompleteTime(reqDto.getPlanCompleteTime()).name(reqDto.getName()).progress(Double.valueOf(this.getProgress(callTaskId))).updateTime(new Date()).build());
        }
    }

    private Map<String, Long> getPhoneBindUserMap(Long bizId, List<CustomerDto> customers, List<Long> userIds) {
        BizSimpleDto biz = this.scrmBizService.getById(bizId);
        if (CollectionUtils.isEmpty(customers) || biz.getIsOpenCrm() == 0) {
            return Maps.newHashMap();
        }
        CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
        crmLeadsInfoReq.setBizId(bizId);
        crmLeadsInfoReq.setMobiles((Collection)customers.stream().map(CustomerDto::getPhone).collect(Collectors.toList()));
        List crmLeadsInfoResps = this.crmLeadsService.queryBindInfoByMobile(crmLeadsInfoReq);
        Map<String, Long> phoneBindUserMap = crmLeadsInfoResps.stream().collect(Collectors.toMap(CrmLeadsInfoResp::getMobile, CrmLeadsInfoResp::getBindingUserId, (key1, key2) -> {
            if (userIds.contains(key1)) {
                return key1;
            }
            return key2;
        }));
        return phoneBindUserMap;
    }

    private Long createNewManualTask(CallTaskReqDto reqDto, CurrentUserInfo currentUser, List<CustomerDto> customers) {
        List<String> userNums = reqDto.getUserIds();
        List userInfoByIds = this.userMapper.getUserInfoByNums(userNums);
        Preconditions.checkArgument((!CollectionUtils.isEmpty((Collection)userInfoByIds) ? 1 : 0) != 0, (Object)"\u6267\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, Long> numIdMap = userInfoByIds.stream().collect(Collectors.toMap(User::getNum, User::getId));
        ArrayList userIds = Lists.newArrayList();
        for (int i = 0; i < userNums.size(); ++i) {
            Long userId = numIdMap.get(userNums.get(i));
            Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u6267\u884c\u4eba\u4e0d\u5b58\u5728");
            userIds.add(userId);
        }
        List<String> userNames = userInfoByIds.stream().map(User::getName).collect(Collectors.toList());
        CallTask callTask = reqDto.backward(currentUser, this.idGen.getNum(), userNames, userIds);
        this.callTaskMapper.insertSelective((Object)callTask);
        if (reqDto.getAllocMode() == 1) {
            reqDto.setAllocRatio(CustomerAllocateUtil.rate2Num(reqDto.getAllocRatio(), customers));
        }
        log.info("createNewManualTask allocRatio: {}", reqDto.getAllocRatio());
        Long callTaskId = callTask.getId();
        ArrayList taskUsers = Lists.newArrayListWithCapacity((int)userIds.size());
        for (Long userId : userIds) {
            CallTaskUser callTaskUser = this.buildTaskUser(currentUser, callTaskId, userId, reqDto.getBizId(), reqDto.getCorpId());
            taskUsers.add(callTaskUser);
        }
        this.callTaskUserMapper.batchInsert((List)taskUsers);
        Map<Object, Object> phoneBindUserMap = Maps.newHashMap();
        if (reqDto.getBizId() == null) {
            phoneBindUserMap = this.getPhoneBindUserMap(currentUser.getBizId(), customers, userIds);
        }
        CustomerAllocateUtil customerAllocateUtil = new CustomerAllocateUtil(this.userMapper, this.idGen, phoneBindUserMap);
        List<CallTaskDetail> taskDetails = customerAllocateUtil.allocate(reqDto.getAllocMode(), customers, userIds, reqDto.getAllocRatio(), currentUser, callTaskId, reqDto);
        this.callTaskDetailMapper.batchInsert(taskDetails);
        Integer openNotice = reqDto.getOpenNotice();
        String string = !ObjectUtils.isEmpty((Object)callTask.getPlanCompleteTime()) ? DateUtil.dateToDateString((Date)callTask.getPlanCompleteTime(), (String)"yyyy-MM-dd HH:mm") : "";
        Map<Long, Long> collect = taskDetails.stream().collect(Collectors.groupingBy(CallTaskDetail::getUserId, Collectors.counting()));
        if (reqDto.getSendType() == 1) {
            return callTaskId;
        }
        for (Map.Entry<Long, Long> entry : collect.entrySet()) {
            String message;
            String content;
            String username;
            String string2 = username = reqDto.getBizId() == null ? currentUser.getName() : "\u8425\u9500sop";
            if (StringUtils.isNotBlank((CharSequence)string)) {
                content = String.format("\u3010\u4eba\u5de5\u5916\u547c\u3011\u4efb\u52a1\u901a\u77e5\n [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\uff0c", username, callTask.getName(), entry.getValue()) + String.format("\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u662f%s\uff0c\u8bf7\u767b\u9646\u767e\u5bb6\u4e91SCRM\u8fdb\u884c\u67e5\u770b\u3002", string);
                message = String.format(" [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\uff0c", username, callTask.getName(), entry.getValue()) + String.format("\n\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u662f%s\u3002", string);
            } else {
                content = String.format("\u3010\u4eba\u5de5\u5916\u547c\u3011\u4efb\u52a1\u901a\u77e5\n [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\uff0c", username, callTask.getName(), entry.getValue()) + "\u8bf7\u767b\u9646\u767e\u5bb6\u4e91SCRM\u8fdb\u884c\u67e5\u770b\u3002";
                message = String.format(" [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\u3002", username, callTask.getName(), entry.getValue());
            }
            AddNoticeReq addNoticeReq = new AddNoticeReq();
            addNoticeReq.setBizId(reqDto.getBizId() == null ? currentUser.getBizId() : reqDto.getBizId());
            addNoticeReq.setType(Integer.valueOf(NoticeType.CALL_TASK.getType()));
            addNoticeReq.setReceiveUserId(entry.getKey());
            addNoticeReq.setMessage(message);
            addNoticeReq.setNoticeTime(new Date());
            NoticeExtendParam noticeExtendParam = new NoticeExtendParam();
            noticeExtendParam.setCallTaskId(callTaskId);
            addNoticeReq.setNoticeExtendParam(noticeExtendParam);
            this.noticeService.addNotice(addNoticeReq);
            if (openNotice == null || 1 != openNotice) continue;
            User userInfoById = this.userMapper.getUserInfoById(entry.getKey());
            String weworkUserId = userInfoById.getWeworkUserId();
            if (StringUtils.isBlank((CharSequence)weworkUserId)) {
                log.info("do not send notice, weworkUserId is null");
                continue;
            }
            log.info("ready to send call task with corpId={}, weworkUserId={}, content={}", new Object[]{currentUser.getCorpId(), weworkUserId, content});
            this.remindService.sendMsg(currentUser.getCorpId(), weworkUserId, content);
        }
        return callTaskId;
    }

    @Override
    public List<CustomerDto> importExcelFile(InputStream inp) {
        List<CustomerDto> customers;
        FileOutputStream outputStream = null;
        try {
            Workbook workbook = CallTaskServiceImpl.create(inp);
            customers = this.parseExcel(workbook);
            File dir = new File(IMPORT_FILE_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String fileName = "./importDir/call/" + simpleDateFormat.format(new Date()) + "_\u5ba2\u6237\u5bfc\u5165\u7ed3\u679c.xlsx";
            File file = new File(fileName);
            outputStream = new FileOutputStream(file);
            workbook.write((OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return customers;
    }

    @Override
    public void transfer(CallTaskReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateTransferParams(currentUser);
        log.info("transfer task detail: {}", (Object)reqDto);
        Long bizId = currentUser.getBizId();
        Long callTaskId = reqDto.getCallTaskId();
        Long userId = this.userMapper.getIdByNum(reqDto.getUserId());
        User user = this.userMapper.getUserInfoById(userId);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)userId) ? 1 : 0) != 0, (Object)"\u65e0\u7528\u6237");
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)callMember) ? 1 : 0) != 0, (Object)"\u6267\u884c\u6210\u5458\u65e0\u6548");
        List<Long> callTaskDetailId = reqDto.getCallTaskDetailId();
        Integer selectMode = reqDto.getSelectMode();
        if (!ObjectUtils.isEmpty((Object)selectMode) && 1 == selectMode) {
            reqDto.setPageDto(null);
            List<CallTaskRespDto> detail = this.detail(reqDto);
            callTaskDetailId = detail.stream().map(CallTaskRespDto::getCallTaskDetailId).collect(Collectors.toList());
            Preconditions.checkArgument((!CollectionUtils.isEmpty(callTaskDetailId) ? 1 : 0) != 0, (Object)"\u5f85\u8f6c\u6d3e\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long taskDetailId : callTaskDetailId) {
            CallTaskDetail taskDetail = CallTaskDetail.builder().id(taskDetailId).userId(userId).userName(user.getName()).updateBy(currentUser.getId()).updateTime(new Date()).build();
            this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)taskDetail);
        }
        this.updateCallTaskUser(currentUser, callTaskId);
    }

    @Override
    public void updateProgress(Long callTaskId) {
        if (ObjectUtils.isEmpty((Object)callTaskId)) {
            return;
        }
        this.callTaskMapper.updateByPrimaryKeySelective((Object)CallTask.builder().id(callTaskId).progress(Double.valueOf(this.getProgress(callTaskId))).build());
    }

    @Override
    public CallTaskRespDto customerDetail(CallTaskReqDto reqDto) {
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)reqDto.getDetailId()) ? 1 : 0) != 0, (Object)"\u4efb\u52a1\u8be6\u60c5id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        CallTaskDetail taskDetail = (CallTaskDetail)this.callTaskDetailMapper.selectOne((Object)CallTaskDetail.builder().bizId(currentUser.getBizId()).id(reqDto.getDetailId()).build());
        if (ObjectUtils.isEmpty((Object)taskDetail)) {
            return new CallTaskRespDto();
        }
        return CallTaskRespDto.from(taskDetail, false, null);
    }

    @Override
    public CallRecordReqDto.CallTaskDetailStatisticRespDto taskDetailStatistic(CallTaskReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateDetailParams(currentUser);
        log.info("taskStatistic reqDto: {}", (Object)reqDto);
        Long bizId = currentUser.getBizId();
        CallTaskQueryParams params = reqDto.to(bizId);
        ArrayList<CallTaskRespDto> resultList = new ArrayList<CallTaskRespDto>();
        if (reqDto.getType() == null || CallTypeEnum.MANUAL.getValue() == reqDto.getType().intValue()) {
            List taskDetails = this.callTaskDetailMapper.taskDetail(params);
            resultList = new ArrayList();
            if (params.getPageDto() != null) {
                params.getPageDto().setCount(Integer.valueOf(this.callTaskDetailMapper.taskDetailCount(params)));
                params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
            }
            if (!CollectionUtils.isEmpty((Collection)taskDetails)) {
                for (CallTaskDetail taskDetail : taskDetails) {
                    resultList.add(CallTaskRespDto.from(taskDetail, false, null));
                }
            }
        }
        int customerCount = this.callTaskDetailMapper.customerCount(params);
        int calledSuccessCount = this.callTaskDetailMapper.calledSuccessCount(params);
        int calledCount = this.callTaskDetailMapper.calledCount(params);
        CallTask callTask = (CallTask)this.callTaskMapper.selectByPrimaryKey((Object)reqDto.getCallTaskId());
        Double progress = callTask != null && Objects.nonNull(callTask.getProgress()) ? callTask.getProgress() : 0.0;
        DecimalFormat df = new DecimalFormat("###.00");
        progress = Double.valueOf(df.format(progress * 100.0));
        CallRecordReqDto.CallTaskDetailStatisticRespDto respDto = CallRecordReqDto.CallTaskDetailStatisticRespDto.builder().users(resultList).calledCount(calledCount).calledSuccessCount(calledSuccessCount).customerCount(customerCount).callProgress(progress).build();
        if (Objects.nonNull(reqDto.getType()) && reqDto.getType().intValue() == CallTypeEnum.VOICE.getValue()) {
            CallTaskDetailCriteria criteria = new CallTaskDetailCriteria();
            criteria.createCriteria().andCallTaskIdEqualTo(reqDto.getCallTaskId()).andLastCallStatusIsNotNull();
            List callTaskDetails = this.callTaskDetailMapper.selectByExample((Object)criteria);
            Map<Integer, Long> countByStatus = callTaskDetails.stream().collect(Collectors.groupingBy(CallTaskDetail::getLastCallStatus, Collectors.counting()));
            respDto.setNobodyVoisCount(Optional.ofNullable(countByStatus.get(StatusEnum.NOBODY.getValue())).map(Long::intValue).orElse(0));
            respDto.setStartVoisCount(Optional.ofNullable(countByStatus.get(StatusEnum.START.getValue())).map(Long::intValue).orElse(0));
            respDto.setNotSupportVoisCount(Optional.ofNullable(countByStatus.get(StatusEnum.NOT_SUPPORT.getValue())).map(Long::intValue).orElse(0));
            respDto.setNotSendVoisCount(Optional.ofNullable(countByStatus.get(StatusEnum.NOBODY.getValue())).map(Long::intValue).orElse(0));
            respDto.setNotSendVoisCount(customerCount - calledCount);
        }
        return respDto;
    }

    @Override
    public List<CallRecordReqDto.CallTaskDetailStatisticRespDto> taskDetailStatisticList(CallTaskReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateForTaskList(currentUser);
        log.info("taskDetailStatisticList reqDto: {}", (Object)reqDto);
        if (CollectionUtils.isEmpty(reqDto.getCallTaskIds())) {
            return Collections.emptyList();
        }
        Long bizId = currentUser.getBizId();
        CallTaskQueryParams params = reqDto.to(bizId);
        ArrayList<CallRecordReqDto.CallTaskDetailStatisticRespDto> resultList = new ArrayList<CallRecordReqDto.CallTaskDetailStatisticRespDto>();
        List callTaskDetails = this.callTaskDetailMapper.taskDetailStatisticList(params);
        if (CollectionUtils.isEmpty((Collection)callTaskDetails)) {
            return Collections.emptyList();
        }
        for (CallTaskDetail callTaskDetail : callTaskDetails) {
            Double progress = Objects.nonNull(callTaskDetail.getProgress()) ? callTaskDetail.getProgress() : 0.0;
            DecimalFormat df = new DecimalFormat("###.00");
            progress = Double.valueOf(df.format(progress * 100.0));
            CallRecordReqDto.CallTaskDetailStatisticRespDto respDto = CallRecordReqDto.CallTaskDetailStatisticRespDto.builder().callProgress(progress).callTaskId(callTaskDetail.getCallTaskId()).customerCount(callTaskDetail.getCustomerCount()).calledSuccessCount(callTaskDetail.getCalledSuccessCount()).notSupportVoisCount(callTaskDetail.getNotSupportVoisCount()).startVoisCount(callTaskDetail.getStartVoisCount()).nobodyVoisCount(callTaskDetail.getNobodyVoisCount()).notSendVoisCount(callTaskDetail.getNotSendVoisCount()).timeoutVoisCount(callTaskDetail.getTimeoutVoisCount()).build();
            resultList.add(respDto);
        }
        return resultList;
    }

    @Override
    public void notice(CallTaskReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateTaskDetailParams(currentUser);
        log.info("notice reqDto: {}", (Object)reqDto);
        String corpId = currentUser.getCorpId();
        Long callTaskId = reqDto.getCallTaskId();
        Long id = reqDto.getUser();
        CallTaskDetailCriteria taskDetailCriteria = new CallTaskDetailCriteria();
        taskDetailCriteria.createCriteria().andCallTaskIdEqualTo(callTaskId).andUserIdEqualTo(id).andLastCallRecordIdIsNull();
        List callTaskDetails = this.callTaskDetailMapper.selectByExample((Object)taskDetailCriteria);
        List phones = callTaskDetails.stream().map(CallTaskDetail::getPhone).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(phones)) {
            return;
        }
        CallTask callTask = (CallTask)this.callTaskMapper.selectOne((Object)CallTask.builder().id(callTaskId).build());
        User create = this.userMapper.getUserInfoById(callTask.getCreateBy());
        String string = !ObjectUtils.isEmpty((Object)callTask.getPlanCompleteTime()) ? DateUtil.dateToDateString((Date)callTask.getPlanCompleteTime(), (String)"yyyy-MM-dd HH:mm") : "";
        String createByName = create != null ? create.getName() : "\u8425\u9500sop";
        String content = StringUtils.isNotBlank((CharSequence)string) ? String.format("\u3010\u4eba\u5de5\u5916\u547c\u3011\u4efb\u52a1\u901a\u77e5\n [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\uff0c", createByName, callTask.getName(), phones.size()) + String.format("\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u662f%s\uff0c\u8bf7\u767b\u9646\u767e\u5bb6\u4e91SCRM\u8fdb\u884c\u67e5\u770b\u3002", string) : String.format("\u3010\u4eba\u5de5\u5916\u547c\u3011\u4efb\u52a1\u901a\u77e5\n [%s]\u521b\u5efa\u4e0b\u53d1\u4e86'%s'\u4efb\u52a1\uff0c\u60a8\u88ab\u5206\u914d\u5230\u5ba2\u6237%s\u4eba\uff0c", createByName, callTask.getName(), phones.size()) + "\u8bf7\u767b\u9646\u767e\u5bb6\u4e91SCRM\u8fdb\u884c\u67e5\u770b\u3002";
        User userInfoById = this.userMapper.getUserInfoById(id);
        String weworkUserId = userInfoById.getWeworkUserId();
        if (StringUtils.isBlank((CharSequence)weworkUserId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6267\u884c\u4eba\u4e0d\u662f\u4f01\u4e1a\u6210\u5458\uff0c\u65e0\u6cd5\u53d1\u9001\u63d0\u9192");
        }
        log.info("ready to send call task with corpId={}, weworkUserId={}, content={}", new Object[]{corpId, weworkUserId, content});
        this.remindService.sendMsg(corpId, weworkUserId, content);
    }

    @Override
    public boolean isOpenCrm() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        log.info("isOpenCrm bizId: {}", (Object)bizId);
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String pkgIdsStr = businessCustomer.getPkgIds();
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return false;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)businessCustomer.getId(), (Object)s);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    private double getProgress(Long callTaskId) {
        int total = this.callTaskDetailMapper.selectCount((Object)CallTaskDetail.builder().callTaskId(callTaskId).build());
        if (total == 0) {
            return 0.0;
        }
        CallTaskDetailCriteria criteria = new CallTaskDetailCriteria();
        criteria.createCriteria().andLastCallRecordIdIsNotNull().andCallTaskIdEqualTo(callTaskId);
        int called = this.callTaskDetailMapper.selectCountByExample((Object)criteria);
        return (double)called / (double)total;
    }

    private double getProgressByVoice(Long callTaskId) {
        int total = this.callTaskDetailMapper.selectCount((Object)CallTaskDetail.builder().callTaskId(callTaskId).build());
        if (total == 0) {
            return 0.0;
        }
        CallTaskDetailCriteria criteria = new CallTaskDetailCriteria();
        criteria.createCriteria().andVoiceTaskStatusNotEquals(Integer.valueOf(VoiceCallStatusEnum.NOT_EXECUTE.getValue())).andCallTaskIdEqualTo(callTaskId);
        int called = this.callTaskDetailMapper.selectCountByExample((Object)criteria);
        return (double)called / (double)total;
    }

    private void updateCallTaskUser(CurrentUserInfo currentUser, Long callTaskId) {
        CallTaskDetailCriteria taskDetailCriteria = new CallTaskDetailCriteria();
        taskDetailCriteria.createCriteria().andCallTaskIdEqualTo(callTaskId);
        List callTaskDetails = this.callTaskDetailMapper.selectByExample((Object)taskDetailCriteria);
        List userIds = callTaskDetails.stream().map(CallTaskDetail::getUserId).collect(Collectors.toList());
        this.callTaskUserMapper.delete((Object)CallTaskUser.builder().callTaskId(callTaskId).build());
        ArrayList taskUsers = Lists.newArrayListWithCapacity((int)userIds.size());
        ArrayList users = Lists.newArrayList();
        for (Long id : userIds) {
            if (users.contains(id)) continue;
            users.add(id);
            CallTaskUser callTaskUser = this.buildTaskUser(currentUser, callTaskId, id, null, null);
            taskUsers.add(callTaskUser);
        }
        this.callTaskUserMapper.batchInsert((List)taskUsers);
    }

    private Set<Long> updateTaskUser(List<Long> callTaskDetailId, CurrentUserInfo currentUser, Long callTaskId, Long userId) {
        Long bizId = currentUser.getBizId();
        CallTaskDetailCriteria callTaskDetailCriteria = new CallTaskDetailCriteria();
        callTaskDetailCriteria.createCriteria().andIdIn(callTaskDetailId);
        List taskDetails = this.callTaskDetailMapper.selectByExample((Object)callTaskDetailCriteria);
        Set selectUserIds = taskDetails.stream().map(CallTaskDetail::getUserId).collect(Collectors.toSet());
        CallTaskDetailCriteria taskDetailCriteria = new CallTaskDetailCriteria();
        callTaskDetailCriteria.createCriteria().andBizIdEqualTo(bizId).andCallTaskIdEqualTo(callTaskId);
        List taskDetailList = this.callTaskDetailMapper.selectByExample((Object)taskDetailCriteria);
        Set<Long> allUserIds = taskDetailList.stream().map(CallTaskDetail::getUserId).collect(Collectors.toSet());
        CallTaskDetailCriteria detailCriteria = new CallTaskDetailCriteria();
        callTaskDetailCriteria.createCriteria().andIdNotIn(callTaskDetailId).andBizIdEqualTo(bizId).andCallTaskIdEqualTo(callTaskId);
        List callTaskDetails = this.callTaskDetailMapper.selectByExample((Object)detailCriteria);
        Set elseUserIds = callTaskDetails.stream().map(CallTaskDetail::getUserId).collect(Collectors.toSet());
        CallTaskUserCriteria callTaskUserCriteria = new CallTaskUserCriteria();
        if (selectUserIds.size() + elseUserIds.size() == allUserIds.size()) {
            ArrayList longs = Lists.newArrayList(selectUserIds);
            if (!CollectionUtils.isEmpty((Collection)longs)) {
                callTaskUserCriteria.createCriteria().andBizIdEqualTo(bizId).andCallTaskIdEqualTo(callTaskId).andUserIdIn((List)longs);
                this.callTaskUserMapper.deleteByExample((Object)callTaskUserCriteria);
            }
            allUserIds.removeAll(selectUserIds);
            if (!elseUserIds.contains(userId)) {
                CallTaskUser taskUserInsert = this.buildTaskUser(currentUser, callTaskId, userId, null, null);
                this.callTaskUserMapper.insert((Object)taskUserInsert);
                allUserIds.add(userId);
            }
        } else {
            if (selectUserIds.contains(userId)) {
                selectUserIds.remove(userId);
            } else {
                List intersection = selectUserIds.stream().filter(item -> elseUserIds.contains(item)).collect(Collectors.toList());
                selectUserIds.removeAll(intersection);
                if (!selectUserIds.contains(userId) && !elseUserIds.contains(userId)) {
                    CallTaskUser taskUserInsert = this.buildTaskUser(currentUser, callTaskId, userId, null, null);
                    this.callTaskUserMapper.insert((Object)taskUserInsert);
                    allUserIds.add(userId);
                }
            }
            ArrayList longs = Lists.newArrayList(selectUserIds);
            if (!CollectionUtils.isEmpty((Collection)longs)) {
                callTaskUserCriteria.createCriteria().andBizIdEqualTo(bizId).andCallTaskIdEqualTo(callTaskId).andUserIdIn((List)Lists.newArrayList(selectUserIds));
                this.callTaskUserMapper.deleteByExample((Object)callTaskUserCriteria);
            }
            allUserIds.removeAll(selectUserIds);
        }
        return allUserIds;
    }

    public CallTaskUser buildTaskUser(CurrentUserInfo currentUser, Long callTaskId, Long userId, Long bizId, String corpId) {
        if (bizId == null) {
            return CallTaskUser.builder().num(this.idGen.getNum()).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).callTaskId(callTaskId).userId(userId).createTime(new Date()).createBy(currentUser.getId()).updateTime(new Date()).updateBy(currentUser.getId()).build();
        }
        return CallTaskUser.builder().num(this.idGen.getNum()).bizId(bizId).corpId(corpId).callTaskId(callTaskId).userId(userId).createTime(new Date()).createBy(Long.valueOf(-1L)).updateTime(new Date()).updateBy(Long.valueOf(-1L)).build();
    }

    private List<CustomerDto> parseExcel(Workbook workbook) {
        int numberOfSheets = workbook.getNumberOfSheets();
        if (numberOfSheets != 1) {
            log.warn("excel\u6587\u4ef6sheet\u9875\u6570\u4e3a:{}", (Object)numberOfSheets);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "excel\u6587\u4ef6\u4e2dsheet\u9875\u6570\u4e0d\u4e3a1");
        }
        Sheet sheet = workbook.getSheetAt(0);
        int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
        if (physicalNumberOfRows - 1 > 5000) {
            log.warn("excel\u6587\u4ef6\u4e2d\u6570\u636e\u603b\u884c\u6570\u4e3a:{}", (Object)(physicalNumberOfRows - 1));
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u6b21\u6700\u591a\u5bfc\u51655000\u6761");
        }
        Row headerRow = sheet.getRow(0);
        Cell firstCell = headerRow.getCell(NumberUtils.INTEGER_ZERO.intValue());
        String firstCellStr = firstCell.getStringCellValue();
        if (!HEADER_FIRST_CELL_STR.equals(firstCellStr)) {
            log.warn("\u6807\u9898\u884c\u7b2c\u4e00\u5217\u6807\u9898\u4e3a:{}", (Object)firstCellStr);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e00\u5217\u4e0d\u4e3a\u3010\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09\u3011");
        }
        HashSet mobiles = Sets.newHashSet();
        HashSet customers = Sets.newHashSet();
        int totalCount = physicalNumberOfRows - 1;
        String name = "";
        int i = 0;
        int dataStartRow = 0;
        while (i < totalCount) {
            Row row;
            if (Objects.isNull(row = sheet.getRow(++dataStartRow))) continue;
            Cell cell = row.getCell(NumberUtils.INTEGER_ZERO.intValue());
            if (Objects.isNull(cell)) {
                ++i;
                continue;
            }
            cell.setCellType(CellType.STRING);
            String mobile = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)mobile)) {
                ++i;
                continue;
            }
            cell = row.getCell(NumberUtils.INTEGER_ONE.intValue());
            if (!Objects.isNull(cell)) {
                cell.setCellType(CellType.STRING);
                name = cell.getStringCellValue();
            }
            if (MobileUtils.isPhone((String)mobile) && mobiles.add(mobile)) {
                CustomerDto reqDto = new CustomerDto();
                reqDto.setPhone(mobile);
                reqDto.setName(name);
                customers.add(reqDto);
            }
            ++i;
        }
        return new ArrayList<CustomerDto>(customers);
    }

    private static Workbook create(InputStream inp) throws IOException, InvalidFormatException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        return WorkbookFactory.create((InputStream)inp);
    }

    @Override
    public void executeVoiceTask() {
        Date now = new Date();
        log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u5f00\u59cb\u6267\u884c \u6267\u884c\u8bed\u97f3\u5916\u547c\u4efb\u52a1 \u5b9a\u65f6\u4efb\u52a1, now:{}", (Object)now);
        BizListDto dto = new BizListDto(null, Integer.valueOf(1), null, null, null);
        List bizList = this.businessCustomerMapper.getBizList(dto, null);
        int pageSize = 20;
        for (BusinessCustomer businessCustomer : bizList) {
            this.executeVoiceTaskService.submit(() -> {
                Long bizId = null;
                String corpId = null;
                String speedKey = null;
                HashMap<Long, Object> taskIdAndVoiceContentMap = null;
                ArrayList<Long> taskIds = null;
                List noExecuteDetails = null;
                HashMap<Long, Long> userIdAndNodeIdMap = null;
                try {
                    bizId = businessCustomer.getId();
                    corpId = businessCustomer.getCorpId();
                    speedKey = VOICE_TASK_SPEED_LIMIT_SLEEP_KEY + bizId;
                    Boolean hasKey = this.stringRedisTemplate.hasKey((Object)speedKey);
                    if (hasKey != null && hasKey.booleanValue()) {
                        Long l = this.stringRedisTemplate.getExpire((Object)speedKey);
                        log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u5546\u6237ID\u4e3a{}\u7684\u8bed\u97f3\u5916\u547c\u4efb\u52a1\u8fbe\u5230\u63a5\u53e3\u5e76\u53d1\u9650\u5236\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u3002\u5269\u4f59\u4f11\u7720\u65f6\u95f4:{}", (Object)bizId, (Object)l);
                        return;
                    }
                    int n = this.callTaskMapper.queryUnfinishedVoiceTaskCount(bizId);
                    if (n == 0) {
                        return;
                    }
                    log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u5546\u6237ID\u4e3a{}\u7684\u672a\u5b8c\u6210\u7684\u8bed\u97f3\u5916\u547c\u4efb\u52a1\u6570\u91cf\u4e3a{}", (Object)bizId, (Object)n);
                    int totalPage = n / pageSize + (n % pageSize == 0 ? 0 : 1);
                    ArrayList taskDetails = new ArrayList();
                    taskIdAndVoiceContentMap = new HashMap<Long, Object>();
                    taskIds = new ArrayList<Long>();
                    for (int i = 0; i < totalPage; ++i) {
                        List callTasks = this.callTaskMapper.queryListByUnfinishedVoiceTask(bizId, Integer.valueOf(pageSize), Integer.valueOf(i * pageSize));
                        for (CallTask callTask : callTasks) {
                            taskIds.add(callTask.getId());
                            CallTaskDetail select = new CallTaskDetail();
                            select.setBizId(bizId);
                            select.setCallTaskId(callTask.getId());
                            List details = this.callTaskDetailMapper.select((Object)select);
                            if (CollectionUtils.isEmpty((Collection)details)) continue;
                            taskDetails.addAll(details);
                            taskIdAndVoiceContentMap.put(callTask.getId(), JSON.parseObject((String)callTask.getVoiceContent(), VoiceContent.class));
                        }
                    }
                    noExecuteDetails = taskDetails.stream().filter(d -> VoiceCallStatusEnum.NOT_EXECUTE.getValue() == d.getVoiceTaskStatus().intValue() && (d.getVoiceTaskExecuteTime() == null || d.getVoiceTaskExecuteTime().before(now))).sorted(Comparator.comparing(CallTaskDetail::getVoiceTaskVersion)).collect(Collectors.toList());
                    log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u5546\u6237ID\u4e3a{}\u7684\u5373\u5c06\u6267\u884c\u7684\u8bed\u97f3\u5916\u547c\u6570\u91cf\u4e3a{}", (Object)bizId, (Object)noExecuteDetails.size());
                    List userIds = noExecuteDetails.stream().map(CallTaskDetail::getCreateBy).collect(Collectors.toList());
                    List userInfoByIds = this.userMapper.getUserInfoByIds(userIds);
                    userIdAndNodeIdMap = new HashMap<Long, Long>();
                    for (User user : userInfoByIds) {
                        userIdAndNodeIdMap.put(user.getId(), user.getNodeId());
                    }
                }
                catch (Exception e) {
                    log.error("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u6267\u884c\u8bed\u97f3\u5916\u547c\u4efb\u52a1\u903b\u8f91\u5f02\u5e38", (Throwable)e);
                    return;
                }
                for (CallTaskDetail callTaskDetail : noExecuteDetails) {
                    String key = bizId + "$$" + callTaskDetail.getId();
                    try {
                        JSONObject jsonObject;
                        Date executeTime;
                        this.lock.lock(key);
                        log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011voiceDetail:{}", (Object)JSON.toJSONString((Object)callTaskDetail));
                        CallTaskDetail selectCurrentStatusDetail = new CallTaskDetail();
                        selectCurrentStatusDetail.setId(callTaskDetail.getId());
                        CallTaskDetail nowDetail = (CallTaskDetail)this.callTaskDetailMapper.selectOne((Object)selectCurrentStatusDetail);
                        if (VoiceCallStatusEnum.NOT_EXECUTE.getValue() != nowDetail.getVoiceTaskStatus().intValue()) continue;
                        Date date = new Date();
                        Date date2 = executeTime = callTaskDetail.getVoiceTaskExecuteTime() != null ? callTaskDetail.getVoiceTaskExecuteTime() : callTaskDetail.getCreateTime();
                        if (date.getTime() - executeTime.getTime() > (long)(this.voiceCallTimeout * 60 * 1000)) {
                            log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011detailId\u4e3a{}\u7684\u8bed\u97f3\u5916\u547c\u8d85\u65f6\uff0c\u4e0d\u6267\u884c\u3002\u6267\u884c\u65f6\u95f4\u4e3a:{}", (Object)callTaskDetail.getId(), (Object)executeTime);
                            callTaskDetail.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.TIMEOUT.getValue()));
                            this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)callTaskDetail);
                            continue;
                        }
                        if (this.judgePhoneIsLimit(bizId, callTaskDetail.getPhone())) {
                            log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011detailId\u4e3a{}\u7684\u8bed\u97f3\u5916\u547c\u53f7\u7801\u8fbe\u5230\u65e5\u4e0a\u9650\uff0c\u4e0d\u6267\u884c\u3002", (Object)callTaskDetail.getId());
                            continue;
                        }
                        VoiceContent voiceContent = (VoiceContent)taskIdAndVoiceContentMap.get(callTaskDetail.getCallTaskId());
                        Map<String, String> params = this.handleVoiceParams(voiceContent, callTaskDetail);
                        log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\uff0cdetailId:{}\uff0c\u5165\u53c2params:{}", (Object)callTaskDetail.getId(), params);
                        String unencryptedContent = params.get("unencryptedContent");
                        params.remove("unencryptedContent");
                        if (!params.containsKey("type")) {
                            log.warn("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u8bed\u97f3\u5916\u547c\u53c2\u6570\u6784\u9020\u5f02\u5e38\uff0c\u5f53\u524d\u8df3\u8fc7\u6267\u884c\uff0cdetailId:{}", (Object)callTaskDetail.getId());
                            continue;
                        }
                        try {
                            jsonObject = this.bjyPartnerService.bjyPost(bizId, this.voiceCallUrl, params);
                        }
                        catch (Exception e) {
                            log.error("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u5f02\u5e38,detailId:{}", (Object)callTaskDetail.getId(), (Object)e);
                            this.lock.unlock(key);
                            continue;
                        }
                        if (jsonObject == null) {
                            log.error("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a, detailId:{}", (Object)callTaskDetail.getId());
                            continue;
                        }
                        Integer code = jsonObject.getInteger("code");
                        if (code.equals(31002)) {
                            log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011detailId\u4e3a{}\u7684\u8bed\u97f3\u5916\u547c\u6267\u884c\u5931\u8d25\u3002[\u88ab\u53eb\u53d7\u9650], \u5931\u8d25\u539f\u56e0\u4e3a:{}", (Object)callTaskDetail.getId(), (Object)jsonObject.getString("msg"));
                            this.saveLimitPhone(bizId, callTaskDetail.getPhone());
                            continue;
                        }
                        if (code.equals(31004)) {
                            log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011detailId\u4e3a{}\u7684\u8bed\u97f3\u5916\u547c\u6267\u884c\u5931\u8d25\u3002[\u8bed\u97f3\u5916\u547c\u6587\u6848\u8d85\u51fa\u957f\u5ea6], \u5931\u8d25\u539f\u56e0\u4e3a:{}", (Object)callTaskDetail.getId(), (Object)jsonObject.getString("msg"));
                            callTaskDetail.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.CONTENT_OVER_LENGTH.getValue()));
                            this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)callTaskDetail);
                            continue;
                        }
                        if (code.equals(31003)) {
                            log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011detailId\u4e3a{}\u7684\u8bed\u97f3\u5916\u547c\u6267\u884c\u5931\u8d25\u3002[\u63a5\u53e3\u5e76\u53d1\u9650\u5236], \u5931\u8d25\u539f\u56e0\u4e3a:{}", (Object)callTaskDetail.getId(), (Object)jsonObject.getString("msg"));
                            this.stringRedisTemplate.opsForValue().set((Object)speedKey, (Object)" ", 1L, TimeUnit.MINUTES);
                            this.callTaskDetailMapper.batchAddVoiceTaskExecuteTimeOneMinute(taskIds);
                            return;
                        }
                        JSONObject data = jsonObject.getJSONObject("data");
                        if (data == null) {
                            log.error("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679cdata\u4e3a\u7a7a, detailId:{}", (Object)callTaskDetail.getId());
                            continue;
                        }
                        String sessionId = data.getString("session_id");
                        if (StringUtils.isBlank((CharSequence)sessionId)) {
                            log.error("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u83b7\u53d6\u4e0d\u5230sessionId, detailId:{}", (Object)callTaskDetail.getId());
                            continue;
                        }
                        this.insertCallRecordAndUpdateDetail(date, params, callTaskDetail, bizId, corpId, sessionId, userIdAndNodeIdMap, unencryptedContent);
                    }
                    catch (Exception e) {
                        log.error("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u5904\u7406\u8bed\u97f3\u5916\u547c\u4efb\u52a1\u5f02\u5e38, detailId:{}", (Object)callTaskDetail.getId(), (Object)e);
                    }
                    finally {
                        this.lock.unlock(key);
                    }
                }
                for (Map.Entry entry : taskIdAndVoiceContentMap.entrySet()) {
                    Long callTaskId = (Long)entry.getKey();
                    double newProgress = this.getProgressByVoice(callTaskId);
                    this.callTaskMapper.updateByPrimaryKeySelective((Object)CallTask.builder().id(callTaskId).progress(Double.valueOf(newProgress)).updateTime(new Date()).build());
                }
                log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u5546\u6237ID\u4e3a{}\u7684\u8bed\u97f3\u5916\u547c\u4efb\u52a1\u5904\u7406\u5b8c\u6bd5", (Object)bizId);
            });
        }
        log.info("\u3010\u8bed\u97f3\u5916\u547c\u5b9a\u65f6\u4efb\u52a1\u3011\u7ed3\u675f\u6267\u884c \u6267\u884c\u8bed\u97f3\u5916\u547c\u4efb\u52a1 \u5b9a\u65f6\u4efb\u52a1");
    }

    @Override
    public void send() {
        log.info("auto send call start");
        CallTaskCriteria callTaskCriteria = new CallTaskCriteria();
        callTaskCriteria.createCriteria().andSendTypeEqualTo(Integer.valueOf(1)).andStatusEqualTo(Integer.valueOf(0)).andSendTimeLessThan(new Date());
        List unProcessedTasks = this.callTaskMapper.selectByExample((Object)callTaskCriteria);
        for (CallTask smsTask : unProcessedTasks) {
            smsTask.setUpdateTime(new Date());
            smsTask.setStatus(Integer.valueOf(1));
            this.callTaskMapper.updateByPrimaryKeySelective((Object)smsTask);
        }
    }

    @Override
    public void cancel(String num) {
        log.info("cancel call task");
        CallTask callTask = new CallTask();
        callTask.setNum(num);
        CallTask callTaskDb = (CallTask)this.callTaskMapper.selectOne((Object)callTask);
        if (ObjectUtils.isEmpty((Object)callTaskDb)) {
            throw new IllegalArgumentException("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        callTaskDb.setUpdateTime(new Date());
        callTaskDb.setStatus(Integer.valueOf(2));
        this.callTaskMapper.updateByPrimaryKeySelective((Object)callTaskDb);
    }

    private void insertCallRecordAndUpdateDetail(Date date, Map<String, String> params, CallTaskDetail detail, Long bizId, String corpId, String sessionId, Map<Long, Long> userIdAndNodeIdMap, String unencryptedContent) {
        Long nodeId = userIdAndNodeIdMap.get(detail.getCreateBy());
        CallRecord record = new CallRecord();
        record.setNum(this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setCustomerPhone(detail.getPhone());
        record.setUserType(Integer.valueOf(CallTypeEnum.VOICE.getValue()));
        record.setApiType(Integer.valueOf(0));
        record.setCallTaskDetailId(detail.getId());
        record.setApiCallId(sessionId);
        record.setUserId(detail.getCreateBy());
        record.setUserPhone("");
        record.setMiddlePhone("");
        record.setType(Integer.valueOf(0));
        record.setStatus(Integer.valueOf(StatusEnum.START.getValue()));
        record.setCanceled(Integer.valueOf(0));
        record.setNodeId(Long.valueOf(Objects.isNull(nodeId) ? -1L : nodeId));
        record.setIsOpenapi(Integer.valueOf(0));
        record.setCreateBy(Long.valueOf(-1L));
        record.setCreateTime(date);
        record.setUpdateBy(Long.valueOf(-1L));
        record.setUpdateTime(date);
        record.setCustomerName(detail.getName());
        record.setVoiceUrl(unencryptedContent);
        this.callRecordMapper.insert((Object)record);
        detail.setApiCallId(sessionId);
        detail.setUpdateTime(date);
        detail.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.EXECUTING.getValue()));
        detail.setLastCallRecordId(record.getId());
        this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)detail);
    }

    private Map<String, String> handleVoiceParams(VoiceContent voiceContent, CallTaskDetail detail) {
        String phone = detail.getPhone();
        String name = detail.getName();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tel_b", phone);
        if (voiceContent.getVoiceContentType() == null) {
            if (StringUtils.isNotBlank((CharSequence)voiceContent.getVoiceContent())) {
                this.buildTextContent(params, voiceContent.getVoiceContent(), name, phone);
                params.put("unencryptedContent", voiceContent.getVoiceContent());
            } else if (StringUtils.isNotBlank((CharSequence)voiceContent.getVoiceUrl())) {
                this.buildVoiceFileContent(params, voiceContent.getVoiceUrl());
                params.put("unencryptedContent", voiceContent.getVoiceUrl());
            }
        } else {
            VoiceContentTypeEnum voiceContentTypeEnum = VoiceContentTypeEnum.get((Integer)voiceContent.getVoiceContentType());
            if (voiceContentTypeEnum.equals((Object)VoiceContentTypeEnum.TEXT)) {
                this.buildTextContent(params, voiceContent.getVoiceContent(), name, phone);
                params.put("unencryptedContent", voiceContent.getVoiceContent());
            } else if (voiceContentTypeEnum.equals((Object)VoiceContentTypeEnum.VOICE_URL)) {
                this.buildVoiceFileContent(params, voiceContent.getVoiceUrl());
                params.put("unencryptedContent", voiceContent.getVoiceUrl());
            } else if (voiceContentTypeEnum.equals((Object)VoiceContentTypeEnum.VOICE_MATERIAL_ID)) {
                this.buildVoiceMaterialContent(params, voiceContent.getVoiceMaterialId(), phone, name, detail.getId());
            }
        }
        return params;
    }

    private void buildVoiceMaterialContent(Map<String, String> params, String materialId, String phone, String name, Long detailId) {
        CallVoiceMaterial select = new CallVoiceMaterial();
        select.setNum(materialId);
        select.setIsDeleted(Integer.valueOf(0));
        CallVoiceMaterial callVoiceMaterial = (CallVoiceMaterial)this.callVoiceMaterialMapper.selectOne((Object)select);
        if (callVoiceMaterial == null) {
            log.warn("\u6784\u9020\u8bed\u97f3\u5916\u547c\u5185\u5bb9\u5931\u8d25\uff0c\u901a\u8fc7\u8bed\u97f3\u7d20\u6750num:{}\uff0c\u627e\u4e0d\u5230\u8bed\u97f3\u7d20\u6750", (Object)materialId);
            CallTaskDetail updateStatus = new CallTaskDetail();
            updateStatus.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.MATERIAL_NOT_EXIST.getValue()));
            updateStatus.setId(detailId);
            this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)updateStatus);
            return;
        }
        VoiceMaterialTypeEnum materialType = VoiceMaterialTypeEnum.get((Integer)callVoiceMaterial.getType());
        params.put("unencryptedContent", callVoiceMaterial.getContent());
        if (VoiceMaterialTypeEnum.TEXT.equals((Object)materialType)) {
            this.buildTextContent(params, callVoiceMaterial.getContent(), name, phone);
        } else if (VoiceMaterialTypeEnum.VOICE.equals((Object)materialType)) {
            this.buildVoiceFileContent(params, callVoiceMaterial.getContent());
        }
    }

    private void buildVoiceFileContent(Map<String, String> params, String voiceUrl) {
        params.put("type", "1");
        params.put("file", voiceUrl);
    }

    private void buildTextContent(Map<String, String> params, String content, String name, String phone) {
        params.put("type", "0");
        if (content.contains("{\u5ba2\u6237\u540d\u79f0}")) {
            content = StringUtils.isNotBlank((CharSequence)name) ? content.replace("{\u5ba2\u6237\u540d\u79f0}", name) : content.replace("{\u5ba2\u6237\u540d\u79f0}", "");
        }
        if (content.contains("{\u624b\u673a\u53f7}")) {
            content = content.replace("{\u624b\u673a\u53f7}", phone);
        }
        String base64Content = Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
        params.put("text", base64Content);
    }

    private void saveLimitPhone(Long bizId, String phone) {
        Date now = new Date();
        String key = VOICE_TASK_LIMIT_PHONES_KEY + bizId;
        this.stringRedisTemplate.opsForSet().add((Object)key, (Object[])new String[]{phone});
        Date todayEndTime = DateUtil.getTodayEndTime();
        long timeout = todayEndTime.getTime() - now.getTime();
        this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.MILLISECONDS);
    }

    private boolean judgePhoneIsLimit(Long bizId, String phone) {
        String key = VOICE_TASK_LIMIT_PHONES_KEY + bizId;
        Boolean member = this.stringRedisTemplate.opsForSet().isMember((Object)key, (Object)phone);
        return member == null ? false : member;
    }

    @Override
    public String convertFile(InputStream inp, String filename) {
        try {
            log.info("convertFile filename:{}", (Object)filename);
            File dir = new File(IMPORT_FILE_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = "./importDir/call/" + this.idGen.getNum() + filename.substring(filename.length() - 4);
            this.saveFileFromInputStream(inp, fileName);
            File file = new File(fileName);
            File convertFile = this.convert(fileName);
            String url = this.aliyunOss.uploadFile(LoginUtils.getCurrentUserCorpId(), convertFile, convertFile.getName());
            if (file.exists()) {
                file.delete();
            }
            FileUtils.deleteQuietly((File)convertFile);
            return url;
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    @Override
    public BatchPhoneDto phoneBatchId(CallTaskReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        log.info("phoneBatchId reqDto:{}, bizId:{}", (Object)reqDto, (Object)bizId);
        Integer selectMode = reqDto.getSelectMode();
        ArrayList customers = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)selectMode) && 1 == selectMode) {
            List<CallTaskRespDto> details = this.detail(reqDto);
            Preconditions.checkArgument((!CollectionUtils.isEmpty(details) ? 1 : 0) != 0, (Object)"\u6240\u9009\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            if (!CollectionUtils.isEmpty(details)) {
                for (CallTaskRespDto respDto : details) {
                    CustomerDto dto = new CustomerDto();
                    dto.setPhone(respDto.getCustomerPhone());
                    dto.setName(respDto.getCustomerName());
                    customers.add(dto);
                }
            }
        } else {
            List<Long> callTaskDetailId = reqDto.getCallTaskDetailId();
            Preconditions.checkArgument((!CollectionUtils.isEmpty(callTaskDetailId) ? 1 : 0) != 0, (Object)"\u6240\u9009\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            CallTaskDetailCriteria taskDetailCriteria = new CallTaskDetailCriteria();
            taskDetailCriteria.createCriteria().andBizIdEqualTo(bizId).andIdIn(callTaskDetailId);
            List taskDetailList = this.callTaskDetailMapper.selectByExample((Object)taskDetailCriteria);
            if (!CollectionUtils.isEmpty((Collection)taskDetailList)) {
                for (CallTaskDetail taskDetail : taskDetailList) {
                    CustomerDto dto = new CustomerDto();
                    dto.setPhone(taskDetail.getPhone());
                    dto.setName(taskDetail.getName());
                    customers.add(dto);
                }
            }
        }
        log.info("phoneBatchId customers: {}", (Object)customers);
        return this.cachePhoneService.batchIdByCustomer((List)customers);
    }

    private File convert(String fileName) {
        String shell = "sudo ffmpeg -i %s -ar 8000 -ac 1 -b:a 128000 %s";
        String wavPath = "./importDir/call/" + this.idGen.getNum() + ".wav";
        shell = String.format(shell, fileName, wavPath);
        try {
            log.info("convert shell:{}", (Object)shell);
            Process ps = Runtime.getRuntime().exec(shell);
            int exitValue = ps.waitFor();
            if (0 != exitValue) {
                log.error("call shell failed. error code is :" + exitValue);
            }
        }
        catch (Exception e) {
            log.error("convert error fileName:{}", (Object)fileName, (Object)e);
            Thread.currentThread().interrupt();
        }
        log.info("convert mp3LocalPath:{}", (Object)wavPath);
        File file = new File(wavPath);
        return file;
    }

    public void saveFileFromInputStream(InputStream stream, String fileName) throws IOException {
        try (FileOutputStream fs = new FileOutputStream(fileName);){
            byte[] buffer = new byte[0x100000];
            int bytesum = 0;
            int byteread = 0;
            while ((byteread = stream.read(buffer)) != -1) {
                bytesum += byteread;
                fs.write(buffer, 0, byteread);
                fs.flush();
            }
            stream.close();
        }
    }

    @Override
    public List<CustomerDto> checkCreateVoice(CallTaskReqDto callTaskReq, Integer voiceNoticeSwitch) {
        if (YnEnum.NO.getValue().equals(voiceNoticeSwitch)) {
            return Lists.newArrayList();
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(callTaskReq), (Object)"\u8bed\u97f3\u901a\u77e5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List customers = callTaskReq.getCustomers();
        if (CollectionUtils.isEmpty(customers)) {
            customers = this.cachePhoneService.getCustomer(callTaskReq.getBatchId());
        }
        for (CustomerDto customer : customers) {
            String name = customer.getName();
            if (StringUtils.isNotBlank((CharSequence)name) && name.length() > 20) {
                customer.setName(name.substring(0, 20));
            }
            Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)customer.getPhone()), (Object)"\u624b\u673a\u53f7\u4e0d\u89c4\u8303");
        }
        return customers;
    }

    @Override
    public CallTask selectByTaskId(Long taskId) {
        return (CallTask)this.callTaskMapper.selectByPrimaryKey((Object)taskId);
    }

    @Override
    public void deleteUnUsedTaskDetail(CallTask callTask) {
        if (Objects.isNull(callTask)) {
            return;
        }
        this.callTaskMapper.delete((Object)callTask);
        CallTaskDetailCriteria delCriteria = new CallTaskDetailCriteria();
        delCriteria.createCriteria().andBizIdEqualTo(LoginUtils.getCurrentUserBizId()).andCallTaskIdEqualTo(callTask.getId());
        this.callTaskDetailMapper.deleteByFilter(delCriteria);
    }
}

