/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.CallConfig;
import com.kuaike.scrm.call.dto.CallOutDto;
import com.kuaike.scrm.call.dto.req.CallBackReqDto;
import com.kuaike.scrm.call.dto.req.CallRecordReqDto;
import com.kuaike.scrm.call.dto.req.CallReqDto;
import com.kuaike.scrm.call.dto.resp.CallRecordRespDto;
import com.kuaike.scrm.call.enums.ApiTypeEnum;
import com.kuaike.scrm.call.enums.CallOutTypeEnum;
import com.kuaike.scrm.call.enums.StatusEnum;
import com.kuaike.scrm.call.enums.VoiceCallStatusEnum;
import com.kuaike.scrm.call.enums.VoiceSmsNoticeTypeEnum;
import com.kuaike.scrm.call.factory.CallOutFacade;
import com.kuaike.scrm.call.service.CallCommonService;
import com.kuaike.scrm.call.service.CallRecordService;
import com.kuaike.scrm.call.service.CallTaskService;
import com.kuaike.scrm.common.dto.CommonKafkaMsg;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.enums.voicecall.VoiceMaterialTypeEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.CachePhoneService;
import com.kuaike.scrm.common.service.CustomerDetailSupportService;
import com.kuaike.scrm.common.service.FollowRecordMsgService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.SopTaskStatusService;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.service.dto.FollowRecordMsg;
import com.kuaike.scrm.common.service.dto.req.ScrmSendSmsReqDto;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.call.dto.CallRecordQueryParams;
import com.kuaike.scrm.dal.call.entity.CallMember;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallRecordCriteria;
import com.kuaike.scrm.dal.call.entity.CallTask;
import com.kuaike.scrm.dal.call.entity.CallTaskDetail;
import com.kuaike.scrm.dal.call.entity.SmsNoticeContent;
import com.kuaike.scrm.dal.call.mapper.CallMemberMapper;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskDetailMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskMapper;
import com.kuaike.scrm.sms.service.SmsTaskService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CallRecordServiceImpl
extends CallCommonService
implements CallRecordService {
    private static final Logger log = LoggerFactory.getLogger(CallRecordServiceImpl.class);
    @Value(value="${app.call.getVoiceUrl}")
    private String getVoiceUrl;
    @Value(value="${app.call.signInOrOutUrl}")
    private String signInOrOutUrl;
    @Value(value="${app.call.rlExtenListUrl}")
    private String rlExtenListUrl;
    @Value(value="${app.call.answerRegisterUrl}")
    private String answerRegisterUrl;
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Value(value="${app.call.memberInfoUrl}")
    private String memberInfoUrl;
    @Value(value="${app.call.getCallSessionIdUrl}")
    private String getCallSessionIdUrl;
    @Value(value="${app.account.getBalanceUrl}")
    private String getBalanceUrl;
    @Autowired
    private IdGen idGen;
    @Resource
    private CallRecordMapper callRecordMapper;
    @Resource
    private CallMemberMapper callMemberMapper;
    @Resource
    private CallTaskDetailMapper callTaskDetailMapper;
    @Autowired
    private CallTaskService callTaskService;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private CachePhoneService cachePhoneService;
    @Resource
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private CallOutFacade callOutFacade;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private FollowRecordMsgService followRecordMsgService;
    @Resource
    private CallTaskMapper callTaskMapper;
    @Resource
    private SmsTaskService smsTaskService;
    @Autowired
    private CustomerDetailSupportService customerDetailSupportService;
    @Value(value="${kafka.topic.scrm_common_msg}")
    private String topic;
    @Autowired
    private SopTaskStatusService sopTaskStatusService;

    public CallRecordServiceImpl(UserRoleCommonService userRoleCommonService, ScrmUserService scrmUserService, NodeService nodeService) {
        this.userRoleCommonService = userRoleCommonService;
        this.scrmUserService = scrmUserService;
        this.nodeService = nodeService;
    }

    @Override
    public List<CallRecordRespDto> list(CallRecordReqDto reqDto) {
        boolean mobileEncrypt;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateListParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        log.info("call list reqDto:{}, bizId:{}", (Object)reqDto, (Object)bizId);
        CallRecordQueryParams params = reqDto.to(bizId);
        Collection<Long> userIds = this.getManageUserIds(bizId, reqDto.getNodeId(), reqDto.getUserId());
        params.setUserIds(userIds);
        List records = this.callRecordMapper.queryList(params);
        String paramValue = this.settingService.getSettingDetail(bizId, SettingEnum.MOBILE_ENCRYPT.getName());
        boolean bl = mobileEncrypt = paramValue != null && paramValue.equals("1");
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.callRecordMapper.queryCount(params)));
        }
        ArrayList<CallRecordRespDto> resultList = new ArrayList<CallRecordRespDto>();
        List mobiles = records.stream().map(CallRecord::getCustomerPhone).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List<Long> nodeIds = records.stream().map(CallRecord::getNodeId).filter(Objects::nonNull).collect(Collectors.toList());
            Map<Long, String> nodePNameMap = this.nodePName(bizId, nodeIds);
            for (CallRecord callRecord : records) {
                callRecord.setOrgName(nodePNameMap.get(callRecord.getNodeId()));
                String customerPhone = callRecord.getCustomerPhone();
                CallRecordRespDto respDto = CallRecordRespDto.from(callRecord, mobileEncrypt);
                respDto.setPhone(customerPhone);
                resultList.add(respDto);
            }
            this.customerDetailSupportService.setCustomerDetailParams(bizId, mobiles, resultList);
        }
        return resultList;
    }

    @Override
    public CallRecordRespDto detail() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = currentUser.getBizId();
        Long userId = currentUser.getId();
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        boolean isCallMember = !ObjectUtils.isEmpty((Object)callMember);
        CallRecordRespDto callRecordRespDto = null;
        if (isCallMember) {
            Map<String, String> params;
            JSONObject jsonObject;
            JSONObject exten;
            CallConfig callConfig;
            CallRecordQueryParams queryParams = new CallRecordQueryParams();
            queryParams.setBizId(bizId);
            queryParams.setUserId(userId);
            CallRecord callRecord = this.callRecordMapper.lastCall(queryParams);
            if (!ObjectUtils.isEmpty((Object)callRecord)) {
                callRecordRespDto = CallRecordRespDto.from(callRecord, false);
            }
            if ((callConfig = this.callConfig(bizId)).getSupplierType() != null && callConfig.getSupplierType().intValue() == CallOutTypeEnum.RONG_LIAN.getValue() && ((exten = (jsonObject = this.bjyPartnerService.bjyPost(bizId, this.memberInfoUrl, params = this.getExtenInfoParams(userId))).getJSONObject("data").getJSONObject("exten")) == null || exten.isEmpty())) {
                isCallMember = false;
            }
        }
        if (callRecordRespDto == null) {
            callRecordRespDto = new CallRecordRespDto();
        }
        callRecordRespDto.setCallMember(isCallMember);
        return callRecordRespDto;
    }

    @Override
    public CallRecordRespDto call(CallRecordReqDto reqDto) {
        String name;
        String phone;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateCallParams(currentUser);
        Long bizId = currentUser.getBizId();
        Long userId = currentUser.getId();
        log.info("call reqDto:{}, bizId:{}", (Object)reqDto, (Object)bizId);
        CallTaskDetail taskDetail = null;
        if (!ObjectUtils.isEmpty((Object)reqDto.getDetailId())) {
            Long detailId = reqDto.getDetailId();
            taskDetail = (CallTaskDetail)this.callTaskDetailMapper.selectByPrimaryKey((Object)CallTaskDetail.builder().bizId(bizId).id(detailId).build());
            Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)taskDetail) ? 1 : 0) != 0, (Object)"\u65e0\u5ba2\u6237\u8bb0\u5f55");
            phone = StringUtils.isEmpty((CharSequence)reqDto.getPhone()) ? taskDetail.getPhone() : reqDto.getPhone();
            log.info("\u6279\u91cf\u5916\u547c,detailId:{},phone:{}", (Object)detailId, (Object)phone);
            name = StringUtils.isEmpty((CharSequence)reqDto.getName()) ? taskDetail.getName() : reqDto.getName();
        } else if (!StringUtils.isEmpty((CharSequence)reqDto.getPhone())) {
            phone = reqDto.getPhone();
            log.info("\u8f6f\u7535\u8bdd\u6761,phone:{}", (Object)phone);
            name = reqDto.getName();
        } else {
            List customers = this.cachePhoneService.getCustomer(reqDto.getBatchId());
            Preconditions.checkArgument((!CollectionUtils.isEmpty((Collection)customers) ? 1 : 0) != 0, (Object)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            CustomerDto customerDto = (CustomerDto)customers.get(0);
            log.info("\u70b9\u5bf9\u70b9\u5916\u547c,customerDto:{}", (Object)customerDto);
            phone = customerDto.getPhone();
            name = customerDto.getName();
        }
        CallConfig callConfig = this.callConfig(bizId);
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)callMember) ? 1 : 0) != 0, (Object)"\u60a8\u5c1a\u672a\u5f00\u901a\u5916\u547c\u6743\u9650");
        String memberPhone = callMember.getPhone();
        Preconditions.checkArgument((!phone.equals(memberPhone) ? 1 : 0) != 0, (Object)"\u4e3b\u53eb\u548c\u88ab\u53eb\u53f7\u7801\u76f8\u540c");
        String callType = StringUtils.isBlank((CharSequence)reqDto.getCallType()) ? ApiTypeEnum.LOCAL.getName() : reqDto.getCallType();
        CallOutDto callOutDto = CallOutDto.builder().bizId(bizId).phone(phone).userPhone(memberPhone).userId(member.getUserId()).callType(callType).callConfig(callConfig).sessionId(reqDto.getSessionId()).build();
        String apiCallId = this.callOutFacade.call(callOutDto);
        CallRecord callRecord = reqDto.backward(currentUser, this.idGen.getNum(), phone, name, memberPhone, apiCallId, callType);
        this.callRecordMapper.insert((Object)callRecord);
        this.followRecordMsgService.followRecordToKafka(FollowRecordMsg.fromCallRecord((CallRecord)callRecord));
        if (taskDetail != null) {
            taskDetail.setCallCount(Integer.valueOf(taskDetail.getCallCount() + 1));
            taskDetail.setLastCallRecordId(callRecord.getId());
            taskDetail.setLastCallTime(callRecord.getCreateTime());
            taskDetail.setUpdateTime(new Date());
            this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)taskDetail);
            this.callTaskService.updateProgress(taskDetail.getCallTaskId());
            this.sopTaskStatusService.sendSopTaskStatusMsg(taskDetail.getCallTaskId(), taskDetail.getId(), SopTaskType.CALL, taskDetail.getPhone(), Integer.valueOf(TaskRunStatusEnum.EXECUTED.getStatus()), null, callRecord.getCreateTime());
        }
        return CallRecordRespDto.builder().num(callRecord.getNum()).apiCallId(apiCallId).customerPhone(phone).build();
    }

    @Override
    public String call(Long bizId, String userNum, String mobile, String sessionId) {
        Integer apiType;
        String callType;
        log.info("call, bizId={}, userNum={}, mobile={}, sessionId={}", new Object[]{bizId, userNum, mobile, sessionId});
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            callType = "webrtc";
            apiType = ApiTypeEnum.SIP.getValue();
        } else {
            callType = "local";
            apiType = ApiTypeEnum.LOCAL.getValue();
        }
        Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)mobile), (Object)"\u624b\u673a\u53f7\u4e0d\u89c4\u8303");
        Long userId = this.scrmUserService.getIdByNum(userNum);
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        CallConfig callConfig = this.callConfig(bizId);
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)callMember) ? 1 : 0) != 0, (Object)"\u60a8\u5c1a\u672a\u5f00\u901a\u5916\u547c\u6743\u9650");
        String memberPhone = callMember.getPhone();
        Preconditions.checkArgument((!mobile.equals(memberPhone) ? 1 : 0) != 0, (Object)"\u4e3b\u53eb\u548c\u88ab\u53eb\u53f7\u7801\u76f8\u540c");
        CallOutDto callOutDto = CallOutDto.builder().bizId(bizId).phone(mobile).userPhone(memberPhone).userId(member.getUserId()).callType(callType).callConfig(callConfig).sessionId(sessionId).build();
        String apiCallId = this.callOutFacade.getInstance(bizId).call(callOutDto);
        String num = this.idGen.getNum();
        UserSimpleInfo user = this.scrmUserService.getById(userId);
        CallRecord callRecord = CallRecord.builder().num(num).bizId(bizId).corpId(callMember.getCorpId()).customerName("").customerPhone(mobile).userType(Integer.valueOf(0)).apiType(apiType).callTaskDetailId(null).apiCallId(apiCallId).userId(userId).userPhone(memberPhone).type(Integer.valueOf(0)).status(Integer.valueOf(0)).canceled(Integer.valueOf(0)).isOpenapi(Integer.valueOf(1)).nodeId(Long.valueOf(Objects.isNull(user.getNodeId()) ? -1L : user.getNodeId())).createTime(new Date()).createBy(userId).updateTime(new Date()).updateBy(userId).build();
        this.callRecordMapper.insert((Object)callRecord);
        this.followRecordMsgService.followRecordToKafka(FollowRecordMsg.fromCallRecord((CallRecord)callRecord));
        return num;
    }

    @Override
    public String playVoice(CallRecordReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateIdParams(currentUser);
        Long bizId = currentUser.getBizId();
        log.info("playVoice{} reqDto:{}, bizId:{}", new Object[]{currentUser.getId(), reqDto, bizId});
        Long id = reqDto.getId();
        String voiceUrl = reqDto.getVoiceUrl();
        if (StringUtils.isBlank((CharSequence)voiceUrl)) {
            CallRecord callRecord = (CallRecord)this.callRecordMapper.selectByPrimaryKey((Object)CallRecord.builder().bizId(bizId).id(id).build());
            if (ObjectUtils.isEmpty((Object)callRecord)) {
                return "";
            }
            voiceUrl = callRecord.getVoiceUrl();
        }
        if (StringUtils.isEmpty((CharSequence)voiceUrl)) {
            return "";
        }
        return this.getFullVoiceUrl(bizId, voiceUrl);
    }

    @Override
    public String getFullVoiceUrl(Long bizId, String voiceUrl) {
        Map<String, String> params = this.getVoiceParams(voiceUrl);
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.getVoiceUrl, params);
        return jsonObject.getJSONObject("data").getString("full_voice_url");
    }

    @Override
    public void callback(CallBackReqDto reqDto) {
        CallTaskDetail callTaskDetail;
        reqDto.validateCallbackParams();
        log.info("callback reqDto:{}", (Object)reqDto);
        CallRecord item = this.callOutFacade.callback(reqDto);
        if (ObjectUtils.isEmpty((Object)item)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)item.getNum())) {
            return;
        }
        CommonKafkaMsg msg = new CommonKafkaMsg();
        msg.setSys("scrm");
        msg.setType("call_record_callback");
        msg.setBizId(item.getBizId());
        msg.setCorpId(item.getCorpId());
        msg.setKey(item.getNum());
        msg.setData(JacksonUtil.obj2Str((Object)item));
        this.kafkaTemplate.send(this.topic, (Object)JacksonUtil.obj2Str((Object)msg));
        log.info("call record item:{}", (Object)item);
        Long subTaskId = item.getCallTaskDetailId();
        if (subTaskId != null && (callTaskDetail = (CallTaskDetail)this.callTaskDetailMapper.selectByPrimaryKey((Object)subTaskId)) != null && item.getUserType().intValue() == CallTypeEnum.MANUAL.getValue()) {
            Long taskId = callTaskDetail.getCallTaskId();
            if (item.getStatus() == 1) {
                this.sopTaskStatusService.sendSopTaskStatusMsg(taskId, subTaskId, SopTaskType.CALL, item.getCustomerPhone(), Integer.valueOf(TaskRunStatusEnum.SUCCESS.getStatus()), null, null);
            } else {
                this.sopTaskStatusService.sendSopTaskStatusMsg(taskId, subTaskId, SopTaskType.CALL, item.getCustomerPhone(), Integer.valueOf(TaskRunStatusEnum.EXECUTED.getStatus()), null, item.getCreateTime());
            }
        }
    }

    @Override
    public void voiceCallback(CallBackReqDto reqDto) {
        CallTaskDetail taskDetail;
        reqDto.validateCallbackParams();
        log.info("voiceCallback reqDto:{}", (Object)reqDto);
        String sessionId = reqDto.getSessionId();
        String voiceUrl = reqDto.getVoiceUrl();
        CallRecord item = new CallRecord();
        item.setUpdateBy(Long.valueOf(-1L));
        item.setUpdateTime(new Date());
        CallRecordCriteria criteria = new CallRecordCriteria();
        criteria.createCriteria().andApiCallIdEqualTo(sessionId);
        CallRecord callRecord = (CallRecord)this.callRecordMapper.selectOne((Object)CallRecord.builder().apiCallId(sessionId).build());
        if (ObjectUtils.isEmpty((Object)callRecord)) {
            return;
        }
        item.setVoiceUrl(voiceUrl);
        this.callRecordMapper.updateByExampleSelective((Object)item, (Object)criteria);
        if (!ObjectUtils.isEmpty((Object)callRecord.getCallTaskDetailId()) && !ObjectUtils.isEmpty((Object)(taskDetail = (CallTaskDetail)this.callTaskDetailMapper.selectByPrimaryKey((Object)CallTaskDetail.builder().id(callRecord.getCallTaskDetailId()).build())))) {
            taskDetail.setLastCallVoiceUrl(voiceUrl);
            taskDetail.setUpdateTime(new Date());
            this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)taskDetail);
        }
        CommonKafkaMsg msg = new CommonKafkaMsg();
        msg.setSys("scrm");
        msg.setType("call_voice_callback");
        msg.setBizId(callRecord.getBizId());
        msg.setCorpId(callRecord.getCorpId());
        msg.setKey(callRecord.getNum());
        String fullVoiceUrl = this.getFullVoiceUrl(callRecord.getBizId(), voiceUrl);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", callRecord.getNum());
        data.put("voiceUrl", fullVoiceUrl);
        data.put("isOpenApi", callRecord.getIsOpenapi());
        msg.setData(JacksonUtil.obj2Str(data));
        this.kafkaTemplate.send(this.topic, (Object)JacksonUtil.obj2Str((Object)msg));
    }

    @Override
    public void voiceBroadcastCallback(CallBackReqDto reqDto) {
        CallTaskDetail taskDetail;
        long l;
        reqDto.validateCallbackParams();
        log.info("voiceBroadcastCallback reqDto:{}", (Object)reqDto);
        String sessionId = reqDto.getSessionId();
        CallRecord callRecord = (CallRecord)this.callRecordMapper.selectOne((Object)CallRecord.builder().apiCallId(sessionId).build());
        if (ObjectUtils.isEmpty((Object)callRecord)) {
            return;
        }
        Integer callStatus = reqDto.getCallStatus();
        if (callStatus == null) {
            log.warn("voiceBroadcastCallback callStatus is null");
            return;
        }
        if (callRecord.getStatus().intValue() == StatusEnum.SUCCESS.getValue()) {
            if (callStatus.intValue() != StatusEnum.SUCCESS.getValue()) {
                log.info("voiceBroadcastCallback \u6570\u636e\u5e93\u4e2d\u72b6\u6001\u662f\u6210\u529f\uff0c\u56de\u8c03\u6570\u636e\u4e2d\u4e0d\u662f\u6210\u529f \u8fc7\u6ee4");
                return;
            }
            if (reqDto.getAirtime() != null && reqDto.getAirtime().equals(0)) {
                log.info("voiceBroadcastCallback \u6570\u636e\u5e93\u4e2d\u72b6\u6001\u662f\u6210\u529f\uff0c\u56de\u8c03\u6570\u636e\u4e2d\u662f\u6210\u529f \u4e14 \u56de\u8c03\u6570\u636e\u4e2dduration=0 \u8fc7\u6ee4");
                return;
            }
        }
        CallRecord item = new CallRecord();
        BeanUtils.copyProperties((Object)callRecord, (Object)item);
        item.setUpdateBy(Long.valueOf(-1L));
        item.setUpdateTime(new Date());
        CallRecordCriteria criteria = new CallRecordCriteria();
        criteria.createCriteria().andApiCallIdEqualTo(sessionId);
        int ringingDuration = 0;
        String alertingTime = reqDto.getAlertingTime();
        String answerTime = reqDto.getAnswerTime();
        String endTime = reqDto.getEndTime();
        if (callStatus == 1) {
            if (!StringUtils.isEmpty((CharSequence)alertingTime) && !StringUtils.isEmpty((CharSequence)answerTime)) {
                l = DateUtil.compareDateSecond((String)alertingTime, (String)answerTime);
                ringingDuration = Math.toIntExact(l / 1000L);
            }
        } else if (!StringUtils.isEmpty((CharSequence)alertingTime) && !StringUtils.isEmpty((CharSequence)endTime)) {
            l = DateUtil.compareDateSecond((String)reqDto.getAlertingTime(), (String)reqDto.getEndTime());
            ringingDuration = Math.toIntExact(l / 1000L);
        }
        item.setMiddlePhone(reqDto.getBindNbr());
        item.setRingingDuration(Integer.valueOf(ringingDuration));
        item.setCallDuration(reqDto.getAirtime());
        item.setBillCallDuration(Integer.valueOf((int)Math.ceil((double)item.getCallDuration().intValue() / 60.0)));
        item.setStatus(callStatus);
        item.setStartTime(DateUtil.getDate((String)answerTime, (String)"yyyy-MM-dd HH:mm:ss"));
        item.setEndTime(DateUtil.getDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
        this.callRecordMapper.updateByExampleSelective((Object)item, (Object)criteria);
        if (!ObjectUtils.isEmpty((Object)callRecord.getCallTaskDetailId()) && !ObjectUtils.isEmpty((Object)(taskDetail = (CallTaskDetail)this.callTaskDetailMapper.selectByPrimaryKey((Object)CallTaskDetail.builder().id(callRecord.getCallTaskDetailId()).build())))) {
            taskDetail.setLastCallStatus(callStatus);
            taskDetail.setUpdateTime(new Date());
            if (callStatus.intValue() == StatusEnum.SUCCESS.getValue()) {
                taskDetail.setCallSuccessCount(Integer.valueOf(taskDetail.getCallSuccessCount() + 1));
            }
            taskDetail.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.COMPLETED.getValue()));
            this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)taskDetail);
        }
        if (callRecord.getIsOpenapi() == 0) {
            try {
                this.handleVoiceCallSmsNotice(callRecord, item.getStatus());
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u8bed\u97f3\u5916\u547c\u77ed\u4fe1\u63d0\u9192\u5f02\u5e38", (Throwable)e);
            }
        }
        item.setCreateTime(callRecord.getCreateTime());
        item.setExecuteTime(DateUtil.getDate((String)reqDto.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (StatusEnum.SUCCESS.getValue() == item.getStatus().intValue() || StatusEnum.LINK.getValue() == item.getStatus().intValue()) {
            item.setCallStatus("SUCCESS");
            item.setErrCode("SUCCESS");
            item.setErrDesc("\u6210\u529f");
        } else {
            item.setCallStatus("FAIL");
            StatusEnum statusEnum = StatusEnum.get(item.getStatus());
            if (statusEnum != null) {
                item.setErrCode(statusEnum.getCode());
                item.setErrDesc(statusEnum.getDesc());
            }
        }
        if (CallTypeEnum.VOICE.getValue() == callRecord.getUserType().intValue()) {
            if (callRecord.getVoiceUrl().startsWith("https://") || callRecord.getVoiceUrl().startsWith("http://")) {
                item.setVoiceType(Integer.valueOf(VoiceMaterialTypeEnum.VOICE.getValue()));
            } else {
                item.setVoiceType(Integer.valueOf(VoiceMaterialTypeEnum.TEXT.getValue()));
            }
        }
        CommonKafkaMsg msg = new CommonKafkaMsg();
        msg.setSys("scrm");
        msg.setType("call_voice_broadcast_callback");
        msg.setBizId(item.getBizId());
        msg.setCorpId(item.getCorpId());
        msg.setKey(item.getNum());
        msg.setData(JacksonUtil.obj2Str((Object)item));
        log.info("voiceBroadcastCallback topic msg:{}", (Object)msg);
        this.kafkaTemplate.send(this.topic, (Object)JacksonUtil.obj2Str((Object)msg));
    }

    private CallTask getCallTaskByRecord(CallRecord callRecord) {
        Long callTaskDetailId = callRecord.getCallTaskDetailId();
        if (callTaskDetailId == null) {
            return null;
        }
        CallTaskDetail callTaskDetail = (CallTaskDetail)this.callTaskDetailMapper.selectByPrimaryKey((Object)callTaskDetailId);
        if (callTaskDetail == null) {
            log.info("getCallTaskByRecord callTaskDetail is null");
            return null;
        }
        return (CallTask)this.callTaskMapper.selectByPrimaryKey((Object)callTaskDetail.getCallTaskId());
    }

    private void handleVoiceCallSmsNotice(CallRecord callRecord, Integer callStatus) {
        log.info("handleVoiceCallSmsNotice callStatus:{} , callRecord:{}", (Object)callStatus, (Object)callRecord);
        if (StatusEnum.START.getValue() == callStatus.intValue()) {
            return;
        }
        CallTask callTask = this.getCallTaskByRecord(callRecord);
        if (callTask == null) {
            log.info("handleVoiceCallSmsNotice callTask is null");
            return;
        }
        log.info("handleVoiceCallSmsNotice callTask:{}", (Object)callTask);
        if (CallTypeEnum.VOICE.getValue() != callTask.getType().intValue()) {
            return;
        }
        if (callTask.getSmsNotice() == null || callTask.getSmsNotice() != 1) {
            return;
        }
        SmsNoticeContent smsNoticeContent = (SmsNoticeContent)JSON.parseObject((String)callTask.getSmsNoticeContent(), SmsNoticeContent.class);
        if (smsNoticeContent == null) {
            return;
        }
        VoiceSmsNoticeTypeEnum voiceSmsNoticeTypeEnum = VoiceSmsNoticeTypeEnum.get(smsNoticeContent.getSmsNoticeType());
        if (voiceSmsNoticeTypeEnum == null) {
            return;
        }
        if (VoiceSmsNoticeTypeEnum.ALL.equals((Object)voiceSmsNoticeTypeEnum)) {
            this.sendSms(callRecord, smsNoticeContent.getSmsId());
        } else {
            boolean isLink;
            boolean bl = isLink = StatusEnum.SUCCESS.getValue() == callStatus.intValue() || StatusEnum.LINK.getValue() == callStatus.intValue();
            if (VoiceSmsNoticeTypeEnum.LINK.equals((Object)voiceSmsNoticeTypeEnum) && isLink || VoiceSmsNoticeTypeEnum.UN_LINK.equals((Object)voiceSmsNoticeTypeEnum) && !isLink) {
                this.sendSms(callRecord, smsNoticeContent.getSmsId());
            }
        }
    }

    private void sendSms(CallRecord callRecord, Long smsId) {
        ScrmSendSmsReqDto params = new ScrmSendSmsReqDto();
        params.setBizId(callRecord.getBizId());
        params.setCorpId(callRecord.getCorpId());
        params.setUserId(callRecord.getUserId());
        params.setMobile(callRecord.getCustomerPhone());
        params.setName(callRecord.getCustomerName());
        params.setTemplateId(smsId);
        Long id = null;
        try {
            id = this.smsTaskService.sendCustomSmsByTemplateId(params);
        }
        catch (Exception e) {
            log.error("handleVoiceCallSmsNotice \u53d1\u9001\u77ed\u4fe1\u5f02\u5e38", (Throwable)e);
        }
        log.info("handleVoiceCallSmsNotice,\u53d1\u9001\u77ed\u4fe1,params:{},id:{}", (Object)params, (Object)id);
    }

    @Override
    public List<CallRecordRespDto> called(CallRecordReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateCalledParams(currentUser);
        Long bizId = currentUser.getBizId();
        log.info("called reqDto:{}, bizId:{}", (Object)reqDto, (Object)bizId);
        CallRecordQueryParams params = reqDto.to(bizId);
        List records = this.callRecordMapper.calledList(params);
        ArrayList<CallRecordRespDto> resultList = new ArrayList<CallRecordRespDto>();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            for (CallRecord callRecord : records) {
                resultList.add(CallRecordRespDto.from(callRecord, false));
            }
        }
        return resultList;
    }

    @Override
    public void cancel() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUser), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.callConfig(currentUser.getBizId());
        this.callOutFacade.cancel(currentUser);
    }

    @Override
    public void switchExtenType(CallReqDto reqDto) {
        log.info("switchExtenType reqDto:{}", (Object)reqDto);
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long userId = LoginUtils.getCurrentUserId();
        Preconditions.checkArgument((boolean)Objects.nonNull(reqDto), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String extenType = reqDto.getExtenType();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)extenType), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CallConfig callConfig = this.callConfig(bizId);
        Preconditions.checkArgument((callConfig.getSupplierType().intValue() == CallOutTypeEnum.RONG_LIAN.getValue() ? 1 : 0) != 0, (Object)"\u4f9b\u5e94\u5546\u4e0d\u652f\u6301\u5207\u6362");
        Preconditions.checkArgument((boolean)callConfig.getWayType().contains(","), (Object)"\u4e0d\u652f\u6301\u5207\u6362\u5916\u547c\u6a21\u5f0f");
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        callConfig.getAccountInfo().setDefaultExtenType(extenType);
        bindings.setUpdateBy(userId);
        bindings.setUpdateTime(new Date());
        bindings.setConfigJson(JacksonUtil.obj2Str((Object)callConfig));
        this.bindingsMapper.updateByPrimaryKeySelective((Object)bindings);
    }

    @Override
    public void signInOrOut(CallReqDto reqDto, Long bizId, Long userId) {
        log.info("signInOrOut reqDto:{}", (Object)reqDto);
        Preconditions.checkArgument((boolean)Objects.nonNull(reqDto), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Integer signInType = reqDto.getSignInType();
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)signInType) ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("signInOrOut signInType:{}, bizId:{}", (Object)signInType, (Object)bizId);
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)callMember) ? 1 : 0) != 0, (Object)"\u60a8\u5c1a\u672a\u5f00\u901a\u5916\u547c\u6743\u9650");
        Map<String, String> params = this.getSignInOrOutParams(callMember.getExten(), signInType);
        this.bjyPartnerService.bjyPost(bizId, this.signInOrOutUrl, params);
        callMember.setExtenStatus(signInType);
        this.callMemberMapper.updateByPrimaryKeySelective((Object)callMember);
    }

    @Override
    public Object freeExten() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        Map<String, String> params = this.getRlExtenListParams();
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.rlExtenListUrl, params);
        return jsonObject.getJSONObject("data").getJSONArray("exten");
    }

    @Override
    public void inRegister(CallReqDto reqDto, Long bizId, Long userId) {
        log.info("inRegister reqDto:{}", (Object)reqDto);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getCallType()), (Object)"callType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getCallSheetId()), (Object)"callSheetId\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, String> params = this.getInRegisterParams(reqDto.getCallType(), reqDto.getCallSheetId());
        this.bjyPartnerService.bjyPost(bizId, this.answerRegisterUrl, params);
    }

    @Override
    public CallConfig callConfig(Long bizId) {
        CallConfig callConfig;
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        Preconditions.checkArgument((bindings != null && bindings.getIsOpen() == 1 ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u5c1a\u672a\u5f00\u901a\u5916\u547c\u529f\u80fd");
        String configJson = bindings.getConfigJson();
        try {
            callConfig = (CallConfig)JacksonUtil.str2Obj((String)configJson, CallConfig.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u89e3\u6790\u5916\u547c\u914d\u7f6e\u5f02\u5e38");
        }
        return callConfig;
    }

    @Override
    public String getCallSessionId(Long bizId, Long userId) {
        log.info("getCallSessionId");
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)callMember) ? 1 : 0) != 0, (Object)"\u60a8\u5c1a\u672a\u5f00\u901a\u5916\u547c\u6743\u9650");
        JSONObject account = this.bjyPartnerService.bjyPost(bizId, this.getBalanceUrl, (Map)Maps.newHashMap());
        long longValue = account.getJSONObject("data").getLongValue("left_total_money");
        Preconditions.checkArgument((longValue > 0L ? 1 : 0) != 0, (Object)"\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u524d\u5f80\u4f01\u4e1a\u94b1\u5305\u5145\u503c");
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.getCallSessionIdUrl, (Map)Maps.newHashMap());
        return jsonObject.getJSONObject("data").getString("session_id");
    }

    private Map<String, String> getVoiceParams(String url) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("voice_path", url);
        return result;
    }

    private Map<String, String> getSignInOrOutParams(String exten, Integer signInType) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("exten", exten);
        result.put("sign_in", String.valueOf(signInType));
        return result;
    }

    private Map<String, String> getInRegisterParams(String callType, String callSheetId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("call_type", callType);
        result.put("call_sheet_id", callSheetId);
        return result;
    }

    private Map<String, String> getRlExtenListParams() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("is_login", "1");
        result.put("busy_type", "0");
        return result;
    }

    private Map<String, String> getExtenInfoParams(Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("user_number", String.valueOf(userId));
        return result;
    }
}

