/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.call.dto.CallAccountConfig;
import com.kuaike.scrm.call.dto.req.CallAccountReqDto;
import com.kuaike.scrm.call.dto.req.CallAccountSeatReqDto;
import com.kuaike.scrm.call.dto.resp.CallAccountRespDto;
import com.kuaike.scrm.call.dto.resp.CallAccountSeatRespDto;
import com.kuaike.scrm.call.enums.ApiTypeEnum;
import com.kuaike.scrm.call.enums.CallOutTypeEnum;
import com.kuaike.scrm.call.service.CallAccountService;
import com.kuaike.scrm.common.enums.EnumDto;
import com.kuaike.scrm.common.enums.EnumService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.call.entity.CallAccount;
import com.kuaike.scrm.dal.call.entity.CallAccountCriteria;
import com.kuaike.scrm.dal.call.entity.CallAccountSeat;
import com.kuaike.scrm.dal.call.entity.CallAccountSeatCriteria;
import com.kuaike.scrm.dal.call.entity.CallAccountUsing;
import com.kuaike.scrm.dal.call.mapper.CallAccountMapper;
import com.kuaike.scrm.dal.call.mapper.CallAccountSeatMapper;
import com.kuaike.scrm.dal.call.mapper.CallAccountUsingMapper;
import com.kuaike.scrm.roc.dto.Staff;
import com.kuaike.scrm.roc.service.StaffService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CallAccountServiceImpl
implements CallAccountService {
    private static final Logger log = LoggerFactory.getLogger(CallAccountServiceImpl.class);
    private static final int HEADER_ROWS = 1;
    private static final int MAX_ROWS = 5000;
    private static final String HEADER_FIRST_CELL_STR = "\u5750\u5e2d\u7f16\u53f7\uff08\u5fc5\u586b\uff09";
    private static final String HEADER_SECOND_CELL_STR = "\u5916\u663e\u53f7\uff08\u5fc5\u586b\uff09";
    private static final String HEADER_THIRD_CELL_STR = "\u5f52\u5c5e\u5730\uff08\u5fc5\u586b\uff09";
    @Autowired
    private IdGen idGen;
    @Resource
    private CallAccountMapper callAccountMapper;
    @Resource
    private CallAccountUsingMapper callAccountUsingMapper;
    @Resource
    private CallAccountSeatMapper callAccountSeatMapper;
    @Resource
    private StaffService staffService;

    @Override
    public void add(CallAccountReqDto req) {
        CallAccount callAccount;
        CallAccountConfig callAccountConfig;
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("add call account staff AccountName: {}, name : {}\uff0c req:{} ", new Object[]{staff.getSAMAccountName(), staff.getName(), req});
        Preconditions.checkArgument((req.getSupplierType() != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u4f9b\u5e94\u5546\u7c7b\u578b\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getWayType() != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u6a21\u5f0f\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getConfigJson()), (Object)"\u5916\u547c\u914d\u7f6e\u4e3a\u7a7a");
        try {
            callAccountConfig = (CallAccountConfig)JacksonUtil.str2Obj((String)req.getConfigJson(), CallAccountConfig.class);
        }
        catch (IOException e) {
            log.error("parse config json failed, json:{}", (Object)req.getConfigJson(), (Object)e);
            throw new IllegalArgumentException("\u5916\u547c\u914d\u7f6e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790\u3002");
        }
        if (req.getSupplierType().intValue() == CallOutTypeEnum.RONG_LIAN.getValue() || req.getSupplierType().intValue() == CallOutTypeEnum.ZHONG_TONG.getValue()) {
            log.info("add call account callAccountConfig:{} ", (Object)callAccountConfig);
            callAccount = CallAccount.builder().supplierType(req.getSupplierType()).wayType(req.getWayType()).wayAccount(callAccountConfig.getAccountName()).build();
        } else {
            callAccount = req.getSupplierType().intValue() == CallOutTypeEnum.RONG_YING.getValue() ? CallAccount.builder().supplierType(req.getSupplierType()).wayType(req.getWayType()).wayAccount(callAccountConfig.getAppId()).build() : CallAccount.builder().supplierType(req.getSupplierType()).wayType(req.getWayType()).wayAccount(callAccountConfig.getCallLine()).build();
        }
        if (StringUtils.isBlank((CharSequence)callAccount.getWayAccount()) && !req.getSupplierType().equals(CallOutTypeEnum.ZHONG_TONG.getValue())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5916\u547c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CallAccount exist = (CallAccount)this.callAccountMapper.selectOne((Object)callAccount);
        Preconditions.checkArgument((exist == null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u5df2\u5b58\u5728");
        callAccount.setNum(this.idGen.getNum());
        callAccount.setConfigJson(req.getConfigJson());
        callAccount.setCreateTime(new Date());
        callAccount.setUpdateTime(new Date());
        callAccount.setCreateBy(staff.getSAMAccountName());
        callAccount.setUpdateBy(staff.getSAMAccountName());
        this.callAccountMapper.insertSelective((Object)callAccount);
    }

    @Override
    public void mod(CallAccountReqDto req) {
        CallAccountConfig callAccountConfig;
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("mod call account staff AccountName: {}, name : {}\uff0c req:{} ", new Object[]{staff.getSAMAccountName(), staff.getName(), req});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getNum()), (Object)"num\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getConfigJson()), (Object)"\u5916\u547c\u914d\u7f6e\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getSupplierType() != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u4f9b\u5e94\u5546\u7c7b\u578b\u4e3a\u7a7a");
        Preconditions.checkArgument((req.getWayType() != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u6a21\u5f0f\u4e3a\u7a7a");
        CallAccount callAccount = (CallAccount)this.callAccountMapper.selectOne((Object)CallAccount.builder().num(req.getNum()).build());
        Preconditions.checkArgument((callAccount != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u4e0d\u5b58\u5728");
        if (req.getSupplierType() != callAccount.getSupplierType() || req.getWayType() != callAccount.getWayType()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5916\u547c\u670d\u52a1\u5546\u548c\u6a21\u5f0f\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        try {
            callAccountConfig = (CallAccountConfig)JacksonUtil.str2Obj((String)req.getConfigJson(), CallAccountConfig.class);
        }
        catch (IOException e) {
            log.error("parse config json failed, json:{}", (Object)req.getConfigJson(), (Object)e);
            throw new IllegalArgumentException("\u5916\u547c\u914d\u7f6e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790\u3002");
        }
        log.info("mod call account callAccountConfig:{} ", (Object)callAccountConfig);
        if (req.getSupplierType().intValue() == CallOutTypeEnum.RONG_LIAN.getValue() || req.getSupplierType().intValue() == CallOutTypeEnum.ZHONG_TONG.getValue()) {
            if (!callAccountConfig.getAccountName().equals(callAccount.getWayAccount())) {
                CallAccount callAccountQuery = CallAccount.builder().supplierType(req.getSupplierType()).wayAccount(callAccountConfig.getAccountName()).wayType(req.getWayType()).build();
                CallAccount exist = (CallAccount)this.callAccountMapper.selectOne((Object)callAccountQuery);
                Preconditions.checkArgument((exist == null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u5df2\u5b58\u5728");
                callAccount.setWayAccount(callAccountConfig.getAccountName());
            }
        } else if (req.getSupplierType().intValue() == CallOutTypeEnum.RONG_YING.getValue()) {
            if (!callAccountConfig.getAppId().equals(callAccount.getWayAccount())) {
                CallAccount callAccountQuery = CallAccount.builder().supplierType(req.getSupplierType()).wayAccount(callAccountConfig.getAppId()).wayType(req.getWayType()).build();
                CallAccount exist = (CallAccount)this.callAccountMapper.selectOne((Object)callAccountQuery);
                Preconditions.checkArgument((exist == null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u5df2\u5b58\u5728");
                callAccount.setWayAccount(callAccountConfig.getAppId());
            }
        } else if (!callAccountConfig.getCallLine().equals(callAccount.getWayAccount())) {
            CallAccount callAccountQuery = CallAccount.builder().wayType(req.getWayType()).supplierType(req.getSupplierType()).wayAccount(callAccountConfig.getCallLine()).build();
            CallAccount exist = (CallAccount)this.callAccountMapper.selectOne((Object)callAccountQuery);
            Preconditions.checkArgument((exist == null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u5df2\u5b58\u5728");
            callAccount.setWayAccount(callAccountConfig.getCallLine());
        }
        callAccount.setUpdateBy(staff.getSAMAccountName());
        callAccount.setUpdateTime(new Date());
        callAccount.setConfigJson(req.getConfigJson());
        this.callAccountMapper.updateByPrimaryKeySelective((Object)callAccount);
    }

    @Override
    public List<CallAccountRespDto> list(CallAccountReqDto req) {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("call account list staff AccountName: {}, name : {}\uff0c req:{} ", new Object[]{staff.getSAMAccountName(), staff.getName(), req});
        CallAccountCriteria callAccountCriteria = new CallAccountCriteria();
        CallAccountCriteria.Criteria criteria = callAccountCriteria.createCriteria();
        criteria.andIsEnabledGreaterThanOrEqualTo(Integer.valueOf(0));
        if (req.getSupplierType() != null) {
            criteria.andSupplierTypeEqualTo(req.getSupplierType());
        }
        if (req.getAccount() != null) {
            criteria.andWayAccountLike(req.getAccount());
        }
        if (req.getWayType() != null) {
            criteria.andWayTypeEqualTo(req.getWayType());
        }
        if (req.getPageDto() == null) {
            List callAccountList = this.callAccountMapper.selectByExample((Object)callAccountCriteria);
            return this.buildCallAccountResultList(callAccountList);
        }
        Page page = PageHelper.startPage((int)req.getPageDto().getPageNum(), (int)req.getPageDto().getPageSize()).doSelectPage(() -> this.callAccountMapper.selectByExample((Object)callAccountCriteria));
        req.getPageDto().setCount(Integer.valueOf((int)page.getTotal()));
        return this.buildCallAccountResultList(page.getResult());
    }

    private List<CallAccountRespDto> buildCallAccountResultList(List<CallAccount> callAccountList) {
        if (CollectionUtils.isEmpty(callAccountList)) {
            return Collections.emptyList();
        }
        ArrayList accounts = Lists.newArrayList();
        for (CallAccount callAccount : callAccountList) {
            List usings = this.callAccountUsingMapper.select((Object)CallAccountUsing.builder().callAccountId(callAccount.getId()).build());
            List<String> names = usings.stream().map(CallAccountUsing::getBizName).collect(Collectors.toList());
            accounts.add(CallAccountRespDto.builder().num(callAccount.getNum()).supplierType(EnumDto.from((EnumService)CallOutTypeEnum.get(callAccount.getSupplierType()))).wayType(EnumDto.from((EnumService)ApiTypeEnum.get(callAccount.getWayType()))).configJson(callAccount.getConfigJson()).bizNameList(names).account(callAccount.getWayAccount()).build());
        }
        return accounts;
    }

    @Override
    public void enable(CallAccountReqDto req) {
        int isEnabled;
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("enable call account staff AccountName: {}, name : {}\uff0c req:{} ", new Object[]{staff.getSAMAccountName(), staff.getName(), req});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getNum()), (Object)"num\u4e3a\u7a7a");
        CallAccount callAccount = (CallAccount)this.callAccountMapper.selectOne((Object)CallAccount.builder().num(req.getNum()).build());
        Preconditions.checkArgument((callAccount != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u4e0d\u5b58\u5728");
        int n = isEnabled = callAccount.getIsEnabled() == 0 ? 1 : 0;
        if (isEnabled == 0) {
            int used = this.callAccountUsingMapper.selectCount((Object)CallAccountUsing.builder().callAccountId(callAccount.getId()).build());
            Preconditions.checkArgument((used <= 0 ? 1 : 0) != 0, (Object)"\u7ebf\u8def\u5df2\u88ab\u4f7f\u7528\uff0c\u9700\u8981\u7981\u7528\u8bf7\u79fb\u9664\u76f8\u5e94\u7684\u4f01\u4e1a\u914d\u7f6e\uff01");
        }
        callAccount.setIsEnabled(Integer.valueOf(isEnabled));
        callAccount.setUpdateTime(new Date());
        callAccount.setUpdateBy(staff.getSAMAccountName());
        this.callAccountMapper.updateByPrimaryKeySelective((Object)callAccount);
    }

    @Override
    public void delete(CallAccountReqDto req) {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("delete call account staff AccountName: {}, name : {}\uff0c req:{} ", new Object[]{staff.getSAMAccountName(), staff.getName(), req});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getNum()), (Object)"num\u4e3a\u7a7a");
        CallAccount callAccount = (CallAccount)this.callAccountMapper.selectOne((Object)CallAccount.builder().num(req.getNum()).build());
        Preconditions.checkArgument((callAccount != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u4e0d\u5b58\u5728");
        int used = this.callAccountUsingMapper.selectCount((Object)CallAccountUsing.builder().callAccountId(callAccount.getId()).build());
        Preconditions.checkArgument((used <= 0 ? 1 : 0) != 0, (Object)"\u7ebf\u8def\u5df2\u88ab\u4f7f\u7528\uff0c\u9700\u8981\u5220\u9664\u8bf7\u79fb\u9664\u76f8\u5e94\u7684\u4f01\u4e1a\u914d\u7f6e\uff01");
        this.callAccountMapper.delete((Object)callAccount);
    }

    @Override
    public List<CallAccountSeatRespDto> importSeat(InputStream in) {
        List<CallAccountSeatRespDto> seats;
        try {
            Workbook workbook = CallAccountServiceImpl.create(in);
            seats = this.parseExcel(workbook);
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return seats;
    }

    @Override
    public void addSeat(CallAccountSeatReqDto req) {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("addSeat staff AccountName: {}, name : {}\uff0c req:{} ", new Object[]{staff.getSAMAccountName(), staff.getName(), req});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getNum()), (Object)"num\u4e3a\u7a7a");
        CallAccount callAccount = (CallAccount)this.callAccountMapper.selectOne((Object)CallAccount.builder().num(req.getNum()).build());
        Preconditions.checkArgument((callAccount != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u4e0d\u5b58\u5728");
        List<CallAccountSeatRespDto> seats = req.getSeats();
        if (CollectionUtils.isEmpty(seats)) {
            return;
        }
        List addSeatNos = seats.stream().map(CallAccountSeatRespDto::getSeat).collect(Collectors.toList());
        List exists = this.callAccountSeatMapper.select((Object)CallAccountSeat.builder().callAccountId(callAccount.getId()).build());
        List seatNos = exists.stream().filter(seat -> seat.getOccupyBizId() != null).map(CallAccountSeat::getSeat).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(seatNos) && !addSeatNos.containsAll(seatNos)) {
            addSeatNos.retainAll(seatNos);
            seatNos.removeAll(addSeatNos);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, seatNos + "\u5750\u5e2d\u5df2\u88ab\u4f7f\u7528, \u8bf7\u91cd\u65b0\u5bfc\u5165");
        }
        this.callAccountSeatMapper.delete((Object)CallAccountSeat.builder().callAccountId(callAccount.getId()).build());
        ArrayList accountSeats = Lists.newArrayList();
        seats.forEach(seat -> accountSeats.add(CallAccountSeat.builder().num(this.idGen.getNum()).callAccountId(callAccount.getId()).wayType(callAccount.getWayType()).seat(seat.getSeat()).phone(seat.getPhone()).city(seat.getCity()).occupyBizId(exists.stream().filter(callAccountSeat -> seat.getSeat().equals(callAccountSeat.getSeat())).findFirst().orElse(new CallAccountSeat()).getOccupyBizId()).occupyBizName(exists.stream().filter(callAccountSeat -> seat.getSeat().equals(callAccountSeat.getSeat())).findFirst().orElse(new CallAccountSeat()).getOccupyBizName()).createTime(new Date()).updateTime(new Date()).createBy(staff.getSAMAccountName()).updateBy(staff.getSAMAccountName()).build()));
        this.callAccountSeatMapper.batchInsert((List)accountSeats);
    }

    @Override
    public List<CallAccountSeatRespDto> seatList(CallAccountSeatReqDto req) {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("seatList staff AccountName: {}, name : {}\uff0c req:{} ", new Object[]{staff.getSAMAccountName(), staff.getName(), req});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getNum()), (Object)"num\u4e3a\u7a7a");
        CallAccount callAccount = (CallAccount)this.callAccountMapper.selectOne((Object)CallAccount.builder().num(req.getNum()).build());
        Preconditions.checkArgument((callAccount != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u7ebf\u8def\u4e0d\u5b58\u5728");
        if (req.getPageDto() == null) {
            List accountSeats = this.callAccountSeatMapper.select((Object)CallAccountSeat.builder().callAccountId(callAccount.getId()).build());
            return this.buildResultList(accountSeats);
        }
        CallAccountSeatCriteria criteria = new CallAccountSeatCriteria();
        criteria.createCriteria().andCallAccountIdEqualTo(callAccount.getId());
        criteria.setOrderByClause("seat");
        Page page = PageHelper.startPage((int)req.getPageDto().getPageNum(), (int)req.getPageDto().getPageSize()).doSelectPage(() -> this.callAccountSeatMapper.selectByExample((Object)criteria));
        req.getPageDto().setCount(Integer.valueOf((int)page.getTotal()));
        List accountSeats = page.getResult();
        return this.buildResultList(accountSeats);
    }

    private List<CallAccountSeatRespDto> buildResultList(List<CallAccountSeat> accountSeats) {
        if (CollectionUtils.isEmpty(accountSeats)) {
            return Collections.emptyList();
        }
        ArrayList seats = Lists.newArrayList();
        accountSeats.forEach(seat -> seats.add(CallAccountSeatRespDto.builder().num(seat.getNum()).seat(seat.getSeat()).phone(seat.getPhone()).city(seat.getCity()).used(seat.getOccupyBizId() != null).name(seat.getOccupyBizName()).build()));
        return seats;
    }

    private static Workbook create(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        return WorkbookFactory.create((InputStream)inp);
    }

    private List<CallAccountSeatRespDto> parseExcel(Workbook workbook) {
        int numberOfSheets = workbook.getNumberOfSheets();
        if (numberOfSheets != 1) {
            log.warn("excel\u6587\u4ef6sheet\u9875\u6570\u4e3a:{}", (Object)numberOfSheets);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "excel\u6587\u4ef6\u4e2dsheet\u9875\u6570\u4e0d\u4e3a1");
        }
        Sheet sheet = workbook.getSheetAt(0);
        int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
        if (physicalNumberOfRows - 1 > 5000) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u6b21\u6700\u591a\u5bfc\u51655000\u6761");
        }
        Row headerRow = sheet.getRow(0);
        Cell firstCell = headerRow.getCell(NumberUtils.INTEGER_ZERO.intValue());
        String firstCellStr = firstCell.getStringCellValue();
        if (!HEADER_FIRST_CELL_STR.equals(firstCellStr)) {
            log.warn("\u6807\u9898\u884c\u7b2c\u4e00\u5217\u6807\u9898\u4e3a:{}", (Object)firstCellStr);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e00\u5217\u4e0d\u4e3a\u3010\u5750\u5e2d\u7f16\u53f7\uff08\u5fc5\u586b\uff09\u3011");
        }
        Cell secondCell = headerRow.getCell(NumberUtils.INTEGER_ONE.intValue());
        String secondCellStr = secondCell.getStringCellValue();
        if (!HEADER_SECOND_CELL_STR.equals(secondCellStr)) {
            log.warn("\u6807\u9898\u884c\u7b2c\u4e8c\u5217\u6807\u9898\u4e3a:{}", (Object)secondCellStr);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e8c\u5217\u4e0d\u4e3a\u3010\u5916\u663e\u53f7\uff08\u5fc5\u586b\uff09\u3011");
        }
        Cell thirdCell = headerRow.getCell(NumberUtils.INTEGER_TWO.intValue());
        String thirdCellStr = thirdCell.getStringCellValue();
        if (!HEADER_THIRD_CELL_STR.equals(thirdCellStr)) {
            log.warn("\u6807\u9898\u884c\u7b2c\u4e09\u5217\u6807\u9898\u4e3a:{}", (Object)thirdCellStr);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e09\u5217\u4e0d\u4e3a\u3010\u5f52\u5c5e\u5730\uff08\u5fc5\u586b\uff09\u3011");
        }
        HashSet seats = Sets.newHashSet();
        ArrayList seatList = Lists.newArrayList();
        int totalCount = physicalNumberOfRows - 1;
        int i = 0;
        int dataStartRow = 0;
        while (i < totalCount) {
            Row row;
            if (Objects.isNull(row = sheet.getRow(++dataStartRow))) continue;
            Cell cell = row.getCell(NumberUtils.INTEGER_ZERO.intValue());
            if (Objects.isNull(cell)) {
                ++i;
                continue;
            }
            cell.setCellType(CellType.STRING);
            String seat = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)seat)) {
                ++i;
                continue;
            }
            if (seatList.contains(seat)) {
                ++i;
                continue;
            }
            cell = row.getCell(NumberUtils.INTEGER_ONE.intValue());
            if (Objects.isNull(cell)) {
                ++i;
                continue;
            }
            cell.setCellType(CellType.STRING);
            String phone = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)phone)) {
                ++i;
                continue;
            }
            cell = row.getCell(NumberUtils.INTEGER_TWO.intValue());
            if (Objects.isNull(cell)) {
                ++i;
                continue;
            }
            cell.setCellType(CellType.STRING);
            String city = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)city)) {
                ++i;
                continue;
            }
            seatList.add(seat);
            CallAccountSeatRespDto callAccountSeat = CallAccountSeatRespDto.builder().seat(seat).phone(phone).city(city).build();
            seats.add(callAccountSeat);
            ++i;
        }
        return Lists.newArrayList((Iterable)seats);
    }
}

