/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.factory;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.CallOutDto;
import com.kuaike.scrm.call.dto.req.CallBackReqDto;
import com.kuaike.scrm.call.enums.ApiTypeEnum;
import com.kuaike.scrm.call.enums.CallOutTypeEnum;
import com.kuaike.scrm.call.enums.CanceledEnum;
import com.kuaike.scrm.call.enums.StatusEnum;
import com.kuaike.scrm.call.enums.TypeEnum;
import com.kuaike.scrm.call.factory.CallOutService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.call.dto.CallRecordQueryParams;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallRecordCriteria;
import com.kuaike.scrm.dal.call.entity.CallTaskDetail;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskDetailMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.dal.sms.mapper.PartnerInfoMapper;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ZhongTongCallOutServiceImpl
implements CallOutService {
    private static final Logger log = LoggerFactory.getLogger(ZhongTongCallOutServiceImpl.class);
    @Value(value="${app.call.click2CallUrl}")
    private String click2CallUrl;
    @Value(value="${app.call.callRegisterUrl}")
    private String callRegisterUrl;
    @Value(value="${app.call.releaseCallUrl}")
    private String releaseCall;
    @Autowired
    private CallRecordMapper callRecordMapper;
    @Autowired
    private CallTaskDetailMapper callTaskDetailMapper;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private PartnerInfoMapper partnerInfoMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IdGen idGen;

    @Override
    public Integer getCallOutType() {
        return CallOutTypeEnum.ZHONG_TONG.getValue();
    }

    @Override
    public String call(CallOutDto callOutDto) {
        JSONObject jsonObject;
        Long bizId = callOutDto.getBizId();
        log.info("zhongtong call callOutDto:{}, bizId:{}", (Object)callOutDto, (Object)bizId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)callOutDto.getCallType()), (Object)"\u5916\u547c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, String> params = this.getCallParams(callOutDto);
        if (callOutDto.getCallType().equals(ApiTypeEnum.LOCAL.getName())) {
            Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)callOutDto.getPhone()), (Object)"\u8bf7\u8f93\u516511\u4f4d\u624b\u673a\u53f7");
            jsonObject = this.bjyPartnerService.bjyPost(bizId, this.click2CallUrl, params);
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)callOutDto.getSessionId()), (Object)"sessionId\u4e0d\u80fd\u4e3a\u7a7a");
            jsonObject = this.bjyPartnerService.bjyPost(bizId, this.callRegisterUrl, params);
        }
        return jsonObject.getJSONObject("data").getString("session_id");
    }

    @Override
    public CallRecord callback(CallBackReqDto reqDto) {
        long l;
        String sessionId = reqDto.getSessionId();
        Integer isCallIn = reqDto.getIsCallIn();
        CallRecord callRecord = (CallRecord)this.callRecordMapper.selectOne((Object)CallRecord.builder().apiCallId(sessionId).build());
        CallRecord item = new CallRecord();
        item.setUpdateBy(Long.valueOf(-1L));
        item.setUpdateTime(new Date());
        CallRecordCriteria criteria = new CallRecordCriteria();
        criteria.createCriteria().andApiCallIdEqualTo(sessionId);
        Integer callStatus = reqDto.getCallStatus();
        int ringingDuration = 0;
        String alertingTime = reqDto.getAlertingTime();
        String answerTime = reqDto.getAnswerTime();
        String endTime = reqDto.getEndTime();
        if (callStatus == 1) {
            if (!StringUtils.isEmpty((CharSequence)alertingTime) && !StringUtils.isEmpty((CharSequence)answerTime)) {
                l = DateUtil.compareDateSecond((String)alertingTime, (String)answerTime);
                ringingDuration = Math.toIntExact(l / 1000L);
            }
        } else if (!StringUtils.isEmpty((CharSequence)alertingTime) && !StringUtils.isEmpty((CharSequence)endTime)) {
            l = DateUtil.compareDateSecond((String)reqDto.getAlertingTime(), (String)reqDto.getEndTime());
            ringingDuration = Math.toIntExact(l / 1000L);
        }
        item.setMiddlePhone(reqDto.getBindNbr());
        item.setRingingDuration(Integer.valueOf(ringingDuration));
        item.setCallDuration(reqDto.getAirtime());
        item.setBillCallDuration(reqDto.getBillCallDuration());
        item.setStatus(callStatus);
        item.setStartTime(DateUtil.getDate((String)answerTime, (String)"yyyy-MM-dd HH:mm:ss"));
        item.setEndTime(DateUtil.getDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
        if (ObjectUtils.isEmpty((Object)callRecord)) {
            if (isCallIn != null && isCallIn == 0) {
                return null;
            }
            String partnerId = reqDto.getPartnerId();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)partnerId), (Object)"partnerId can not be null");
            PartnerInfo partnerInfo = (PartnerInfo)this.partnerInfoMapper.selectOne((Object)PartnerInfo.builder().partnerId(partnerId).build());
            Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)partnerInfo) ? 1 : 0) != 0, (Object)"partnerInfo can not be null");
            item.setIsOpenapi(Integer.valueOf(0));
            item.setType(Integer.valueOf(TypeEnum.CALL_IN.getValue()));
            item.setCanceled(Integer.valueOf(CanceledEnum.START.getValue()));
            item.setUserPhone(reqDto.getTelA());
            item.setCustomerPhone(reqDto.getTelB());
            item.setApiCallId(reqDto.getSessionId());
            item.setCreateBy(Long.valueOf(-1L));
            item.setCreateTime(DateUtil.getDate((String)alertingTime, (String)"yyyy-MM-dd HH:mm:ss"));
            item.setNum(this.idGen.getNum());
            item.setBizId(partnerInfo.getBizId());
            item.setCorpId(partnerInfo.getCorpId());
            item.setUserType(Integer.valueOf(CallTypeEnum.MANUAL.getValue()));
            item.setApiType(Integer.valueOf(ApiTypeEnum.ofValue(reqDto.getCallType())));
            Long userNumber = reqDto.getUserNumber();
            if (ObjectUtils.isEmpty((Object)userNumber)) {
                item.setUserId(Long.valueOf(-1L));
                item.setNodeId(Long.valueOf(-1L));
            } else {
                User user = this.userMapper.getUserInfoById(userNumber);
                if (ObjectUtils.isEmpty((Object)user)) {
                    item.setUserId(Long.valueOf(-1L));
                    item.setNodeId(Long.valueOf(-1L));
                } else {
                    item.setUserId(userNumber);
                    item.setNodeId(Long.valueOf(Objects.isNull(user.getNodeId()) ? -1L : user.getNodeId()));
                }
            }
            this.callRecordMapper.insert((Object)item);
        } else {
            CallTaskDetail taskDetail;
            item.setNum(callRecord.getNum());
            item.setCorpId(callRecord.getCorpId());
            item.setBizId(callRecord.getBizId());
            item.setUserId(callRecord.getUserId());
            item.setNodeId(callRecord.getNodeId());
            item.setCustomerPhone(callRecord.getCustomerPhone());
            item.setUserPhone(callRecord.getUserPhone());
            item.setIsOpenapi(callRecord.getIsOpenapi());
            item.setCreateTime(callRecord.getCreateTime());
            item.setType(callRecord.getType());
            item.setVoiceUrl(callRecord.getVoiceUrl());
            item.setCallTaskDetailId(callRecord.getCallTaskDetailId());
            item.setUserType(callRecord.getUserType());
            this.callRecordMapper.updateByExampleSelective((Object)item, (Object)criteria);
            if (callRecord.getStatus().intValue() == StatusEnum.SUCCESS.getValue()) {
                return null;
            }
            if (!ObjectUtils.isEmpty((Object)callRecord.getCallTaskDetailId()) && !ObjectUtils.isEmpty((Object)(taskDetail = (CallTaskDetail)this.callTaskDetailMapper.selectByPrimaryKey((Object)CallTaskDetail.builder().id(callRecord.getCallTaskDetailId()).build())))) {
                taskDetail.setLastCallStatus(callStatus);
                taskDetail.setUpdateTime(new Date());
                if (callStatus == 1) {
                    taskDetail.setCallSuccessCount(Integer.valueOf(taskDetail.getCallSuccessCount() + 1));
                }
                this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)taskDetail);
            }
        }
        return item;
    }

    @Override
    public void cancel(CurrentUserInfo currentUser) {
        Long bizId = currentUser.getBizId();
        Long userId = currentUser.getId();
        CallRecordQueryParams queryParams = new CallRecordQueryParams();
        queryParams.setBizId(bizId);
        queryParams.setUserId(userId);
        CallRecord callRecord = this.callRecordMapper.lastCall(queryParams);
        Map<String, String> params = this.getHangupParams(callRecord.getApiCallId());
        if (!ObjectUtils.isEmpty((Object)callRecord)) {
            callRecord.setUpdateBy(Long.valueOf(-1L));
            callRecord.setUpdateTime(new Date());
            callRecord.setCanceled(Integer.valueOf(1));
            this.callRecordMapper.updateByPrimaryKeySelective((Object)callRecord);
        }
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.releaseCall, params);
            log.info("cancel result:{}", (Object)jsonObject);
        }
        catch (Exception e) {
            log.error("zhongtong cancel error", (Throwable)e);
        }
    }

    private Map<String, String> getCallParams(CallOutDto callOutDto) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("tel_a", callOutDto.getUserPhone());
        result.put("tel_b", callOutDto.getPhone());
        result.put("user_number", String.valueOf(callOutDto.getUserId()));
        result.put("call_type", callOutDto.getCallType());
        if (StringUtils.isNotBlank((CharSequence)callOutDto.getSessionId())) {
            result.put("session_id", callOutDto.getSessionId());
        }
        return result;
    }

    private Map<String, String> getHangupParams(String sessionId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("session_id", sessionId);
        return result;
    }
}

