/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.utils;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CallSmsUtil {
    private static final Logger log = LoggerFactory.getLogger(CallSmsUtil.class);
    @Value(value="${aliyun.sms.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.sms.accessKeySecret}")
    private String accessKeySecret;
    private static String accessKeyIdStatic;
    private static String accessKeySecretStatic;

    @PostConstruct
    public void init() {
        accessKeyIdStatic = this.accessKeyId;
        accessKeySecretStatic = this.accessKeySecret;
    }

    public static Boolean sendSms(String phoneNumber, String signName, String templateCode, String param) {
        log.info("sendSms,phoneNumber:{},signName:{},templateCode:{},param:{}", new Object[]{phoneNumber, signName, templateCode, param});
        try {
            Config config = new Config();
            config.accessKeyId = accessKeyIdStatic;
            config.accessKeySecret = accessKeySecretStatic;
            Client client = new Client(config);
            SendSmsRequest sendReq = new SendSmsRequest().setPhoneNumbers(phoneNumber).setSignName(signName).setTemplateCode(templateCode).setTemplateParam(param);
            SendSmsResponse response = client.sendSms(sendReq);
            log.info("phoneNumber:{},response:{}", (Object)phoneNumber, (Object)response);
            return "OK".equals(response.body.code);
        }
        catch (Exception ex) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
            return false;
        }
    }
}

