/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.CallAccountConfig;
import com.kuaike.scrm.call.dto.CallConfig;
import com.kuaike.scrm.call.dto.req.CallRecordReqDto;
import com.kuaike.scrm.call.dto.req.CallReqDto;
import com.kuaike.scrm.call.dto.resp.CallRecordRespDto;
import com.kuaike.scrm.call.enums.ApiTypeEnum;
import com.kuaike.scrm.call.enums.CallOutTypeEnum;
import com.kuaike.scrm.call.enums.StatusEnum;
import com.kuaike.scrm.call.enums.VoiceCallErrorEnum;
import com.kuaike.scrm.call.service.CallRecordService;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.enums.voicecall.VoiceMaterialTypeEnum;
import com.kuaike.scrm.common.service.CachePhoneService;
import com.kuaike.scrm.common.service.ScrmCallService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.AppCallRespDto;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.service.dto.req.AppCalledReqDto;
import com.kuaike.scrm.common.service.dto.req.ScrmCallOutReq;
import com.kuaike.scrm.common.service.dto.req.voicematerial.AddVoiceMaterialReq;
import com.kuaike.scrm.common.service.dto.req.voicematerial.CreateVoiceCallReq;
import com.kuaike.scrm.common.service.dto.req.voicematerial.EditVoiceMaterialReq;
import com.kuaike.scrm.common.service.dto.req.voicematerial.VoiceMaterialIdReq;
import com.kuaike.scrm.common.service.dto.req.voicematerial.VoiceMaterialListReq;
import com.kuaike.scrm.common.service.dto.resp.AppCalledRespDto;
import com.kuaike.scrm.common.service.dto.resp.CallRecordDto;
import com.kuaike.scrm.common.service.dto.resp.call.AppConfigRespDto;
import com.kuaike.scrm.common.service.dto.resp.call.CallAccountConfigRespDto;
import com.kuaike.scrm.common.service.dto.resp.call.DubboCallRecordRespDto;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.CreateVoiceCallResp;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.VoiceMaterialDetailResp;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.VoiceMaterialListResp;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.call.dto.CallRecordQueryParams;
import com.kuaike.scrm.dal.call.dto.VoiceMaterialQueryParams;
import com.kuaike.scrm.dal.call.entity.CallMember;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallRecordCriteria;
import com.kuaike.scrm.dal.call.entity.CallVoiceMaterial;
import com.kuaike.scrm.dal.call.mapper.CallMemberMapper;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.call.mapper.CallVoiceMaterialMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ScrmCallServiceImpl
implements ScrmCallService {
    private static final Logger log = LoggerFactory.getLogger(ScrmCallServiceImpl.class);
    @Autowired
    private CallRecordService callRecordService;
    @Autowired
    private CachePhoneService cachePhoneService;
    @Autowired
    private CallRecordMapper callRecordMapper;
    @Autowired
    private CallMemberMapper callMemberMapper;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Resource
    private CallVoiceMaterialMapper callVoiceMaterialMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private BjyPartnerService bjyPartnerService;
    @Value(value="${app.call.voiceCallUrl}")
    private String voiceCallUrl;
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Value(value="${app.call.memberInfoUrl}")
    private String memberInfoUrl;
    @Value(value="${app.call.rlExtenListUrl}")
    private String rlExtenListUrl;
    @Value(value="${app.account.getBalanceUrl}")
    private String getBalanceUrl;
    @Value(value="${app.call.getCallSessionIdUrl}")
    private String getCallSessionIdUrl;
    @Autowired
    private AliyunOss aliyunOss;

    public AppCallRespDto recordList(List<String> phones, PageDto pageDto) {
        return this.resultList(phones, pageDto);
    }

    public AppCallRespDto recordList(String phone, PageDto pageDto) {
        return this.resultList(Lists.newArrayList((Object[])new String[]{phone}), pageDto);
    }

    public List<CallRecordDto> recordList(List<String> nums) {
        CallRecordCriteria callRecordCriteria = new CallRecordCriteria();
        if (CollectionUtils.isEmpty(nums)) {
            return Lists.newArrayList();
        }
        callRecordCriteria.createCriteria().andNumIn(nums);
        List records = this.callRecordMapper.selectByExample((Object)callRecordCriteria);
        ArrayList<CallRecordDto> resultList = new ArrayList<CallRecordDto>();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            for (CallRecord callRecord : records) {
                CallRecordDto callRecordDto = new CallRecordDto();
                BeanUtils.copyProperties((Object)callRecord, (Object)callRecordDto);
                resultList.add(callRecordDto);
            }
        }
        return resultList;
    }

    public List<CallRecordDto> recordListByTime(Long bizId, Collection<String> mobiles, Date statTime, Date endTime) {
        log.info("recordListByTime,bizId:{},mobiles size:{},statTime:{},endTime:{}", new Object[]{bizId, mobiles.size(), statTime, endTime});
        if (bizId == null || CollectionUtils.isEmpty(mobiles) || statTime == null && endTime == null) {
            return Collections.emptyList();
        }
        CallRecordQueryParams params = new CallRecordQueryParams();
        params.setBizId(bizId);
        params.setPhones(new ArrayList<String>(mobiles));
        params.setStartDate(statTime);
        params.setEndDate(endTime);
        List callRecords = this.callRecordMapper.queryRecordListByTimeAndPhones(params);
        if (CollectionUtils.isEmpty((Collection)callRecords)) {
            return Collections.emptyList();
        }
        ArrayList<CallRecordDto> list = new ArrayList<CallRecordDto>();
        for (CallRecord callRecord : callRecords) {
            Long userId = callRecord.getUserId();
            String customerPhone = callRecord.getCustomerPhone();
            Integer status = callRecord.getStatus();
            CallRecordDto dto = new CallRecordDto();
            dto.setUserId(userId);
            dto.setCustomerPhone(customerPhone);
            dto.setIsConnected(Boolean.valueOf(StatusEnum.SUCCESS.getValue() == status.intValue()));
            list.add(dto);
        }
        return list;
    }

    private AppCallRespDto resultList(List<String> phones, PageDto pageDto) {
        CallRecordReqDto reqDto = new CallRecordReqDto();
        reqDto.setPageDto(pageDto);
        reqDto.setPhones(phones);
        List<CallRecordRespDto> list = this.callRecordService.list(reqDto);
        ArrayList<CallRecordDto> resultList = new ArrayList<CallRecordDto>();
        if (!CollectionUtils.isEmpty(list)) {
            for (CallRecordRespDto callRecordRespDto : list) {
                CallRecordDto callRecordDto = new CallRecordDto();
                BeanUtils.copyProperties((Object)((Object)callRecordRespDto), (Object)callRecordDto);
                callRecordDto.setStartTime(callRecordRespDto.getCreateTime());
                if (callRecordDto.getUserType() != null && callRecordDto.getUserType().getId() == CallTypeEnum.VOICE.getValue()) {
                    callRecordDto.setUserName("");
                }
                resultList.add(callRecordDto);
            }
        }
        return new AppCallRespDto(resultList, reqDto.getPageDto());
    }

    public AppCallRespDto queryRecordByBatchId(String num) {
        List customers = this.cachePhoneService.getCustomer(num);
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(10));
        return this.resultList(customers.stream().map(CustomerDto::getPhone).collect(Collectors.toList()), pageDto);
    }

    public List<AppCalledRespDto> called(AppCalledReqDto reqDto) {
        CallRecordReqDto recordReqDto = new CallRecordReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)recordReqDto);
        recordReqDto.setCallUserId(reqDto.getUserId());
        List<CallRecordRespDto> list = this.callRecordService.called(recordReqDto);
        List phones = reqDto.getPhones();
        ArrayList<AppCalledRespDto> resultList = new ArrayList<AppCalledRespDto>();
        if (!CollectionUtils.isEmpty(list)) {
            List calledPhones = list.stream().map(CallRecordRespDto::getCustomerPhone).collect(Collectors.toList());
            for (String phone : phones) {
                AppCalledRespDto calledRespDto = new AppCalledRespDto();
                calledRespDto.setPhone(phone);
                calledRespDto.setCalled(!CollectionUtils.isEmpty(calledPhones) && calledPhones.contains(phone));
                resultList.add(calledRespDto);
            }
        }
        return resultList;
    }

    public String callOut(ScrmCallOutReq params) {
        log.info("call out, params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getUserNum()), (Object)"userId is null");
        return this.callRecordService.call(params.getBizId(), params.getUserNum(), params.getMobile(), params.getSessionId());
    }

    public String getFullVoiceUrl(Long bizId, String voiceUrl) {
        log.info("get full voice url, bizId={}, voiceUrl={}", (Object)bizId, (Object)voiceUrl);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)voiceUrl), (Object)"voiceUrl is null");
        return this.callRecordService.getFullVoiceUrl(bizId, voiceUrl);
    }

    public boolean isOpen(Long bizId) {
        log.info("validate call api is open, bizId={}", (Object)bizId);
        CallConfig callConfig = this.callRecordService.callConfig(bizId);
        CallOutTypeEnum supplier = CallOutTypeEnum.get(callConfig.getSupplierType());
        Preconditions.checkArgument((supplier != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u4f9b\u5e94\u5546\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        if (supplier.getValue() == CallOutTypeEnum.RONG_LIAN.getValue()) {
            Preconditions.checkArgument((callConfig.getAccountInfo() != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u4f9b\u5e94\u5546\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            String wayType = callConfig.getWayType();
            Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)wayType) && (wayType.contains("local") || wayType.contains(ApiTypeEnum.SIP.getName())) ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u672a\u5f00\u901a\u7535\u8bdd\u5916\u547c");
        }
        return true;
    }

    public boolean isOpenVoice(Long bizId) {
        log.info("isOpenVoice bizId:{}", (Object)bizId);
        CallConfig callConfig = this.callRecordService.callConfig(bizId);
        CallOutTypeEnum supplier = CallOutTypeEnum.get(callConfig.getSupplierType());
        Preconditions.checkArgument((supplier != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u4f9b\u5e94\u5546\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        if (supplier.getValue() == CallOutTypeEnum.RONG_LIAN.getValue()) {
            Preconditions.checkArgument((callConfig.getAccountInfo() != null ? 1 : 0) != 0, (Object)"\u5916\u547c\u4f9b\u5e94\u5546\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            String wayType = callConfig.getWayType();
            Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)wayType) && wayType.contains("voice") ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u672a\u5f00\u901a\u8bed\u97f3\u5916\u547c");
        }
        return true;
    }

    public String addVoiceMaterial(AddVoiceMaterialReq req) {
        log.info("addVoiceMaterial req:{}", (Object)req);
        req.validate();
        VoiceMaterialTypeEnum voiceMaterialTypeEnum = VoiceMaterialTypeEnum.get((Integer)req.getType());
        if (VoiceMaterialTypeEnum.VOICE.equals((Object)voiceMaterialTypeEnum)) {
            Preconditions.checkArgument((boolean)req.getContent().startsWith("https://" + this.aliyunOss.getBucket()), (Object)"\u8bed\u97f3\u6587\u4ef6\u5730\u5740\u975e\u6cd5");
        }
        CallVoiceMaterial nameExist = new CallVoiceMaterial();
        nameExist.setName(req.getName());
        nameExist.setBizId(req.getBizId());
        int count = this.callVoiceMaterialMapper.selectCount((Object)nameExist);
        Preconditions.checkArgument((count == 0 ? 1 : 0) != 0, (Object)"\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        String num = this.idGen.getNum();
        Date now = new Date();
        CallVoiceMaterial callVoiceMaterial = new CallVoiceMaterial();
        callVoiceMaterial.setNum(num);
        callVoiceMaterial.setBizId(req.getBizId());
        callVoiceMaterial.setCorpId(req.getCorpId());
        callVoiceMaterial.setName(req.getName());
        callVoiceMaterial.setType(req.getType());
        callVoiceMaterial.setContent(req.getContent());
        callVoiceMaterial.setCreateBy(Long.valueOf(-1L));
        callVoiceMaterial.setUpdateBy(Long.valueOf(-1L));
        callVoiceMaterial.setCreateTime(now);
        callVoiceMaterial.setUpdateTime(now);
        if (StringUtils.isNotBlank((CharSequence)req.getFileName())) {
            callVoiceMaterial.setVoiceFileName(req.getFileName());
        }
        callVoiceMaterial.setIsDeleted(Integer.valueOf(0));
        this.callVoiceMaterialMapper.insert((Object)callVoiceMaterial);
        return num;
    }

    public VoiceMaterialDetailResp voiceMaterialDetail(VoiceMaterialIdReq req) {
        log.info("voiceMaterialDetail req:{}", (Object)req);
        req.validate();
        CallVoiceMaterial select = new CallVoiceMaterial();
        select.setBizId(req.getBizId());
        select.setNum(req.getId());
        select.setIsDeleted(Integer.valueOf(0));
        CallVoiceMaterial callVoiceMaterial = (CallVoiceMaterial)this.callVoiceMaterialMapper.selectOne((Object)select);
        Preconditions.checkArgument((callVoiceMaterial != null ? 1 : 0) != 0, (Object)"\u8bed\u8a00\u5916\u547c\u7d20\u6750\u4e0d\u5b58\u5728");
        VoiceMaterialDetailResp resp = new VoiceMaterialDetailResp();
        resp.setId(callVoiceMaterial.getNum());
        resp.setName(callVoiceMaterial.getName());
        resp.setType(callVoiceMaterial.getType());
        resp.setContent(callVoiceMaterial.getContent());
        resp.setFileName(callVoiceMaterial.getVoiceFileName());
        resp.setCreateTime(callVoiceMaterial.getCreateTime());
        resp.setUpdateTime(callVoiceMaterial.getUpdateTime());
        return resp;
    }

    public void editVoiceMaterial(EditVoiceMaterialReq req) {
        log.info("editVoiceMaterial req:{}", (Object)req);
        req.validate();
        VoiceMaterialTypeEnum voiceMaterialTypeEnum = VoiceMaterialTypeEnum.get((Integer)req.getType());
        if (VoiceMaterialTypeEnum.VOICE.equals((Object)voiceMaterialTypeEnum)) {
            Preconditions.checkArgument((boolean)req.getContent().startsWith("https://" + this.aliyunOss.getBucket()), (Object)"\u8bed\u97f3\u6587\u4ef6\u5730\u5740\u975e\u6cd5");
        }
        CallVoiceMaterial exist = new CallVoiceMaterial();
        exist.setBizId(req.getBizId());
        exist.setNum(req.getId());
        exist.setIsDeleted(Integer.valueOf(0));
        CallVoiceMaterial callVoiceMaterial = (CallVoiceMaterial)this.callVoiceMaterialMapper.selectOne((Object)exist);
        Preconditions.checkArgument((callVoiceMaterial != null ? 1 : 0) != 0, (Object)"\u8bed\u8a00\u5916\u547c\u7d20\u6750\u4e0d\u5b58\u5728");
        if (!callVoiceMaterial.getName().equals(req.getName())) {
            Long count = this.callVoiceMaterialMapper.nameCountByEdit(callVoiceMaterial.getId(), req.getName(), req.getBizId());
            Preconditions.checkArgument((count == 0L ? 1 : 0) != 0, (Object)"\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        Date now = new Date();
        callVoiceMaterial.setName(req.getName());
        callVoiceMaterial.setType(req.getType());
        callVoiceMaterial.setContent(req.getContent());
        callVoiceMaterial.setVoiceFileName(req.getFileName());
        callVoiceMaterial.setUpdateTime(now);
        this.callVoiceMaterialMapper.updateByPrimaryKeySelective((Object)callVoiceMaterial);
    }

    public void delVoiceMaterial(VoiceMaterialIdReq req) {
        log.info("delVoiceMaterial req:{}", (Object)req);
        req.validate();
        CallVoiceMaterial exist = new CallVoiceMaterial();
        exist.setBizId(req.getBizId());
        exist.setNum(req.getId());
        exist.setIsDeleted(Integer.valueOf(0));
        CallVoiceMaterial callVoiceMaterial = (CallVoiceMaterial)this.callVoiceMaterialMapper.selectOne((Object)exist);
        Preconditions.checkArgument((callVoiceMaterial != null ? 1 : 0) != 0, (Object)"\u8bed\u8a00\u5916\u547c\u7d20\u6750\u4e0d\u5b58\u5728");
        Date now = new Date();
        callVoiceMaterial.setIsDeleted(Integer.valueOf(1));
        callVoiceMaterial.setUpdateTime(now);
        this.callVoiceMaterialMapper.updateByPrimaryKeySelective((Object)callVoiceMaterial);
    }

    public VoiceMaterialListResp voiceMaterialList(VoiceMaterialListReq req) {
        log.info("delVoiceMaterial req:{}", (Object)req);
        req.validate();
        VoiceMaterialListResp resp = new VoiceMaterialListResp();
        VoiceMaterialQueryParams params = new VoiceMaterialQueryParams();
        params.setPageDto(req.getPageDto());
        params.setType(req.getType());
        params.setQuery(req.getQuery());
        params.setBizId(req.getBizId());
        Long total = this.callVoiceMaterialMapper.queryListCount(params);
        if (total == 0L) {
            resp.setTotal(Long.valueOf(0L));
            resp.setList(Collections.emptyList());
            return resp;
        }
        resp.setTotal(total);
        List list = this.callVoiceMaterialMapper.queryList(params);
        ArrayList<VoiceMaterialDetailResp> respList = new ArrayList<VoiceMaterialDetailResp>(list.size());
        for (CallVoiceMaterial callVoiceMaterial : list) {
            VoiceMaterialDetailResp detailResp = new VoiceMaterialDetailResp();
            detailResp.setId(callVoiceMaterial.getNum());
            detailResp.setName(callVoiceMaterial.getName());
            detailResp.setType(callVoiceMaterial.getType());
            detailResp.setContent(callVoiceMaterial.getContent());
            detailResp.setFileName(callVoiceMaterial.getVoiceFileName());
            detailResp.setCreateTime(callVoiceMaterial.getCreateTime());
            detailResp.setUpdateTime(callVoiceMaterial.getUpdateTime());
            respList.add(detailResp);
        }
        resp.setList(respList);
        return resp;
    }

    public CreateVoiceCallResp createVoiceCall(CreateVoiceCallReq req) {
        JSONObject jsonObject;
        log.info("createVoiceCall req:{}", (Object)req);
        req.validate();
        String mobile = req.getMobile();
        Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)mobile), (Object)"\u624b\u673a\u53f7\u4e0d\u89c4\u8303");
        CallVoiceMaterial select = new CallVoiceMaterial();
        select.setBizId(req.getBizId());
        select.setNum(req.getMaterialId());
        select.setIsDeleted(Integer.valueOf(0));
        CallVoiceMaterial callVoiceMaterial = (CallVoiceMaterial)this.callVoiceMaterialMapper.selectOne((Object)select);
        Preconditions.checkArgument((callVoiceMaterial != null ? 1 : 0) != 0, (Object)"\u8bed\u97f3\u5916\u547c\u6a21\u677f\u4e0d\u5b58\u5728");
        ArrayList<CreateVoiceCallResp> respList = new ArrayList<CreateVoiceCallResp>();
        CreateVoiceCallResp resp = new CreateVoiceCallResp();
        resp.setPhone(mobile);
        Map<String, String> params = this.handleVoiceParams(mobile, callVoiceMaterial, req.getMaterialParams());
        log.info("\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\uff0c\u5165\u53c2params:{}", params);
        try {
            jsonObject = this.bjyPartnerService.bjyPost(req.getBizId(), this.voiceCallUrl, params);
        }
        catch (Exception e) {
            resp.setSuccess(false);
            resp.setMsg(VoiceCallErrorEnum.VOICE_CALL_ERROR.getMsg());
            resp.setCode(VoiceCallErrorEnum.VOICE_CALL_ERROR.getCode());
            respList.add(resp);
            log.error("\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u5f02\u5e38,phone:{}", (Object)mobile, (Object)e);
            return resp;
        }
        if (jsonObject == null) {
            resp.setSuccess(false);
            resp.setMsg(VoiceCallErrorEnum.EMPTY_RESULT.getMsg());
            resp.setCode(VoiceCallErrorEnum.EMPTY_RESULT.getCode());
            respList.add(resp);
            log.error("\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,phone:{}", (Object)mobile);
            return resp;
        }
        log.info("\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)jsonObject);
        Integer code = jsonObject.getInteger("code");
        String msg = jsonObject.getString("msg");
        if (code != 0) {
            resp.setSuccess(false);
            resp.setCode(VoiceCallErrorEnum.VOICE_CALL_ERROR.getCode());
            resp.setMsg(msg);
            respList.add(resp);
            log.warn("\u8bed\u97f3\u5916\u547c\u6267\u884c\u4e0d\u6210\u529f\uff0cphone:{}\uff0c\u539f\u56e0:{}", (Object)mobile, (Object)msg);
            return resp;
        }
        JSONObject data = jsonObject.getJSONObject("data");
        if (data == null) {
            resp.setSuccess(false);
            resp.setMsg(VoiceCallErrorEnum.EMPTY_RESULT.getMsg());
            resp.setCode(VoiceCallErrorEnum.EMPTY_RESULT.getCode());
            respList.add(resp);
            log.error("\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679cdata\u4e3a\u7a7a,phone:{}", (Object)mobile);
            return resp;
        }
        String sessionId = data.getString("session_id");
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            resp.setSuccess(false);
            resp.setMsg(VoiceCallErrorEnum.EMPTY_RESULT.getMsg());
            resp.setCode(VoiceCallErrorEnum.EMPTY_RESULT.getCode());
            respList.add(resp);
            log.error("\u8bf7\u6c42\u8bed\u97f3\u5916\u547c\u63a5\u53e3\u83b7\u53d6\u4e0d\u5230sessionId,phone:{}", (Object)mobile);
            return resp;
        }
        Date now = new Date();
        String num = this.idGen.getNum();
        CallRecord callRecord = new CallRecord();
        callRecord.setNum(num);
        callRecord.setBizId(req.getBizId());
        callRecord.setCorpId(req.getCorpId());
        callRecord.setCustomerPhone(mobile);
        callRecord.setUserType(Integer.valueOf(CallTypeEnum.VOICE.getValue()));
        callRecord.setApiType(Integer.valueOf(0));
        callRecord.setApiCallId(sessionId);
        callRecord.setUserId(Long.valueOf(-1L));
        callRecord.setUserPhone("");
        callRecord.setMiddlePhone("");
        callRecord.setType(Integer.valueOf(0));
        callRecord.setStatus(Integer.valueOf(StatusEnum.START.getValue()));
        callRecord.setCanceled(Integer.valueOf(0));
        callRecord.setNodeId(Long.valueOf(-1L));
        callRecord.setIsOpenapi(Integer.valueOf(1));
        callRecord.setCreateBy(Long.valueOf(-1L));
        callRecord.setCreateTime(now);
        callRecord.setUpdateBy(Long.valueOf(-1L));
        callRecord.setUpdateTime(now);
        callRecord.setVoiceUrl(callVoiceMaterial.getContent());
        this.callRecordMapper.insert((Object)callRecord);
        resp.setSuccess(true);
        resp.setId(num);
        respList.add(resp);
        log.info("createVoiceCall resp:{}", respList);
        return resp;
    }

    public List<AppCalledRespDto> callCount(AppCalledReqDto reqDto) {
        Map<Object, Object> recordMap;
        log.info("callCount req:{}", (Object)reqDto);
        CallRecordReqDto recordReqDto = new CallRecordReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)recordReqDto);
        Preconditions.checkArgument((reqDto.getBizId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237\u5fc5\u4f20");
        CallRecordQueryParams params = recordReqDto.to(reqDto.getBizId());
        List records = this.callRecordMapper.callCount(params);
        List ids = this.callRecordMapper.queryLatestRecordIds(params);
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            List recordList = this.callRecordMapper.selectByIds((Collection)ids);
            recordMap = recordList.stream().collect(Collectors.toMap(CallRecord::getCustomerPhone, Function.identity()));
        } else {
            recordMap = Collections.emptyMap();
        }
        ArrayList<AppCalledRespDto> resultList = new ArrayList<AppCalledRespDto>();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            for (CallRecord callRecord : records) {
                AppCalledRespDto calledRespDto = new AppCalledRespDto();
                CallRecord latestRecord = (CallRecord)recordMap.get(callRecord.getCustomerPhone());
                calledRespDto.setPhone(callRecord.getCustomerPhone());
                calledRespDto.setCallCount(callRecord.getCallCount());
                calledRespDto.setSuccessCount(callRecord.getSuccessCount());
                if (latestRecord != null) {
                    calledRespDto.setLatestCallTime(latestRecord.getCreateTime());
                    calledRespDto.setLatestCallDuration(latestRecord.getCallDuration());
                    calledRespDto.setVoiceUrl(latestRecord.getVoiceUrl());
                    calledRespDto.setLatestCallRecordId(latestRecord.getNum());
                }
                resultList.add(calledRespDto);
            }
        }
        return resultList;
    }

    public List<AppCalledRespDto> batchCallCount(AppCalledReqDto reqDto) {
        log.info("batch callCount req:{}", (Object)reqDto);
        CallRecordReqDto recordReqDto = new CallRecordReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)recordReqDto);
        Preconditions.checkArgument((reqDto.getBizId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237\u5fc5\u4f20");
        CallRecordQueryParams params = recordReqDto.to(reqDto.getBizId());
        List records = this.callRecordMapper.batchQueryCallCount(params);
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Lists.newArrayList();
        }
        return records.stream().map(item -> {
            AppCalledRespDto calledRespDto = new AppCalledRespDto();
            calledRespDto.setPhone(item.getCustomerPhone());
            calledRespDto.setUserId(item.getUserId());
            calledRespDto.setCallCount(item.getCallCount());
            calledRespDto.setSuccessCount(item.getSuccessCount());
            return calledRespDto;
        }).collect(Collectors.toList());
    }

    public AppConfigRespDto config(Long bizId, Long userId) {
        log.info("config bizId:{} userId:{}", (Object)bizId, (Object)userId);
        AppConfigRespDto appConfigRespDto = new AppConfigRespDto();
        AppBindings bindings = this.bindingsMapper.selectByBizIdAndAppCode(bizId, this.appCode);
        appConfigRespDto.setCode(this.appCode);
        if (bindings == null || bindings.getIsOpen() == 0) {
            appConfigRespDto.setIsOpen(Integer.valueOf(0));
            return appConfigRespDto;
        }
        appConfigRespDto.setIsOpen(bindings.getIsOpen());
        CallConfig callConfig = this.json2CallConfig(bindings.getConfigJson());
        if (ObjectUtils.isEmpty((Object)callConfig)) {
            return appConfigRespDto;
        }
        CallAccountConfig accountInfo = callConfig.getAccountInfo();
        CallAccountConfigRespDto configJson = new CallAccountConfigRespDto();
        if (!ObjectUtils.isEmpty((Object)accountInfo)) {
            BeanUtils.copyProperties((Object)accountInfo, (Object)configJson);
        }
        appConfigRespDto.setConfigJson(configJson);
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        if (ObjectUtils.isEmpty((Object)callMember)) {
            return appConfigRespDto;
        }
        Map<String, String> params = this.getExtenInfoParams(userId);
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.memberInfoUrl, params);
        appConfigRespDto.setExten(jsonObject.getJSONObject("data").getJSONObject("exten"));
        return appConfigRespDto;
    }

    public DubboCallRecordRespDto detail(Long bizId, Long userId) {
        log.info("detail bizId:{} userId:{}", (Object)bizId, (Object)userId);
        CallMember member = CallMember.builder().bizId(bizId).userId(userId).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).build();
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)member);
        boolean isCallMember = !ObjectUtils.isEmpty((Object)callMember);
        DubboCallRecordRespDto dubboCallRecordRespDto = null;
        if (isCallMember) {
            Map<String, String> params;
            JSONObject jsonObject;
            JSONObject exten;
            CallConfig callConfig;
            CallRecordQueryParams queryParams = new CallRecordQueryParams();
            queryParams.setBizId(bizId);
            queryParams.setUserId(userId);
            CallRecord callRecord = this.callRecordMapper.lastCall(queryParams);
            if (!ObjectUtils.isEmpty((Object)callRecord)) {
                dubboCallRecordRespDto = this.buildCallRecordRespDto(callRecord);
            }
            if ((callConfig = this.callConfig(bizId)).getSupplierType() != null && callConfig.getSupplierType().intValue() == CallOutTypeEnum.RONG_LIAN.getValue() && ((exten = (jsonObject = this.bjyPartnerService.bjyPost(bizId, this.memberInfoUrl, params = this.getExtenInfoParams(userId))).getJSONObject("data").getJSONObject("exten")) == null || exten.isEmpty())) {
                isCallMember = false;
            }
        }
        if (dubboCallRecordRespDto == null) {
            dubboCallRecordRespDto = new DubboCallRecordRespDto();
        }
        dubboCallRecordRespDto.setCallMember(isCallMember);
        return dubboCallRecordRespDto;
    }

    public JSONArray freeExten(Long bizId, Long userId) {
        log.info("freeExten bizId:{} userId:{}", (Object)bizId, (Object)userId);
        Map<String, String> params = this.getRlExtenListParams();
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.rlExtenListUrl, params);
        return jsonObject.getJSONObject("data").getJSONArray("exten");
    }

    public String getCallSessionId(Long bizId, Long userId) {
        log.info("getCallSessionId bizId:{} userId:{}", (Object)bizId, (Object)userId);
        return this.callRecordService.getCallSessionId(bizId, userId);
    }

    public void signInOrOut(Long bizId, Long userId, Integer signInType) {
        log.info("signInOrOut bizId:{} userId:{} signInType:{}", new Object[]{bizId, userId, signInType});
        CallReqDto reqDto = new CallReqDto();
        reqDto.setSignInType(signInType);
        this.callRecordService.signInOrOut(reqDto, bizId, userId);
    }

    public void register(Long bizId, Long userId, String callType, String callSheetId) {
        log.info("register bizId:{} userId:{} callType:{} callSheetId:{}", new Object[]{bizId, userId, callType, callSheetId});
        CallReqDto reqDto = new CallReqDto();
        reqDto.setCallType(callType);
        reqDto.setCallSheetId(callSheetId);
        this.callRecordService.inRegister(reqDto, bizId, userId);
    }

    public CallConfig callConfig(Long bizId) {
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        Preconditions.checkArgument((bindings != null && bindings.getIsOpen() == 1 ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u5c1a\u672a\u5f00\u901a\u5916\u547c\u529f\u80fd");
        String configJson = bindings.getConfigJson();
        return this.json2CallConfig(configJson);
    }

    public CallConfig json2CallConfig(String configJson) {
        CallConfig callConfig;
        try {
            callConfig = (CallConfig)JacksonUtil.str2Obj((String)configJson, CallConfig.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u89e3\u6790\u5916\u547c\u914d\u7f6e\u5f02\u5e38");
        }
        return callConfig;
    }

    private Map<String, String> handleVoiceParams(String phone, CallVoiceMaterial callVoiceMaterial, Map<String, String> materialParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tel_b", phone);
        String content = callVoiceMaterial.getContent();
        VoiceMaterialTypeEnum materialType = VoiceMaterialTypeEnum.get((Integer)callVoiceMaterial.getType());
        if (VoiceMaterialTypeEnum.TEXT.equals((Object)materialType)) {
            params.put("type", "0");
            for (Map.Entry<String, String> param : materialParams.entrySet()) {
                String template = "{" + param.getKey() + "}";
                if (!content.contains(template)) continue;
                content = content.replace(template, param.getValue());
            }
            String base64Content = Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
            params.put("text", base64Content);
        } else if (VoiceMaterialTypeEnum.VOICE.equals((Object)materialType)) {
            params.put("type", "1");
            params.put("file", content);
        }
        return params;
    }

    private Map<String, String> getExtenInfoParams(Long userId) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("user_number", String.valueOf(userId));
        return map;
    }

    private Map<String, String> getRlExtenListParams() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("is_login", "1");
        result.put("busy_type", "0");
        return result;
    }

    private DubboCallRecordRespDto buildCallRecordRespDto(CallRecord callRecord) {
        String num = this.scrmUserService.getNumById(callRecord.getUserId());
        return DubboCallRecordRespDto.builder().apiCallId(callRecord.getApiCallId()).userId(num).num(callRecord.getNum()).ringingDuration(callRecord.getRingingDuration()).callDuration(callRecord.getCallDuration()).userName(callRecord.getUserName()).userPhone(callRecord.getUserPhone()).middlePhone(callRecord.getMiddlePhone()).voiceUrl(callRecord.getVoiceUrl()).orgName(callRecord.getOrgName()).createTime(callRecord.getCreateTime()).status(callRecord.getStatus()).openapi(callRecord.getIsOpenapi() != null && callRecord.getIsOpenapi() == 1).build();
    }
}

