/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.factory;

import com.alibaba.fastjson.JSONObject;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.CallOutDto;
import com.kuaike.scrm.call.dto.req.CallBackReqDto;
import com.kuaike.scrm.call.enums.CallOutTypeEnum;
import com.kuaike.scrm.call.enums.StatusEnum;
import com.kuaike.scrm.call.factory.CallOutService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.call.dto.CallRecordQueryParams;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallRecordCriteria;
import com.kuaike.scrm.dal.call.entity.CallTaskDetail;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskDetailMapper;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ZhuQueCallOutServiceImpl
implements CallOutService {
    private static final Logger log = LoggerFactory.getLogger(ZhuQueCallOutServiceImpl.class);
    @Value(value="${app.call.click2CallUrl}")
    private String click2CallUrl;
    @Autowired
    private CallRecordMapper callRecordMapper;
    @Autowired
    private CallTaskDetailMapper callTaskDetailMapper;
    @Autowired
    private BjyPartnerService bjyPartnerService;

    @Override
    public Integer getCallOutType() {
        return CallOutTypeEnum.ZHU_QUE.getValue();
    }

    @Override
    public String call(CallOutDto callOutDto) {
        Long bizId = callOutDto.getBizId();
        log.info("call callOutDto:{}, bizId:{}", (Object)callOutDto, (Object)bizId);
        Map<String, String> params = this.getCallParams(callOutDto.getUserPhone(), callOutDto.getPhone(), callOutDto.getUserId());
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.click2CallUrl, params);
        return jsonObject.getJSONObject("data").getString("session_id");
    }

    @Override
    public CallRecord callback(CallBackReqDto reqDto) {
        CallTaskDetail taskDetail;
        long l;
        reqDto.validateCallbackParams();
        log.info("callback reqDto:{}", (Object)reqDto);
        String sessionId = reqDto.getSessionId();
        CallRecord callRecord = (CallRecord)this.callRecordMapper.selectOne((Object)CallRecord.builder().apiCallId(sessionId).build());
        if (ObjectUtils.isEmpty((Object)callRecord)) {
            return null;
        }
        if (callRecord.getStatus().intValue() == StatusEnum.SUCCESS.getValue()) {
            return null;
        }
        CallRecord item = new CallRecord();
        item.setUpdateBy(Long.valueOf(-1L));
        item.setUpdateTime(new Date());
        CallRecordCriteria criteria = new CallRecordCriteria();
        criteria.createCriteria().andApiCallIdEqualTo(sessionId);
        Integer callStatus = reqDto.getCallStatus();
        int ringingDuration = 0;
        String alertingTime = reqDto.getAlertingTime();
        String answerTime = reqDto.getAnswerTime();
        String endTime = reqDto.getEndTime();
        if (callStatus == 1) {
            if (!StringUtils.isEmpty((CharSequence)alertingTime) && !StringUtils.isEmpty((CharSequence)answerTime)) {
                l = DateUtil.compareDateSecond((String)alertingTime, (String)answerTime);
                ringingDuration = Math.toIntExact(l / 1000L);
            }
        } else if (!StringUtils.isEmpty((CharSequence)alertingTime) && !StringUtils.isEmpty((CharSequence)endTime)) {
            l = DateUtil.compareDateSecond((String)reqDto.getAlertingTime(), (String)reqDto.getEndTime());
            ringingDuration = Math.toIntExact(l / 1000L);
        }
        item.setMiddlePhone(reqDto.getBindNbr());
        item.setRingingDuration(Integer.valueOf(ringingDuration));
        item.setCallDuration(reqDto.getAirtime());
        item.setBillCallDuration(reqDto.getBillCallDuration());
        item.setStatus(callStatus);
        item.setStartTime(DateUtil.getDate((String)answerTime, (String)"yyyy-MM-dd HH:mm:ss"));
        item.setEndTime(DateUtil.getDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
        this.callRecordMapper.updateByExampleSelective((Object)item, (Object)criteria);
        if (!ObjectUtils.isEmpty((Object)callRecord.getCallTaskDetailId()) && !ObjectUtils.isEmpty((Object)(taskDetail = (CallTaskDetail)this.callTaskDetailMapper.selectByPrimaryKey((Object)CallTaskDetail.builder().id(callRecord.getCallTaskDetailId()).build())))) {
            taskDetail.setLastCallStatus(callStatus);
            taskDetail.setUpdateTime(new Date());
            if (callStatus == 1) {
                taskDetail.setCallSuccessCount(Integer.valueOf(taskDetail.getCallSuccessCount() + 1));
            }
            this.callTaskDetailMapper.updateByPrimaryKeySelective((Object)taskDetail);
        }
        item.setNum(callRecord.getNum());
        item.setCorpId(callRecord.getCorpId());
        item.setBizId(callRecord.getBizId());
        item.setUserId(callRecord.getUserId());
        item.setNodeId(callRecord.getNodeId());
        item.setCustomerPhone(callRecord.getCustomerPhone());
        item.setUserPhone(callRecord.getUserPhone());
        item.setIsOpenapi(callRecord.getIsOpenapi());
        item.setCreateTime(callRecord.getCreateTime());
        item.setType(callRecord.getType());
        item.setVoiceUrl(callRecord.getVoiceUrl());
        item.setCallTaskDetailId(callRecord.getCallTaskDetailId());
        item.setUserType(callRecord.getUserType());
        return item;
    }

    @Override
    public void cancel(CurrentUserInfo currentUser) {
        Long bizId = currentUser.getBizId();
        Long userId = currentUser.getId();
        CallRecordQueryParams queryParams = new CallRecordQueryParams();
        queryParams.setBizId(bizId);
        queryParams.setUserId(userId);
        CallRecord callRecord = this.callRecordMapper.lastCall(queryParams);
        if (!ObjectUtils.isEmpty((Object)callRecord)) {
            callRecord.setUpdateBy(Long.valueOf(-1L));
            callRecord.setUpdateTime(new Date());
            callRecord.setCanceled(Integer.valueOf(1));
            this.callRecordMapper.updateByPrimaryKeySelective((Object)callRecord);
        }
    }

    private Map<String, String> getCallParams(String userPhone, String customerPhone, Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("tel_a", userPhone);
        result.put("tel_b", customerPhone);
        result.put("user_number", String.valueOf(userId));
        return result;
    }
}

