/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.call.dto.CallStatisticQueryParams;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;

public class CallStatisticReqDto {
    private String userId;
    private String nodeId;
    private Date startTime;
    private Date endTime;
    private Integer mode;
    private String startDate;
    private String endDate;
    private Long bizId;
    private String corpId;
    private Integer type;
    private Integer userType;

    private void validateBaseParams(CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateStatisticParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.mode) ? 1 : 0) != 0, (Object)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateAnalyseParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
    }

    public CallStatisticQueryParams to(Long bizId) {
        CallStatisticQueryParams queryParams = new CallStatisticQueryParams();
        queryParams.setBizId(bizId);
        if (StringUtils.isNotBlank((CharSequence)this.startDate)) {
            queryParams.setStartDate(DateUtil.dateToDateString((Date)DateUtil.getDate((String)this.startDate, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.endDate)) {
            queryParams.setEndDate(DateUtil.dateToDateString((Date)DateUtil.getDate((String)this.endDate, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd"));
        }
        queryParams.setMode(this.mode);
        queryParams.setType(this.type);
        queryParams.setUserType(this.userType);
        queryParams.setMemberUserId(this.userId);
        return queryParams;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getMode() {
        return this.mode;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallStatisticReqDto)) {
            return false;
        }
        CallStatisticReqDto other = (CallStatisticReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$mode = this.getMode();
        Integer other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)this$mode).equals(other$mode)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$userType = this.getUserType();
        Integer other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)this$userType).equals(other$userType)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        return !(this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallStatisticReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)$mode).hashCode());
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)$userType).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        return result;
    }

    public String toString() {
        return "CallStatisticReqDto(userId=" + this.getUserId() + ", nodeId=" + this.getNodeId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", mode=" + this.getMode() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", bizId=" + this.getBizId() + ", corpId=" + this.getCorpId() + ", type=" + this.getType() + ", userType=" + this.getUserType() + ")";
    }
}

